/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.svg.figures;

import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jhotdraw.beans.PropertyChangeEdit;
import org.jhotdraw.draw.AbstractHandle;
import org.jhotdraw.draw.CompositeFigureEdit;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.HandleAttributeKeys;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.samples.svg.SVGAttributeKeys;
import org.jhotdraw.samples.svg.figures.SVGRectFigure;
import org.jhotdraw.util.ResourceBundleUtil;

public class SVGRectRadiusHandle
extends AbstractHandle {
    private static final boolean DEBUG = false;
    private static final int OFFSET = 6;
    private Dimension2DDouble originalArc2D;

    public SVGRectRadiusHandle(Figure figure) {
        super(figure);
    }

    @Override
    public void draw(Graphics2D graphics2D) {
        if (this.getEditor().getTool().supportsHandleInteraction()) {
            this.drawDiamond(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_STROKE_COLOR));
        } else {
            this.drawDiamond(graphics2D, this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_FILL_COLOR_DISABLED), this.getEditor().getHandleAttribute(HandleAttributeKeys.ATTRIBUTE_HANDLE_STROKE_COLOR_DISABLED));
        }
    }

    @Override
    protected Rectangle basicGetBounds() {
        Rectangle rectangle = new Rectangle(this.locate());
        rectangle.grow(this.getHandlesize() / 2 + 1, this.getHandlesize() / 2 + 1);
        return rectangle;
    }

    private Point locate() {
        SVGRectFigure sVGRectFigure = (SVGRectFigure)this.getOwner();
        Rectangle2D.Double double_ = sVGRectFigure.getBounds();
        Point2D.Double double_2 = new Point2D.Double(double_.x + sVGRectFigure.getArcWidth(), double_.y + sVGRectFigure.getArcHeight());
        if (sVGRectFigure.get(SVGAttributeKeys.TRANSFORM) != null) {
            ((AffineTransform)sVGRectFigure.get(SVGAttributeKeys.TRANSFORM)).transform(double_2, double_2);
        }
        return this.view.drawingToView(double_2);
    }

    @Override
    public void trackStart(Point point, int n) {
        SVGRectFigure sVGRectFigure = (SVGRectFigure)this.getOwner();
        this.originalArc2D = new Dimension2DDouble(sVGRectFigure.getArcWidth(), sVGRectFigure.getArcHeight());
    }

    @Override
    public void trackStep(Point point, Point point2, int n) {
        int n2 = point2.x - point.x;
        int n3 = point2.y - point.y;
        SVGRectFigure sVGRectFigure = (SVGRectFigure)this.getOwner();
        sVGRectFigure.willChange();
        Point2D.Double double_ = this.view.viewToDrawing(point2);
        if (sVGRectFigure.get(SVGAttributeKeys.TRANSFORM) != null) {
            try {
                ((AffineTransform)sVGRectFigure.get(SVGAttributeKeys.TRANSFORM)).inverseTransform(double_, double_);
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                // empty catch block
            }
        }
        Rectangle2D.Double double_2 = sVGRectFigure.getBounds();
        sVGRectFigure.setArc(Math.min(sVGRectFigure.getWidth(), Math.max(0.0, double_.x - double_2.x)), Math.min(sVGRectFigure.getHeight(), Math.max(0.0, double_.y - double_2.y)));
        sVGRectFigure.changed();
    }

    @Override
    public void trackEnd(Point point, Point point2, int n) {
        SVGRectFigure sVGRectFigure = (SVGRectFigure)this.getOwner();
        Dimension2DDouble dimension2DDouble = this.originalArc2D;
        Dimension2DDouble dimension2DDouble2 = new Dimension2DDouble(sVGRectFigure.getArcWidth(), sVGRectFigure.getArcHeight());
        ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
        CompositeFigureEdit compositeFigureEdit = new CompositeFigureEdit((Figure)sVGRectFigure, resourceBundleUtil.getString("attribute.roundRectRadius"));
        compositeFigureEdit.setVerbose(true);
        this.fireUndoableEditHappened(compositeFigureEdit);
        this.fireUndoableEditHappened(new PropertyChangeEdit((Object)sVGRectFigure, "arcWidth", dimension2DDouble.width, dimension2DDouble2.width));
        this.fireUndoableEditHappened(new PropertyChangeEdit((Object)sVGRectFigure, "arcHeight", dimension2DDouble.height, dimension2DDouble2.height));
        this.fireUndoableEditHappened(compositeFigureEdit);
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        SVGRectFigure sVGRectFigure = (SVGRectFigure)this.getOwner();
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(sVGRectFigure.getArcWidth(), sVGRectFigure.getArcHeight());
        Dimension2DDouble dimension2DDouble2 = new Dimension2DDouble(sVGRectFigure.getArcWidth(), sVGRectFigure.getArcHeight());
        switch (keyEvent.getKeyCode()) {
            case 38: {
                if (dimension2DDouble2.height > 0.0) {
                    dimension2DDouble2.height = Math.max(0.0, dimension2DDouble2.height - 1.0);
                }
                keyEvent.consume();
                break;
            }
            case 40: {
                dimension2DDouble2.height = Math.min(sVGRectFigure.getHeight(), dimension2DDouble2.height + 1.0);
                keyEvent.consume();
                break;
            }
            case 37: {
                if (dimension2DDouble2.width > 0.0) {
                    dimension2DDouble2.width = Math.max(0.0, dimension2DDouble2.width - 1.0);
                }
                keyEvent.consume();
                break;
            }
            case 39: {
                dimension2DDouble2.width = Math.min(sVGRectFigure.getWidth(), dimension2DDouble2.width + 1.0);
                keyEvent.consume();
            }
        }
        if (!dimension2DDouble2.equals(dimension2DDouble)) {
            sVGRectFigure.willChange();
            sVGRectFigure.setArc(dimension2DDouble2.width, dimension2DDouble2.height);
            sVGRectFigure.changed();
            ResourceBundleUtil resourceBundleUtil = ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels");
            CompositeFigureEdit compositeFigureEdit = new CompositeFigureEdit((Figure)sVGRectFigure, resourceBundleUtil.getString("attribute.roundRectRadius"));
            this.fireUndoableEditHappened(compositeFigureEdit);
            this.fireUndoableEditHappened(new PropertyChangeEdit((Object)sVGRectFigure, "arcWidth", dimension2DDouble.width, dimension2DDouble2.width));
            this.fireUndoableEditHappened(new PropertyChangeEdit((Object)sVGRectFigure, "arcHeight", dimension2DDouble.height, dimension2DDouble2.height));
            this.fireUndoableEditHappened(compositeFigureEdit);
        }
    }

    @Override
    public String getToolTipText(Point point) {
        return ResourceBundleUtil.getBundle("org.jhotdraw.draw.Labels").getString("handle.roundRectangleRadius.toolTipText");
    }
}

