/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.internal.connection;

import com.mongodb.ServerAddress;
import com.mongodb.internal.connection.SniSslHelper;
import javax.net.ssl.SSLParameters;

public final class SslHelper {
    private static final SniSslHelper SNI_SSL_HELPER;

    public static void enableHostNameVerification(SSLParameters sslParameters) {
        sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
    }

    public static void enableSni(ServerAddress address, SSLParameters sslParameters) {
        if (SNI_SSL_HELPER != null) {
            SNI_SSL_HELPER.enableSni(address, sslParameters);
        }
    }

    private SslHelper() {
    }

    static {
        SniSslHelper sniSslHelper;
        try {
            sniSslHelper = (SniSslHelper)Class.forName("com.mongodb.internal.connection.Java8SniSslHelper").newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (InstantiationException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (IllegalAccessException e) {
            throw new ExceptionInInitializerError(e);
        }
        catch (LinkageError t) {
            sniSslHelper = null;
        }
        SNI_SSL_HELPER = sniSslHelper;
    }
}

