/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.sprites;

import java.nio.ByteBuffer;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL30;

public class StreamVBO {
    private final int target;
    private final long size;
    private final int padding;
    private int ID;
    private long cursor;

    public StreamVBO(int target, int size) {
        this(target, size, 64);
    }

    public StreamVBO(int target, int size, int padding) {
        this.target = target;
        this.padding = padding;
        this.size = Math.max(this.pad(size), padding);
        this.ID = GL15.glGenBuffers();
        GL15.glBindBuffer((int)target, (int)this.ID);
        GL15.glBufferData((int)target, (long)this.size, (int)35040);
    }

    public int getTarget() {
        return this.target;
    }

    public int getID() {
        return this.ID;
    }

    public long getSize() {
        return this.size;
    }

    public int getPadding() {
        return this.padding;
    }

    public void bind() {
        GL15.glBindBuffer((int)this.target, (int)this.ID);
    }

    public void init(int offset, ByteBuffer data) {
        GL15.glBufferSubData((int)this.target, (long)offset, (ByteBuffer)data);
    }

    public void unmap() {
        GL15.glUnmapBuffer((int)this.target);
    }

    public void destroy() {
        GL15.glBindBuffer((int)this.target, (int)0);
        GL15.glDeleteBuffers((int)this.ID);
    }

    public void reset() {
        GL15.glBufferData((int)this.target, (long)this.size, (int)35040);
        this.cursor = 0L;
    }

    public ByteBuffer map(int bytes) {
        return this.map(bytes, null);
    }

    public ByteBuffer map(int bytes, ByteBuffer old_buffer) {
        return this.doMap(this.pad(bytes), old_buffer);
    }

    private int pad(int size) {
        int mod = size % this.padding;
        if (mod == 0) {
            return size;
        }
        return size + this.padding - mod;
    }

    private ByteBuffer doMap(int bytes, ByteBuffer old_buffer) {
        if (LWJGLUtil.CHECKS && this.size < (long)bytes) {
            throw new IllegalArgumentException(Integer.toString(bytes));
        }
        if (this.size < this.cursor + (long)bytes) {
            this.reset();
        }
        ByteBuffer map = GL30.glMapBufferRange((int)this.target, (long)this.cursor, (long)bytes, (int)34, (ByteBuffer)old_buffer);
        this.cursor += (long)bytes;
        return map;
    }
}

