/* -*- Mode: C; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 *  Copyright (C) 2005 Takuro Ashie
 *  Copyright (C) 2006 Juernjakob Harder
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */ 

#ifndef __TOMOE_HANDWRITING_H__
#define __TOMOE_HANDWRITING_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtktable.h>
#include <tomoe-char.h>
#include <tomoe-context.h>

G_BEGIN_DECLS

#define TOMOE_TYPE_HANDWRITING            (tomoe_handwriting_get_type ())
#define TOMOE_HANDWRITING(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TOMOE_TYPE_HANDWRITING, TomoeHandwriting))
#define TOMOE_HANDWRITING_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), TOMOE_TYPE_HANDWRITING, TomoeHandwritingClass))
#define TOMOE_IS_HANDWRITING(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TOMOE_TYPE_HANDWRITING))
#define TOMOE_IS_HANDWRITING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TOMOE_TYPE_HANDWRITING))
#define TOMOE_HANDWRITING_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), TOMOE_TYPE_HANDWRITING, TomoeHandwritingClass))


typedef struct _TomoeHandwritingClass TomoeHandwritingClass;
typedef struct _TomoeHandwriting      TomoeHandwriting;

struct _TomoeHandwriting
{
    GtkTable parent_instance;
};

struct _TomoeHandwritingClass
{
    GtkTableClass parent_class;
    /* -- signals -- */
    void (*selected) (TomoeHandwriting *search);
};


GType        tomoe_handwriting_get_type   (void) G_GNUC_CONST;
GtkWidget   *tomoe_handwriting_new        (TomoeContext     *context);
GtkWidget   *tomoe_handwriting_get_canvas (TomoeHandwriting *handwriting);
GtkWidget   *tomoe_handwriting_get_button_area 
                                          (TomoeHandwriting *handwriting);
GtkWidget   *tomoe_handwriting_get_char_table
                                          (TomoeHandwriting *handwriting);
const gchar *tomoe_handwriting_get_selected_char
                                          (TomoeHandwriting *handwriting);
TomoeChar   *tomoe_handwriting_get_selected_tomoe_char
                                          (TomoeHandwriting *handwriting);

G_END_DECLS

#endif /* __TOMOE_HANDWRITING_H__ */

/*
 * vi:ts=4:nowrap:ai:expandtab
 */
