/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.lang.ref.SoftReference;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.file.FileSystemException;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Arrays;
import java.util.Objects;
import sun.nio.fs.AbstractPath;
import sun.nio.fs.AbstractWatchService;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixUriUtils;
import sun.nio.fs.Util;

class UnixPath
extends AbstractPath {
    private static ThreadLocal<SoftReference<CharsetEncoder>> encoder = new ThreadLocal();
    private final UnixFileSystem fs;
    private final byte[] path;
    private volatile String stringValue;
    private int hash;
    private volatile int[] offsets;

    UnixPath(UnixFileSystem unixFileSystem, byte[] byArray) {
        this.fs = unixFileSystem;
        this.path = byArray;
    }

    UnixPath(UnixFileSystem unixFileSystem, String string) {
        this(unixFileSystem, UnixPath.encode(unixFileSystem, UnixPath.normalizeAndCheck(string)));
    }

    static String normalizeAndCheck(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '/' && n2 == 47) {
                return UnixPath.normalize(string, n, i - 1);
            }
            UnixPath.checkNotNul(string, c);
            n2 = c;
        }
        if (n2 == 47) {
            return UnixPath.normalize(string, n, n - 1);
        }
        return string;
    }

    private static void checkNotNul(String string, char c) {
        if (c == '\u0000') {
            throw new InvalidPathException(string, "Nul character not allowed");
        }
    }

    private static String normalize(String string, int n, int n2) {
        int n3;
        if (n == 0) {
            return string;
        }
        for (n3 = n; n3 > 0 && string.charAt(n3 - 1) == '/'; --n3) {
        }
        if (n3 == 0) {
            return "/";
        }
        StringBuilder stringBuilder = new StringBuilder(string.length());
        if (n2 > 0) {
            stringBuilder.append(string.substring(0, n2));
        }
        int n4 = 0;
        for (int i = n2; i < n3; ++i) {
            char c = string.charAt(i);
            if (c == '/' && n4 == 47) continue;
            UnixPath.checkNotNul(string, c);
            stringBuilder.append(c);
            n4 = c;
        }
        return stringBuilder.toString();
    }

    private static byte[] encode(UnixFileSystem unixFileSystem, String string) {
        boolean bl;
        CharsetEncoder charsetEncoder;
        SoftReference<CharsetEncoder> softReference = encoder.get();
        CharsetEncoder charsetEncoder2 = charsetEncoder = softReference != null ? softReference.get() : null;
        if (charsetEncoder == null) {
            charsetEncoder = Util.jnuEncoding().newEncoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT);
            encoder.set(new SoftReference<CharsetEncoder>(charsetEncoder));
        }
        char[] cArray = unixFileSystem.normalizeNativePath(string.toCharArray());
        byte[] byArray = new byte[(int)((double)cArray.length * (double)charsetEncoder.maxBytesPerChar())];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        CharBuffer charBuffer = CharBuffer.wrap(cArray);
        charsetEncoder.reset();
        CoderResult coderResult = charsetEncoder.encode(charBuffer, byteBuffer, true);
        if (!coderResult.isUnderflow()) {
            bl = true;
        } else {
            coderResult = charsetEncoder.flush(byteBuffer);
            boolean bl2 = bl = !coderResult.isUnderflow();
        }
        if (bl) {
            throw new InvalidPathException(string, "Malformed input or input contains unmappable characters");
        }
        int n = byteBuffer.position();
        if (n != byArray.length) {
            byArray = Arrays.copyOf(byArray, n);
        }
        return byArray;
    }

    byte[] asByteArray() {
        return this.path;
    }

    byte[] getByteArrayForSysCalls() {
        if (this.getFileSystem().needToResolveAgainstDefaultDirectory()) {
            return UnixPath.resolve(this.getFileSystem().defaultDirectory(), this.path);
        }
        if (!this.isEmpty()) {
            return this.path;
        }
        byte[] byArray = new byte[]{46};
        return byArray;
    }

    String getPathForExceptionMessage() {
        return this.toString();
    }

    String getPathForPermissionCheck() {
        if (this.getFileSystem().needToResolveAgainstDefaultDirectory()) {
            return Util.toString(this.getByteArrayForSysCalls());
        }
        return this.toString();
    }

    static UnixPath toUnixPath(Path path) {
        if (path == null) {
            throw new NullPointerException();
        }
        if (!(path instanceof UnixPath)) {
            throw new ProviderMismatchException();
        }
        return (UnixPath)path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOffsets() {
        if (this.offsets == null) {
            int n = 0;
            int n2 = 0;
            if (this.isEmpty()) {
                n = 1;
            } else {
                while (n2 < this.path.length) {
                    byte by;
                    if ((by = this.path[n2++]) == 47) continue;
                    ++n;
                    while (n2 < this.path.length && this.path[n2] != 47) {
                        ++n2;
                    }
                }
            }
            int[] nArray = new int[n];
            n = 0;
            n2 = 0;
            while (n2 < this.path.length) {
                byte by = this.path[n2];
                if (by == 47) {
                    ++n2;
                    continue;
                }
                nArray[n++] = n2++;
                while (n2 < this.path.length && this.path[n2] != 47) {
                    ++n2;
                }
            }
            UnixPath unixPath = this;
            synchronized (unixPath) {
                if (this.offsets == null) {
                    this.offsets = nArray;
                }
            }
        }
    }

    private boolean isEmpty() {
        return this.path.length == 0;
    }

    private UnixPath emptyPath() {
        return new UnixPath(this.getFileSystem(), new byte[0]);
    }

    @Override
    public UnixFileSystem getFileSystem() {
        return this.fs;
    }

    @Override
    public UnixPath getRoot() {
        if (this.path.length > 0 && this.path[0] == 47) {
            return this.getFileSystem().rootDirectory();
        }
        return null;
    }

    @Override
    public UnixPath getFileName() {
        this.initOffsets();
        int n = this.offsets.length;
        if (n == 0) {
            return null;
        }
        if (n == 1 && this.path.length > 0 && this.path[0] != 47) {
            return this;
        }
        int n2 = this.offsets[n - 1];
        int n3 = this.path.length - n2;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.path, n2, byArray, 0, n3);
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public UnixPath getParent() {
        this.initOffsets();
        int n = this.offsets.length;
        if (n == 0) {
            return null;
        }
        int n2 = this.offsets[n - 1] - 1;
        if (n2 <= 0) {
            return this.getRoot();
        }
        byte[] byArray = new byte[n2];
        System.arraycopy(this.path, 0, byArray, 0, n2);
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    @Override
    public UnixPath getName(int n) {
        this.initOffsets();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        int n2 = this.offsets[n];
        int n3 = n == this.offsets.length - 1 ? this.path.length - n2 : this.offsets[n + 1] - n2 - 1;
        byte[] byArray = new byte[n3];
        System.arraycopy(this.path, n2, byArray, 0, n3);
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public UnixPath subpath(int n, int n2) {
        this.initOffsets();
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        if (n2 > this.offsets.length) {
            throw new IllegalArgumentException();
        }
        if (n >= n2) {
            throw new IllegalArgumentException();
        }
        int n3 = this.offsets[n];
        int n4 = n2 == this.offsets.length ? this.path.length - n3 : this.offsets[n2] - n3 - 1;
        byte[] byArray = new byte[n4];
        System.arraycopy(this.path, n3, byArray, 0, n4);
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public boolean isAbsolute() {
        return this.path.length > 0 && this.path[0] == 47;
    }

    private static byte[] resolve(byte[] byArray, byte[] byArray2) {
        byte[] byArray3;
        int n = byArray.length;
        int n2 = byArray2.length;
        if (n2 == 0) {
            return byArray;
        }
        if (n == 0 || byArray2[0] == 47) {
            return byArray2;
        }
        if (n == 1 && byArray[0] == 47) {
            byArray3 = new byte[n2 + 1];
            byArray3[0] = 47;
            System.arraycopy(byArray2, 0, byArray3, 1, n2);
        } else {
            byArray3 = new byte[n + 1 + n2];
            System.arraycopy(byArray, 0, byArray3, 0, n);
            byArray3[byArray.length] = 47;
            System.arraycopy(byArray2, 0, byArray3, n + 1, n2);
        }
        return byArray3;
    }

    @Override
    public UnixPath resolve(Path path) {
        byte[] byArray = UnixPath.toUnixPath((Path)path).path;
        if (byArray.length > 0 && byArray[0] == 47) {
            return (UnixPath)path;
        }
        byte[] byArray2 = UnixPath.resolve(this.path, byArray);
        return new UnixPath(this.getFileSystem(), byArray2);
    }

    UnixPath resolve(byte[] byArray) {
        return this.resolve(new UnixPath(this.getFileSystem(), byArray));
    }

    @Override
    public UnixPath relativize(Path path) {
        int n;
        int n2;
        int n3;
        UnixPath unixPath = UnixPath.toUnixPath(path);
        if (unixPath.equals(this)) {
            return this.emptyPath();
        }
        if (this.isAbsolute() != unixPath.isAbsolute()) {
            throw new IllegalArgumentException("'other' is different type of Path");
        }
        if (this.isEmpty()) {
            return unixPath;
        }
        int n4 = this.getNameCount();
        int n5 = n4 > (n3 = unixPath.getNameCount()) ? n3 : n4;
        for (n2 = 0; n2 < n5 && this.getName(n2).equals(unixPath.getName(n2)); ++n2) {
        }
        if (n2 < n3) {
            UnixPath unixPath2 = unixPath.subpath(n2, n3);
            if (n == 0) {
                return unixPath2;
            }
            boolean bl = unixPath.isEmpty();
            int n6 = n * 3 + unixPath2.path.length;
            if (bl) {
                assert (unixPath2.isEmpty());
                --n6;
            }
            byte[] byArray = new byte[n6];
            int n7 = 0;
            while (n > 0) {
                byArray[n7++] = 46;
                byArray[n7++] = 46;
                if (bl) {
                    if (n > 1) {
                        byArray[n7++] = 47;
                    }
                } else {
                    byArray[n7++] = 47;
                }
                --n;
            }
            System.arraycopy(unixPath2.path, 0, byArray, n7, unixPath2.path.length);
            return new UnixPath(this.getFileSystem(), byArray);
        }
        byte[] byArray = new byte[n * 3 - 1];
        int n8 = 0;
        for (n = n4 - n2; n > 0; --n) {
            byArray[n8++] = 46;
            byArray[n8++] = 46;
            if (n <= 1) continue;
            byArray[n8++] = 47;
        }
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public Path normalize() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = this.getNameCount();
        if (n5 == 0 || this.isEmpty()) {
            return this;
        }
        boolean[] blArray = new boolean[n5];
        int[] nArray = new int[n5];
        int n6 = n5;
        boolean bl = false;
        boolean bl2 = this.isAbsolute();
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = this.offsets[n4];
            n2 = n4 == this.offsets.length - 1 ? this.path.length - n3 : this.offsets[n4 + 1] - n3 - 1;
            nArray[n4] = n2;
            if (this.path[n3] != 46) continue;
            if (n2 == 1) {
                blArray[n4] = true;
                --n6;
                continue;
            }
            if (this.path[n3 + 1] != 46) continue;
            bl = true;
        }
        if (bl) {
            do {
                n4 = n6;
                n3 = -1;
                for (n2 = 0; n2 < n5; ++n2) {
                    if (blArray[n2]) continue;
                    if (nArray[n2] != 2) {
                        n3 = n2;
                        continue;
                    }
                    n = this.offsets[n2];
                    if (this.path[n] != 46 || this.path[n + 1] != 46) {
                        n3 = n2;
                        continue;
                    }
                    if (n3 >= 0) {
                        blArray[n3] = true;
                        blArray[n2] = true;
                        n6 -= 2;
                        n3 = -1;
                        continue;
                    }
                    if (!bl2) continue;
                    boolean bl3 = false;
                    for (int i = 0; i < n2; ++i) {
                        if (blArray[i]) continue;
                        bl3 = true;
                        break;
                    }
                    if (bl3) continue;
                    blArray[n2] = true;
                    --n6;
                }
            } while (n4 > n6);
        }
        if (n6 == n5) {
            return this;
        }
        if (n6 == 0) {
            return bl2 ? this.getFileSystem().rootDirectory() : this.emptyPath();
        }
        n4 = n6 - 1;
        if (bl2) {
            ++n4;
        }
        for (n3 = 0; n3 < n5; ++n3) {
            if (blArray[n3]) continue;
            n4 += nArray[n3];
        }
        byte[] byArray = new byte[n4];
        n2 = 0;
        if (bl2) {
            byArray[n2++] = 47;
        }
        for (n = 0; n < n5; ++n) {
            if (blArray[n]) continue;
            System.arraycopy(this.path, this.offsets[n], byArray, n2, nArray[n]);
            n2 += nArray[n];
            if (--n6 <= 0) continue;
            byArray[n2++] = 47;
        }
        return new UnixPath(this.getFileSystem(), byArray);
    }

    @Override
    public boolean startsWith(Path path) {
        int n;
        if (!(Objects.requireNonNull(path) instanceof UnixPath)) {
            return false;
        }
        UnixPath unixPath = (UnixPath)path;
        if (unixPath.path.length > this.path.length) {
            return false;
        }
        int n2 = this.getNameCount();
        int n3 = unixPath.getNameCount();
        if (n3 == 0 && this.isAbsolute()) {
            return !unixPath.isEmpty();
        }
        if (n3 > n2) {
            return false;
        }
        if (n3 == n2 && this.path.length != unixPath.path.length) {
            return false;
        }
        for (n = 0; n < n3; ++n) {
            Integer n4;
            Integer n5 = this.offsets[n];
            if (n5.equals(n4 = Integer.valueOf(unixPath.offsets[n]))) continue;
            return false;
        }
        for (n = 0; n < unixPath.path.length; ++n) {
            if (this.path[n] == unixPath.path[n]) continue;
            return false;
        }
        return n >= this.path.length || this.path[n] == 47;
    }

    @Override
    public boolean endsWith(Path path) {
        int n;
        int n2;
        if (!(Objects.requireNonNull(path) instanceof UnixPath)) {
            return false;
        }
        UnixPath unixPath = (UnixPath)path;
        int n3 = unixPath.path.length;
        int n4 = this.path.length;
        if (n3 > n4) {
            return false;
        }
        if (n4 > 0 && n3 == 0) {
            return false;
        }
        if (unixPath.isAbsolute() && !this.isAbsolute()) {
            return false;
        }
        int n5 = this.getNameCount();
        int n6 = unixPath.getNameCount();
        if (n6 > n5) {
            return false;
        }
        if (n6 == n5) {
            if (n5 == 0) {
                return true;
            }
            n2 = n4;
            if (this.isAbsolute() && !unixPath.isAbsolute()) {
                --n2;
            }
            if (n3 != n2) {
                return false;
            }
        } else if (unixPath.isAbsolute()) {
            return false;
        }
        if (n3 - (n = unixPath.offsets[0]) != n4 - (n2 = this.offsets[n5 - n6])) {
            return false;
        }
        while (n < n3) {
            if (this.path[n2++] == unixPath.path[n++]) continue;
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(Path path) {
        int n = this.path.length;
        int n2 = ((UnixPath)path).path.length;
        int n3 = Math.min(n, n2);
        byte[] byArray = this.path;
        byte[] byArray2 = ((UnixPath)path).path;
        for (int i = 0; i < n3; ++i) {
            int n4 = byArray[i] & 0xFF;
            int n5 = byArray2[i] & 0xFF;
            if (n4 == n5) continue;
            return n4 - n5;
        }
        return n - n2;
    }

    @Override
    public boolean equals(Object object) {
        if (object != null && object instanceof UnixPath) {
            return this.compareTo((Path)object) == 0;
        }
        return false;
    }

    @Override
    public int hashCode() {
        int n = this.hash;
        if (n == 0) {
            for (int i = 0; i < this.path.length; ++i) {
                n = 31 * n + (this.path[i] & 0xFF);
            }
            this.hash = n;
        }
        return n;
    }

    @Override
    public String toString() {
        if (this.stringValue == null) {
            this.stringValue = this.fs.normalizeJavaPath(Util.toString(this.path));
        }
        return this.stringValue;
    }

    int openForAttributeAccess(boolean bl) throws IOException {
        int n = 0;
        if (!bl) {
            n |= 0x100;
        }
        try {
            return UnixNativeDispatcher.open(this, n, 0);
        }
        catch (UnixException unixException) {
            if (this.getFileSystem().isSolaris() && unixException.errno() == 22) {
                unixException.setError(62);
            }
            if (unixException.errno() == 62) {
                throw new FileSystemException(this.getPathForExceptionMessage(), null, unixException.getMessage() + " or unable to access attributes of symbolic link");
            }
            unixException.rethrowAsIOException(this);
            return -1;
        }
    }

    void checkRead() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkRead(this.getPathForPermissionCheck());
        }
    }

    void checkWrite() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkWrite(this.getPathForPermissionCheck());
        }
    }

    void checkDelete() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkDelete(this.getPathForPermissionCheck());
        }
    }

    @Override
    public UnixPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPropertyAccess("user.dir");
        }
        return new UnixPath(this.getFileSystem(), UnixPath.resolve(this.getFileSystem().defaultDirectory(), this.path));
    }

    @Override
    public Path toRealPath(LinkOption ... linkOptionArray) throws IOException {
        this.checkRead();
        UnixPath unixPath = this.toAbsolutePath();
        if (Util.followLinks(linkOptionArray)) {
            try {
                byte[] byArray = UnixNativeDispatcher.realpath(unixPath);
                return new UnixPath(this.getFileSystem(), byArray);
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(this);
            }
        }
        UnixPath unixPath2 = this.fs.rootDirectory();
        for (int i = 0; i < unixPath.getNameCount(); ++i) {
            UnixPath unixPath3 = unixPath.getName(i);
            if (unixPath3.asByteArray().length == 1 && unixPath3.asByteArray()[0] == 46) continue;
            if (unixPath3.asByteArray().length == 2 && unixPath3.asByteArray()[0] == 46 && unixPath3.asByteArray()[1] == 46) {
                UnixFileAttributes unixFileAttributes = null;
                try {
                    unixFileAttributes = UnixFileAttributes.get(unixPath2, false);
                }
                catch (UnixException unixException) {
                    unixException.rethrowAsIOException(unixPath2);
                }
                if (!unixFileAttributes.isSymbolicLink()) {
                    if ((unixPath2 = unixPath2.getParent()) != null) continue;
                    unixPath2 = this.fs.rootDirectory();
                    continue;
                }
            }
            unixPath2 = unixPath2.resolve(unixPath3);
        }
        try {
            UnixFileAttributes.get(unixPath2, false);
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(unixPath2);
        }
        return unixPath2;
    }

    @Override
    public URI toUri() {
        return UnixUriUtils.toUri(this);
    }

    @Override
    public WatchKey register(WatchService watchService, WatchEvent.Kind<?>[] kindArray, WatchEvent.Modifier ... modifierArray) throws IOException {
        if (watchService == null) {
            throw new NullPointerException();
        }
        if (!(watchService instanceof AbstractWatchService)) {
            throw new ProviderMismatchException();
        }
        this.checkRead();
        return ((AbstractWatchService)watchService).register(this, kindArray, modifierArray);
    }
}

