/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.synth;

import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.plaf.synth.SynthTextFieldUI;
import javax.swing.plaf.synth.SynthUI;
import javax.swing.text.JTextComponent;

public class SynthTextAreaUI
extends BasicTextAreaUI
implements SynthUI {
    private Handler handler = new Handler();
    private SynthStyle style;

    public static ComponentUI createUI(JComponent jComponent) {
        return new SynthTextAreaUI();
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        this.updateStyle(this.getComponent());
        this.getComponent().addFocusListener(this.handler);
    }

    @Override
    protected void uninstallDefaults() {
        SynthContext synthContext = this.getContext(this.getComponent(), 1);
        this.getComponent().putClientProperty("caretAspectRatio", null);
        this.getComponent().removeFocusListener(this.handler);
        this.style.uninstallDefaults(synthContext);
        synthContext.dispose();
        this.style = null;
        super.uninstallDefaults();
    }

    private void updateStyle(JTextComponent jTextComponent) {
        SynthContext synthContext = this.getContext(jTextComponent, 1);
        SynthStyle synthStyle = this.style;
        this.style = SynthLookAndFeel.updateStyle(synthContext, this);
        if (this.style != synthStyle) {
            SynthTextFieldUI.updateStyle(jTextComponent, synthContext, this.getPropertyPrefix());
            if (synthStyle != null) {
                this.uninstallKeyboardActions();
                this.installKeyboardActions();
            }
        }
        synthContext.dispose();
    }

    @Override
    public SynthContext getContext(JComponent jComponent) {
        return this.getContext(jComponent, SynthLookAndFeel.getComponentState(jComponent));
    }

    private SynthContext getContext(JComponent jComponent, int n) {
        return SynthContext.getContext(jComponent, this.style, n);
    }

    @Override
    public void update(Graphics graphics, JComponent jComponent) {
        SynthContext synthContext = this.getContext(jComponent);
        SynthLookAndFeel.update(synthContext, graphics);
        synthContext.getPainter().paintTextAreaBackground(synthContext, graphics, 0, 0, jComponent.getWidth(), jComponent.getHeight());
        this.paint(synthContext, graphics);
        synthContext.dispose();
    }

    protected void paint(SynthContext synthContext, Graphics graphics) {
        super.paint(graphics, this.getComponent());
    }

    @Override
    protected void paintBackground(Graphics graphics) {
    }

    @Override
    public void paintBorder(SynthContext synthContext, Graphics graphics, int n, int n2, int n3, int n4) {
        synthContext.getPainter().paintTextAreaBorder(synthContext, graphics, n, n2, n3, n4);
    }

    @Override
    protected void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (SynthLookAndFeel.shouldUpdateStyle(propertyChangeEvent)) {
            this.updateStyle((JTextComponent)propertyChangeEvent.getSource());
        }
        super.propertyChange(propertyChangeEvent);
    }

    private final class Handler
    implements FocusListener {
        private Handler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            SynthTextAreaUI.this.getComponent().repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            SynthTextAreaUI.this.getComponent().repaint();
        }
    }
}

