/*
 * Decompiled with CFR 0.152.
 */
package java.time.format;

import java.time.chrono.Chronology;
import java.time.chrono.IsoChronology;
import java.time.chrono.JapaneseChronology;
import java.time.format.TextStyle;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import java.time.temporal.TemporalField;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import sun.util.locale.provider.CalendarDataUtility;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;

class DateTimeTextProvider {
    private static final ConcurrentMap<Map.Entry<TemporalField, Locale>, Object> CACHE = new ConcurrentHashMap<Map.Entry<TemporalField, Locale>, Object>(16, 0.75f, 2);
    private static final Comparator<Map.Entry<String, Long>> COMPARATOR = new Comparator<Map.Entry<String, Long>>(){

        @Override
        public int compare(Map.Entry<String, Long> entry, Map.Entry<String, Long> entry2) {
            return entry2.getKey().length() - entry.getKey().length();
        }
    };

    DateTimeTextProvider() {
    }

    static DateTimeTextProvider getInstance() {
        return new DateTimeTextProvider();
    }

    public String getText(TemporalField temporalField, long l, TextStyle textStyle, Locale locale) {
        Object object = this.findStore(temporalField, locale);
        if (object instanceof LocaleStore) {
            return ((LocaleStore)object).getText(l, textStyle);
        }
        return null;
    }

    public String getText(Chronology chronology, TemporalField temporalField, long l, TextStyle textStyle, Locale locale) {
        int n;
        int n2;
        if (chronology == IsoChronology.INSTANCE || !(temporalField instanceof ChronoField)) {
            return this.getText(temporalField, l, textStyle, locale);
        }
        if (temporalField == ChronoField.ERA) {
            n2 = 0;
            n = chronology == JapaneseChronology.INSTANCE ? (l == -999L ? 0 : (int)l + 2) : (int)l;
        } else if (temporalField == ChronoField.MONTH_OF_YEAR) {
            n2 = 2;
            n = (int)l - 1;
        } else if (temporalField == ChronoField.DAY_OF_WEEK) {
            n2 = 7;
            n = (int)l + 1;
            if (n > 7) {
                n = 1;
            }
        } else if (temporalField == ChronoField.AMPM_OF_DAY) {
            n2 = 9;
            n = (int)l;
        } else {
            return null;
        }
        return CalendarDataUtility.retrieveJavaTimeFieldValueName(chronology.getCalendarType(), n2, n, textStyle.toCalendarStyle(), locale);
    }

    public Iterator<Map.Entry<String, Long>> getTextIterator(TemporalField temporalField, TextStyle textStyle, Locale locale) {
        Object object = this.findStore(temporalField, locale);
        if (object instanceof LocaleStore) {
            return ((LocaleStore)object).getTextIterator(textStyle);
        }
        return null;
    }

    public Iterator<Map.Entry<String, Long>> getTextIterator(Chronology chronology, TemporalField temporalField, TextStyle textStyle, Locale locale) {
        int n;
        if (chronology == IsoChronology.INSTANCE || !(temporalField instanceof ChronoField)) {
            return this.getTextIterator(temporalField, textStyle, locale);
        }
        switch ((ChronoField)temporalField) {
            case ERA: {
                n = 0;
                break;
            }
            case MONTH_OF_YEAR: {
                n = 2;
                break;
            }
            case DAY_OF_WEEK: {
                n = 7;
                break;
            }
            case AMPM_OF_DAY: {
                n = 9;
                break;
            }
            default: {
                return null;
            }
        }
        int n2 = textStyle == null ? 0 : textStyle.toCalendarStyle();
        Map<String, Integer> map = CalendarDataUtility.retrieveJavaTimeFieldValueNames(chronology.getCalendarType(), n, n2, locale);
        if (map == null) {
            return null;
        }
        ArrayList<Map.Entry<String, Long>> arrayList = new ArrayList<Map.Entry<String, Long>>(map.size());
        switch (n) {
            case 0: {
                for (Map.Entry<String, Integer> entry : map.entrySet()) {
                    int n3 = entry.getValue();
                    if (chronology == JapaneseChronology.INSTANCE) {
                        n3 = n3 == 0 ? -999 : (n3 -= 2);
                    }
                    arrayList.add(DateTimeTextProvider.createEntry(entry.getKey(), Long.valueOf(n3)));
                }
                break;
            }
            case 2: {
                for (Map.Entry<String, Integer> entry : map.entrySet()) {
                    arrayList.add(DateTimeTextProvider.createEntry(entry.getKey(), Long.valueOf(entry.getValue() + 1)));
                }
                break;
            }
            case 7: {
                for (Map.Entry<String, Integer> entry : map.entrySet()) {
                    arrayList.add(DateTimeTextProvider.createEntry(entry.getKey(), Long.valueOf(DateTimeTextProvider.toWeekDay(entry.getValue()))));
                }
                break;
            }
            default: {
                for (Map.Entry<String, Integer> entry : map.entrySet()) {
                    arrayList.add(DateTimeTextProvider.createEntry(entry.getKey(), Long.valueOf(entry.getValue().intValue())));
                }
            }
        }
        return arrayList.iterator();
    }

    private Object findStore(TemporalField temporalField, Locale locale) {
        Map.Entry<TemporalField, Locale> entry = DateTimeTextProvider.createEntry(temporalField, locale);
        Object object = CACHE.get(entry);
        if (object == null) {
            object = this.createStore(temporalField, locale);
            CACHE.putIfAbsent(entry, object);
            object = CACHE.get(entry);
        }
        return object;
    }

    private static int toWeekDay(int n) {
        if (n == 1) {
            return 7;
        }
        return n - 1;
    }

    private Object createStore(TemporalField temporalField, Locale locale) {
        HashMap<TextStyle, Map<Long, String>> hashMap = new HashMap<TextStyle, Map<Long, String>>();
        if (temporalField == ChronoField.ERA) {
            for (TextStyle textStyle : TextStyle.values()) {
                Map<String, Integer> map;
                if (textStyle.isStandalone() || (map = CalendarDataUtility.retrieveJavaTimeFieldValueNames("gregory", 0, textStyle.toCalendarStyle(), locale)) == null) continue;
                HashMap<Long, String> hashMap2 = new HashMap<Long, String>();
                for (Map.Entry<String, Integer> entry : map.entrySet()) {
                    hashMap2.put(Long.valueOf(entry.getValue().intValue()), entry.getKey());
                }
                if (hashMap2.isEmpty()) continue;
                hashMap.put(textStyle, hashMap2);
            }
            return new LocaleStore(hashMap);
        }
        if (temporalField == ChronoField.MONTH_OF_YEAR) {
            for (TextStyle textStyle : TextStyle.values()) {
                Map<String, Integer> map = CalendarDataUtility.retrieveJavaTimeFieldValueNames("gregory", 2, textStyle.toCalendarStyle(), locale);
                HashMap<Long, String> hashMap3 = new HashMap<Long, String>();
                if (map != null) {
                    for (Map.Entry<String, Integer> object : map.entrySet()) {
                        hashMap3.put(Long.valueOf(object.getValue() + 1), object.getKey());
                    }
                } else {
                    String entry;
                    for (int i = 0; i <= 11 && (entry = CalendarDataUtility.retrieveJavaTimeFieldValueName("gregory", 2, i, textStyle.toCalendarStyle(), locale)) != null; ++i) {
                        hashMap3.put(Long.valueOf(i + 1), entry);
                    }
                }
                if (hashMap3.isEmpty()) continue;
                hashMap.put(textStyle, hashMap3);
            }
            return new LocaleStore(hashMap);
        }
        if (temporalField == ChronoField.DAY_OF_WEEK) {
            for (TextStyle textStyle : TextStyle.values()) {
                Map<String, Integer> map = CalendarDataUtility.retrieveJavaTimeFieldValueNames("gregory", 7, textStyle.toCalendarStyle(), locale);
                HashMap<Long, String> hashMap4 = new HashMap<Long, String>();
                if (map != null) {
                    for (Map.Entry<String, Integer> entry : map.entrySet()) {
                        hashMap4.put(Long.valueOf(DateTimeTextProvider.toWeekDay(entry.getValue())), entry.getKey());
                    }
                } else {
                    String string;
                    for (int i = 1; i <= 7 && (string = CalendarDataUtility.retrieveJavaTimeFieldValueName("gregory", 7, i, textStyle.toCalendarStyle(), locale)) != null; ++i) {
                        hashMap4.put(Long.valueOf(DateTimeTextProvider.toWeekDay(i)), string);
                    }
                }
                if (hashMap4.isEmpty()) continue;
                hashMap.put(textStyle, hashMap4);
            }
            return new LocaleStore(hashMap);
        }
        if (temporalField == ChronoField.AMPM_OF_DAY) {
            for (TextStyle textStyle : TextStyle.values()) {
                Map<String, Integer> map;
                if (textStyle.isStandalone() || (map = CalendarDataUtility.retrieveJavaTimeFieldValueNames("gregory", 9, textStyle.toCalendarStyle(), locale)) == null) continue;
                HashMap<Long, String> hashMap5 = new HashMap<Long, String>();
                for (Map.Entry<String, Integer> entry : map.entrySet()) {
                    hashMap5.put(Long.valueOf(entry.getValue().intValue()), entry.getKey());
                }
                if (hashMap5.isEmpty()) continue;
                hashMap.put(textStyle, hashMap5);
            }
            return new LocaleStore(hashMap);
        }
        if (temporalField == IsoFields.QUARTER_OF_YEAR) {
            String[] stringArray = new String[]{"QuarterNames", "standalone.QuarterNames", "QuarterAbbreviations", "standalone.QuarterAbbreviations", "QuarterNarrows", "standalone.QuarterNarrows"};
            for (int i = 0; i < stringArray.length; ++i) {
                String[] stringArray2 = (String[])DateTimeTextProvider.getLocalizedResource(stringArray[i], locale);
                if (stringArray2 == null) continue;
                HashMap<Long, String> hashMap6 = new HashMap<Long, String>();
                for (int j = 0; j < stringArray2.length; ++j) {
                    hashMap6.put(Long.valueOf(j + 1), stringArray2[j]);
                }
                hashMap.put(TextStyle.values()[i], hashMap6);
            }
            return new LocaleStore(hashMap);
        }
        return "";
    }

    private static <A, B> Map.Entry<A, B> createEntry(A a, B b) {
        return new AbstractMap.SimpleImmutableEntry<A, B>(a, b);
    }

    static <T> T getLocalizedResource(String string, Locale locale) {
        LocaleResources localeResources = LocaleProviderAdapter.getResourceBundleBased().getLocaleResources(locale);
        ResourceBundle resourceBundle = localeResources.getJavaTimeFormatData();
        return (T)(resourceBundle.containsKey(string) ? resourceBundle.getObject(string) : null);
    }

    static final class LocaleStore {
        private final Map<TextStyle, Map<Long, String>> valueTextMap;
        private final Map<TextStyle, List<Map.Entry<String, Long>>> parsable;

        LocaleStore(Map<TextStyle, Map<Long, String>> map) {
            this.valueTextMap = map;
            HashMap<TextStyle, List<Map.Entry<String, Long>>> hashMap = new HashMap<TextStyle, List<Map.Entry<String, Long>>>();
            ArrayList arrayList = new ArrayList();
            for (Map.Entry<TextStyle, Map<Long, String>> entry : map.entrySet()) {
                HashMap<String, Map.Entry> hashMap2 = new HashMap<String, Map.Entry>();
                for (Map.Entry<Long, String> entry2 : entry.getValue().entrySet()) {
                    if (hashMap2.put(entry2.getValue(), DateTimeTextProvider.createEntry(entry2.getValue(), entry2.getKey())) == null) continue;
                }
                ArrayList arrayList2 = new ArrayList(hashMap2.values());
                Collections.sort(arrayList2, COMPARATOR);
                hashMap.put(entry.getKey(), arrayList2);
                arrayList.addAll(arrayList2);
                hashMap.put(null, arrayList);
            }
            Collections.sort(arrayList, COMPARATOR);
            this.parsable = hashMap;
        }

        String getText(long l, TextStyle textStyle) {
            Map<Long, String> map = this.valueTextMap.get((Object)textStyle);
            return map != null ? map.get(l) : null;
        }

        Iterator<Map.Entry<String, Long>> getTextIterator(TextStyle textStyle) {
            List<Map.Entry<String, Long>> list = this.parsable.get((Object)textStyle);
            return list != null ? list.iterator() : null;
        }
    }
}

