/*
 * Decompiled with CFR 0.152.
 */
package org.jd.gui.service.treenode;

import java.io.File;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.tree.DefaultMutableTreeNode;
import org.jd.gui.api.API;
import org.jd.gui.api.feature.UriGettable;
import org.jd.gui.api.model.Container;
import org.jd.gui.service.treenode.ZipFileTreeNodeFactoryProvider;
import org.jd.gui.util.container.JarContainerEntryUtil;
import org.jd.gui.view.data.TreeNodeBean;

public class JarFileTreeNodeFactoryProvider
extends ZipFileTreeNodeFactoryProvider {
    protected static final ImageIcon JAR_FILE_ICON = new ImageIcon(JarFileTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/jar_obj.png"));
    protected static final ImageIcon EJB_FILE_ICON = new ImageIcon(JarFileTreeNodeFactoryProvider.class.getClassLoader().getResource("org/jd/gui/images/ejbmodule_obj.gif"));

    @Override
    public String[] getSelectors() {
        return this.appendSelectors("*:file:*.jar");
    }

    @Override
    public <T extends DefaultMutableTreeNode & UriGettable> T make(API api, Container.Entry entry) {
        int lastSlashIndex = entry.getPath().lastIndexOf("/");
        String label = entry.getPath().substring(lastSlashIndex + 1);
        String location = new File(entry.getUri()).getPath();
        ImageIcon icon = JarFileTreeNodeFactoryProvider.isAEjbModule(entry) ? EJB_FILE_ICON : JAR_FILE_ICON;
        TreeNode node = new TreeNode(entry, new TreeNodeBean(label, "Location: " + location, (Icon)icon));
        node.add(new DefaultMutableTreeNode());
        return (T)node;
    }

    protected static boolean isAEjbModule(Container.Entry entry) {
        Collection<Container.Entry> children = entry.getChildren();
        if (children != null) {
            Container.Entry metaInf = null;
            for (Container.Entry child : children) {
                if (!child.getPath().equals("META-INF")) continue;
                metaInf = child;
                break;
            }
            if (metaInf != null) {
                children = metaInf.getChildren();
                for (Container.Entry child : children) {
                    if (!child.getPath().equals("META-INF/ejb-jar.xml")) continue;
                    return true;
                }
            }
        }
        return false;
    }

    protected static class TreeNode
    extends ZipFileTreeNodeFactoryProvider.TreeNode {
        public TreeNode(Container.Entry entry, Object userObject) {
            super(entry, userObject);
        }

        @Override
        public Collection<Container.Entry> getChildren() {
            return JarContainerEntryUtil.removeInnerTypeEntries(this.entry.getChildren());
        }
    }
}

