/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirDesignatedCompilerRequiredAnnotationsResolveTransformer;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u0005J\u000e\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\u0007J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "", "()V", "declarationsWithResolvedAnnotations", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "filesWithResolvedImports", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "annotationsAreResolved", "", "declaration", "importsAreResolved", "file", "recordThatAnnotationsAreResolved", "", "recordThatImportsAreResolved", "resolveAnnotationSymbol", "symbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "resolveAnnotationsOnAnnotationIfNeeded", "resolve"})
public class CompilerRequiredAnnotationsComputationSession {
    @NotNull
    private final Set<FirFile> filesWithResolvedImports = new LinkedHashSet();
    @NotNull
    private final Set<FirDeclaration> declarationsWithResolvedAnnotations = new LinkedHashSet();

    public final boolean importsAreResolved(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return this.filesWithResolvedImports.contains(file2);
    }

    public final void recordThatImportsAreResolved(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        if (!this.filesWithResolvedImports.add(file2)) {
            throw new IllegalStateException("Imports are resolved twice".toString());
        }
    }

    public final boolean annotationsAreResolved(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (declaration instanceof FirFile) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)declaration.getOrigin(), (Object)FirDeclarationOrigin.Source.INSTANCE)) {
            return true;
        }
        return this.declarationsWithResolvedAnnotations.contains(declaration);
    }

    public final void recordThatAnnotationsAreResolved(@NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!this.declarationsWithResolvedAnnotations.add(declaration)) {
            throw new IllegalStateException("Annotations are resolved twice".toString());
        }
    }

    public final void resolveAnnotationsOnAnnotationIfNeeded(@NotNull FirRegularClassSymbol symbol2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        FirRegularClass regularClass = (FirRegularClass)symbol2.getFir();
        if (this.annotationsAreResolved(regularClass)) {
            return;
        }
        this.resolveAnnotationSymbol(symbol2, scopeSession);
    }

    public void resolveAnnotationSymbol(@NotNull FirRegularClassSymbol symbol2, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter((Object)symbol2, (String)"symbol");
        Intrinsics.checkNotNullParameter((Object)scopeSession, (String)"scopeSession");
        DesignationState designationState = DesignationState.Companion.create(symbol2, MapsKt.emptyMap(), true);
        if (designationState == null) {
            return;
        }
        DesignationState designation2 = designationState;
        FirDesignatedCompilerRequiredAnnotationsResolveTransformer transformer2 = new FirDesignatedCompilerRequiredAnnotationsResolveTransformer(designation2.getFirstDeclaration().getModuleData().getSession(), scopeSession, this, designation2);
        FirTransformerUtilKt.transformSingle((FirElement)designation2.getFirstDeclaration(), transformer2, null);
    }
}

