/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class BitUtil {
    @Contract(pure=true)
    public static boolean isSet(byte value2, byte mask) {
        BitUtil.assertOneBitMask(mask);
        return (value2 & mask) == mask;
    }

    @Contract(pure=true)
    public static boolean isSet(int value2, int mask) {
        BitUtil.assertOneBitMask(mask);
        return (value2 & mask) == mask;
    }

    @Contract(pure=true)
    public static byte set(byte value2, byte mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return (byte)(setBit ? value2 | mask : value2 & ~mask);
    }

    @Contract(pure=true)
    public static int set(int value2, int mask, boolean setBit) {
        BitUtil.assertOneBitMask(mask);
        return setBit ? value2 | mask : value2 & ~mask;
    }

    @Contract(pure=true)
    public static int clear(int value2, int mask) {
        return BitUtil.set(value2, mask, false);
    }

    private static void assertOneBitMask(byte mask) {
        BitUtil.assertOneBitMask((long)mask & 0xFFL);
    }

    public static void assertOneBitMask(int mask) {
        assert ((mask & mask - 1) == 0) : BitUtil.invalidMaskError(mask);
    }

    private static void assertOneBitMask(long mask) {
        assert ((mask & mask - 1L) == 0L) : BitUtil.invalidMaskError(mask);
    }

    @NotNull
    private static String invalidMaskError(long mask) {
        String string2 = "Mask must have only one bit set, but got: " + Long.toBinaryString(mask);
        if (string2 == null) {
            BitUtil.$$$reportNull$$$0(0);
        }
        return string2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/kotlin/com/intellij/util/BitUtil", "invalidMaskError"));
    }
}

