/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.filters;

import java.util.stream.Stream;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.filters.ElementFilter;

public class AndFilter
implements ElementFilter {
    private final ElementFilter[] myFilters;

    public AndFilter(ElementFilter filter1, ElementFilter filter2) {
        this.myFilters = new ElementFilter[]{filter1, filter2};
    }

    public AndFilter(ElementFilter ... filters) {
        this.myFilters = filters;
    }

    @Override
    public boolean isAcceptable(Object element, PsiElement context) {
        return Stream.of(this.myFilters).allMatch(filter2 -> filter2.isAcceptable(element, context));
    }

    @Override
    public boolean isClassAcceptable(Class elementClass) {
        return Stream.of(this.myFilters).allMatch(filter2 -> filter2.isClassAcceptable(elementClass));
    }

    @Override
    public String toString() {
        return '(' + StringUtil.join(this.myFilters, ElementFilter::toString, " & ") + ')';
    }
}

