/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.openapi.progress;

import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.com.intellij.openapi.application.AccessToken;
import org.jetbrains.kotlin.com.intellij.openapi.progress.JobCanceledException;

@ApiStatus.Internal
public final class Cancellation {
    private static final ThreadLocal<Job> ourJob = new ThreadLocal();

    @VisibleForTesting
    @Nullable
    public static Job currentJob() {
        return ourJob.get();
    }

    public static boolean isCancelled() {
        Job job = ourJob.get();
        return job != null && job.isCancelled();
    }

    public static void checkCancelled() {
        if (Cancellation.isCancelled()) {
            throw new JobCanceledException();
        }
    }

    @NotNull
    public static AccessToken withJob(final @NotNull Job job) {
        if (job == null) {
            Cancellation.$$$reportNull$$$0(0);
        }
        final Job previousJob = ourJob.get();
        ourJob.set(job);
        return new AccessToken(){

            @Override
            public void finish() {
                Job currentJob = (Job)ourJob.get();
                ourJob.set(previousJob);
                if (currentJob != job) {
                    throw new IllegalStateException("Job was not reset correctly");
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "job";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "action";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/kotlin/com/intellij/openapi/progress/Cancellation";
        objectArray[2] = "withJob";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

