/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.serialization;

import com.google.common.collect.Sets;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.concurrent.ThreadSafe;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderCache;
import org.gradle.tooling.internal.provider.serialization.ClassLoaderDetails;
import org.gradle.tooling.internal.provider.serialization.ClasspathInferer;
import org.gradle.tooling.internal.provider.serialization.ClientOwnedClassLoaderSpec;
import org.gradle.tooling.internal.provider.serialization.DeserializeMap;
import org.gradle.tooling.internal.provider.serialization.PayloadClassLoaderRegistry;
import org.gradle.tooling.internal.provider.serialization.SerializeMap;

@ThreadSafe
public class ClientSidePayloadClassLoaderRegistry
implements PayloadClassLoaderRegistry {
    private static final short CLIENT_CLASS_LOADER_ID = 1;
    private final PayloadClassLoaderRegistry delegate;
    private final ClasspathInferer classpathInferer;
    private final ClassLoaderCache classLoaderCache;
    private final Lock lock = new ReentrantLock();
    private final Map<UUID, LocalClassLoaderMapping> classLoaders = new LinkedHashMap<UUID, LocalClassLoaderMapping>();

    public ClientSidePayloadClassLoaderRegistry(PayloadClassLoaderRegistry delegate, ClasspathInferer classpathInferer, ClassLoaderCache classLoaderCache) {
        this.delegate = delegate;
        this.classpathInferer = classpathInferer;
        this.classLoaderCache = classLoaderCache;
    }

    @Override
    public SerializeMap newSerializeSession() {
        final LinkedHashSet candidates = new LinkedHashSet();
        final LinkedHashSet classPath = new LinkedHashSet();
        final HashMap classLoaderIds = new HashMap();
        final HashMap classLoaderDetails = new HashMap();
        return new SerializeMap(){

            @Override
            public short visitClass(Class<?> target) {
                ClassLoader classLoader = target.getClassLoader();
                Short id = (Short)classLoaderIds.get(classLoader);
                if (id != null) {
                    return id;
                }
                ClassLoaderDetails details = ClientSidePayloadClassLoaderRegistry.this.classLoaderCache.maybeGetDetails(classLoader);
                if (details != null) {
                    id = (short)(classLoaderIds.size() + 1 + 1);
                    classLoaderIds.put(classLoader, id);
                    classLoaderDetails.put(id, details);
                    return id;
                }
                ClientSidePayloadClassLoaderRegistry.this.classpathInferer.getClassPathFor(target, classPath);
                candidates.add(target.getClassLoader());
                return 1;
            }

            @Override
            public void collectClassLoaderDefinitions(Map<Short, ClassLoaderDetails> details) {
                ClassLoaderDetails clientClassLoaders = ClientSidePayloadClassLoaderRegistry.this.getDetailsForClassLoaders(candidates, classPath);
                details.putAll(classLoaderDetails);
                details.put((short)1, clientClassLoaders);
            }
        };
    }

    @Override
    public DeserializeMap newDeserializeSession() {
        final DeserializeMap deserializeMap = this.delegate.newDeserializeSession();
        return new DeserializeMap(){

            @Override
            public Class<?> resolveClass(ClassLoaderDetails classLoaderDetails, String className) throws ClassNotFoundException {
                Set candidates = ClientSidePayloadClassLoaderRegistry.this.getClassLoaders(classLoaderDetails);
                if (candidates != null) {
                    for (ClassLoader candidate : candidates) {
                        try {
                            return candidate.loadClass(className);
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                        }
                    }
                    throw new UnsupportedOperationException("Unexpected class received in response.");
                }
                return deserializeMap.resolveClass(classLoaderDetails, className);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<ClassLoader> getClassLoaders(ClassLoaderDetails details) {
        this.lock.lock();
        try {
            LocalClassLoaderMapping localClassLoaderMapping = this.classLoaders.get(details.uuid);
            if (localClassLoaderMapping != null) {
                Set<ClassLoader> set = localClassLoaderMapping.getClassLoaders();
                return set;
            }
            for (LocalClassLoaderMapping classLoaderMapping : new ArrayList<LocalClassLoaderMapping>(this.classLoaders.values())) {
                if (!((LocalClassLoaderMapping)classLoaderMapping).details.spec.equals(details.spec)) continue;
                this.classLoaders.put(details.uuid, classLoaderMapping);
                Set<ClassLoader> set = classLoaderMapping.getClassLoaders();
                return set;
            }
            Iterator<LocalClassLoaderMapping> iterator = null;
            return iterator;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoaderDetails getDetailsForClassLoaders(Set<ClassLoader> candidates, Set<URL> classPath) {
        this.lock.lock();
        try {
            Object object;
            for (LocalClassLoaderMapping localClassLoaderMapping : new ArrayList<LocalClassLoaderMapping>(this.classLoaders.values())) {
                LinkedHashSet<ClassLoader> localCandidates = new LinkedHashSet<ClassLoader>();
                for (WeakReference reference : localClassLoaderMapping.classLoaders) {
                    ClassLoader cl = (ClassLoader)reference.get();
                    if (cl == null) continue;
                    localCandidates.add(cl);
                }
                if (localCandidates.isEmpty()) {
                    this.classLoaders.remove(((LocalClassLoaderMapping)localClassLoaderMapping).details.uuid);
                    continue;
                }
                if (!localCandidates.equals(candidates)) continue;
                object = new ClassLoaderDetails(((LocalClassLoaderMapping)localClassLoaderMapping).details.uuid, new ClientOwnedClassLoaderSpec(new ArrayList<URL>(classPath)));
                return object;
            }
            UUID uuid = UUID.randomUUID();
            ClassLoaderDetails clientClassLoaders = new ClassLoaderDetails(uuid, new ClientOwnedClassLoaderSpec(new ArrayList<URL>(classPath)));
            LocalClassLoaderMapping mapping = new LocalClassLoaderMapping(clientClassLoaders);
            for (ClassLoader candidate : candidates) {
                mapping.classLoaders.add(new WeakReference<ClassLoader>(candidate));
            }
            this.classLoaders.put(uuid, mapping);
            object = mapping.details;
            return object;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class LocalClassLoaderMapping {
        private final Set<WeakReference<ClassLoader>> classLoaders = Sets.newLinkedHashSet();
        private final ClassLoaderDetails details;

        private LocalClassLoaderMapping(ClassLoaderDetails details) {
            this.details = details;
        }

        public String toString() {
            return "{details=" + this.details + " classloaders=" + this.classLoaders + "}";
        }

        Set<ClassLoader> getClassLoaders() {
            LinkedHashSet candidates = Sets.newLinkedHashSet();
            for (WeakReference<ClassLoader> reference : this.classLoaders) {
                ClassLoader classLoader = (ClassLoader)reference.get();
                if (classLoader == null) continue;
                candidates.add(classLoader);
            }
            return candidates;
        }
    }
}

