/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.local;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.gradle.api.Action;
import org.gradle.api.NonNullApi;
import org.gradle.internal.hash.ChecksumService;
import org.gradle.internal.resource.local.DefaultPathKeyFileStore;
import org.gradle.internal.resource.local.LocallyAvailableResource;

@NonNullApi
public class UniquePathKeyFileStore
extends DefaultPathKeyFileStore {
    public UniquePathKeyFileStore(ChecksumService checksumService, File baseDir) {
        super(checksumService, baseDir);
    }

    @Override
    public LocallyAvailableResource move(String path, File source) {
        LocallyAvailableResource entry = super.move(path, source);
        if (source.exists()) {
            FileUtils.deleteQuietly((File)source);
        }
        return entry;
    }

    @Override
    protected void doAdd(File destination, Action<File> action) {
        if (!destination.exists()) {
            super.doAdd(destination, action);
        }
    }
}

