/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.RelativePath;
import org.gradle.api.internal.file.DefaultFilePermissions;
import org.gradle.api.specs.Spec;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.file.Stat;

public class SingleFileTreeElementMatcher {
    private final Stat stat;

    public SingleFileTreeElementMatcher(Stat stat) {
        this.stat = stat;
    }

    public boolean elementWithRelativePathMatches(Spec<FileTreeElement> filter, File element, String relativePathString) {
        boolean elementIsFile = !element.isDirectory();
        RelativePath relativePath = RelativePath.parse((boolean)elementIsFile, (String)relativePathString);
        if (!filter.isSatisfiedBy((Object)new ReadOnlyFileTreeElement(element, relativePath, this.stat))) {
            return false;
        }
        RelativePath parentRelativePath = relativePath.getParent();
        File parentFile = element.getParentFile();
        while (parentRelativePath != null && parentRelativePath != RelativePath.EMPTY_ROOT) {
            if (!filter.isSatisfiedBy((Object)new ReadOnlyFileTreeElement(parentFile, parentRelativePath, this.stat))) {
                return false;
            }
            parentRelativePath = parentRelativePath.getParent();
            parentFile = parentFile.getParentFile();
        }
        return true;
    }

    private static class ReadOnlyFileTreeElement
    implements FileTreeElement {
        private final File file;
        private final RelativePath relativePath;
        private final Stat stat;

        public ReadOnlyFileTreeElement(File file, RelativePath relativePath, Stat stat) {
            this.file = file;
            this.relativePath = relativePath;
            this.stat = stat;
        }

        public File getFile() {
            return this.file;
        }

        public boolean isDirectory() {
            return !this.relativePath.isFile();
        }

        public long getLastModified() {
            return this.file.lastModified();
        }

        public long getSize() {
            return this.file.length();
        }

        public InputStream open() {
            try {
                return Files.newInputStream(this.file.toPath(), new OpenOption[0]);
            }
            catch (IOException e) {
                throw UncheckedException.throwAsUncheckedException((Throwable)e);
            }
        }

        public void copyTo(OutputStream output) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        public boolean copyTo(File target) {
            throw new UnsupportedOperationException("Copy to not supported for filters");
        }

        public String getName() {
            return this.file.getName();
        }

        public String getPath() {
            return this.relativePath.getPathString();
        }

        public RelativePath getRelativePath() {
            return this.relativePath;
        }

        public int getMode() {
            return this.getPermissions().toUnixNumeric();
        }

        public FilePermissions getPermissions() {
            int unixNumeric = this.stat.getUnixMode(this.file);
            return new DefaultFilePermissions(unixNumeric);
        }
    }
}

