/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import com.google.common.annotations.VisibleForTesting;
import org.gradle.api.NonNullApi;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.tasks.TaskDestroyablesInternal;
import org.gradle.api.internal.tasks.TaskLocalStateInternal;
import org.gradle.internal.properties.PropertyVisitor;
import org.gradle.internal.properties.bean.PropertyWalker;
import org.gradle.internal.reflect.validation.TypeValidationContext;

@NonNullApi
public class TaskPropertyUtils {
    @VisibleForTesting
    public static void visitProperties(PropertyWalker propertyWalker, TaskInternal task, PropertyVisitor visitor) {
        TaskPropertyUtils.visitProperties(propertyWalker, task, TypeValidationContext.NOOP, visitor);
    }

    public static void visitProperties(PropertyWalker propertyWalker, TaskInternal task, TypeValidationContext validationContext, PropertyVisitor visitor) {
        TaskPropertyUtils.visitAnnotatedProperties(propertyWalker, task, validationContext, visitor);
        TaskPropertyUtils.visitRegisteredProperties(task, visitor);
    }

    private static void visitRegisteredProperties(TaskInternal task, PropertyVisitor visitor) {
        task.getInputs().visitRegisteredProperties(visitor);
        task.getOutputs().visitRegisteredProperties(visitor);
        ((TaskDestroyablesInternal)task.getDestroyables()).visitRegisteredProperties(visitor);
        ((TaskLocalStateInternal)task.getLocalState()).visitRegisteredProperties(visitor);
    }

    static void visitAnnotatedProperties(PropertyWalker propertyWalker, TaskInternal task, TypeValidationContext validationContext, PropertyVisitor visitor) {
        propertyWalker.visitProperties((Object)task, validationContext, visitor);
    }
}

