/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.classpath;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.classpath.ManifestUtil;
import org.gradle.internal.classloader.ClasspathUtil;
import org.gradle.internal.classpath.DefaultClassPath;

public class EffectiveClassPath
extends DefaultClassPath {
    public EffectiveClassPath(ClassLoader classLoader) {
        super(DefaultClassPath.ImmutableUniqueList.of(EffectiveClassPath.findAvailableClasspathFiles(classLoader)));
    }

    private static List<File> findAvailableClasspathFiles(ClassLoader classLoader) {
        List rawClasspath = ClasspathUtil.getClasspath((ClassLoader)classLoader).getAsURLs();
        ArrayList<File> classpathFiles = new ArrayList<File>();
        for (URL url : rawClasspath) {
            if (!url.getProtocol().equals("file")) continue;
            try {
                File classpathFile = new File(url.toURI());
                EffectiveClassPath.addClasspathFile(classpathFile, classpathFiles);
            }
            catch (URISyntaxException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
        if (classLoader == ClassLoader.getSystemClassLoader()) {
            for (String value : System.getProperty("java.class.path").split(File.pathSeparator)) {
                EffectiveClassPath.addClasspathFile(new File(value), classpathFiles);
            }
        }
        return classpathFiles;
    }

    private static void addClasspathFile(File classpathFile, List<File> classpathFiles) {
        if (classpathFile.exists() && !classpathFiles.contains(classpathFile)) {
            classpathFiles.add(classpathFile.getAbsoluteFile());
            EffectiveClassPath.addManifestClasspathFiles(classpathFile, classpathFiles);
        }
    }

    private static void addManifestClasspathFiles(File classpathFile, List<File> classpathFiles) {
        List<URI> classpathUris = ManifestUtil.parseManifestClasspath(classpathFile);
        for (URI classpathUri : classpathUris) {
            EffectiveClassPath.addClasspathFile(new File(classpathUri), classpathFiles);
        }
    }
}

