/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.metadata;

import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentIdentifierSerializer;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.IvyArtifactNameSerializer;
import org.gradle.internal.component.local.model.ComponentFileArtifactIdentifier;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;
import org.gradle.internal.serialize.Serializer;

public class ComponentFileArtifactIdentifierSerializer
implements Serializer<ComponentFileArtifactIdentifier> {
    private final ComponentIdentifierSerializer componentIdentifierSerializer = new ComponentIdentifierSerializer();

    public void write(Encoder encoder, ComponentFileArtifactIdentifier value) throws Exception {
        this.componentIdentifierSerializer.write(encoder, value.getComponentIdentifier());
        Object rawFileName = value.getRawFileName();
        if (rawFileName instanceof IvyArtifactName) {
            encoder.writeBoolean(true);
            IvyArtifactNameSerializer.INSTANCE.write(encoder, (IvyArtifactName)rawFileName);
        } else {
            encoder.writeBoolean(false);
            encoder.writeString((CharSequence)((String)rawFileName));
        }
    }

    public ComponentFileArtifactIdentifier read(Decoder decoder) throws Exception {
        ModuleComponentIdentifier componentIdentifier = (ModuleComponentIdentifier)this.componentIdentifierSerializer.read(decoder);
        if (decoder.readBoolean()) {
            IvyArtifactName fileName = IvyArtifactNameSerializer.INSTANCE.read(decoder);
            return new ComponentFileArtifactIdentifier((ComponentIdentifier)componentIdentifier, fileName);
        }
        String fileName = decoder.readString();
        return new ComponentFileArtifactIdentifier((ComponentIdentifier)componentIdentifier, fileName);
    }
}

