/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import com.google.common.collect.Interner;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.gradle.internal.serialize.Decoder;

class StringDeduplicatingDecoder
implements Decoder,
Closeable {
    private final Decoder delegate;
    private final Interner<String> stringInterner;

    StringDeduplicatingDecoder(Decoder delegate, Interner<String> stringInterner) {
        this.delegate = delegate;
        this.stringInterner = stringInterner;
    }

    public InputStream getInputStream() {
        return this.delegate.getInputStream();
    }

    public long readLong() throws EOFException, IOException {
        return this.delegate.readLong();
    }

    public long readSmallLong() throws EOFException, IOException {
        return this.delegate.readSmallLong();
    }

    public int readInt() throws EOFException, IOException {
        return this.delegate.readInt();
    }

    public int readSmallInt() throws EOFException, IOException {
        return this.delegate.readSmallInt();
    }

    @Nullable
    public Integer readNullableSmallInt() throws IOException {
        return this.delegate.readNullableSmallInt();
    }

    public boolean readBoolean() throws EOFException, IOException {
        return this.delegate.readBoolean();
    }

    public String readString() throws EOFException, IOException {
        return (String)this.stringInterner.intern((Object)this.delegate.readString());
    }

    @Nullable
    public String readNullableString() throws EOFException, IOException {
        String str = this.delegate.readNullableString();
        if (str != null) {
            str = (String)this.stringInterner.intern((Object)str);
        }
        return str;
    }

    public byte readByte() throws EOFException, IOException {
        return this.delegate.readByte();
    }

    public void readBytes(byte[] buffer) throws EOFException, IOException {
        this.delegate.readBytes(buffer);
    }

    public void readBytes(byte[] buffer, int offset, int count) throws EOFException, IOException {
        this.delegate.readBytes(buffer, offset, count);
    }

    public byte[] readBinary() throws EOFException, IOException {
        return this.delegate.readBinary();
    }

    public void skipBytes(long count) throws EOFException, IOException {
        this.delegate.skipBytes(count);
    }

    public <T> T decodeChunked(Decoder.DecodeAction<Decoder, T> decodeAction) throws EOFException, Exception {
        throw new UnsupportedOperationException();
    }

    public void skipChunked() throws EOFException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        ((Closeable)this.delegate).close();
    }
}

