/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FilePermissions;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.internal.file.DefaultFilePermissions;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.file.Chmod;
import org.gradle.util.internal.GFileUtils;

public abstract class AbstractFileTreeElement
implements FileTreeElement {
    private final Chmod chmod;

    public abstract String getDisplayName();

    protected AbstractFileTreeElement(Chmod chmod) {
        this.chmod = chmod;
    }

    protected Chmod getChmod() {
        return this.chmod;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getName() {
        return this.getRelativePath().getLastName();
    }

    public String getPath() {
        return this.getRelativePath().getPathString();
    }

    public void copyTo(OutputStream output) {
        try (InputStream inputStream = this.open();){
            IOUtils.copyLarge((InputStream)inputStream, (OutputStream)output);
        }
        catch (IOException e) {
            throw new UncheckedIOException((Throwable)e);
        }
    }

    public boolean copyTo(File target) {
        this.validateTimeStamps();
        try {
            if (this.isDirectory()) {
                GFileUtils.mkdirs((File)target);
            } else {
                GFileUtils.mkdirs((File)target.getParentFile());
                this.copyFile(target);
            }
            this.chmod.chmod(target, this.getPermissions().toUnixNumeric());
            return true;
        }
        catch (Exception e) {
            throw new CopyFileElementException(String.format("Could not copy %s to '%s'.", this.getDisplayName(), target), e);
        }
    }

    private void validateTimeStamps() {
        long lastModified = this.getLastModified();
        if (lastModified < 0L) {
            throw new GradleException(String.format("Invalid Timestamp %s for '%s'.", lastModified, this.getDisplayName()));
        }
    }

    private void copyFile(File target) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(target);){
            this.copyTo(outputStream);
        }
    }

    public int getMode() {
        return this.getPermissions().toUnixNumeric();
    }

    public FilePermissions getPermissions() {
        return this.isDirectory() ? DefaultFilePermissions.DEFAULT_DIR_PERMISSIONS : DefaultFilePermissions.DEFAULT_FILE_PERMISSIONS;
    }

    @Contextual
    private static class CopyFileElementException
    extends GradleException {
        CopyFileElementException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

