/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.text;

import java.util.Arrays;
import org.gradle.api.Action;
import org.gradle.internal.SystemProperties;
import org.gradle.internal.logging.text.AbstractStyledTextOutput;

public abstract class AbstractLineChoppingStyledTextOutput
extends AbstractStyledTextOutput {
    private final char[] eolChars;
    private final String eol;
    private SeenFromEol seenFromEol;
    private State currentState = INITIAL_STATE;
    private static final State SYSTEM_EOL_PARSING_STATE;
    private static final State INITIAL_STATE;
    private static final State WELL_KNOWN_EOL_PARSING_STATE;
    private static final State WINDOWS_EOL_PARSING_ODDITY_STATE;
    private static final State START_LINE_STATE;

    protected AbstractLineChoppingStyledTextOutput() {
        this.eol = SystemProperties.getInstance().getLineSeparator();
        this.eolChars = this.eol.toCharArray();
        this.seenFromEol = new SeenFromEol(this.eolChars);
    }

    @Override
    protected final void doAppend(String text) {
        StateContext context = new StateContext(text);
        while (context.hasChar()) {
            this.currentState.execute(context);
        }
        this.seenFromEol = context.seenFromEol;
        context.flushLineText();
    }

    protected void doStartLine() {
    }

    protected abstract void doLineText(CharSequence var1);

    protected abstract void doEndLine(CharSequence var1);

    static {
        INITIAL_STATE = SYSTEM_EOL_PARSING_STATE = new State(){

            public void execute(StateContext context) {
                if (!context.seenFromEol.all()) {
                    if (!context.eol.equals("\r\n") && context.isCurrentCharEquals(context.eolChars[context.seenFromEol.size()])) {
                        context.seenFromEol.add();
                        if (context.seenFromEol.all()) {
                            context.flushLineText();
                            context.flushEndLine(context.eol);
                            context.next(context.seenFromEol.size());
                            context.reset();
                            context.setState(START_LINE_STATE);
                        }
                        return;
                    }
                    if (context.seenFromEol.none()) {
                        WELL_KNOWN_EOL_PARSING_STATE.execute(context);
                        return;
                    }
                }
                context.next(context.seenFromEol.size());
                context.flushLineText();
                context.reset();
                context.setState(INITIAL_STATE);
            }
        };
        WELL_KNOWN_EOL_PARSING_STATE = new State(){

            public void execute(StateContext context) {
                if (context.isCurrentCharEquals('\r')) {
                    context.seenFromEol.add('\r');
                    context.setState(WINDOWS_EOL_PARSING_ODDITY_STATE);
                } else if (context.isCurrentCharEquals('\n')) {
                    context.flushLineText();
                    context.flushEndLine("\n");
                    context.next();
                    context.reset();
                    context.setState(START_LINE_STATE);
                } else {
                    context.next();
                    context.setState(INITIAL_STATE);
                }
            }
        };
        WINDOWS_EOL_PARSING_ODDITY_STATE = new State(){

            public void execute(StateContext context) {
                if (context.isCurrentCharEquals('\n')) {
                    context.flushLineText();
                    context.flushEndLine("\r\n");
                    context.next(2);
                    context.reset();
                    context.setState(START_LINE_STATE);
                } else if (context.isCurrentCharEquals('\r')) {
                    context.next();
                } else {
                    context.next();
                    context.seenFromEol.clear();
                    context.setState(INITIAL_STATE);
                }
            }
        };
        START_LINE_STATE = new State(){

            public void execute(StateContext context) {
                context.flushStartLine();
                context.setState(INITIAL_STATE);
            }
        };
    }

    private static class SeenFromEol {
        private final char[] eol;
        private final char[] seen;
        private int count;

        SeenFromEol(char[] eol) {
            this.eol = eol;
            this.seen = new char[eol.length];
            this.count = 0;
        }

        private SeenFromEol(char[] eol, char[] seen, int count) {
            this.eol = eol;
            this.seen = seen;
            this.count = count;
        }

        SeenFromEol copy() {
            return new SeenFromEol(this.eol, Arrays.copyOf(this.seen, this.seen.length), this.count);
        }

        public void add(char c) {
            this.seen[this.count++] = c;
        }

        public void add() {
            this.seen[this.count] = this.eol[this.count];
            ++this.count;
        }

        void clear() {
            this.count = 0;
        }

        int size() {
            return this.count;
        }

        boolean all() {
            return this.count == this.seen.length;
        }

        boolean none() {
            return this.count == 0;
        }

        public String string(int length) {
            return new String(this.seen, 0, length);
        }
    }

    private class StateContext {
        private final SeenFromEol seenFromEol;
        private final char[] eolChars;
        private final String eol;
        private final String text;
        private final int max;
        private int start;
        private int pos;

        StateContext(String text) {
            this.seenFromEol = AbstractLineChoppingStyledTextOutput.this.seenFromEol.copy();
            this.eolChars = AbstractLineChoppingStyledTextOutput.this.eolChars;
            this.eol = AbstractLineChoppingStyledTextOutput.this.eol;
            this.text = text;
            this.max = text.length();
            this.start = this.pos = -this.seenFromEol.size();
        }

        void next() {
            ++this.pos;
        }

        void next(int count) {
            this.pos += count;
        }

        boolean isCurrentCharEquals(char value) {
            char ch = this.seenFromEol.size() + this.pos < 0 ? this.eolChars[this.pos + AbstractLineChoppingStyledTextOutput.this.seenFromEol.size()] : this.text.charAt(this.pos + this.seenFromEol.size());
            return ch == value;
        }

        boolean hasChar() {
            return this.pos + this.seenFromEol.size() < this.max;
        }

        void setState(State state) {
            AbstractLineChoppingStyledTextOutput.this.currentState = state;
        }

        void reset() {
            this.start = this.pos;
            this.seenFromEol.clear();
        }

        void flushLineText() {
            if (this.start < this.pos) {
                String data = "";
                if (this.start < 0 && this.pos >= 0) {
                    data = this.seenFromEol.string(Math.abs(this.start)) + this.text.substring(0, this.pos);
                } else if (this.start >= 0) {
                    data = this.text.substring(this.start, this.pos);
                }
                if (data.length() > 0) {
                    AbstractLineChoppingStyledTextOutput.this.doLineText(data);
                }
            }
        }

        void flushEndLine(String eol) {
            AbstractLineChoppingStyledTextOutput.this.doEndLine(eol);
        }

        void flushStartLine() {
            AbstractLineChoppingStyledTextOutput.this.doStartLine();
        }
    }

    private static interface State
    extends Action<StateContext> {
    }
}

