/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.instantiation.generator;

import com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.reflect.ObjectInstantiationException;
import org.gradle.cache.internal.CrossBuildInMemoryCacheFactory;
import org.gradle.internal.instantiation.DeserializationInstantiator;
import org.gradle.internal.instantiation.InjectAnnotationHandler;
import org.gradle.internal.instantiation.InstanceGenerator;
import org.gradle.internal.instantiation.InstantiationScheme;
import org.gradle.internal.instantiation.InstantiatorFactory;
import org.gradle.internal.instantiation.PropertyRoleAnnotationHandler;
import org.gradle.internal.instantiation.generator.AsmBackedClassGenerator;
import org.gradle.internal.instantiation.generator.ClassGenerator;
import org.gradle.internal.instantiation.generator.ConstructorSelector;
import org.gradle.internal.instantiation.generator.DefaultInstantiationScheme;
import org.gradle.internal.instantiation.generator.Jsr330ConstructorSelector;
import org.gradle.internal.instantiation.generator.ParamsMatchingConstructorSelector;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.internal.service.ServiceLookup;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.state.ManagedFactory;

public class DefaultInstantiatorFactory
implements InstantiatorFactory {
    private static final int MANAGED_FACTORY_ID = Objects.hashCode(ManagedTypeFactory.class.getName());
    private final ServiceRegistry defaultServices;
    private final CrossBuildInMemoryCacheFactory cacheFactory;
    private final List<InjectAnnotationHandler> annotationHandlers;
    private final PropertyRoleAnnotationHandler roleHandler;
    private final DefaultInstantiationScheme injectOnlyScheme;
    private final DefaultInstantiationScheme injectOnlyLenientScheme;
    private final DefaultInstantiationScheme decoratingScheme;
    private final DefaultInstantiationScheme decoratingLenientScheme;
    private final ManagedFactory managedFactory;

    public DefaultInstantiatorFactory(CrossBuildInMemoryCacheFactory cacheFactory, List<InjectAnnotationHandler> injectHandlers, PropertyRoleAnnotationHandler roleAnnotationHandler) {
        this.cacheFactory = cacheFactory;
        this.annotationHandlers = injectHandlers;
        this.roleHandler = roleAnnotationHandler;
        this.defaultServices = this.defaultServiceRegistry();
        ClassGenerator injectOnlyGenerator = AsmBackedClassGenerator.injectOnly(injectHandlers, roleAnnotationHandler, (Collection<Class<? extends Annotation>>)ImmutableSet.of(), cacheFactory, MANAGED_FACTORY_ID);
        ClassGenerator decoratedGenerator = AsmBackedClassGenerator.decorateAndInject(injectHandlers, roleAnnotationHandler, (Collection<Class<? extends Annotation>>)ImmutableSet.of(), cacheFactory, MANAGED_FACTORY_ID);
        Jsr330ConstructorSelector injectOnlyJsr330Selector = new Jsr330ConstructorSelector(injectOnlyGenerator, cacheFactory.newClassCache());
        Jsr330ConstructorSelector decoratedJsr330Selector = new Jsr330ConstructorSelector(decoratedGenerator, cacheFactory.newClassCache());
        ParamsMatchingConstructorSelector injectOnlyLenientSelector = new ParamsMatchingConstructorSelector(injectOnlyGenerator);
        ParamsMatchingConstructorSelector decoratedLenientSelector = new ParamsMatchingConstructorSelector(decoratedGenerator);
        ImmutableSet injectionAnnotations = ImmutableSet.of(Inject.class);
        this.injectOnlyScheme = new DefaultInstantiationScheme((ConstructorSelector)injectOnlyJsr330Selector, injectOnlyGenerator, (ServiceLookup)this.defaultServices, (Set<Class<? extends Annotation>>)injectionAnnotations, cacheFactory);
        this.injectOnlyLenientScheme = new DefaultInstantiationScheme((ConstructorSelector)injectOnlyLenientSelector, injectOnlyGenerator, (ServiceLookup)this.defaultServices, (Set<Class<? extends Annotation>>)injectionAnnotations, cacheFactory);
        this.decoratingScheme = new DefaultInstantiationScheme((ConstructorSelector)decoratedJsr330Selector, decoratedGenerator, (ServiceLookup)this.defaultServices, (Set<Class<? extends Annotation>>)injectionAnnotations, cacheFactory);
        this.decoratingLenientScheme = new DefaultInstantiationScheme((ConstructorSelector)decoratedLenientSelector, decoratedGenerator, (ServiceLookup)this.defaultServices, (Set<Class<? extends Annotation>>)injectionAnnotations, cacheFactory);
        this.managedFactory = new ManagedTypeFactory(this.injectOnlyScheme.deserializationInstantiator());
    }

    private DefaultServiceRegistry defaultServiceRegistry() {
        DefaultServiceRegistry services = new DefaultServiceRegistry("default services");
        services.add(InstantiatorFactory.class, (Object)this);
        return services;
    }

    @Override
    public InstanceGenerator inject(ServiceLookup services) {
        return this.injectOnlyScheme.withServices(services).instantiator();
    }

    @Override
    public InstanceGenerator inject() {
        return this.injectOnlyScheme.instantiator();
    }

    @Override
    public InstantiationScheme injectScheme() {
        return this.injectOnlyScheme;
    }

    @Override
    public InstantiationScheme injectScheme(Collection<Class<? extends Annotation>> injectAnnotations) {
        if (injectAnnotations.isEmpty()) {
            return this.injectOnlyScheme;
        }
        for (Class<? extends Annotation> annotation : injectAnnotations) {
            this.assertKnownAnnotation(annotation);
        }
        ClassGenerator classGenerator = AsmBackedClassGenerator.injectOnly(this.annotationHandlers, this.roleHandler, (Collection<Class<? extends Annotation>>)ImmutableSet.copyOf(injectAnnotations), this.cacheFactory, MANAGED_FACTORY_ID);
        Jsr330ConstructorSelector constructorSelector = new Jsr330ConstructorSelector(classGenerator, this.cacheFactory.newClassCache());
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)(injectAnnotations.size() + 1));
        builder.addAll(injectAnnotations);
        builder.add(Inject.class);
        return new DefaultInstantiationScheme((ConstructorSelector)constructorSelector, classGenerator, (ServiceLookup)this.defaultServices, (Set<Class<? extends Annotation>>)builder.build(), this.cacheFactory);
    }

    @Override
    public InstanceGenerator injectLenient() {
        return this.injectOnlyLenientScheme.instantiator();
    }

    @Override
    public InstanceGenerator injectLenient(ServiceLookup services) {
        return this.injectOnlyLenientScheme.withServices(services).instantiator();
    }

    @Override
    public InstantiationScheme decorateLenientScheme() {
        return this.decoratingLenientScheme;
    }

    @Override
    public InstanceGenerator decorateLenient() {
        return this.decoratingLenientScheme.instantiator();
    }

    @Override
    public InstanceGenerator decorateLenient(ServiceLookup services) {
        return this.decoratingLenientScheme.withServices(services).instantiator();
    }

    @Override
    public InstantiationScheme decorateScheme() {
        return this.decoratingScheme;
    }

    @Override
    public InstanceGenerator decorate(ServiceLookup services) {
        return this.decoratingScheme.withServices(services).instantiator();
    }

    @Override
    public ManagedFactory getManagedFactory() {
        return this.managedFactory;
    }

    private void assertKnownAnnotation(Class<? extends Annotation> annotation) {
        for (InjectAnnotationHandler annotationHandler : this.annotationHandlers) {
            if (!annotationHandler.getAnnotationType().equals(annotation)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Annotation @%s is not a registered injection annotation.", annotation.getSimpleName()));
    }

    private static class ManagedTypeFactory
    implements ManagedFactory {
        private final DeserializationInstantiator deserializationInstantiator;

        public ManagedTypeFactory(DeserializationInstantiator deserializationInstantiator) {
            this.deserializationInstantiator = deserializationInstantiator;
        }

        @Override
        @Nullable
        public <T> T fromState(Class<T> type, Object state) {
            try {
                Object instance = this.deserializationInstantiator.newInstance(type, Object.class);
                instance.getClass().getMethod("initFromState", Object[].class).invoke(instance, state);
                return type.cast(instance);
            }
            catch (Exception e) {
                throw new ObjectInstantiationException(type, (Throwable)e);
            }
        }

        @Override
        public int getId() {
            return MANAGED_FACTORY_ID;
        }
    }
}

