/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.nativeplatform.internal.incremental.sourceparser;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.gradle.language.nativeplatform.internal.Expression;
import org.gradle.language.nativeplatform.internal.IncludeType;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.AbstractExpression;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.AbstractMacroFunction;
import org.gradle.language.nativeplatform.internal.incremental.sourceparser.ComplexExpression;

class ArgsMappingMacroFunction
extends AbstractMacroFunction {
    static final int KEEP = -1;
    static final int REPLACE_ARGS = -2;
    private final int[] argsMap;
    private final IncludeType type;
    private final String value;
    private final List<Expression> arguments;

    public ArgsMappingMacroFunction(String macroName, int parameters, int[] argsMap, IncludeType type, String value, List<Expression> arguments) {
        super(macroName, parameters);
        this.argsMap = argsMap;
        this.type = type;
        this.value = value;
        this.arguments = arguments;
    }

    @Override
    protected String getBody() {
        return AbstractExpression.format(this.type, this.value, this.arguments);
    }

    public IncludeType getType() {
        return this.type;
    }

    public String getValue() {
        return this.value;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    public int[] getArgsMap() {
        return this.argsMap;
    }

    public Expression evaluate(List<Expression> arguments) {
        ArrayList<Expression> mapped = new ArrayList<Expression>(this.arguments.size());
        int currentMapPos = 0;
        for (Expression argument : this.arguments) {
            currentMapPos = this.mapInto(argument, arguments, currentMapPos, mapped);
        }
        return new ComplexExpression(this.type, this.value, mapped);
    }

    private int mapInto(Expression expression, List<Expression> arguments, int currentMapPos, List<Expression> mapped) {
        int replaceWith = this.argsMap[currentMapPos];
        ++currentMapPos;
        if (replaceWith == -1) {
            mapped.add(expression);
        } else if (replaceWith == -2) {
            ArrayList<Expression> mappedArgs = new ArrayList<Expression>(expression.getArguments().size());
            for (Expression arg : expression.getArguments()) {
                currentMapPos = this.mapInto(arg, arguments, currentMapPos, mappedArgs);
            }
            mapped.add(new ComplexExpression(expression.getType(), expression.getValue(), mappedArgs));
        } else if (this.type == IncludeType.MACRO_FUNCTION) {
            mapped.add(arguments.get(replaceWith).asMacroExpansion());
        } else {
            mapped.add(arguments.get(replaceWith));
        }
        return currentMapPos;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ArgsMappingMacroFunction other = (ArgsMappingMacroFunction)obj;
        return this.type == other.type && Objects.equal((Object)this.value, (Object)other.value) && Arrays.equals(this.argsMap, other.argsMap) && this.arguments.equals(other.arguments);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.type.hashCode() ^ this.arguments.hashCode() ^ Arrays.hashCode(this.argsMap);
    }
}

