/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.obr.filter;

import org.apache.ivy.osgi.obr.xml.RequirementFilter;

public class CompareFilter
extends RequirementFilter {
    private Operator operator;
    private final String rightValue;
    private final String leftValue;

    public CompareFilter(String leftValue, Operator operator, String rightValue) {
        this.leftValue = leftValue;
        this.rightValue = rightValue;
        this.operator = operator;
    }

    public String getLeftValue() {
        return this.leftValue;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public String getRightValue() {
        return this.rightValue;
    }

    public void append(StringBuffer builder) {
        builder.append("(");
        builder.append(this.leftValue);
        builder.append(this.operator.toString());
        builder.append(this.rightValue);
        builder.append(")");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.leftValue == null ? 0 : this.leftValue.hashCode());
        result = 31 * result + (this.operator == null ? 0 : this.operator.hashCode());
        result = 31 * result + (this.rightValue == null ? 0 : this.rightValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CompareFilter)) {
            return false;
        }
        CompareFilter other = (CompareFilter)obj;
        if (this.leftValue == null ? other.leftValue != null : !this.leftValue.equals(other.leftValue)) {
            return false;
        }
        if (this.operator == null ? other.operator != null : !this.operator.equals(other.operator)) {
            return false;
        }
        return !(this.rightValue == null ? other.rightValue != null : !this.rightValue.equals(other.rightValue));
    }

    public static class Operator {
        public static Operator EQUALS = new Operator();
        public static Operator LOWER_THAN = new Operator();
        public static Operator LOWER_OR_EQUAL = new Operator();
        public static Operator GREATER_THAN = new Operator();
        public static Operator GREATER_OR_EQUAL = new Operator();

        public String toString() {
            if (this == EQUALS) {
                return "=";
            }
            if (this == GREATER_THAN) {
                return ">";
            }
            if (this == GREATER_OR_EQUAL) {
                return ">=";
            }
            if (this == LOWER_THAN) {
                return "<";
            }
            if (this == LOWER_OR_EQUAL) {
                return "<=";
            }
            return super.toString();
        }
    }
}

