/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import com.google.common.collect.Lists;
import java.util.List;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateFactory;
import org.gradle.buildinit.plugins.internal.TemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.model.Description;
import org.gradle.buildinit.plugins.internal.modifiers.ComponentType;

public class JvmLibraryProjectInitDescriptor
extends JvmProjectInitDescriptor {
    private final TemplateLibraryVersionProvider libraryVersionProvider;

    public JvmLibraryProjectInitDescriptor(Description description, TemplateLibraryVersionProvider libraryVersionProvider, DocumentationRegistry documentationRegistry) {
        super(description, libraryVersionProvider, documentationRegistry);
        this.libraryVersionProvider = libraryVersionProvider;
    }

    @Override
    public ComponentType getComponentType() {
        return ComponentType.LIBRARY;
    }

    @Override
    public void generateProjectBuildScript(String projectName, InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        super.generateProjectBuildScript(projectName, settings, buildScriptBuilder);
        this.applyLibraryPlugin(buildScriptBuilder);
        buildScriptBuilder.dependency("api", "This dependency is exported to consumers, that is to say found on their compile classpath.", "org.apache.commons:commons-math3:" + this.libraryVersionProvider.getVersion("commons-math"));
        buildScriptBuilder.implementationDependency("This dependency is used internally, and not exposed to consumers on their own compile classpath.", "com.google.guava:guava:" + this.libraryVersionProvider.getVersion("guava"));
    }

    @Override
    protected List<String> getSourceTemplates(String subproject, InitSettings settings, TemplateFactory templateFactory) {
        return Lists.newArrayList((Object[])new String[]{"Library"});
    }

    @Override
    protected List<String> getTestSourceTemplates(String subproject, InitSettings settings, TemplateFactory templateFactory) {
        return Lists.newArrayList((Object[])new String[]{JvmLibraryProjectInitDescriptor.getUnitTestSourceTemplateName(settings)});
    }

    private static String getUnitTestSourceTemplateName(InitSettings settings) {
        switch (settings.getTestFramework()) {
            case SPOCK: {
                return "groovy/LibraryTest";
            }
            case TESTNG: {
                return "testng/LibraryTest";
            }
            case JUNIT: 
            case KOTLINTEST: {
                return "LibraryTest";
            }
            case JUNIT_JUPITER: {
                return "junitjupiter/LibraryTest";
            }
            case SCALATEST: {
                return "LibrarySuite";
            }
        }
        throw new IllegalArgumentException();
    }
}

