/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.health.memory;

import org.gradle.internal.os.OperatingSystem;
import org.gradle.process.internal.health.memory.CGroupMemoryInfo;
import org.gradle.process.internal.health.memory.MBeanOsMemoryInfo;
import org.gradle.process.internal.health.memory.MemInfoOsMemoryInfo;
import org.gradle.process.internal.health.memory.NativeOsMemoryInfo;
import org.gradle.process.internal.health.memory.OsMemoryInfo;
import org.gradle.process.internal.health.memory.OsMemoryStatus;

public class DefaultOsMemoryInfo
implements OsMemoryInfo {
    private final OsMemoryInfo delegate;

    public DefaultOsMemoryInfo() {
        OperatingSystem operatingSystem = OperatingSystem.current();
        this.delegate = operatingSystem.isMacOsX() ? new NativeOsMemoryInfo() : (operatingSystem.isLinux() ? this.getLinuxDelegate() : new MBeanOsMemoryInfo());
    }

    private OsMemoryInfo getLinuxDelegate() {
        OsMemoryStatus memInfoSnapshot;
        OsMemoryStatus cGroupSnapshot;
        CGroupMemoryInfo cGroupDelegate = new CGroupMemoryInfo();
        MemInfoOsMemoryInfo memInfoDelegate = new MemInfoOsMemoryInfo();
        try {
            cGroupSnapshot = cGroupDelegate.getOsSnapshot();
        }
        catch (UnsupportedOperationException e) {
            return memInfoDelegate;
        }
        try {
            memInfoSnapshot = memInfoDelegate.getOsSnapshot();
        }
        catch (UnsupportedOperationException e) {
            return cGroupDelegate;
        }
        long cGroupFreeMemory = cGroupSnapshot.getFreePhysicalMemory();
        long memInfoFreeMemory = memInfoSnapshot.getFreePhysicalMemory();
        return cGroupFreeMemory > memInfoFreeMemory ? memInfoDelegate : cGroupDelegate;
    }

    @Override
    public OsMemoryStatus getOsSnapshot() {
        return this.delegate.getOsSnapshot();
    }
}

