/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.artifact;

import com.google.common.base.Strings;
import javax.annotation.Nullable;
import org.gradle.api.internal.tasks.DefaultTaskDependency;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.publish.ivy.internal.publisher.IvyArtifactInternal;
import org.gradle.api.tasks.TaskDependency;

public abstract class AbstractIvyArtifact
implements IvyArtifactInternal {
    private final TaskDependency allBuildDependencies;
    private final DefaultTaskDependency additionalBuildDependencies = new DefaultTaskDependency();
    private String name;
    private String type;
    private String extension;
    private String classifier;
    private String conf;

    protected AbstractIvyArtifact(TaskDependencyFactory taskDependencyFactory) {
        this.allBuildDependencies = taskDependencyFactory.visitingDependencies(context -> {
            context.add((Object)this.getDefaultBuildDependencies());
            this.additionalBuildDependencies.visitDependencies(context);
        });
    }

    @Override
    public String getName() {
        return this.name != null ? this.name : this.getDefaultName();
    }

    protected abstract String getDefaultName();

    @Override
    public void setName(String name) {
        this.name = Strings.nullToEmpty((String)name);
    }

    @Override
    public String getType() {
        return this.type != null ? this.type : this.getDefaultType();
    }

    protected abstract String getDefaultType();

    @Override
    public void setType(String type) {
        this.type = Strings.nullToEmpty((String)type);
    }

    @Override
    public String getExtension() {
        return this.extension != null ? this.extension : this.getDefaultExtension();
    }

    protected abstract String getDefaultExtension();

    @Override
    public void setExtension(String extension) {
        this.extension = Strings.nullToEmpty((String)extension);
    }

    @Override
    @Nullable
    public String getClassifier() {
        return Strings.emptyToNull((String)(this.classifier != null ? this.classifier : this.getDefaultClassifier()));
    }

    @Nullable
    protected abstract String getDefaultClassifier();

    @Override
    public void setClassifier(@Nullable String classifier) {
        this.classifier = Strings.nullToEmpty((String)classifier);
    }

    @Override
    @Nullable
    public String getConf() {
        return Strings.emptyToNull((String)(this.conf != null ? this.conf : this.getDefaultConf()));
    }

    @Nullable
    protected abstract String getDefaultConf();

    @Override
    public void setConf(@Nullable String conf) {
        this.conf = Strings.nullToEmpty((String)conf);
    }

    public void builtBy(Object ... tasks) {
        this.additionalBuildDependencies.add(tasks);
    }

    public TaskDependency getBuildDependencies() {
        return this.allBuildDependencies;
    }

    protected abstract TaskDependency getDefaultBuildDependencies();

    public String toString() {
        return String.format("%s %s:%s:%s:%s", this.getClass().getSimpleName(), this.getName(), this.getType(), this.getExtension(), this.getClassifier());
    }
}

