// ----------------------------------------------------------------------------
//
//     ***     AUTO GENERATED CODE    ***    Type: MMv1     ***
//
// ----------------------------------------------------------------------------
//
//     This file is automatically generated by Magic Modules and manual
//     changes will be clobbered when the file is regenerated.
//
//     Please read more about how to change this file in
//     .github/CONTRIBUTING.md.
//
// ----------------------------------------------------------------------------

package google

import (
	"fmt"
	"log"
	"reflect"
	"strings"
	"time"

	"github.com/hashicorp/terraform-plugin-sdk/v2/helper/schema"
)

func resourceBigqueryConnectionConnection() *schema.Resource {
	return &schema.Resource{
		Create: resourceBigqueryConnectionConnectionCreate,
		Read:   resourceBigqueryConnectionConnectionRead,
		Update: resourceBigqueryConnectionConnectionUpdate,
		Delete: resourceBigqueryConnectionConnectionDelete,

		Importer: &schema.ResourceImporter{
			State: resourceBigqueryConnectionConnectionImport,
		},

		Timeouts: &schema.ResourceTimeout{
			Create: schema.DefaultTimeout(20 * time.Minute),
			Update: schema.DefaultTimeout(20 * time.Minute),
			Delete: schema.DefaultTimeout(20 * time.Minute),
		},

		Schema: map[string]*schema.Schema{
			"aws": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Connection properties specific to Amazon Web Services.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"access_role": {
							Type:        schema.TypeList,
							Required:    true,
							Description: `Authentication using Google owned service account to assume into customer's AWS IAM Role.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"iam_role_id": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `The user’s AWS IAM Role that trusts the Google-owned AWS IAM user Connection.`,
									},
									"identity": {
										Type:        schema.TypeString,
										Computed:    true,
										Description: `A unique Google-owned and Google-generated identity for the Connection. This identity will be used to access the user's AWS IAM Role.`,
									},
								},
							},
						},
					},
				},
				ExactlyOneOf: []string{"cloud_sql", "aws", "azure", "cloud_spanner", "cloud_resource"},
			},
			"azure": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Container for connection properties specific to Azure.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"customer_tenant_id": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `The id of customer's directory that host the data.`,
						},
						"application": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The name of the Azure Active Directory Application.`,
						},
						"client_id": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The client id of the Azure Active Directory Application.`,
						},
						"object_id": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The object id of the Azure Active Directory Application.`,
						},
						"redirect_uri": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The URL user will be redirected to after granting consent during connection setup.`,
						},
					},
				},
				ExactlyOneOf: []string{"cloud_sql", "aws", "azure", "cloud_spanner", "cloud_resource"},
			},
			"cloud_resource": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Container for connection properties for delegation of access to GCP resources.`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"service_account_id": {
							Type:        schema.TypeString,
							Computed:    true,
							Description: `The account ID of the service created for the purpose of this connection.`,
						},
					},
				},
				ExactlyOneOf: []string{"cloud_sql", "aws", "azure", "cloud_spanner", "cloud_resource"},
			},
			"cloud_spanner": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `Connection properties specific to Cloud Spanner`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"database": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Cloud Spanner database in the form 'project/instance/database'`,
						},
						"use_parallelism": {
							Type:        schema.TypeBool,
							Optional:    true,
							Description: `If parallelism should be used when reading from Cloud Spanner`,
						},
					},
				},
				ExactlyOneOf: []string{"cloud_sql", "aws", "azure", "cloud_spanner", "cloud_resource"},
			},
			"cloud_sql": {
				Type:        schema.TypeList,
				Optional:    true,
				Description: `A nested object resource`,
				MaxItems:    1,
				Elem: &schema.Resource{
					Schema: map[string]*schema.Schema{
						"credential": {
							Type:        schema.TypeList,
							Required:    true,
							Description: `Cloud SQL properties.`,
							MaxItems:    1,
							Elem: &schema.Resource{
								Schema: map[string]*schema.Schema{
									"password": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Password for database.`,
										Sensitive:   true,
									},
									"username": {
										Type:        schema.TypeString,
										Required:    true,
										Description: `Username for database.`,
									},
								},
							},
						},
						"database": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Database name.`,
						},
						"instance_id": {
							Type:        schema.TypeString,
							Required:    true,
							Description: `Cloud SQL instance ID in the form project:location:instance.`,
						},
						"type": {
							Type:         schema.TypeString,
							Required:     true,
							ValidateFunc: validateEnum([]string{"DATABASE_TYPE_UNSPECIFIED", "POSTGRES", "MYSQL"}),
							Description:  `Type of the Cloud SQL database. Possible values: ["DATABASE_TYPE_UNSPECIFIED", "POSTGRES", "MYSQL"]`,
						},
					},
				},
				ExactlyOneOf: []string{"cloud_sql", "aws", "azure", "cloud_spanner", "cloud_resource"},
			},
			"connection_id": {
				Type:        schema.TypeString,
				Computed:    true,
				Optional:    true,
				ForceNew:    true,
				Description: `Optional connection id that should be assigned to the created connection.`,
			},
			"description": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `A descriptive description for the connection`,
			},
			"friendly_name": {
				Type:        schema.TypeString,
				Optional:    true,
				Description: `A descriptive name for the connection`,
			},
			"location": {
				Type:     schema.TypeString,
				Optional: true,
				ForceNew: true,
				Description: `The geographic location where the connection should reside.
Cloud SQL instance must be in the same location as the connection
with following exceptions: Cloud SQL us-central1 maps to BigQuery US, Cloud SQL europe-west1 maps to BigQuery EU.
Examples: US, EU, asia-northeast1, us-central1, europe-west1.
Spanner Connections same as spanner region
AWS allowed regions are aws-us-east-1
Azure allowed regions are azure-eastus2`,
			},
			"has_credential": {
				Type:        schema.TypeBool,
				Computed:    true,
				Description: `True if the connection has credential assigned.`,
			},
			"name": {
				Type:     schema.TypeString,
				Computed: true,
				Description: `The resource name of the connection in the form of: 
"projects/{project_id}/locations/{location_id}/connections/{connectionId}"`,
			},
			"project": {
				Type:     schema.TypeString,
				Optional: true,
				Computed: true,
				ForceNew: true,
			},
		},
		UseJSONNumber: true,
	}
}

func resourceBigqueryConnectionConnectionCreate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	obj := make(map[string]interface{})
	connection_idProp, err := expandBigqueryConnectionConnectionConnectionId(d.Get("connection_id"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("connection_id"); !isEmptyValue(reflect.ValueOf(connection_idProp)) && (ok || !reflect.DeepEqual(v, connection_idProp)) {
		obj["connection_id"] = connection_idProp
	}
	friendlyNameProp, err := expandBigqueryConnectionConnectionFriendlyName(d.Get("friendly_name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("friendly_name"); !isEmptyValue(reflect.ValueOf(friendlyNameProp)) && (ok || !reflect.DeepEqual(v, friendlyNameProp)) {
		obj["friendlyName"] = friendlyNameProp
	}
	descriptionProp, err := expandBigqueryConnectionConnectionDescription(d.Get("description"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("description"); !isEmptyValue(reflect.ValueOf(descriptionProp)) && (ok || !reflect.DeepEqual(v, descriptionProp)) {
		obj["description"] = descriptionProp
	}
	cloudSqlProp, err := expandBigqueryConnectionConnectionCloudSql(d.Get("cloud_sql"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("cloud_sql"); !isEmptyValue(reflect.ValueOf(cloudSqlProp)) && (ok || !reflect.DeepEqual(v, cloudSqlProp)) {
		obj["cloudSql"] = cloudSqlProp
	}
	awsProp, err := expandBigqueryConnectionConnectionAws(d.Get("aws"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("aws"); !isEmptyValue(reflect.ValueOf(awsProp)) && (ok || !reflect.DeepEqual(v, awsProp)) {
		obj["aws"] = awsProp
	}
	azureProp, err := expandBigqueryConnectionConnectionAzure(d.Get("azure"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("azure"); !isEmptyValue(reflect.ValueOf(azureProp)) && (ok || !reflect.DeepEqual(v, azureProp)) {
		obj["azure"] = azureProp
	}
	cloudSpannerProp, err := expandBigqueryConnectionConnectionCloudSpanner(d.Get("cloud_spanner"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("cloud_spanner"); !isEmptyValue(reflect.ValueOf(cloudSpannerProp)) && (ok || !reflect.DeepEqual(v, cloudSpannerProp)) {
		obj["cloudSpanner"] = cloudSpannerProp
	}
	cloudResourceProp, err := expandBigqueryConnectionConnectionCloudResource(d.Get("cloud_resource"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("cloud_resource"); ok || !reflect.DeepEqual(v, cloudResourceProp) {
		obj["cloudResource"] = cloudResourceProp
	}

	obj, err = resourceBigqueryConnectionConnectionEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{BigqueryConnectionBasePath}}projects/{{project}}/locations/{{location}}/connections?connectionId={{connection_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Creating new Connection: %#v", obj)
	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Connection: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "POST", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutCreate))
	if err != nil {
		return fmt.Errorf("Error creating Connection: %s", err)
	}
	if err := d.Set("name", flattenBigqueryConnectionConnectionName(res["name"], d, config)); err != nil {
		return fmt.Errorf(`Error setting computed identity field "name": %s`, err)
	}

	// Store the ID now
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/connections/{{connection_id}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	if isEmptyValue(reflect.ValueOf(d.Get("connection_id"))) {
		// connection id is set by API when unset and required to GET the connection
		// it is set by reading the "name" field rather than a field in the response
		if err := d.Set("connection_id", flattenBigqueryConnectionConnectionConnectionId("", d, config)); err != nil {
			return fmt.Errorf("Error reading Connection: %s", err)
		}
	}

	// Reset id to make sure connection_id is not empty
	id2, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/connections/{{connection_id}}")
	if err != nil {
		return fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id2)

	log.Printf("[DEBUG] Finished creating Connection %q: %#v", d.Id(), res)

	return resourceBigqueryConnectionConnectionRead(d, meta)
}

func resourceBigqueryConnectionConnectionRead(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{BigqueryConnectionBasePath}}projects/{{project}}/locations/{{location}}/connections/{{connection_id}}")
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Connection: %s", err)
	}
	billingProject = project

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequest(config, "GET", billingProject, url, userAgent, nil)
	if err != nil {
		return handleNotFoundError(err, d, fmt.Sprintf("BigqueryConnectionConnection %q", d.Id()))
	}

	if err := d.Set("project", project); err != nil {
		return fmt.Errorf("Error reading Connection: %s", err)
	}

	if err := d.Set("name", flattenBigqueryConnectionConnectionName(res["name"], d, config)); err != nil {
		return fmt.Errorf("Error reading Connection: %s", err)
	}
	if err := d.Set("connection_id", flattenBigqueryConnectionConnectionConnectionId(res["connection_id"], d, config)); err != nil {
		return fmt.Errorf("Error reading Connection: %s", err)
	}
	if err := d.Set("friendly_name", flattenBigqueryConnectionConnectionFriendlyName(res["friendlyName"], d, config)); err != nil {
		return fmt.Errorf("Error reading Connection: %s", err)
	}
	if err := d.Set("description", flattenBigqueryConnectionConnectionDescription(res["description"], d, config)); err != nil {
		return fmt.Errorf("Error reading Connection: %s", err)
	}
	if err := d.Set("has_credential", flattenBigqueryConnectionConnectionHasCredential(res["hasCredential"], d, config)); err != nil {
		return fmt.Errorf("Error reading Connection: %s", err)
	}
	if err := d.Set("cloud_sql", flattenBigqueryConnectionConnectionCloudSql(res["cloudSql"], d, config)); err != nil {
		return fmt.Errorf("Error reading Connection: %s", err)
	}
	if err := d.Set("aws", flattenBigqueryConnectionConnectionAws(res["aws"], d, config)); err != nil {
		return fmt.Errorf("Error reading Connection: %s", err)
	}
	if err := d.Set("azure", flattenBigqueryConnectionConnectionAzure(res["azure"], d, config)); err != nil {
		return fmt.Errorf("Error reading Connection: %s", err)
	}
	if err := d.Set("cloud_spanner", flattenBigqueryConnectionConnectionCloudSpanner(res["cloudSpanner"], d, config)); err != nil {
		return fmt.Errorf("Error reading Connection: %s", err)
	}
	if err := d.Set("cloud_resource", flattenBigqueryConnectionConnectionCloudResource(res["cloudResource"], d, config)); err != nil {
		return fmt.Errorf("Error reading Connection: %s", err)
	}

	return nil
}

func resourceBigqueryConnectionConnectionUpdate(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Connection: %s", err)
	}
	billingProject = project

	obj := make(map[string]interface{})
	friendlyNameProp, err := expandBigqueryConnectionConnectionFriendlyName(d.Get("friendly_name"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("friendly_name"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, friendlyNameProp)) {
		obj["friendlyName"] = friendlyNameProp
	}
	descriptionProp, err := expandBigqueryConnectionConnectionDescription(d.Get("description"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("description"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, descriptionProp)) {
		obj["description"] = descriptionProp
	}
	cloudSqlProp, err := expandBigqueryConnectionConnectionCloudSql(d.Get("cloud_sql"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("cloud_sql"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, cloudSqlProp)) {
		obj["cloudSql"] = cloudSqlProp
	}
	awsProp, err := expandBigqueryConnectionConnectionAws(d.Get("aws"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("aws"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, awsProp)) {
		obj["aws"] = awsProp
	}
	azureProp, err := expandBigqueryConnectionConnectionAzure(d.Get("azure"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("azure"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, azureProp)) {
		obj["azure"] = azureProp
	}
	cloudSpannerProp, err := expandBigqueryConnectionConnectionCloudSpanner(d.Get("cloud_spanner"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("cloud_spanner"); !isEmptyValue(reflect.ValueOf(v)) && (ok || !reflect.DeepEqual(v, cloudSpannerProp)) {
		obj["cloudSpanner"] = cloudSpannerProp
	}
	cloudResourceProp, err := expandBigqueryConnectionConnectionCloudResource(d.Get("cloud_resource"), d, config)
	if err != nil {
		return err
	} else if v, ok := d.GetOkExists("cloud_resource"); ok || !reflect.DeepEqual(v, cloudResourceProp) {
		obj["cloudResource"] = cloudResourceProp
	}

	obj, err = resourceBigqueryConnectionConnectionEncoder(d, meta, obj)
	if err != nil {
		return err
	}

	url, err := replaceVars(d, config, "{{BigqueryConnectionBasePath}}projects/{{project}}/locations/{{location}}/connections/{{connection_id}}")
	if err != nil {
		return err
	}

	log.Printf("[DEBUG] Updating Connection %q: %#v", d.Id(), obj)
	updateMask := []string{}

	if d.HasChange("friendly_name") {
		updateMask = append(updateMask, "friendlyName")
	}

	if d.HasChange("description") {
		updateMask = append(updateMask, "description")
	}

	if d.HasChange("cloud_sql") {
		updateMask = append(updateMask, "cloudSql")
	}

	if d.HasChange("aws") {
		updateMask = append(updateMask, "aws")
	}

	if d.HasChange("azure") {
		updateMask = append(updateMask, "azure")
	}

	if d.HasChange("cloud_spanner") {
		updateMask = append(updateMask, "cloudSpanner")
	}

	if d.HasChange("cloud_resource") {
		updateMask = append(updateMask, "cloudResource")
	}
	// updateMask is a URL parameter but not present in the schema, so replaceVars
	// won't set it
	url, err = addQueryParams(url, map[string]string{"updateMask": strings.Join(updateMask, ",")})
	if err != nil {
		return err
	}

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "PATCH", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutUpdate))

	if err != nil {
		return fmt.Errorf("Error updating Connection %q: %s", d.Id(), err)
	} else {
		log.Printf("[DEBUG] Finished updating Connection %q: %#v", d.Id(), res)
	}

	return resourceBigqueryConnectionConnectionRead(d, meta)
}

func resourceBigqueryConnectionConnectionDelete(d *schema.ResourceData, meta interface{}) error {
	config := meta.(*Config)
	userAgent, err := generateUserAgentString(d, config.userAgent)
	if err != nil {
		return err
	}

	billingProject := ""

	project, err := getProject(d, config)
	if err != nil {
		return fmt.Errorf("Error fetching project for Connection: %s", err)
	}
	billingProject = project

	url, err := replaceVars(d, config, "{{BigqueryConnectionBasePath}}projects/{{project}}/locations/{{location}}/connections/{{connection_id}}")
	if err != nil {
		return err
	}

	var obj map[string]interface{}
	log.Printf("[DEBUG] Deleting Connection %q", d.Id())

	// err == nil indicates that the billing_project value was found
	if bp, err := getBillingProject(d, config); err == nil {
		billingProject = bp
	}

	res, err := sendRequestWithTimeout(config, "DELETE", billingProject, url, userAgent, obj, d.Timeout(schema.TimeoutDelete))
	if err != nil {
		return handleNotFoundError(err, d, "Connection")
	}

	log.Printf("[DEBUG] Finished deleting Connection %q: %#v", d.Id(), res)
	return nil
}

func resourceBigqueryConnectionConnectionImport(d *schema.ResourceData, meta interface{}) ([]*schema.ResourceData, error) {
	config := meta.(*Config)
	if err := parseImportId([]string{
		"projects/(?P<project>[^/]+)/locations/(?P<location>[^/]+)/connections/(?P<connection_id>[^/]+)",
		"(?P<project>[^/]+)/(?P<location>[^/]+)/(?P<connection_id>[^/]+)",
		"(?P<location>[^/]+)/(?P<connection_id>[^/]+)",
	}, d, config); err != nil {
		return nil, err
	}

	// Replace import id for the resource id
	id, err := replaceVars(d, config, "projects/{{project}}/locations/{{location}}/connections/{{connection_id}}")
	if err != nil {
		return nil, fmt.Errorf("Error constructing id: %s", err)
	}
	d.SetId(id)

	return []*schema.ResourceData{d}, nil
}

func flattenBigqueryConnectionConnectionName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionConnectionId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	parts := strings.Split(d.Get("name").(string), "/")
	return parts[len(parts)-1]
}

func flattenBigqueryConnectionConnectionFriendlyName(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionDescription(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionHasCredential(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionCloudSql(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["instance_id"] =
		flattenBigqueryConnectionConnectionCloudSqlInstanceId(original["instanceId"], d, config)
	transformed["database"] =
		flattenBigqueryConnectionConnectionCloudSqlDatabase(original["database"], d, config)
	transformed["credential"] =
		flattenBigqueryConnectionConnectionCloudSqlCredential(original["credential"], d, config)
	transformed["type"] =
		flattenBigqueryConnectionConnectionCloudSqlType(original["type"], d, config)
	return []interface{}{transformed}
}
func flattenBigqueryConnectionConnectionCloudSqlInstanceId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionCloudSqlDatabase(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionCloudSqlCredential(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return []interface{}{
		map[string]interface{}{
			"username": d.Get("cloud_sql.0.credential.0.username"),
			"password": d.Get("cloud_sql.0.credential.0.password"),
		},
	}
}

func flattenBigqueryConnectionConnectionCloudSqlType(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionAws(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["access_role"] =
		flattenBigqueryConnectionConnectionAwsAccessRole(original["accessRole"], d, config)
	return []interface{}{transformed}
}
func flattenBigqueryConnectionConnectionAwsAccessRole(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["iam_role_id"] =
		flattenBigqueryConnectionConnectionAwsAccessRoleIamRoleId(original["iamRoleId"], d, config)
	transformed["identity"] =
		flattenBigqueryConnectionConnectionAwsAccessRoleIdentity(original["identity"], d, config)
	return []interface{}{transformed}
}
func flattenBigqueryConnectionConnectionAwsAccessRoleIamRoleId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionAwsAccessRoleIdentity(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionAzure(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["application"] =
		flattenBigqueryConnectionConnectionAzureApplication(original["application"], d, config)
	transformed["client_id"] =
		flattenBigqueryConnectionConnectionAzureClientId(original["clientId"], d, config)
	transformed["object_id"] =
		flattenBigqueryConnectionConnectionAzureObjectId(original["objectId"], d, config)
	transformed["customer_tenant_id"] =
		flattenBigqueryConnectionConnectionAzureCustomerTenantId(original["customerTenantId"], d, config)
	transformed["redirect_uri"] =
		flattenBigqueryConnectionConnectionAzureRedirectUri(original["redirectUri"], d, config)
	return []interface{}{transformed}
}
func flattenBigqueryConnectionConnectionAzureApplication(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionAzureClientId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionAzureObjectId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionAzureCustomerTenantId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionAzureRedirectUri(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionCloudSpanner(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["database"] =
		flattenBigqueryConnectionConnectionCloudSpannerDatabase(original["database"], d, config)
	transformed["use_parallelism"] =
		flattenBigqueryConnectionConnectionCloudSpannerUseParallelism(original["useParallelism"], d, config)
	return []interface{}{transformed}
}
func flattenBigqueryConnectionConnectionCloudSpannerDatabase(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionCloudSpannerUseParallelism(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func flattenBigqueryConnectionConnectionCloudResource(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	if v == nil {
		return nil
	}
	original := v.(map[string]interface{})
	if len(original) == 0 {
		return nil
	}
	transformed := make(map[string]interface{})
	transformed["service_account_id"] =
		flattenBigqueryConnectionConnectionCloudResourceServiceAccountId(original["serviceAccountId"], d, config)
	return []interface{}{transformed}
}
func flattenBigqueryConnectionConnectionCloudResourceServiceAccountId(v interface{}, d *schema.ResourceData, config *Config) interface{} {
	return v
}

func expandBigqueryConnectionConnectionConnectionId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionFriendlyName(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionDescription(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionCloudSql(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedInstanceId, err := expandBigqueryConnectionConnectionCloudSqlInstanceId(original["instance_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedInstanceId); val.IsValid() && !isEmptyValue(val) {
		transformed["instanceId"] = transformedInstanceId
	}

	transformedDatabase, err := expandBigqueryConnectionConnectionCloudSqlDatabase(original["database"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDatabase); val.IsValid() && !isEmptyValue(val) {
		transformed["database"] = transformedDatabase
	}

	transformedCredential, err := expandBigqueryConnectionConnectionCloudSqlCredential(original["credential"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCredential); val.IsValid() && !isEmptyValue(val) {
		transformed["credential"] = transformedCredential
	}

	transformedType, err := expandBigqueryConnectionConnectionCloudSqlType(original["type"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedType); val.IsValid() && !isEmptyValue(val) {
		transformed["type"] = transformedType
	}

	return transformed, nil
}

func expandBigqueryConnectionConnectionCloudSqlInstanceId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionCloudSqlDatabase(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionCloudSqlCredential(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedUsername, err := expandBigqueryConnectionConnectionCloudSqlCredentialUsername(original["username"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUsername); val.IsValid() && !isEmptyValue(val) {
		transformed["username"] = transformedUsername
	}

	transformedPassword, err := expandBigqueryConnectionConnectionCloudSqlCredentialPassword(original["password"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedPassword); val.IsValid() && !isEmptyValue(val) {
		transformed["password"] = transformedPassword
	}

	return transformed, nil
}

func expandBigqueryConnectionConnectionCloudSqlCredentialUsername(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionCloudSqlCredentialPassword(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionCloudSqlType(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionAws(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedAccessRole, err := expandBigqueryConnectionConnectionAwsAccessRole(original["access_role"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedAccessRole); val.IsValid() && !isEmptyValue(val) {
		transformed["accessRole"] = transformedAccessRole
	}

	return transformed, nil
}

func expandBigqueryConnectionConnectionAwsAccessRole(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedIamRoleId, err := expandBigqueryConnectionConnectionAwsAccessRoleIamRoleId(original["iam_role_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedIamRoleId); val.IsValid() && !isEmptyValue(val) {
		transformed["iamRoleId"] = transformedIamRoleId
	}

	transformedIdentity, err := expandBigqueryConnectionConnectionAwsAccessRoleIdentity(original["identity"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedIdentity); val.IsValid() && !isEmptyValue(val) {
		transformed["identity"] = transformedIdentity
	}

	return transformed, nil
}

func expandBigqueryConnectionConnectionAwsAccessRoleIamRoleId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionAwsAccessRoleIdentity(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionAzure(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedApplication, err := expandBigqueryConnectionConnectionAzureApplication(original["application"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedApplication); val.IsValid() && !isEmptyValue(val) {
		transformed["application"] = transformedApplication
	}

	transformedClientId, err := expandBigqueryConnectionConnectionAzureClientId(original["client_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedClientId); val.IsValid() && !isEmptyValue(val) {
		transformed["clientId"] = transformedClientId
	}

	transformedObjectId, err := expandBigqueryConnectionConnectionAzureObjectId(original["object_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedObjectId); val.IsValid() && !isEmptyValue(val) {
		transformed["objectId"] = transformedObjectId
	}

	transformedCustomerTenantId, err := expandBigqueryConnectionConnectionAzureCustomerTenantId(original["customer_tenant_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedCustomerTenantId); val.IsValid() && !isEmptyValue(val) {
		transformed["customerTenantId"] = transformedCustomerTenantId
	}

	transformedRedirectUri, err := expandBigqueryConnectionConnectionAzureRedirectUri(original["redirect_uri"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedRedirectUri); val.IsValid() && !isEmptyValue(val) {
		transformed["redirectUri"] = transformedRedirectUri
	}

	return transformed, nil
}

func expandBigqueryConnectionConnectionAzureApplication(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionAzureClientId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionAzureObjectId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionAzureCustomerTenantId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionAzureRedirectUri(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionCloudSpanner(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedDatabase, err := expandBigqueryConnectionConnectionCloudSpannerDatabase(original["database"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedDatabase); val.IsValid() && !isEmptyValue(val) {
		transformed["database"] = transformedDatabase
	}

	transformedUseParallelism, err := expandBigqueryConnectionConnectionCloudSpannerUseParallelism(original["use_parallelism"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedUseParallelism); val.IsValid() && !isEmptyValue(val) {
		transformed["useParallelism"] = transformedUseParallelism
	}

	return transformed, nil
}

func expandBigqueryConnectionConnectionCloudSpannerDatabase(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionCloudSpannerUseParallelism(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func expandBigqueryConnectionConnectionCloudResource(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	l := v.([]interface{})
	if len(l) == 0 || l[0] == nil {
		return nil, nil
	}
	raw := l[0]
	original := raw.(map[string]interface{})
	transformed := make(map[string]interface{})

	transformedServiceAccountId, err := expandBigqueryConnectionConnectionCloudResourceServiceAccountId(original["service_account_id"], d, config)
	if err != nil {
		return nil, err
	} else if val := reflect.ValueOf(transformedServiceAccountId); val.IsValid() && !isEmptyValue(val) {
		transformed["serviceAccountId"] = transformedServiceAccountId
	}

	return transformed, nil
}

func expandBigqueryConnectionConnectionCloudResourceServiceAccountId(v interface{}, d TerraformResourceData, config *Config) (interface{}, error) {
	return v, nil
}

func resourceBigqueryConnectionConnectionEncoder(d *schema.ResourceData, meta interface{}, obj map[string]interface{}) (map[string]interface{}, error) {
	// connection_id is needed to qualify the URL but cannot be sent in the body
	delete(obj, "connection_id")
	return obj, nil
}
