/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.transport.http;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.connector.transport.Transporter;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transfer.NoTransporterException;
import org.eclipse.aether.transport.http.ChecksumExtractor;
import org.eclipse.aether.transport.http.HttpTransporter;
import org.eclipse.aether.transport.http.Nexus2ChecksumExtractor;
import org.eclipse.aether.transport.http.XChecksumChecksumExtractor;

@Named(value="http")
public final class HttpTransporterFactory
implements TransporterFactory {
    private static final Map<String, ChecksumExtractor> EXTRACTORS;
    private float priority = 5.0f;
    private final Map<String, ChecksumExtractor> extractors;

    @Deprecated
    public HttpTransporterFactory() {
        this(EXTRACTORS);
    }

    @Inject
    public HttpTransporterFactory(Map<String, ChecksumExtractor> extractors) {
        this.extractors = Objects.requireNonNull(extractors);
    }

    @Override
    public float getPriority() {
        return this.priority;
    }

    public HttpTransporterFactory setPriority(float priority) {
        this.priority = priority;
        return this;
    }

    @Override
    public Transporter newInstance(RepositorySystemSession session2, RemoteRepository repository) throws NoTransporterException {
        Objects.requireNonNull(session2, "session cannot be null");
        Objects.requireNonNull(repository, "repository cannot be null");
        return new HttpTransporter(this.extractors, repository, session2);
    }

    static {
        HashMap<String, ChecksumExtractor> map2 = new HashMap<String, ChecksumExtractor>();
        map2.put("nexus2", new Nexus2ChecksumExtractor());
        map2.put("x-checksum", new XChecksumChecksumExtractor());
        EXTRACTORS = Collections.unmodifiableMap(map2);
    }
}

