/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui.object;

import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.object.VariableInserter;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.log4j.Logger;

public class VariablesPanel
implements DataEntryPanel {
    private final JPanel panel;
    private String currentPickedVariable = "";
    private String currentDefValue = "";
    private final SPVariableHelper variableHelper;
    private final JLabel pickerLabel;
    private final JTextField varNameText;
    private final JButton varPicker;
    private final JLabel varDefaultLabel;
    private final JTextField varDefaultText;
    private final JLabel varEditLabel;
    private final JTextField varEditText;
    private final JLabel previewLabel;
    private final JLabel varPreviewLabel1;
    private final JLabel varPreviewLabel2;
    private boolean stuffToInsert = true;
    private final VariableInserter action;
    private final JLabel optionsLabel;
    private final JLabel namespaceLabel;
    private final JCheckBox namespaceBox;
    private final JLabel generalLabel;
    private static final Logger logger = Logger.getLogger(VariablesPanel.class);

    public VariablesPanel(SPVariableHelper variableHelper, VariableInserter action) {
        this(variableHelper, action, "");
    }

    public VariablesPanel(SPVariableHelper variableHelper, VariableInserter action, String varDefinition) {
        this.variableHelper = variableHelper;
        this.action = action;
        this.generalLabel = new JLabel("General");
        this.generalLabel.setFont(this.generalLabel.getFont().deriveFont(1));
        this.pickerLabel = new JLabel("Pick a variable");
        this.varNameText = new JTextField();
        this.varNameText.setEditable(false);
        this.varNameText.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                ShowPickerAction act = new ShowPickerAction();
                act.actionPerformed(null);
            }
        });
        this.varPicker = new JButton(new ShowPickerAction());
        this.optionsLabel = new JLabel("Options");
        this.optionsLabel.setFont(this.optionsLabel.getFont().deriveFont(1));
        this.varDefaultLabel = new JLabel("Default value");
        this.varDefaultText = new JTextField();
        this.varDefaultText.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        VariablesPanel.this.currentDefValue = VariablesPanel.this.varDefaultText.getText();
                        VariablesPanel.this.updateGUI();
                    }
                });
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.varEditLabel = new JLabel("Customization");
        this.varEditText = new JTextField();
        this.varEditText.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int carPos = VariablesPanel.this.varEditText.getCaretPosition();
                        String text = VariablesPanel.this.varEditText.getText().replace("$", "").replace("{", "").replace("}", "");
                        VariablesPanel.this.currentPickedVariable = SPVariableHelper.stripDefaultValue(text);
                        if (VariablesPanel.this.currentPickedVariable == null) {
                            VariablesPanel.this.currentPickedVariable = "";
                        }
                        VariablesPanel.this.currentDefValue = SPVariableHelper.getDefaultValue(text);
                        if (VariablesPanel.this.currentDefValue == null) {
                            VariablesPanel.this.currentDefValue = "";
                        }
                        if (SPVariableHelper.getNamespace(text) == null) {
                            VariablesPanel.this.namespaceBox.setSelected(false);
                        } else {
                            VariablesPanel.this.namespaceBox.setSelected(true);
                        }
                        VariablesPanel.this.updateGUI();
                        try {
                            VariablesPanel.this.varEditText.setCaretPosition(carPos);
                        }
                        catch (IllegalArgumentException e) {
                            VariablesPanel.this.varEditText.setCaretPosition(carPos - 1);
                        }
                    }
                });
            }

            @Override
            public void keyReleased(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.namespaceLabel = new JLabel("Constrain to namespace");
        this.namespaceBox = new JCheckBox("");
        if (SPVariableHelper.getNamespace(varDefinition) != null || "".equals(varDefinition)) {
            this.namespaceBox.setSelected(true);
        } else {
            this.namespaceBox.setSelected(false);
        }
        this.namespaceBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VariablesPanel.this.updateGUI();
            }
        });
        this.previewLabel = new JLabel("Preview");
        this.previewLabel.setFont(this.previewLabel.getFont().deriveFont(1));
        this.varPreviewLabel1 = new JLabel("Current value is");
        this.varPreviewLabel1.setForeground(Color.GRAY);
        this.varPreviewLabel2 = new JLabel();
        this.varPreviewLabel2.setForeground(Color.GRAY);
        this.panel = new JPanel((LayoutManager)new MigLayout());
        this.panel.add((Component)this.generalLabel, "growx, span, wrap");
        this.panel.add((Component)new JLabel(" "), "wmin 20, wmax 20");
        this.panel.add(this.pickerLabel);
        this.panel.add((Component)this.varNameText, "growx, wmin 275, wmax 275, gapright 0");
        this.panel.add((Component)this.varPicker, "wmax 20, hmax 20, wrap, gapleft 0");
        this.panel.add((Component)this.optionsLabel, "growx, span, wrap");
        this.panel.add((Component)new JLabel(" "), "wmin 20, wmax 20");
        this.panel.add(this.varDefaultLabel);
        this.panel.add((Component)this.varDefaultText, "span, wrap, wmin 300, wmax 300");
        this.panel.add((Component)new JLabel(" "), "wmin 20, wmax 20");
        this.panel.add(this.namespaceLabel);
        this.panel.add((Component)this.namespaceBox, "span, wrap");
        this.panel.add((Component)new JLabel(" "), "wmin 20, wmax 20");
        this.panel.add(this.varEditLabel);
        this.panel.add((Component)this.varEditText, "span, wmin 300, wmax 300, wrap");
        this.panel.add((Component)this.previewLabel, "growx, span, wrap");
        this.panel.add((Component)new JLabel(" "), "wmin 20, wmax 20");
        this.panel.add(this.varPreviewLabel1);
        this.panel.add((Component)this.varPreviewLabel2, "span, growx");
        this.currentPickedVariable = varDefinition;
        this.updateGUI();
    }

    private void updateGUI() {
        String text = "${";
        text = this.namespaceBox.isSelected() ? text + this.currentPickedVariable : text + SPVariableHelper.getKey(this.currentPickedVariable);
        if (!this.currentDefValue.trim().equals("")) {
            text = text + "->";
            text = text + this.currentDefValue;
        }
        text = text + "}";
        this.varNameText.setText(this.currentPickedVariable);
        this.varDefaultText.setText(this.currentDefValue);
        this.varEditText.setText(text);
        Object resolvedValue = this.variableHelper.resolve(this.currentPickedVariable, this.currentDefValue == null ? "null" : this.currentDefValue);
        this.varPreviewLabel2.setText(resolvedValue == null ? "null" : resolvedValue.toString());
    }

    @Override
    public boolean applyChanges() {
        final String variable = this.varEditText.getText();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VariablesPanel.this.action.insert(variable);
            }
        });
        this.stuffToInsert = false;
        return true;
    }

    @Override
    public void discardChanges() {
        this.stuffToInsert = false;
    }

    @Override
    public JComponent getPanel() {
        return this.panel;
    }

    @Override
    public boolean hasUnsavedChanges() {
        return this.stuffToInsert;
    }

    private void showVarsPicker() {
        final MultiValueMap namespaces = this.variableHelper.getNamespaces();
        ArrayList sortedNames = new ArrayList(namespaces.keySet().size());
        sortedNames.addAll(namespaces.keySet());
        Collections.sort(sortedNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        });
        JPopupMenu menu = new JPopupMenu();
        for (final String name : sortedNames) {
            final JMenu subMenu = new JMenu(name);
            menu.add(subMenu);
            subMenu.addMenuListener(new MenuListener(){
                private Timer timer;

                @Override
                public void menuSelected(MenuEvent e) {
                    subMenu.removeAll();
                    subMenu.add(new PleaseWaitAction());
                    ActionListener menuPopulator = new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            if (subMenu.isPopupMenuVisible()) {
                                subMenu.removeAll();
                                for (Object namespaceO : namespaces.getCollection((Object)name)) {
                                    String namespace = (String)namespaceO;
                                    logger.debug((Object)"Resolving variables for namespace ".concat(namespace));
                                    int nbItems = 0;
                                    for (String key : VariablesPanel.this.variableHelper.keySet(namespace)) {
                                        subMenu.add(new InsertVariableAction(SPVariableHelper.getKey(key), key));
                                        ++nbItems;
                                    }
                                    if (nbItems != 0) continue;
                                    subMenu.add(new DummyAction());
                                    logger.debug((Object)"No variables found.");
                                }
                                subMenu.revalidate();
                                subMenu.getPopupMenu().pack();
                            }
                        }
                    };
                    this.timer = new Timer(700, menuPopulator);
                    this.timer.setRepeats(false);
                    this.timer.start();
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                    this.timer.stop();
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                    this.timer.stop();
                }
            });
        }
        menu.show(this.varNameText, 0, this.varNameText.getHeight());
    }

    private final class PleaseWaitAction
    extends AbstractAction {
        public PleaseWaitAction() {
            super("Please wait...");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private final class DummyAction
    extends AbstractAction {
        public DummyAction() {
            super("No variables available");
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }

    private final class InsertVariableAction
    extends AbstractAction {
        private final String var;

        public InsertVariableAction(String label, String var) {
            super(label);
            this.var = var;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariablesPanel.this.currentPickedVariable = this.var;
            VariablesPanel.this.updateGUI();
        }
    }

    private final class ShowPickerAction
    extends AbstractAction {
        public ShowPickerAction() {
            super("...");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            VariablesPanel.this.showVarsPicker();
        }
    }
}

