/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import ca.sqlpower.sqlobject.SQLType;
import ca.sqlpower.sqlobject.UserDefinedSQLType;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;

public class DataEntryPanelChangeUtil {
    public static final String ERROR_MESSAGE = "<html>This object has been changed by another user.<br>You must re-open this window before making changes.</html>";
    public static final Color NONCONFLICTING_COLOR = new Color(255, 255, 200);
    public static final Color DARK_NONCONFLICTING_COLOR = new Color(255, 200, 0);
    public static final Color CONFLICTING_COLOR = new Color(255, 200, 200);
    public static final Color DARK_CONFLICTING_COLOR = new Color(255, 100, 100);

    public static boolean incomingChange(JTextComponent field, PropertyChangeEvent e) {
        return DataEntryPanelChangeUtil.changeBackground(field, field.getText(), e);
    }

    public static boolean incomingChange(JComboBox field, PropertyChangeEvent e) {
        Object fieldValue = field.getSelectedItem();
        if (field.getSelectedItem() instanceof String) {
            DataEntryPanelChangeUtil.changeBackground(field, (String)fieldValue, e);
        } else if (field.getSelectedItem() instanceof SQLType) {
            SQLType type = (SQLType)field.getSelectedItem();
            fieldValue = type.getType();
            DataEntryPanelChangeUtil.changeBackground(field, fieldValue, e);
        }
        return DataEntryPanelChangeUtil.changeBorder(field, fieldValue, e);
    }

    public static boolean incomingChange(JSpinner field, PropertyChangeEvent e) {
        return DataEntryPanelChangeUtil.changeBackground(((JSpinner.DefaultEditor)field.getEditor()).getTextField(), field.getValue(), e);
    }

    public static boolean incomingChange(JCheckBox field, PropertyChangeEvent e) {
        return DataEntryPanelChangeUtil.changeBorder(field, field.isSelected(), e);
    }

    public static boolean incomingChange(ButtonGroup field, Object fieldValue, PropertyChangeEvent e) {
        return DataEntryPanelChangeUtil.changeBorder(DataEntryPanelChangeUtil.getSelectedButton(field), fieldValue, e);
    }

    public static boolean incomingChange(JTree field, PropertyChangeEvent e) {
        Object selection = field.getLastSelectedPathComponent();
        if (selection instanceof UserDefinedSQLType) {
            return DataEntryPanelChangeUtil.changeBackground(field, ((UserDefinedSQLType)selection).getType(), e);
        }
        return false;
    }

    public static boolean incomingChange(JTable table, PropertyChangeEvent evt) {
        return DataEntryPanelChangeUtil.changeBackground(table, null, evt);
    }

    public static boolean changeBackground(JComponent field, Object fieldValue, PropertyChangeEvent e) {
        Object oldValue = e.getOldValue();
        Object incomingValue = e.getNewValue();
        if (fieldValue instanceof String) {
            oldValue = oldValue != null ? ((String)oldValue).trim() : "";
            incomingValue = incomingValue != null ? ((String)incomingValue).trim() : "";
            Object object = fieldValue = fieldValue != null ? ((String)fieldValue).trim() : "";
        }
        if (incomingValue.equals(fieldValue)) {
            return false;
        }
        if (oldValue.equals(fieldValue)) {
            field.setBackground(NONCONFLICTING_COLOR);
        } else {
            field.setBackground(CONFLICTING_COLOR);
        }
        return true;
    }

    public static boolean changeBorder(JComponent field, Object fieldValue, PropertyChangeEvent e) {
        Object oldValue = e.getOldValue();
        Object incomingValue = e.getNewValue();
        if (fieldValue instanceof String) {
            oldValue = oldValue != null ? ((String)oldValue).trim() : "";
            incomingValue = incomingValue != null ? ((String)incomingValue).trim() : "";
            Object object = fieldValue = fieldValue != null ? ((String)fieldValue).trim() : "";
        }
        if (incomingValue.equals(fieldValue)) {
            return false;
        }
        if (oldValue.equals(fieldValue)) {
            field.setBorder(BorderFactory.createLineBorder(DARK_NONCONFLICTING_COLOR, 3));
        } else {
            field.setBorder(BorderFactory.createLineBorder(DARK_CONFLICTING_COLOR, 3));
        }
        if (field instanceof AbstractButton) {
            ((AbstractButton)field).setBorderPainted(true);
        }
        return true;
    }

    private static AbstractButton getSelectedButton(ButtonGroup field) {
        Enumeration<AbstractButton> buttons = field.getElements();
        while (buttons.hasMoreElements()) {
            AbstractButton b = buttons.nextElement();
            if (!b.isSelected()) continue;
            return b;
        }
        throw new IllegalStateException("No button is selected");
    }
}

