/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.mysqlbulkload;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.provider.local.LocalFile;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.mysqlbulkload.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryMysqlBulkLoad
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String schemaname;
    private String tablename;
    private String filename;
    private String separator;
    private String enclosed;
    private String escaped;
    private String linestarted;
    private String lineterminated;
    private String ignorelines;
    private boolean replacedata;
    private String listattribut;
    private boolean localinfile;
    public int prorityvalue;
    private boolean addfiletoresult;
    private DatabaseMeta connection;

    public JobEntryMysqlBulkLoad(String n) {
        super(n, "");
        this.tablename = null;
        this.schemaname = null;
        this.filename = null;
        this.separator = null;
        this.enclosed = null;
        this.escaped = null;
        this.lineterminated = null;
        this.linestarted = null;
        this.replacedata = true;
        this.ignorelines = "0";
        this.listattribut = null;
        this.localinfile = true;
        this.connection = null;
        this.addfiletoresult = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.MYSQL_BULK_LOAD);
    }

    public JobEntryMysqlBulkLoad() {
        this("");
    }

    public JobEntryMysqlBulkLoad(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryMysqlBulkLoad je = (JobEntryMysqlBulkLoad)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(200);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"schemaname", (String)this.schemaname));
        retval.append("      ").append(XMLHandler.addTagValue((String)"tablename", (String)this.tablename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"separator", (String)this.separator));
        retval.append("      ").append(XMLHandler.addTagValue((String)"enclosed", (String)this.enclosed));
        retval.append("      ").append(XMLHandler.addTagValue((String)"escaped", (String)this.escaped));
        retval.append("      ").append(XMLHandler.addTagValue((String)"linestarted", (String)this.linestarted));
        retval.append("      ").append(XMLHandler.addTagValue((String)"lineterminated", (String)this.lineterminated));
        retval.append("      ").append(XMLHandler.addTagValue((String)"replacedata", (boolean)this.replacedata));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ignorelines", (String)this.ignorelines));
        retval.append("      ").append(XMLHandler.addTagValue((String)"listattribut", (String)this.listattribut));
        retval.append("      ").append(XMLHandler.addTagValue((String)"localinfile", (boolean)this.localinfile));
        retval.append("      ").append(XMLHandler.addTagValue((String)"prorityvalue", (int)this.prorityvalue));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection", this.connection == null ? null : this.connection.getName()));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.schemaname = XMLHandler.getTagValue((Node)entrynode, (String)"schemaname");
            this.tablename = XMLHandler.getTagValue((Node)entrynode, (String)"tablename");
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.separator = XMLHandler.getTagValue((Node)entrynode, (String)"separator");
            this.enclosed = XMLHandler.getTagValue((Node)entrynode, (String)"enclosed");
            this.escaped = XMLHandler.getTagValue((Node)entrynode, (String)"escaped");
            this.linestarted = XMLHandler.getTagValue((Node)entrynode, (String)"linestarted");
            this.lineterminated = XMLHandler.getTagValue((Node)entrynode, (String)"lineterminated");
            this.replacedata = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"replacedata"));
            this.ignorelines = XMLHandler.getTagValue((Node)entrynode, (String)"ignorelines");
            this.listattribut = XMLHandler.getTagValue((Node)entrynode, (String)"listattribut");
            this.localinfile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"localinfile"));
            this.prorityvalue = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"prorityvalue"), (int)-1);
            String dbname = XMLHandler.getTagValue((Node)entrynode, (String)"connection");
            this.addfiletoresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.connection = DatabaseMeta.findDatabase(databases, (String)dbname);
        }
        catch (KettleException e) {
            throw new KettleXMLException("Unable to load job entry of type 'Mysql bulk load' from XML node", (Throwable)e);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.schemaname = rep.getJobEntryAttributeString(id_jobentry, "schemaname");
            this.tablename = rep.getJobEntryAttributeString(id_jobentry, "tablename");
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.separator = rep.getJobEntryAttributeString(id_jobentry, "separator");
            this.enclosed = rep.getJobEntryAttributeString(id_jobentry, "enclosed");
            this.escaped = rep.getJobEntryAttributeString(id_jobentry, "escaped");
            this.linestarted = rep.getJobEntryAttributeString(id_jobentry, "linestarted");
            this.lineterminated = rep.getJobEntryAttributeString(id_jobentry, "lineterminated");
            this.replacedata = rep.getJobEntryAttributeBoolean(id_jobentry, "replacedata");
            this.ignorelines = rep.getJobEntryAttributeString(id_jobentry, "ignorelines");
            this.listattribut = rep.getJobEntryAttributeString(id_jobentry, "listattribut");
            this.localinfile = rep.getJobEntryAttributeBoolean(id_jobentry, "localinfile");
            this.prorityvalue = (int)rep.getJobEntryAttributeInteger(id_jobentry, "prorityvalue");
            this.addfiletoresult = rep.getJobEntryAttributeBoolean(id_jobentry, "addfiletoresult");
            long id_db = rep.getJobEntryAttributeInteger(id_jobentry, "id_database");
            this.connection = id_db > 0L ? DatabaseMeta.findDatabase(databases, (long)id_db) : DatabaseMeta.findDatabase(databases, (String)rep.getJobEntryAttributeString(id_jobentry, "connection"));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'Mysql bulk load' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "schemaname", this.schemaname);
            rep.saveJobEntryAttribute(id_job, this.getID(), "tablename", this.tablename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "separator", this.separator);
            rep.saveJobEntryAttribute(id_job, this.getID(), "enclosed", this.enclosed);
            rep.saveJobEntryAttribute(id_job, this.getID(), "escaped", this.escaped);
            rep.saveJobEntryAttribute(id_job, this.getID(), "linestarted", this.linestarted);
            rep.saveJobEntryAttribute(id_job, this.getID(), "lineterminated", this.lineterminated);
            rep.saveJobEntryAttribute(id_job, this.getID(), "replacedata", this.replacedata);
            rep.saveJobEntryAttribute(id_job, this.getID(), "ignorelines", this.ignorelines);
            rep.saveJobEntryAttribute(id_job, this.getID(), "listattribut", this.listattribut);
            rep.saveJobEntryAttribute(id_job, this.getID(), "localinfile", this.localinfile);
            rep.saveJobEntryAttribute(id_job, this.getID(), "prorityvalue", this.prorityvalue);
            rep.saveJobEntryAttribute(id_job, this.getID(), "addfiletoresult", this.addfiletoresult);
            if (this.connection != null) {
                rep.saveJobEntryAttribute(id_job, this.getID(), "connection", this.connection.getName());
            }
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to load job entry of type 'Mysql Bulk Load' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public void setSchemaname(String schemaname) {
        this.schemaname = schemaname;
    }

    public String getSchemaname() {
        return this.schemaname;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setDatabase(DatabaseMeta database) {
        this.connection = database;
    }

    public DatabaseMeta getDatabase() {
        return this.connection;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public boolean isUnconditional() {
        return true;
    }

    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        Result result;
        block32: {
            String IgnoreNbrLignes = "";
            String ListOfColumn = "";
            String LocalExec = "";
            String PriorityText = "";
            String LineTerminatedby = "";
            String FieldTerminatedby = "";
            LogWriter log = LogWriter.getInstance();
            result = previousResult;
            result.setResult(false);
            String vfsFilename = this.environmentSubstitute(this.filename);
            if (!Const.isEmpty((String)vfsFilename)) {
                try {
                    FileObject fileObject = KettleVFS.getFileObject((String)vfsFilename);
                    if (!(fileObject instanceof LocalFile)) {
                        throw new KettleException("Only local files are supported at this time, file [" + vfsFilename + "] is not a local file.");
                    }
                    String realFilename = KettleVFS.getFilename((FileObject)fileObject);
                    File file = new File(realFilename);
                    if (file.exists() && file.canRead() || !this.isLocalInfile()) {
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), "File [" + realFilename + "] exists.", new Object[0]);
                        }
                        if (this.connection != null) {
                            Database db = new Database(this.connection);
                            db.shareVariablesWith((VariableSpace)this);
                            try {
                                db.connect();
                                String realSchemaname = this.environmentSubstitute(this.schemaname);
                                String realTablename = this.environmentSubstitute(this.tablename);
                                if (db.checkTableExists(realTablename)) {
                                    if (log.isDetailed()) {
                                        log.logDetailed(this.toString(), "Table [" + realTablename + "] exists.", new Object[0]);
                                    }
                                    if (this.schemaname != null) {
                                        realTablename = realSchemaname + "." + realTablename;
                                    }
                                    String ReplaceIgnore = this.isReplacedata() ? "REPLACE" : "IGNORE";
                                    if (Const.toInt((String)this.getRealIgnorelines(), (int)0) > 0) {
                                        IgnoreNbrLignes = "IGNORE " + this.getRealIgnorelines() + " LINES";
                                    }
                                    if (this.getRealListattribut() != null) {
                                        ListOfColumn = "(" + this.MysqlString(this.getRealListattribut()) + ")";
                                    }
                                    if (this.isLocalInfile()) {
                                        LocalExec = "LOCAL";
                                    }
                                    if (this.prorityvalue == 1) {
                                        PriorityText = "LOW_PRIORITY";
                                    } else if (this.prorityvalue == 2) {
                                        PriorityText = "CONCURRENT";
                                    }
                                    if (this.getRealSeparator() != null || this.getRealEnclosed() != null || this.getRealEscaped() != null) {
                                        FieldTerminatedby = "FIELDS ";
                                        if (this.getRealSeparator() != null) {
                                            FieldTerminatedby = FieldTerminatedby + "TERMINATED BY '" + Const.replace((String)this.getRealSeparator(), (String)"'", (String)"''") + "'";
                                        }
                                        if (this.getRealEnclosed() != null) {
                                            FieldTerminatedby = FieldTerminatedby + " ENCLOSED BY '" + Const.replace((String)this.getRealEnclosed(), (String)"'", (String)"''") + "'";
                                        }
                                        if (this.getRealEscaped() != null) {
                                            FieldTerminatedby = FieldTerminatedby + " ESCAPED BY '" + Const.replace((String)this.getRealEscaped(), (String)"'", (String)"''") + "'";
                                        }
                                    }
                                    if (this.getRealLinestarted() != null || this.getRealLineterminated() != null) {
                                        LineTerminatedby = "LINES ";
                                        if (this.getRealLinestarted() != null) {
                                            LineTerminatedby = LineTerminatedby + "STARTING BY '" + Const.replace((String)this.getRealLinestarted(), (String)"'", (String)"''") + "'";
                                        }
                                        if (this.getRealLineterminated() != null) {
                                            LineTerminatedby = LineTerminatedby + " TERMINATED BY '" + Const.replace((String)this.getRealLineterminated(), (String)"'", (String)"''") + "'";
                                        }
                                    }
                                    String SQLBULKLOAD = "LOAD DATA " + PriorityText + " " + LocalExec + " INFILE '" + realFilename.replace('\\', '/') + "' " + ReplaceIgnore + " INTO TABLE " + realTablename + " " + FieldTerminatedby + " " + LineTerminatedby + " " + IgnoreNbrLignes + " " + ListOfColumn + ";";
                                    try {
                                        db.execStatements(SQLBULKLOAD);
                                        db.disconnect();
                                        if (this.isAddFileToResult()) {
                                            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)realFilename), parentJob.getJobname(), this.toString());
                                            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                                        }
                                        result.setResult(true);
                                    }
                                    catch (KettleDatabaseException je) {
                                        db.disconnect();
                                        result.setNrErrors(1L);
                                        log.logError(this.toString(), "An error occurred executing this job entry : " + je.getMessage(), new Object[0]);
                                    }
                                    catch (IOException e) {
                                        log.logError(this.toString(), "An error occurred executing this job entry : " + e.getMessage(), new Object[0]);
                                        result.setNrErrors(1L);
                                    }
                                } else {
                                    db.disconnect();
                                    result.setNrErrors(1L);
                                    if (log.isDetailed()) {
                                        log.logDetailed(this.toString(), "Table [" + realTablename + "] doesn't exist!", new Object[0]);
                                    }
                                }
                                break block32;
                            }
                            catch (KettleDatabaseException dbe) {
                                db.disconnect();
                                result.setNrErrors(1L);
                                log.logError(this.toString(), "An error occurred executing this entry: " + dbe.getMessage(), new Object[0]);
                            }
                            break block32;
                        }
                        result.setNrErrors(1L);
                        log.logError(this.toString(), Messages.getString("JobMysqlBulkLoad.Nodatabase.Label"), new Object[0]);
                        break block32;
                    }
                    result.setNrErrors(1L);
                    log.logError(this.toString(), "File [" + realFilename + "] doesn't exist!", new Object[0]);
                }
                catch (Exception e) {
                    result.setNrErrors(1L);
                    log.logError(this.toString(), Messages.getString("JobMysqlBulkLoad.UnexpectedError.Label"), (Throwable)e);
                }
            } else {
                result.setNrErrors(1L);
                log.logError(this.toString(), Messages.getString("JobMysqlBulkLoad.Nofilename.Label"), new Object[0]);
            }
        }
        return result;
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        return new DatabaseMeta[]{this.connection};
    }

    public boolean isReplacedata() {
        return this.replacedata;
    }

    public void setReplacedata(boolean replacedata) {
        this.replacedata = replacedata;
    }

    public void setLocalInfile(boolean localinfile) {
        this.localinfile = localinfile;
    }

    public boolean isLocalInfile() {
        return this.localinfile;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    public void setLineterminated(String lineterminated) {
        this.lineterminated = lineterminated;
    }

    public void setLinestarted(String linestarted) {
        this.linestarted = linestarted;
    }

    public String getEnclosed() {
        return this.enclosed;
    }

    public String getRealEnclosed() {
        return this.environmentSubstitute(this.getEnclosed());
    }

    public void setEnclosed(String enclosed) {
        this.enclosed = enclosed;
    }

    public String getEscaped() {
        return this.escaped;
    }

    public String getRealEscaped() {
        return this.environmentSubstitute(this.getEscaped());
    }

    public void setEscaped(String escaped) {
        this.escaped = escaped;
    }

    public String getSeparator() {
        return this.separator;
    }

    public String getLineterminated() {
        return this.lineterminated;
    }

    public String getLinestarted() {
        return this.linestarted;
    }

    public String getRealLinestarted() {
        return this.environmentSubstitute(this.getLinestarted());
    }

    public String getRealLineterminated() {
        return this.environmentSubstitute(this.getLineterminated());
    }

    public String getRealSeparator() {
        return this.environmentSubstitute(this.getSeparator());
    }

    public void setIgnorelines(String ignorelines) {
        this.ignorelines = ignorelines;
    }

    public String getIgnorelines() {
        return this.ignorelines;
    }

    public String getRealIgnorelines() {
        return this.environmentSubstitute(this.getIgnorelines());
    }

    public void setListattribut(String listattribut) {
        this.listattribut = listattribut;
    }

    public String getListattribut() {
        return this.listattribut;
    }

    public String getRealListattribut() {
        return this.environmentSubstitute(this.getListattribut());
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    private String MysqlString(String listcolumns) {
        String returnString = "";
        String[] split = listcolumns.split(",");
        for (int i = 0; i < split.length; ++i) {
            returnString = returnString.equals("") ? "`" + Const.trim((String)split[i]) + "`" : returnString + ", `" + Const.trim((String)split[i]) + "`";
        }
        return returnString;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        ResourceReference reference = null;
        if (this.connection != null) {
            reference = new ResourceReference(this);
            references.add(reference);
            reference.getEntries().add(new ResourceEntry(this.connection.getHostname(), ResourceEntry.ResourceType.SERVER));
            reference.getEntries().add(new ResourceEntry(this.connection.getDatabaseName(), ResourceEntry.ResourceType.DATABASENAME));
        }
        if (this.filename != null) {
            String realFilename = this.getRealFilename();
            if (reference == null) {
                reference = new ResourceReference(this);
                references.add(reference);
            }
            reference.getEntries().add(new ResourceEntry(realFilename, ResourceEntry.ResourceType.FILE));
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx, this.getVariables());
        AndValidator.putValidators(ctx, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, ctx);
        JobEntryValidatorUtils.andValidator().validate(this, "tablename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

