/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.immutable.reference;

import com.android.tools.smali.dexlib2.iface.reference.CallSiteReference;
import com.android.tools.smali.dexlib2.iface.reference.FieldReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodHandleReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodProtoReference;
import com.android.tools.smali.dexlib2.iface.reference.MethodReference;
import com.android.tools.smali.dexlib2.iface.reference.Reference;
import com.android.tools.smali.dexlib2.iface.reference.StringReference;
import com.android.tools.smali.dexlib2.iface.reference.TypeReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableCallSiteReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableFieldReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableMethodHandleReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableMethodProtoReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableMethodReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableStringReference;
import com.android.tools.smali.dexlib2.immutable.reference.ImmutableTypeReference;
import com.android.tools.smali.util.ExceptionWithContext;

public class ImmutableReferenceFactory {
    public static ImmutableReference of(Reference reference) {
        if (reference instanceof StringReference) {
            return ImmutableStringReference.of((StringReference)reference);
        }
        if (reference instanceof TypeReference) {
            return ImmutableTypeReference.of((TypeReference)reference);
        }
        if (reference instanceof FieldReference) {
            return ImmutableFieldReference.of((FieldReference)reference);
        }
        if (reference instanceof MethodReference) {
            return ImmutableMethodReference.of((MethodReference)reference);
        }
        if (reference instanceof MethodProtoReference) {
            return ImmutableMethodProtoReference.of((MethodProtoReference)reference);
        }
        if (reference instanceof CallSiteReference) {
            return ImmutableCallSiteReference.of((CallSiteReference)reference);
        }
        if (reference instanceof MethodHandleReference) {
            return ImmutableMethodHandleReference.of((MethodHandleReference)reference);
        }
        throw new ExceptionWithContext("Invalid reference type", new Object[0]);
    }

    public static ImmutableReference of(int referenceType, Reference reference) {
        switch (referenceType) {
            case 0: {
                return ImmutableStringReference.of((StringReference)reference);
            }
            case 1: {
                return ImmutableTypeReference.of((TypeReference)reference);
            }
            case 2: {
                return ImmutableFieldReference.of((FieldReference)reference);
            }
            case 3: {
                return ImmutableMethodReference.of((MethodReference)reference);
            }
            case 4: {
                return ImmutableMethodProtoReference.of((MethodProtoReference)reference);
            }
            case 5: {
                return ImmutableCallSiteReference.of((CallSiteReference)reference);
            }
            case 6: {
                return ImmutableMethodHandleReference.of((MethodHandleReference)reference);
            }
        }
        throw new ExceptionWithContext("Invalid reference type: %d", referenceType);
    }
}

