/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.iface.DexFile;
import com.android.tools.smali.dexlib2.iface.MultiDexContainer;
import com.android.tools.smali.dexlib2.util.DexUtil;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipDexContainer
implements MultiDexContainer<DexBackedDexFile> {
    private final File zipFilePath;
    private final Opcodes opcodes;

    public ZipDexContainer(File zipFilePath, Opcodes opcodes) {
        this.zipFilePath = zipFilePath;
        this.opcodes = opcodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getDexEntryNames() throws IOException {
        ArrayList<String> entryNames = Lists.newArrayList();
        try (ZipFile zipFile = this.getZipFile();){
            Enumeration<? extends ZipEntry> entriesEnumeration = zipFile.entries();
            while (entriesEnumeration.hasMoreElements()) {
                ZipEntry entry = entriesEnumeration.nextElement();
                if (!this.isDex(zipFile, entry)) continue;
                entryNames.add(entry.getName());
            }
            ArrayList<String> arrayList = entryNames;
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MultiDexContainer.DexEntry<DexBackedDexFile> getEntry(String entryName) throws IOException {
        try (ZipFile zipFile = this.getZipFile();){
            ZipEntry entry = zipFile.getEntry(entryName);
            if (entry == null) {
                MultiDexContainer.DexEntry<DexBackedDexFile> dexEntry = null;
                return dexEntry;
            }
            MultiDexContainer.DexEntry dexEntry = this.loadEntry(zipFile, entry);
            return dexEntry;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isZipFile() {
        ZipFile zipFile = null;
        try {
            zipFile = this.getZipFile();
            boolean bl = true;
            return bl;
        }
        catch (IOException ex) {
            boolean bl = false;
            return bl;
        }
        catch (NotAZipFileException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isDex(ZipFile zipFile, ZipEntry zipEntry) throws IOException {
        try (BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));){
            DexUtil.verifyDexHeader(inputStream);
        }
        return true;
    }

    protected ZipFile getZipFile() throws IOException {
        try {
            return new ZipFile(this.zipFilePath);
        }
        catch (IOException ex) {
            throw new NotAZipFileException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MultiDexContainer.DexEntry loadEntry(ZipFile zipFile, final ZipEntry zipEntry) throws IOException {
        try (InputStream inputStream = zipFile.getInputStream(zipEntry);){
            final byte[] buf = ByteStreams.toByteArray(inputStream);
            MultiDexContainer.DexEntry dexEntry = new MultiDexContainer.DexEntry(){

                public DexFile getDexFile() {
                    return new DexBackedDexFile(ZipDexContainer.this.opcodes, buf);
                }
            };
            return dexEntry;
        }
    }

    public static class NotAZipFileException
    extends RuntimeException {
    }
}

