/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.dexbacked;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.raw.OdexHeaderItem;
import com.android.tools.smali.dexlib2.util.DexUtil;
import com.google.common.io.ByteStreams;
import java.io.IOException;
import java.io.InputStream;

public class DexBackedOdexFile
extends DexBackedDexFile {
    private final byte[] odexBuf;

    public DexBackedOdexFile(Opcodes opcodes, byte[] odexBuf, byte[] dexBuf) {
        super(opcodes, dexBuf);
        this.odexBuf = odexBuf;
    }

    @Override
    public boolean supportsOptimizedOpcodes() {
        return true;
    }

    public static DexBackedOdexFile fromInputStream(Opcodes opcodes, InputStream is) throws IOException {
        DexUtil.verifyOdexHeader(is);
        is.reset();
        byte[] odexBuf = new byte[40];
        ByteStreams.readFully(is, odexBuf);
        int dexOffset = OdexHeaderItem.getDexOffset(odexBuf);
        if (dexOffset > 40) {
            ByteStreams.skipFully(is, dexOffset - 40);
        }
        byte[] dexBuf = ByteStreams.toByteArray(is);
        return new DexBackedOdexFile(opcodes, odexBuf, dexBuf);
    }

    public int getOdexVersion() {
        return OdexHeaderItem.getVersion(this.odexBuf, 0);
    }

    public static class NotAnOdexFile
    extends RuntimeException {
        public NotAnOdexFile() {
        }

        public NotAnOdexFile(String message) {
            super(message);
        }
    }
}

