/*
 * Decompiled with CFR 0.152.
 */
package brut.androlib.apk;

import brut.androlib.apk.YamlStringEscapeUtils;
import java.util.Objects;

public class YamlLine {
    public int indent = 0;
    private String key = "";
    private String value = "";
    public boolean isComment;
    public boolean isEmpty;
    public boolean hasColon;
    public boolean isNull;
    public boolean isItem;

    public YamlLine(String line) {
        this.isNull = Objects.isNull(line);
        if (this.isNull) {
            return;
        }
        this.isEmpty = line.trim().isEmpty();
        if (this.isEmpty) {
            return;
        }
        for (int i = 0; i < line.length() && line.charAt(i) == ' '; ++i) {
            ++this.indent;
        }
        char first = (line = line.trim()).charAt(0);
        this.isComment = first == '#' || first == '!';
        boolean bl = this.isItem = first == '-';
        if (this.isComment) {
            this.value = line.substring(1).trim();
        } else {
            this.hasColon = line.contains(":");
            if (this.isItem) {
                this.value = line.substring(1).trim();
            } else {
                String[] parts = line.split(":");
                if (parts.length > 0) {
                    this.key = parts[0].trim();
                    if (parts.length > 1) {
                        this.value = parts[1].trim();
                    }
                }
            }
        }
    }

    public static String unescape(String value) {
        return YamlStringEscapeUtils.unescapeString(value);
    }

    public String getValue() {
        if (this.value.equals("null")) {
            return null;
        }
        String res = YamlLine.unescape(this.value);
        res = res.replaceAll("^\"|\"$", "");
        res = res.replaceAll("^'|'$", "");
        return res;
    }

    public String getKey() {
        String res = YamlLine.unescape(this.key);
        res = res.replaceAll("^\"|\"$", "");
        res = res.replaceAll("^'|'$", "");
        return res;
    }

    public boolean getValueBool() {
        return Objects.equals(this.value, "true");
    }

    public int getValueInt() {
        return Integer.parseInt(this.value);
    }
}

