'''OpenGL extension NV.conservative_raster_pre_snap_triangles

This module customises the behaviour of the 
OpenGL.raw.GLES2.NV.conservative_raster_pre_snap_triangles to provide a more 
Python-friendly API

Overview (from the spec)
	
	When CONSERVATIVE_RASTERIZATION_NV is enabled, the fragments generated for
	a primitive are conservative with respect to the primitive after snapping
	to sub-pixel grid.  This extension provides a new mode of rasterization
	for triangles where the fragments generated are conservative with respect
	to the primitive at infinite precision before vertex snapping.
	
	When the conservative raster mode is set to CONSERVATIVE_RASTER_MODE_PRE_-
	SNAP_TRIANGLES, triangles are rasterized more conservatively, and may
	generate fragments not generated when the mode is CONSERVATIVE_RASTER_MODE_-
	POST_SNAP (default). In particular it may generate fragments for pixels
	covered by triangles with zero area, or for pixels that are adjacent to
	but not covered by any triangle. This modified behavior may be useful in
	compensating for rounding errors caused by snapping vertex positions to a
	sub-pixel grid during rasterization.  It's possible that a non-degenerate
	triangle becomes degenerate due to snapping.  It's additionally possible
	that rounding errors in computing the position of a vertex or from
	snapping may cause a primitive that would cover a pixel at infinite
	precision to fail to cover the pixel post-snap.  Rasterizing such
	primitives more conservatively may be useful for "binning" algorithms
	described in NV_conservative_raster.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/conservative_raster_pre_snap_triangles.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.NV.conservative_raster_pre_snap_triangles import *
from OpenGL.raw.GLES2.NV.conservative_raster_pre_snap_triangles import _EXTENSION_NAME

def glInitConservativeRasterPreSnapTrianglesNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION