/**
 *
 * Jquery Mapael - Dynamic maps jQuery plugin (based on raphael.js)
 * Requires jQuery and raphael.js
 *
 * Map of Vinnytsia Region
 *
 * @author Ievgen Sentiabov https://github.com/joni-jones
 * @source http://upload.wikimedia.org/wikipedia/commons/thumb/b/b9/Vinnycya_regions.svg/574px-Vinnycya_regions.svg.png
 */
(function ($) {
    $.extend(true, $.fn.mapael,
        {
            maps: {
                vinnytsia_region: {
                    width: 830,
                    height: 870,
                    getCoords : function(lat, lon) {
                        // @TODO Implement the required code to convert the lat / lon to x / y coordinates
                    },
                    elems: {
                        "Vinnytsia City": "m 380.531,312.199 c -0.12,0.08 -0.29,0.17 -0.5,0.29 -0.78,0.39 -2.06,0.67 -3.31,1.5 -1.3,0.86 -2.13,1.89 -2.44,2.99 -0.31,1.08 -0.28,1.91 -0.52,3.04 -0.4,2.03 -1.01,4.64 -2.04,6.79 -1.05,2.16 -2.41,3.69 -4.24,4.12 -0.19,0.04 -0.32,0.06 -0.42,0.06 -0.34,-0.01 -0.46,-0.1 -1.18,-0.84 -0.64,-0.68 -1.78,-1.79 -3.61,-2 -0.28,-0.03 -0.55,-0.05 -0.82,-0.05 -2.68,0.04 -4.89,1.38 -6.61,1.84 -1.54,0.5 -4.56,0.27 -6.92,1.44 -1.16,0.63 -1.74,1.54 -2.14,2 -0.46,0.51 -0.41,0.44 -0.59,0.47 -0.05,0 -0.14,-0.01 -0.28,-0.04 -0.75,-3.29 -1.91,-5.96 -3.87,-7.93 -2.13,-2.13 -5.09,-3.23 -8.82,-3.41 -1.49,-0.06 -3.13,-0.11 -4.22,-0.47 -1.11,-0.43 -1.45,-0.66 -1.61,-1.82 -0.01,-0.08 -0.01,-0.14 -0.01,-0.21 -0.01,-0.89 0.47,-1.75 1.29,-2.44 0.81,-0.69 1.94,-1.11 2.83,-1.1 0.08,0 0.15,0 0.23,0.01 0.52,0.03 1.03,-0.21 1.34,-0.64 0.75,-1.08 0.87,-2.24 0.86,-3.08 0,-0.41 -0.02,-0.77 -0.02,-1.07 0.06,-0.83 -0.01,-0.87 0.61,-1.39 0.18,-0.19 1.14,-0.39 2.33,-0.36 0.54,0 1.11,0.02 1.7,0.02 0.8,0 1.61,-0.02 2.43,-0.24 2.21,-0.62 3.76,-1.51 4.72,-2.79 0.96,-1.28 1.17,-2.75 1.16,-4.06 0,-1.43 -0.21,-2.82 -0.2,-4.17 0,-1.17 0.14,-2.29 0.62,-3.43 0.03,-0.06 0.05,-0.12 0.06,-0.17 2.83,-0.2 5.56,-0.7 8.08,-0.69 0.56,0 1.12,0.02 1.66,0.08 2.47,0.24 4.12,0.54 5.16,1.19 1.04,0.64 1.84,1.66 2.62,4.07 0.17,0.57 0.68,0.98 1.29,1.04 0.11,0.01 0.24,0.02 0.38,0.02 1.76,-0.01 2.79,-1.19 3.43,-1.94 0.65,-0.83 1.17,-1.39 1.46,-1.46 0.22,-0.09 0.53,-0.14 0.88,-0.14 0.95,-0.03 2.19,0.48 2.5,0.82 0.3,0.25 0.58,0.95 0.86,1.99 0.3,1.01 0.64,2.34 1.79,3.45 0.97,0.86 2.16,1.32 3.12,1.69 -0.23,0.11 -0.54,0.24 -0.88,0.39 -0.38,0.18 -0.81,0.42 -1.23,0.85 -0.41,0.42 -0.72,1.09 -0.75,1.78 0,0.03 0,0.05 0,0.07 0,0.04 0,0.07 0,0.08 0.03,0.97 0.53,1.56 0.97,2.02 0.85,0.799 1.92,1.4 2.85,1.83 z",
                        "Vinnytsia": "M326.781,246.539c0.85,0.05,1.36,0.41,2.07,1.47c1.01,1.55,1.77,4.31,2.92,6.78      c0.58,1.24,1.27,2.45,2.3,3.41c1.02,0.96,2.46,1.62,4.1,1.6c0.28,0,0.56-0.02,0.84-0.05c0.76-0.08,1.32-0.71,1.34-1.46      c0.04-2.08,0.18-4.19,0.32-6.33c0.81,0.31,1.77,0.75,2.76,1.2c1.79,0.78,3.71,1.62,5.76,1.64c1.27,0.01,2.64-0.41,3.69-1.43      c1.49-1.53,1.57-3.52,1.6-5.34c0-1.47-0.13-2.92-0.13-4.01c0-0.35,0.01-0.64,0.04-0.87c0.17-1.7,0.07-3.54,0.29-4.98      c0.24-1.42,0.58-2.1,1.27-2.41c0.06,0,0.14,0,0.25,0c0.54,0,1.46,0.05,2.25,0.12c0.39,0.03,0.76,0.07,1.03,0.11      c0.13,0.02,0.25,0.04,0.31,0.05h0.01c0.47,0.21,0.75,0.35,0.85,0.43c0.08,0.24,0.22,0.89,0.6,1.75c1.31,3,2.86,4.77,4.86,5.85      c1.98,1.08,4.12,1.56,7.07,2.65c3.21,1.16,6.18,1.73,8.25,2.67c2.07,0.99,3.15,1.92,3.64,4.5c0.49,3.5,1.96,5.79,5.08,7.67      c2.98,1.92,5.62,2.21,8.59,2.24c0.1,3.16,1,6.05,3.28,8.58c0.79,0.88,1.34,1.31,1.53,1.52c0.17,0.2,0.27,0.28,0.57,1.21      c0.57,1.75,0.66,3.17,1.82,5.26c1.82,3.15,3.89,4.98,4.51,7.86c0.6,2.61,1.31,4.47,2.7,5.94c1.16,1.23,2.61,2.06,4.56,2.99      c-0.13,0.62-0.2,1.23-0.2,1.83c0.07,4.73,3.67,8.38,6.89,10.54c2.97,1.97,5.93,2.56,8.64,2.94c2.73,0.38,5.221,0.58,7.601,1.56      c3.14,1.28,6.31,1.43,9.33,1.43c1.18,0,2.34-0.02,3.489-0.02c0.801,0,1.59,0.01,2.36,0.05c3.99,0.2,6.67,0.63,10.25,1.67      c-0.08,0.66-0.42,1.37-0.96,2.22c-0.61,0.99-1.44,2.08-1.95,3.5c-0.42,1.18-0.66,1.92-0.67,2.75c-0.07,0.91,0.64,1.87,1.08,2.13      c0.44,0.34,0.74,0.52,1.16,0.97c2.46,2.6,2.979,5.27,3.45,8.75c-0.221-0.07-0.46-0.12-0.721-0.12      c-0.75,0.01-1.31,0.28-1.97,0.63c-1.43,0.89-1.83,2.25-2.32,3.6c-0.43,1.36-0.68,2.72-0.76,3.59c-0.02,0.22-0.04,0.45-0.03,0.68      c0.061,2.74,1.261,4.29,1.36,5.92c0.03,0.32,0.05,0.67,0.05,1.04c0.01,1.79-0.38,3.95-0.39,6.16c0,0,0,0.05,0,0.11      c0.01,1.59,0.2,3.68,0.2,5.58c0,1.46-0.141,2.8-0.41,3.47c-0.141,0.45-1.101,1.66-2.18,2.81c-1.08,1.19-2.261,2.39-3,3.6      c-2.49,4.22-6.601,6.97-10.53,11.04c-2.44,2.6-6.63,3.93-10.71,4.19c-0.05-0.76-0.61-1.57-1.221-1.84      c-0.64-0.34-1.239-0.39-1.829-0.4c-2.75,0.04-6.7,1.61-7.23,1.75c-1.41,0.45-2.49,0.65-3.479,0.65c-1.48,0-2.9-0.44-5.07-1.54      c-0.68-0.33-1.66-1.03-2.74-1.67c-1.08-0.63-2.27-1.28-3.73-1.3c-1.29-0.05-2.71,0.77-3.44,2.12c-0.59,1-0.8,1.99-0.79,2.79      c0.01,0.65,0.1,1.19,0.16,1.5c-0.03,0.01-0.07,0.02-0.12,0.04c-0.07,0.02-0.14,0.04-0.23,0.06c-0.38-0.61-0.75-1.19-1.04-1.77      c-0.18-0.35-0.33-0.7-0.45-1.06c-0.39-1.01-0.48-2.15-0.48-3.41c0-0.76,0.04-1.57,0.04-2.4c-0.01-1.33-0.08-2.74-0.66-4.15      c-0.57-1.37-1.61-2.21-2.53-2.92c-0.94-0.69-1.83-1.28-2.27-1.77c-0.98-1.05-1.02-1.34-1.09-1.7c-0.07-0.39,0.05-1.29-0.17-2.69      c-0.63-3.8-2.35-7.94-6.66-9.49c-0.97-0.35-1.92-0.51-2.82-0.51c-3.29,0.01-5.69,2.09-7.54,4.29c-1.86,2.24-3.34,4.81-4.64,6.41      c-1.16,1.42-2.08,2.08-3.16,2.49c-1.09,0.4-2.48,0.54-4.45,0.55c-1.62,0.01-3.39,0.22-5,1.01c-0.9,0.44-1.75,1.12-2.38,2.02      c-1.37-1.55-2.8-3.2-3.65-4.64c-1.15-1.93-0.76-2.77-1.04-5.73c-0.16-1.53-0.34-2.75-1.09-3.89c-0.76-1.13-1.85-1.82-3.36-2.61      c-2.11-1.1-3.73-1.26-4.6-1.56c-0.83-0.33-1.22-0.46-2.2-2.3c-0.72-1.42-1.89-5.05-3.42-8.29c-0.77-1.63-1.63-3.19-2.69-4.44      c-1.04-1.22-2.39-2.26-4.15-2.28c-0.17,0-0.33,0.01-0.49,0.03c-0.88,0.13-1.43,0.55-1.95,0.97c-0.77,0.66-1.45,1.47-2.06,2.22      c-0.59,0.73-1.16,1.41-1.39,1.6c-1.67,1.5-3.64,3.18-5.45,4.23c-0.8-0.95-1.6-2.11-2.39-3.16c-0.51-0.69-1.02-1.33-1.62-1.87      c-0.58-0.52-1.31-1.05-2.35-1.06c-1.16,0-2.08,0.75-2.67,1.64c-0.61,0.92-1.12,2.13-1.64,3.83c-0.62,2.05-1.06,3.56-2.29,4.81      c-1.66,1.8-4.75,3.03-6.49,6.16c-0.39-0.24-0.78-0.45-1.19-0.59c-1.96-0.79-4.12-0.98-5.7-1.35c-4.69-0.97-8.08-5.06-13.36-7.39      c-1-0.43-1.7-0.62-2.23-0.82c-0.52-0.21-0.95-0.42-1.72-1c-1.3-0.96-2.54-2.66-4.35-4.02c-1.71-1.25-3.45-2.26-5.5-2.27      c-1.81-0.01-3.58,0.89-5.15,2.55c-1.63,1.67-2.16,3.54-2.3,5.13c-0.11,1.13-0.11,2.14-0.25,3.16c-0.89-0.47-2.06-1.65-3.01-3.24      c-1.31-2.09-2.32-4.68-2.65-5.98c-0.12-0.48-0.18-0.91-0.18-1.32c0.08-2.03,1.14-3.32,3.8-3.59c0.42-0.03,0.81-0.24,1.08-0.57      c0.26-0.33,0.36-0.77,0.29-1.18c-0.45-2.78-2.75-4.44-4.99-4.41c-1.82-0.06-3.69,1.16-4.39,3.2c-0.49-0.11-1.02-0.41-1.69-0.9      c-0.85-0.62-1.8-1.49-3.12-2.06c-2.79-1.18-6.1-2.04-9.03-2.77c0.22-0.78,0.96-1.82,1.94-3.01c1.15-1.47,2.64-3.21,2.68-5.69      c-0.01-0.03-0.01-0.05-0.01-0.07c-0.04-1.36-0.57-2.38-0.96-3.26c-0.42-0.88-0.69-1.61-0.66-1.96c0-0.15,0.02-0.24,0.08-0.36      c0.04-0.04,0.14-0.11,0.32-0.2c0.75-0.41,2.11-0.74,3.1-1.2c0.47-0.23,0.76-0.67,0.83-1.15c4.83,0.2,9.56,1.28,14.7,1.29      c0,0,0.01,0,0.02,0c1.61-0.01,2.83-0.21,3.85-0.84c1.04-0.6,1.61-1.83,1.57-2.85c-0.04-1.62-0.8-2.98-1.6-4.39      c-0.42-0.72-0.88-1.43-1.31-2.1c1.57-0.52,2.97-1.18,4.16-1.34c0.21-0.03,0.42-0.04,0.62-0.03c0.35,0,0.68,0.05,1.02,0.15      c0.6,0.11,1.8,1.33,3.02,2.7c1.25,1.3,2.65,2.93,5.01,3.01c0.22,0,0.43-0.02,0.64-0.05c1.77-0.39,2.73-1.63,3.89-2.8      c1.08-1.17,2.17-2.43,2.64-2.74c2.68-1.93,6.08-3.33,8.75-6.21c3.55-3.88,6.24-6.52,10.62-9.33c1.99-1.28,3.72-2.25,5.11-3.59      c1.4-1.31,2.33-3.18,2.29-5.5c0-1.07-0.16-2.22-0.47-3.54c-0.12-0.53-0.52-0.95-1.05-1.1c-0.66-0.2-0.96-0.48-1.23-0.91      c-0.25-0.43-0.41-1.09-0.41-1.88c-0.04-2,1.09-4.72,2.06-5.75c0.85-1.11,3.36-1.82,5.19-4.18c1.73-2.47,2.24-5.2,3.51-6.58      c1.4-1.71,3.87-2.63,5.59-5.57c0.64-1.2,0.81-2.32,1.1-2.9c0.37-0.56,0.14-0.51,0.98-0.61      C326.761,246.539,326.781,246.539,326.781,246.539z M384.011,311.438c0.04-0.69-0.4-1.32-1.07-1.52      c-0.34-0.09-1.39-0.51-2.2-0.99c-0.34-0.21-0.66-0.43-0.85-0.6c0.03-0.02,0.06-0.04,0.1-0.06c0.37-0.18,0.99-0.37,1.67-0.82      c0.68-0.4,1.44-1.42,1.4-2.58c0-0.27-0.03-0.53-0.08-0.78c-0.08-0.46-0.38-0.86-0.8-1.07c-1.42-0.67-3.23-1.21-3.68-1.71      c-0.4-0.37-0.68-1.08-0.96-2.1c-0.3-0.98-0.57-2.26-1.68-3.34c-1.18-1.06-2.82-1.61-4.56-1.64c-0.64,0-1.3,0.09-1.95,0.34      c-1.44,0.58-2.11,1.67-2.7,2.33c-0.17,0.21-0.32,0.37-0.44,0.49c-0.81-1.99-1.91-3.41-3.41-4.31c-1.83-1.09-3.9-1.35-6.42-1.62      c-0.66-0.06-1.31-0.09-1.96-0.09c-3.58,0.01-7.03,0.78-10.14,0.77c0,0,0,0-0.01,0c-0.02,0-0.08-0.01-0.24,0.01      c-0.82,0.11-1.39,0.87-1.28,1.69c0.05,0.37,0.23,0.7,0.5,0.93c-0.47,1.37-0.59,2.69-0.59,3.89c0,1.63,0.21,3.06,0.2,4.17      c0,1.05-0.15,1.72-0.56,2.26c-0.41,0.55-1.26,1.18-3.12,1.7c-0.31,0.09-0.92,0.13-1.63,0.13c-0.52,0-1.1-0.02-1.7-0.02      c-1.31,0.03-2.75,0.01-4.09,0.93c-1.54,1.03-1.91,2.77-1.85,3.82c0,0.4,0.02,0.76,0.02,1.07s-0.02,0.54-0.06,0.74      c-1.5,0.15-2.94,0.79-4.12,1.76c-1.34,1.11-2.37,2.77-2.37,4.75c0,0.14,0,0.31,0.02,0.5c0.13,2.39,1.97,3.93,3.69,4.39      c1.73,0.54,3.57,0.53,4.97,0.61c3.29,0.18,5.35,1.04,6.85,2.53c1.51,1.51,2.56,3.85,3.25,7.24c0.09,0.48,0.41,0.87,0.85,1.07      c0.77,0.34,1.48,0.53,2.18,0.54c0.02,0,0.04,0,0.05,0c1.42,0,2.39-0.96,2.85-1.56c0.52-0.64,0.84-1.06,1.24-1.26      c1.07-0.66,4.03-0.61,6.34-1.21c2.2-0.67,4.23-1.76,5.78-1.72c0.16,0,0.31,0.01,0.45,0.03c0.86,0.12,1.16,0.43,1.82,1.1      c0.57,0.6,1.59,1.76,3.34,1.76c0.37,0,0.74-0.05,1.12-0.14c3.11-0.76,5.03-3.21,6.24-5.74c1.23-2.57,1.86-5.4,2.28-7.5      c0.27-1.4,0.3-2.32,0.46-2.76c0.14-0.41,0.23-0.66,1.26-1.39c0.57-0.42,1.69-0.71,2.89-1.26      C382.491,314.719,383.971,313.429,384.011,311.438z",
                        "Bar": "M110.131,498.329c-0.01,0.29,0,0.729,0,1.29c0,0.859-0.02,1.97-0.1,2.869      c-0.04,0.44-0.09,0.841-0.15,1.08c-0.01,0-0.01,0.011-0.01,0.021c-0.14-0.22-0.33-0.601-0.49-1c-0.25-0.59-0.41-1.16-0.81-1.8      c-2.06-3.091-4.95-5.78-7.62-8.051c-2.73-2.359-4.8-3.72-8.61-3.93c-1.68-0.11-2.6-0.21-3.17-0.45      c-0.57-0.239-1.14-0.67-2.19-1.93c-1.58-1.85-2.2-4.56-2.75-7.59c-0.57-3-1.07-6.3-3-9.13c-1.8-2.57-4.47-3.9-6.78-5.19      c-2.35-1.28-4.3-2.49-5.21-4.26c-0.72-1.33-1.12-2.79-2.02-4.26c-0.88-1.48-2.44-2.82-4.87-3.41c-0.51-0.141-1.04-0.2-1.55-0.2      c-2.46,0.02-4.81,1.36-6.12,3.52c-0.35-0.149-0.65-0.38-0.98-0.729c-0.86-0.9-1.61-2.64-2.51-4.39      c-0.91-1.71-2.11-3.641-4.45-4.351c-0.37-0.109-0.71-0.14-1.03-0.14c-1.07,0.01-2.23,0.3-3.35,0.76      c-1.1,0.49-2.14,1.01-2.85,2.15c-0.4,0.689-0.6,1.439-0.6,2.13c0.01,1.21,0.53,2.1,0.9,2.76c0.4,0.67,0.67,1.17,0.72,1.47      c0.09,0.54,0.14,1.011,0.14,1.4c-0.08,1.439-0.36,1.63-1.03,2.03c-0.72,0.359-2.12,0.5-3.72,0.489c-0.54,0-1.1-0.01-1.67-0.02      c-1.34-0.021-2.89-0.14-4.47-0.14c-0.81,0-1.64,0.029-2.46,0.149c-1.33,0.22-2.36,0.65-3.25,0.96c-0.11-0.22-0.2-0.43-0.32-0.64      c-1.53-2.69-2.96-4.55-3.88-6.271c-0.93-1.72-1.5-3.27-1.64-6c-0.11-2.22-0.64-4.96-0.63-6.899c-0.01-0.79,0.11-1.391,0.16-1.49      c0.26-0.72,1.03-1.7,2.1-2.92c1.04-1.23,2.38-2.71,3.19-4.87c0.35-1.03,1.2-2.79,1.25-5.04c0-0.43-0.04-0.87-0.14-1.32      c-0.17-0.72-0.39-1.39-0.8-2.04c-0.63-1.01-1.62-1.56-1.94-1.73c-0.37-0.21-0.41-0.22-0.68-0.48c-0.9-0.89-1.31-1.57-1.63-2.42      c-0.3-0.85-0.47-1.96-0.55-3.51c-0.18-3.52-0.59-7.35-0.59-10.88c0-2.56,0.22-4.93,0.8-6.84c0.59-2.03,1.76-5.09,2.69-6.58      c0.18-0.3,0.33-0.55,0.45-0.76c0.23-0.06,0.52-0.13,0.85-0.23c0.01,0,0.04-0.01,0.16-0.02c0.11-0.01,0.29-0.02,0.51-0.02      c0.33,0,0.73,0.01,1.19,0.01c0.99-0.03,2.42,0.03,4.03-1.03c0.92-0.66,1.3-1.46,1.51-1.97c0.29-0.79,0.37-1.27,0.46-1.5      c0.54-0.23,2.16-0.55,3.9-0.5c1.7,0,3.46,0.15,4.96,0.15c4.45,0,8.75-0.12,13.22-0.39c1-0.06,1.91-0.61,2.42-1.48      c0.5-0.87,0.54-1.93,0.1-2.83c-0.28-0.52-0.44-1.51-0.66-2.88c-0.24-1.33-0.61-3.22-2.14-4.88c-1.64-1.71-3.44-2.22-4.3-2.69      c-0.11-0.06-0.21-0.11-0.29-0.15c0.01-0.03,0.02-0.06,0.03-0.09c0.1-0.51,0.84-1.31,2.4-2.22c1.5-0.95,3.49-1.77,5.22-3.63      c1.75-1.84,2.22-4.25,2.16-5.82c0-0.35-0.01-0.68-0.02-0.99c0.98,0.1,2.62,0.65,4.82,0.71c0.37,0,0.74-0.02,1.12-0.07      c0.89-0.11,1.67-0.61,2.15-1.37c0.78-1.2,1.08-2.56,1.07-3.6c0-0.27-0.02-0.53-0.04-0.75c0.02,0,0.04,0,0.07,0      c1.19-0.14,3.22,1.12,6.59,1.26c1.06,0.01,2.25-0.21,3.4-0.73c2.07-0.92,3.65-2.42,4.63-4.09c1-1.68,1.47-3.44,1.76-5.14      c0.17-1,0.38-1.55,0.54-1.82c0.23-0.37,0.27-0.44,1.11-0.89c0.81-0.41,2.25-0.93,4.09-1.85c2.15-1.13,4.02-1.96,4.89-1.89      c0.6,0.05,0.89,0.03,1.87,1.12c0.95,1.2,0.9,1.6,1.49,3.11c0.28,0.73,0.86,1.76,1.78,2.51c0.92,0.77,2,1.27,3.31,1.68      c1.7,0.4,3.63,2.47,7.3,3.45c0.59,0.14,1.12,0.17,1.59,0.17c1.14-0.02,1.94-0.16,2.33-0.15c0.13,0,0.2,0.01,0.22,0.01      c0.57,0.1,1.1,0.32,1.9,0.7c0.79,0.38,1.85,0.93,3.26,1.27c1.22,0.29,2.4,0.44,3.53,0.44c4.26,0.04,7.61-2.21,9.71-4.91      c2.13-2.66,3.45-5.78,4.6-8.55c0.6,0.29,1.33,0.55,2.18,0.67c0.28,0.04,0.55,0.06,0.82,0.05c1.45,0.01,2.69-0.55,3.56-1.13      c1.32-0.9,2.14-1.86,2.84-2.44c0.71-0.61,1.05-0.72,1.21-0.73c0.34-0.02,0.68-0.03,1.03-0.03c4.84-0.09,10.38,2.52,16.94,2.61      c1.64,0,3.34-0.2,5.07-0.68c0.01-0.01,0.02-0.01,0.03-0.01c-0.63,2.32-0.96,5.07-1.67,7.35c-0.42,1.39-0.97,2.54-1.62,3.25      c-0.68,0.7-1.35,1.07-2.58,1.09c-0.23,0-0.49-0.01-0.76-0.05c-1.78-0.23-2.92-0.62-4.4-0.63c-1.52-0.02-3.04,0.55-4.95,1.87      c-1.11,0.84-3.3,1.67-4.27,3.96c-0.27,0.73-0.32,1.44-0.33,2.1c0.01,0.92,0.11,1.77,0.1,2.45c0,0.43-0.03,0.77-0.1,1      c-0.27,0.94-0.55,1.46-0.75,1.7c-0.29,0.33-0.37,0.36-1.11,0.52c-0.71,0.13-1.86,0.22-3.25,0.75c-1.17,0.46-2.6,1.4-3.93,2.57      c-1.26,1.22-2.53,2.45-2.64,4.39c0,0.04,0,0.13,0.01,0.26c0.08,0.78,0.38,1.4,0.76,1.88s0.82,0.82,1.16,1.07      c0.37,0.26,0.68,0.47,0.87,0.63c0.1,0.08,0.17,0.14,0.19,0.18h0.02c0.12,0.25,0.23,0.97,0.22,1.81c0,1.59-0.28,3.53-0.29,4.92      c0,0.12,0,0.24,0,0.36c0.02,2.24-0.04,4.07,0.87,5.78c0.97,1.76,2.94,2.58,5.52,2.74c3.94,0.27,6.7,0.2,8.74,0.82      c1.82,0.56,3.31,1.54,5.19,4.23c-1.81,2.28-2.44,4.67-2.41,7.03c0,1.51,0.21,3.02,0.45,4.64c0.33,1.96,0.11,4.29,1.45,6.62      c0.74,1.21,1.66,1.96,2.25,2.63c0.13,0.15,0.24,0.28,0.34,0.41c-1.56,0.11-3.08,0.26-4.56,0.32c-0.53,0.02-1.02,0.32-1.27,0.79      c-1.57,2.95-2.27,6.04-2.27,9.05c0,2.88,0.64,5.689,1.75,8.25c0.71,1.75,2.09,2.649,3.11,3.02c1.04,0.41,1.59,0.561,2,1.011      c0.69,0.68,0.88,2.029,1.17,3.619c0.16,0.771,0.37,1.641,1.03,2.45c0.5,0.63,1.29,1.05,2.17,1.21      c-0.85,3.28-1.72,5.891-1.73,8.95c-0.01,2.23,0.5,4.601,1.75,7.4c0.48,1.05,1.45,4.38,2.61,7.399      c0.59,1.53,1.23,3.011,1.97,4.23c0.53,0.81,1.05,1.6,1.85,2.12c0.02,0.45,0.02,0.92,0.02,1.39c0,0.76-0.01,1.54-0.01,2.33      c0,0.86,0.01,1.74,0.06,2.62c0.04,0.66,0.51,1.22,1.16,1.37c0.47,0.109,0.93,0.17,1.38,0.17c0.5-0.01,0.97-0.08,1.4-0.19      c-0.38,0.891-0.71,1.83-0.74,2.891c-0.02,0.72,0.26,1.64,0.92,2.25c-0.17,0.149-0.34,0.319-0.5,0.51      c-1.17,1.38-1.32,2.93-1.29,3.939c0,0.19,0,0.37,0,0.54c-0.01,0.65-0.04,1.08-0.25,1.591c-0.21,0.359-0.06,0.22-0.57,0.399      c-0.44,0.141-1.5,0.15-2.48,1.11c-1.18,1.12-1.49,2.649-1.43,3.899c0,0.36,0.01,0.74,0.02,1.181c0,0-0.01,0.02-0.01,0.1      c0.01,1.93-0.14,5.42-0.91,8.26c-0.38,1.42-0.92,2.66-1.54,3.431c-0.55,0.64-1.04,0.96-1.7,1.06c-0.04-0.09-0.07-0.18-0.12-0.27      c-0.58-1.03-1.64-1.48-2.39-1.641c-0.79-0.189-1.49-0.25-2.12-0.42c-1.56-0.41-2.06-0.62-2.32-0.81      c-0.27-0.17-0.7-0.7-1.74-1.78c-2.61-2.65-5.16-2.77-7.37-4c-2.11-1.1-3.37-3.46-4.2-6.07c-0.65-1.77-0.49-5.399-2.76-7.92      c-1.15-1.2-2.68-1.8-4.19-1.8c-2.15-0.02-4.33,1.26-5.27,3.57c-0.69,1.71-0.59,3.279-0.66,4.49c-0.07,1.25-0.2,2.039-0.92,2.89      c-0.5,0.6-1.54,0.97-2.88,0.96c-1.06,0.01-2.23-0.23-3.14-0.561c-0.46-0.159-1.09-0.619-1.79-1.18      c-0.72-0.55-1.52-1.22-2.68-1.55c-0.51-0.14-0.97-0.21-1.41-0.21c-0.92-0.04-1.77,0.49-2.09,0.81      c-0.36,0.32-0.45,0.41-0.79,0.561c-0.75,0.31-1.2,0.38-1.54,0.38c-0.72,0.07-1.79-0.63-4.32-1.11      c-0.43-0.069-0.88,0.05-1.22,0.33C110.331,497.469,110.131,497.889,110.131,498.329z",
                        "Bershad": "M745.271,752.639c0.069,0.58,0.26,2.43,0.25,3.76c0,0.03,0,0.05,0,0.08c-0.021,0-0.03,0-0.05,0      c-0.801,0-1.83-0.13-2.931-0.14c-0.12,0-0.29,0-0.56,0.03c-1.561,0.149-2.74,1.489-2.7,3.069c0,0.01,0.01,0.04,0.01,0.11      c0.04,0.96-0.56,2.99-0.609,5.38c0.01,0.84,0.1,1.77,0.449,2.75c0.61,1.66,1.631,2.71,2.301,3.479      c0.72,0.78,1.119,1.28,1.3,1.73c0.43,1.01,0.649,2.27,0.899,3.84c0.271,1.55,0.591,3.42,1.58,5.37      c0.48,0.93,1.061,1.57,1.311,1.86c-0.03,0.069-0.09,0.21-0.23,0.42c-0.279,0.46-0.79,1.1-1.34,1.84      c-0.54,0.76-1.16,1.59-1.58,2.84c-0.5,1.54-0.6,3.021-0.6,4.32c0.01,1.33,0.1,2.51,0.1,3.52c0,1.09-0.1,1.96-0.38,2.73      c-0.479,1.37-0.9,2.38-1.27,2.89c-0.4,0.49-0.53,0.63-1.351,0.87c-2.97,0.73-6.71,0.76-10.649,1.66      c-4.341,1.04-8.32,2.3-12.24,2.62c-0.94,0.08-1.811,0.1-2.73,0.2c-0.7,0.079-1.439,0.189-2.26,0.51      c-0.49,0.17-0.99,0.47-1.44,0.84c-1.149-0.24-2.119-0.46-2.939-0.78c-1.45-0.58-2.55-1.35-3.87-3.28      c-0.36-0.529-1.02-0.779-1.64-0.609c-0.86,0.229-1.63,0.32-2.37,0.32c-2.561,0.039-5.021-1.2-8.46-1.32      c-4.391-0.08-9.29-0.03-12.53-1.97c-3.53-2.011-6.21-7.021-7.69-11.19c-1.069-2.85-3.09-6.98-3.039-9.29l0.01-0.02      c0.01-0.4-0.141-0.79-0.41-1.08c-0.271-0.301-0.66-0.471-1.05-0.48c-1,0-2.25-0.7-3.67-1.7c-1.431-0.979-2.99-2.199-5.021-2.66      c-0.47-0.109-0.93-0.149-1.359-0.149c-1.4,0-2.511,0.49-3.37,0.899c-0.88,0.421-1.551,0.761-2.23,0.87      c-0.229,0.03-0.47,0.051-0.71,0.051c-2.54,0.069-5.78-2.301-8.59-4.07c-0.92-0.54-2.2-1.67-3.61-2.69c-1.42-1-3.04-2-5.02-2.029      c-0.36,0-0.72,0.04-1.08,0.119c-1.89,0.41-3.01,1.61-3.811,2.36c-0.859,0.811-1.239,1.101-1.939,1.11      c-0.22,0-0.49-0.03-0.84-0.12c-1.79-0.4-4.4-3.33-4.98-5.67c-0.54-1.79-0.33-3.681-1.26-6.29c-0.85-2.311-1.79-4.561-2.39-6.72      c-0.881-3.141-1.61-6.24-1.96-9.37c-0.25-2.15-0.5-3.761-1.25-5c0.659-0.21,1.42-0.32,2.329-0.391      c1.98-0.14,4.4,0.051,6.86-0.77c3.8-1.3,7.33-3.811,9.04-8.01c0.4-1.021,0.63-1.71,0.65-2.511c0.05-0.8-0.5-1.689-0.94-1.989      c-0.439-0.36-0.71-0.49-0.96-0.71c0-0.011,0-0.011,0-0.011c-0.29-0.239-0.63-0.359-0.97-0.359c-0.17,0-0.34,0.029-0.5,0.09      c-0.12-0.03-0.24-0.07-0.351-0.101c-0.14-0.04-0.26-0.069-0.35-0.1c-0.12-0.11-0.35-0.34-0.59-0.6      c-0.37-0.351-0.73-0.771-1.46-1.101c-0.63-0.26-1.28-0.34-1.86-0.34c-1.58,0.03-3,0.46-3.92,0.44c-0.32,0-0.55-0.04-0.7-0.101      c-1.39-0.37-2.52-3.08-2.72-5.38c-0.09-0.729-0.68-1.3-1.41-1.34c-0.439-0.021-0.88-0.03-1.32-0.03      c-3.22,0.01-6.63,0.46-9.729,0.45c-1.56,0-3.03-0.11-4.33-0.41c-2.76-0.71-3.39-1.979-3.41-2.99c0-1.26,1.17-2.81,3.74-2.84      c0.24,0,0.49,0.021,0.76,0.05c0.71,0.091,1.38-0.34,1.601-1.02c0.229-0.67,0.31-1.3,0.31-1.84c-0.02-1.101-0.26-1.78-0.229-2.09      c0.02-0.29-0.011-0.521,0.819-1.45c1.2-1.29,3.17-2.16,5.22-3.45c2.601-1.76,4.671-4.51,6.561-4.9      c0.27-0.069,0.66-0.109,1.14-0.109c1.101-0.01,2.54,0.21,3.96,0.21c0.17,0,0.36,0,0.551-0.01c0.64-0.03,1.18-0.46,1.359-1.07      c0.01-0.04,0.021-0.07,0.03-0.1c0.43-0.78,0.36-1.391,0.41-2.091c-0.011-1.609-0.34-3.67-0.33-4.39c0-0.04,0-0.07,0-0.1      c0.13-2.011,0.71-3.33,1.51-5.511c0.73-2.04,0.85-2.779,1.79-3.68c0.27-0.26,0.61-0.42,1.22-0.7c0.59-0.27,1.44-0.72,2.11-1.609      c1.45-2.021,1.47-4.57,1.88-6.561c0.18-0.979,0.43-1.79,0.68-2.17c0.29-0.38,0.28-0.399,0.78-0.439c0.09,0,0.21,0.01,0.35,0.029      c1.07,0.141,2.49,1.2,3.94,2.61c1.47,1.38,2.94,3.01,4.84,3.939c1.891,0.9,3.67,1.311,5.351,1.311      c3.369-0.01,6.069-1.6,8.529-3.271c2.48-1.699,4.82-3.52,7.45-4.5c1.84-0.689,3.83-1.06,5.79-1.06c1.89,0,3.75,0.34,5.43,1.04      c1.75,0.729,2.881,1.42,4.221,2.01c1.33,0.601,2.85,1.021,4.899,1.01c0.33,0,0.67-0.01,1.04-0.029      c0.641-0.03,1.19-0.48,1.37-1.101c0.12-0.439,0.18-0.89,0.18-1.31c-0.02-1.811-0.949-3.08-1.6-4.12      c-0.64-0.95-1.06-1.7-1.11-2.3c1.46-0.82,2.96-1.391,4.551-1.78c0.55-0.14,0.979-0.58,1.1-1.14c0.13-0.57-0.08-1.141-0.53-1.5      c-0.12-0.03-0.89-1.19-1.34-2.46c-0.5-1.271-0.84-2.771-0.84-3.63c0-0.16,0.02-0.29,0.03-0.391c0.08-0.01,0.199-0.01,0.34-0.01      c0.3-0.01,0.72,0.03,1.2,0.03c0.609-0.011,1.39-0.021,2.22-0.58c1.31-0.851,1.88-2.32,1.82-3.37      c-0.021-0.86-0.16-1.49-0.15-2.01c0-0.12,0.01-0.23,0.02-0.341c0.421-2.909,0.961-3.81,3.41-5.09      c1.19-0.59,3.351-0.87,5.33-1.47c1-0.31,2-0.72,2.851-1.49c0.62-0.55,1.09-1.33,1.3-2.229c1.189-0.04,2.399-0.061,3.62-0.061      c2.58,0,5.189,0.07,7.81,0.07c2.561-0.01,4.04,0.07,4.91,0.49c0.86,0.38,1.64,1.17,2.82,3.38c2.08,3.89,5.63,7.7,9.229,10.18      c1.79,1.2,4.03,1.74,6.13,2.34c2.101,0.57,4.051,1.21,5.011,2c0.819,0.561,1.51,2.38,3.029,3.811c2.7,2.37,5.16,3.5,7.521,3.5      c3.5-0.03,5.93-2.41,7.979-4.9c2.07-2.54,3.92-5.43,5.91-7.28c4.851-4.56,12.24-7.38,17.92-12.56c1.84-1.71,2.84-3.75,3.87-5.13      c1.07-1.41,1.771-2.05,3.41-2.09h0.04c1.26-0.03,2.99,0.62,5.12,0.649c0.35,0,0.72-0.02,1.1-0.069      c1.71-0.271,3.07-0.88,4.33-1.42c0.62,1.6,1.83,2.27,2.37,2.6c0.31,0.17,0.52,0.29,0.62,0.35c0.21,0.301,0.59,0.931,1.01,1.631      c0.53,0.819,1.061,1.77,2.22,2.689c1.521,1.18,3.341,1.41,4.511,1.38c0.729,0,1.31-0.04,1.819-0.04c0.311,0,0.58,0.01,0.83,0.04      c0.891,0.101,1.5,0.25,1.86,0.38c0.189,0.07,0.32,0.13,0.38,0.17c0.01,0.07,0.03,0.2,0.03,0.391c0.02,0.84-0.351,2.58-0.37,4.77      c0,1.16,0.13,2.46,0.54,3.82c0.6,2.02,1.68,3.39,2.399,4.43c0.75,1.061,1.15,1.75,1.301,2.561c0.09,0.489,0.14,1.16,0.14,1.91      c0,0.619-0.03,1.289-0.08,1.979c-1.96,0.14-3.87,0.28-5.64,0.271c0,0-0.08,0-0.271,0.01c-1.21,0.05-2.27,0.83-2.68,1.979      c-0.41,1.141-0.101,2.42,0.8,3.23c1.1,0.979,2.53,1.91,3.72,2.939c0.29,0.25,0.561,0.5,0.78,0.73      c-0.12,0.11-0.229,0.22-0.34,0.33c-1.21,1.28-1.76,2.62-2.26,3.75c-0.471,1.13-0.91,2.12-1.03,2.26      c-1.41,2.08-4.021,4.21-6.09,7.42c-1.87,2.99-3.28,5.62-4.891,7.5c-1.63,1.88-3.27,3.13-6.26,3.88      c-0.18,0.04-0.46,0.08-0.82,0.08c-1.02,0.021-2.6-0.33-4.539-0.35c-1.061,0-2.271,0.13-3.5,0.66c-2.62,1.13-3.95,3.34-4.7,4.949      c-0.75,1.66-1.29,2.92-1.61,3.2c-0.22,0.23-0.3,0.26-0.54,0.351c-0.24,0.08-0.67,0.13-1.3,0.13c-0.54,0-1.21-0.04-2-0.04      c-0.88,0-1.91,0.05-3.05,0.34c-2.04,0.58-3.69,1.82-5.15,3.38c-1.399,1.59-2.67,3.5-2.729,6.08c-3.391,3.11-6.03,6.47-8.87,9.44      c-1.351,1.42-3.23,2.649-5.32,4.06c-2.07,1.4-4.37,3.01-6.22,5.479c-0.99,1.32-0.73,3.19,0.59,4.19      c1.32,0.98,2.57,1.41,3.42,1.82c0.43,0.2,0.75,0.38,0.93,0.51c0.19,0.13,0.221,0.19,0.221,0.19c0.08,0.079,0.25,0.71,0.239,1.71      c0,0.63-0.05,1.369-0.05,2.189c0,0.2,0,0.43,0.021,0.69c0.1,1.609,0.479,2.939,0.449,3.699c-0.18,0-0.409,0.011-0.67,0.011      c-0.71,0.02-1.62-0.04-2.87,0.38c-2.17,0.8-3.949,2.229-5.31,3.89c-0.43,0.54-0.72,0.88-1.01,1.28      c-0.25,0.36-0.78,1.09-0.811,2.29c0.011,0.66,0.181,1.12,0.261,1.33C745.142,751.919,745.121,751.679,745.271,752.639z",
                        "Chechelnyk": "M686.562,849.229c-1.03,0.88-1.04,1-2.261,1.08c0,0,0,0-0.02,0c-0.01,0-0.03-0.01-0.07,0      c-0.09-0.01-0.33-0.07-0.779-0.22c-0.54-0.16-1.391-0.48-2.58-0.49c-0.21,0-0.48,0.01-0.78,0.05      c-1.44,0.21-2.44,0.76-3.19,1.101c-0.75,0.37-1.25,0.56-1.55,0.59c-1.04,0.149-1.95,0.22-2.77,0.22      c-2.63-0.06-4.05-0.56-6.271-2.54c-1.64-1.58-3.51-2.36-4.92-2.58c-1.41-0.25-2.07-0.24-3.1-0.609      c-0.08-0.101-0.32-0.561-0.73-1.341c-0.439-0.84-1.35-2.18-2.93-2.909c-0.69-0.33-1.48-0.511-2.22-0.511      c-1.62,0.03-2.65,0.681-3.311,1.03c-0.67,0.39-1.06,0.58-1.13,0.58c-0.2,0.05-0.61,0.09-1.11,0.09c-0.89,0-2.04-0.13-3.3-0.13      c-1.58,0.01-3.96-0.29-6.41-0.29c-1.6,0-3.27,0.11-4.96,0.69c-3.47,1.13-5.71,3.77-6.529,6.39c-0.69,2.08-0.841,4.07-0.99,5.87      c-0.521,0.27-1.08,0.39-1.75,0.399c-1.01,0-2.271-0.35-3.53-1.06c-1.83-1.04-3-1.88-4.149-2.6c-1.11-0.7-2.511-1.46-4.301-1.46      c-2.31,0.06-4.01,0.989-6.72,2.439c-2.5,1.4-3.77,1.811-4.39,1.78c-0.58,0.01-1.54-0.271-3.641-1.63      c-0.899-0.54-1.93-1.86-3.149-3.53c-1.24-1.64-2.74-3.66-5.311-4.95c-1.39-0.68-2.83-0.939-4.12-0.939      c-0.21,0-0.42,0.01-0.619,0.02c2.54-1.39,4.899-3.399,6.38-6.42c0.569-1.21,1-2.38,1.02-3.79c0.03-1.16-0.46-2.7-1.64-3.64      c-1.16-0.94-2.46-1.16-3.641-1.16c-0.579,0-1.17,0.05-1.779,0.16c-1.98,0.35-3.391,1.25-4.58,1.91      c-1.181,0.68-2.12,1.13-2.7,1.199c-0.45,0.07-0.97,0.101-1.54,0.101c-1.46,0-3.18-0.221-4.87-0.391      c-1.38-0.09-3.82-1.06-6.609-1.119c-0.061,0-0.19-0.011-0.4,0.01c-1.32,0.069-2.29,0.479-2.92,0.72      c-0.33,0.13-0.57,0.22-0.71,0.26c-0.07,0.021-0.12,0.03-0.141,0.04c-0.029,0-0.079,0-0.13,0c-2.8-0.04-4.359-0.939-6.109-2.569      c-1.721-1.641-3.311-4.101-5.25-6.62c-3.271-4.17-7.4-7.681-11-11.011c-0.75-0.68-1.59-1.77-2.65-2.97      c-1.06-1.18-2.41-2.53-4.4-3.35c-0.76-0.32-1.489-0.54-2.25-0.66c0.03-0.23,0.011-0.47-0.079-0.7      c-0.891-2.16-1.921-3.21-1.921-4.78c0-0.06,0-0.09,0-0.09c-0.079-1.42,1.171-3.1,1.601-5.649c0.02-0.23,0.04-0.44,0.04-0.65      c-0.04-1.47-0.49-2.64-0.45-3.38c0-0.26,0.03-0.44,0.09-0.58c0.05-0.23,0.851-1.06,1.86-1.73c1.01-0.71,2.13-1.359,2.95-1.989      c1.189-0.98,3.439-1.971,4.43-4.48c0.54-1.439,0.56-2.63,0.63-3.47c0.08-0.87,0.15-1.37,0.64-2.2c1.771-2.88,3.62-5.95,4.5-9.59      c0.091,0.13,0.19,0.27,0.28,0.42c0.72,1.05,1.42,2.36,2.58,3.4c0.45,0.409,1.12,0.489,1.67,0.22c0.55-0.28,0.87-0.87,0.82-1.49      c-0.021-0.16-0.03-0.33-0.03-0.49c0-1.14,0.38-2.35,0.99-3.18c0.62-0.82,1.33-1.25,2.27-1.26c0.4-0.01,0.971,0.189,1.73,0.52      c0.76,0.311,1.7,0.75,2.91,0.761c0.149,0,0.26-0.011,0.35-0.011c1.17-0.13,2.01-0.62,2.89-1.04      c0.851-0.43,1.681-0.83,2.091-0.909c2.979-0.601,5.17-1.07,7.88-3.32c0.74-0.62,2.16-1.32,3.529-2.19      c1.351-0.87,2.83-1.97,3.391-3.89c0.14-0.51,0.189-1.01,0.189-1.5c-0.09-2.96-1.689-5.57-1.619-7.59      c0-0.391,0.05-0.74,0.149-1.07c0.46-1.45,0.88-1.81,1.4-2.07c0.56-0.279,1.58-0.359,3.01-0.35c0.24,0,0.479,0,0.74,0      c2.189,0,4.43,0.08,6.7,0.08c1.14,0,2.289-0.03,3.449-0.08c1.351-0.08,2.37-0.27,3.24-0.7c1.34-0.649,1.94-1.83,2.33-2.67      c0.25-0.55,0.49-1.07,0.86-1.63c0.13,0.18,0.27,0.39,0.42,0.63c0.5,0.75,1.029,1.8,2.21,2.561c1.319,0.81,2.75,0.899,4.06,0.909      c1.181,0,2.311-0.1,3.2-0.1c0.47,0,0.9,0,1.31,0c0.98-0.02,1.78,0,2.41,0.05c0.061,0.37,0.25,0.73,0.57,0.98      c0.28,0.2,0.6,0.3,0.91,0.3c0.28,0,0.55-0.08,0.79-0.23c0.27,0.61,0.54,1.7,0.72,3.551c0.37,3.38,1.15,6.64,2.05,9.84      c0.67,2.41,1.65,4.729,2.46,6.95c0.721,1.89,0.521,3.6,1.19,6.079c1.01,3.33,3.72,6.721,7.08,7.74      c0.569,0.16,1.109,0.24,1.63,0.23c1.93,0.01,3.189-1.141,4.01-1.94c0.88-0.84,1.48-1.399,2.39-1.6      c0.141-0.03,0.28-0.05,0.431-0.05c0.819-0.021,2.02,0.56,3.27,1.47c1.261,0.899,2.511,2.02,3.8,2.82      c2.62,1.529,6.03,4.43,10.15,4.5c0.39,0,0.79-0.03,1.18-0.091c1.301-0.22,2.261-0.75,3.051-1.119c0.8-0.391,1.39-0.61,2.08-0.62      c0.22,0.01,0.449,0.029,0.71,0.09c1.149,0.22,2.489,1.149,3.96,2.189c1.149,0.78,2.399,1.66,3.93,2.04      c0.439,3.28,2.32,6.771,3.12,9.09c1.63,4.44,4.34,9.99,9,12.761c4.35,2.51,9.7,2.25,13.97,2.38c2.6,0.02,5.09,1.28,8.53,1.32      c0.68,0,1.39-0.061,2.12-0.19c1.399,1.81,2.979,2.92,4.68,3.56c0.73,0.271,1.47,0.471,2.24,0.65c-0.41,1.23-0.53,2.51-0.54,4.06      c0,0.11,0,0.261,0,0.431c-0.03,2.99,1.52,5.29,2.71,6.45c1.2,1.26,1.8,1.779,2.229,2.979c0.221,0.61,0.351,1.49,0.351,2.521      c0.01,2.409-0.7,5.489-1.15,8.14c-0.72,4.3-1.04,8.45-1.46,12.51c-0.13,1.561-0.27,3.141-0.55,3.92      c-0.03,0.12-0.07,0.21-0.1,0.28c-0.211-0.04-0.591-0.12-1.11-0.35c-0.39-0.19-0.47-0.28-0.71-0.66      c-0.37-0.57-0.63-1.86-1.351-3.521c-0.38-0.83-0.96-1.79-1.93-2.58c-0.97-0.8-2.27-1.29-3.61-1.41      c-0.239-0.029-0.5-0.05-0.77-0.05c-1.44-0.029-2.74,0.57-3.33,0.94c-0.64,0.38-0.66,0.39-0.82,0.43      c-0.08,0.01-0.25,0.03-0.479,0.03c-0.53,0.01-1.41-0.12-2.58-0.14c-0.51,0-1.08,0.039-1.7,0.17      C689.081,846.589,687.461,848.398,686.562,849.229z",
                        "Chernivtsi": "M251.301,715.469c0.79,0.61,1.26,0.96,1.53,1.51c0.17,0.32,0.22,0.58,0.22,0.891      c0.03,0.55-0.24,1.27-0.54,2.17c-0.15-0.061-0.32-0.12-0.52-0.181c-0.72-0.21-1.54-0.92-2.37-2.12      c-1.26-1.77-2.42-4.39-3.88-6.67c-1.43-2.229-3.41-4.439-6.51-4.46c-0.94,0-1.91,0.21-2.91,0.63      c-2.13,0.99-3.01,3.061-4.1,4.681c-0.51,0.819-1.02,1.55-1.48,1.979c-0.48,0.45-0.79,0.58-1.11,0.58c-0.02,0-0.04,0-0.05,0      c-0.17,0-0.3-0.02-0.38-0.04c-0.07-0.27-0.05-1.01-0.14-1.93c-0.05-0.4-0.06-0.72-0.06-1.021c0-0.489,0.04-0.89,0.04-1.369      c0.02-0.511-0.08-1.33-0.63-1.971c-0.53-0.63-1.16-0.93-1.96-1.24c-1.03-0.399-1.92-0.619-2.77-0.619      c-0.52-0.03-1.05,0.1-1.52,0.319c-1.24-1.25-2.41-2.05-2.44-3.109c-0.01-0.11-0.02-0.221-0.02-0.341      c-0.05-1.909,1.58-4.079,3.09-6.31c0.33-0.51,0.32-1.16-0.02-1.66c-0.34-0.51-0.95-0.75-1.54-0.63      c-3.4,0.74-9.46,3.311-13.72,3.28c-1.18,0-2.16-0.19-2.87-0.57s-1.2-0.88-1.58-1.83c-0.47-1.09-0.17-2.729-0.72-4.819      c-0.32-1.131-0.84-1.961-1.35-2.58c-0.51-0.631-0.95-1.08-1.43-1.801c-0.44-0.64-0.63-1.1-0.7-1.33c0.25-0.1,0.81-0.26,1.5-0.38      c0.95-0.18,2.13-0.359,3.35-0.779c0.73-0.25,1.15-1.011,0.98-1.75c-0.95-4.051-3.03-6.771-4.03-10.141      c-0.48-1.55-0.65-3.27-0.65-5.06c0-2.05,0.23-4.19,0.41-6.29c0.04-0.49-0.15-0.94-0.48-1.24c-0.34-1.54-0.96-2.7-1.21-3.74      c0.08-0.01,0.15-0.02,0.19-0.01c0.04,0,0.04,0,0.04,0c0.15,0.03,0.3,0.04,0.45,0.03c0.01,0,0.02,0,0.04,0      c0.61-0.07,1.14-0.51,1.29-1.141c0.01-0.02,0.01-0.029,0.01-0.039c0.18-0.811-0.33-1.601-1.14-1.78      c-0.06-0.01-0.12-0.021-0.18-0.03c-0.98-0.18-2.11-0.18-3.2-0.25c-1.12-0.03-2.23-0.22-2.31-0.31      c-0.62-0.301-1.13-1.061-1.46-2.24c-0.32-1.16-0.41-2.601-0.41-3.82c0-0.35,0.01-0.68,0.02-1c0.02-0.66-0.41-1.27-1.05-1.47      c-0.64-0.2-1.34,0.04-1.7,0.6c0,0.04-0.55,0.49-1.29,0.761c-0.76,0.31-1.7,0.51-2.46,0.5c-0.36,0.01-0.67-0.04-0.9-0.11      c-0.71-0.22-1.01-0.47-1.14-0.63c-0.13-0.17-0.19-0.33-0.2-0.7c-0.03-0.88,0.68-2.59,1.32-4.35c0.16-0.67,1.08-1.61,1.15-3.381      c0-0.409-0.07-0.84-0.21-1.27c-0.55-1.44-1.69-1.88-2.42-2.28c-0.39-0.18-0.72-0.34-0.93-0.45c-0.05-0.029-0.09-0.06-0.12-0.079      c-0.14-0.28-0.17-0.5-0.18-0.721c-0.09-0.859,1.08-2.3,2.17-4.02c3.34-5.82,1.96-11.15,3.56-16.01      c1.17-3.94,3.87-7.601,3.93-12.2c0-1.67-0.41-3.431-1.38-5.2c-1.73-3.07-3.61-6.76-3.55-8.9c0-0.04,0-0.069,0.01-0.109      c0.04-0.03,0.09-0.05,0.13-0.09c0.5-0.381,0.69-1.011,0.54-1.58c0.03-0.03,0.05-0.07,0.09-0.101c0.56-0.47,1.75-0.93,3.84-1.01      c0.14-0.01,0.26-0.01,0.39-0.01c1.87-0.01,4.79,0.47,7.38,0.479c1.18,0,2.31-0.09,3.37-0.47c1.37-0.53,2.68-1.6,4.02-2.73      c1.32-1.119,2.58-2.319,3.36-2.97c0.96-0.85,1.7-2,2.56-2.96c0.83-0.99,1.67-1.49,1.98-1.43c0.08,0,0.17,0.01,0.29,0.05      c0.19,0.06,0.59,0.4,0.96,1.13c1.18,2.19,1.64,6.79,1.81,8.58c0.38,3.59,2.31,6.11,4.32,8.22c2.04,2.13,4.19,3.98,5.63,6.341      c0.25,0.409,0.7,0.68,1.18,0.71c6.44,0.39,12.7,0.46,18.96,1.05c3.07,0.27,5.95,0.43,7.94,1.95c1.29,0.88,2.15,3.02,4.21,4.729      c1.3,1.05,2.79,1.36,4.07,1.35c1.59-0.01,2.98-0.35,4.22-0.34c1.08,0.011,2,0.19,3.11,0.971c1.07,0.739,2.15,2.09,3.44,3.29      c1.92,1.739,4.08,2.859,5.76,4.159c2.67,2.101,3.65,3.301,4.18,6.301c0.15,0.899,0.04,1.199,0.13,2.029      c0.05,0.41,0.26,0.95,0.59,1.33c0.32,0.391,0.68,0.66,1.13,0.971c1.47,1.029,2.79,1.14,3.29,1.27c0.45,0.16,0.56,0.05,1.5,1.42      c2.05,3.2,3.34,5.07,3.35,8.33c0,0.15,0,0.3-0.01,0.46c-0.06,1.72-0.33,2.88-0.34,4.21c-0.05,1.64,0.72,3.33,2.49,4.91      c1.34,1.22,3.13,1.85,4.69,2.59c1.58,0.69,2.75,1.54,2.87,2c0.16,0.37,0.2,0.65,0.21,0.86c-0.01,0.359-0.12,0.609-0.46,1      c-1.04,1.229-4.25,2.2-6.3,3.33c-1.23,0.72-2.15,1.42-2.81,2.199c-0.66,0.771-1.08,1.7-1.08,2.65c0.03,1.54,0.93,2.62,1.85,3.48      c1.43,1.3,3.3,2.35,4.75,3.409c0.64,0.44,1.14,0.881,1.5,1.271c-0.56,0.54-1.1,1.02-1.76,1.45c-1.01,0.62-1.31,0.62-1.89,0.64      c-0.31,0-0.71-0.03-1.21-0.03c-0.47,0-1.04,0.03-1.67,0.17c-1.58,0.341-2.72,0.91-3.69,1.311c-0.98,0.399-1.77,0.67-3.06,0.67      c-0.09,0-0.17,0-0.24,0c-1.97-0.07-2.54-0.33-4.5-1c-1.5-0.53-3.1-0.93-4.63-0.94c-1.04,0-2.12,0.19-3.05,0.9      c-0.95,0.71-1.45,1.94-1.43,3.22c0,0.92,0.21,1.91,0.59,3.05c0.41,1.2,0.91,1.98,1.18,2.511c0.27,0.54,0.37,0.76,0.38,1.449      c0,0.221-0.01,0.48-0.05,0.79c-0.09,1.351-1.72,3.521-1.81,6.261c0,0.55,0.09,1.14,0.3,1.699c0.64,1.73,2.01,2.83,3.45,3.641      c2.17,1.21,4.72,1.979,6.6,2.95c1.93,1.04,2.8,1.88,2.81,3.33c0,0.46-0.1,1.029-0.34,1.729c-1.01,2.6-1.86,2.89-2.93,2.96      c-1.04,0.021-2.59-0.649-4.12-1.66c-1.53-1-3.05-2.27-4.31-3.229c-1.1-0.84-1.67-2.15-2.26-3.79      c-0.6-1.601-1.15-3.521-2.85-4.95c-0.91-0.75-1.85-1.2-2.86-1.2c-1.59,0.04-2.5,1.021-3.15,1.66c-0.67,0.69-1.21,1.19-1.59,1.29      c-0.22,0.08-0.45,0.11-0.71,0.11c-0.8,0.029-1.73-0.41-3.07-0.46c-0.69-0.04-1.7,0.29-2.26,1.05      c-0.56,0.74-0.78,1.59-0.91,2.689c-0.02,0.16-0.02,0.261-0.02,0.32c0.04,1.14,0.48,2.03,0.87,2.99      c0.41,0.91,0.81,1.84,0.86,2.14c0.21,0.96,0.44,1.88,0.62,2.79c-1.16-0.479-2.48-1.02-4.11-1.06c-1,0-2.09,0.26-3.13,0.859      c-2.11,1.17-3.15,3.351-3.12,5.49c0,0.78,0.12,1.58,0.36,2.36C249.501,713.969,250.551,714.898,251.301,715.469z",
                        "Haisyn": "M716.001,528.879c1.221,0.859,1.28,1.33,1.261,1.37c0.01,0.06-0.051,0.31-0.421,0.72      c-0.529,0.61-1.579,1.36-2.579,2.15c-0.99,0.819-2.091,1.609-2.49,3.189c-0.13,0.58-0.181,1.17-0.181,1.76      c0.021,2.931,1.131,6.12,1.521,8.21c0.51,2.67,1.07,5.25,2.24,7.74c-0.15,0.08-0.301,0.17-0.44,0.28      c-0.49,0.33-0.86,0.85-1.07,1.43c-2.38,0.021-5.079,0.3-7.079,2.26c-1.521,1.521-2.211,3.23-2.891,4.631      c-0.689,1.43-1.31,2.539-2.609,3.479c-1.75,1.32-4.04,1.7-6.12,4.271c-2.24,2.89-2.771,4.77-5.061,6.25      c-2.439,1.64-4.37,1.189-8.01,1.529c-3.12,0.32-5.33,1.2-7.94,1.32c-0.17,0.01-0.35,0.02-0.529,0.02      c-2.67,0.03-5.061-1.1-7.511-1.159c-1.189-0.051-2.659,0.479-3.47,1.75c-0.64,0.979-0.979,2.189-1.16,3.81      c-2.04,0.01-3.83-1.54-5.88-3.53c-2.02-1.92-4.26-4.33-7.76-4.38c-0.521,0-1.06,0.061-1.6,0.19      c-1.061,0.229-1.681,0.96-1.98,1.29c-0.34,0.37-0.41,0.42-0.58,0.47c0,0-0.01,0.01-0.03,0c-0.04,0.01-0.109,0.01-0.189,0.01      c-0.601,0.01-1.561-0.18-2.32-0.189c-0.149,0.01-0.29-0.03-0.68,0.1c-1.07,0.37-1.7,1.04-2.17,1.44      c-0.49,0.43-0.73,0.54-0.83,0.54c0,0-0.01,0-0.03,0c-0.08,0.029-0.51-0.16-1.05-0.631c-0.6-0.39-1-1.13-2.41-1.34      c-0.02,0-0.08-0.01-0.16-0.01c-0.85,0.03-1.41,0.31-2.13,0.63c-1.04,0.51-2.189,1.23-3.2,1.95c-1.02,0.76-1.79,1.33-2.34,2.13      c-0.47,0.7-0.72,1.49-0.72,2.26c0.04,1.73,1.01,2.811,1.64,3.74c0.69,0.94,1.101,1.68,1.08,2.311c0,0.079,0,0.159-0.02,0.27      c-0.16,1.07-0.521,1.44-1.2,2.3c-0.67,0.811-1.57,2.181-1.53,4.16c0,0.26,0.01,0.54,0.04,0.85c0.21,2.811,1.33,4.801,2.96,6.41      c-0.229,0.33-0.25,0.62-0.25,0.8c0,0.021,0,0.04,0,0.051c0,0.569,0.11,1.56,0.11,2.29c0,0.06,0,0.12,0,0.17      c-0.08,0.02-0.22,0.05-0.46,0.09c-0.57,0.08-1.74,0.28-2.641,1.28c-1.05,1.229-1.13,2.67-1.17,4.13      c0.011,2.3,0.521,4.77,0.811,6.01c0.439,1.92,1.27,3.93,2.02,5.58c0.65,1.42,1.63,2.47,2.45,3.38s1.45,1.69,1.6,2.16      c0.03,0.08,0.07,0.32,0.07,0.649c0.021,1.03-0.39,2.641-0.49,4.15c-1.14,0.771-2.6,1.34-3.63,1.32      c-0.79-0.021-1.229-0.2-1.67-0.78c-0.609-0.85-0.67-1.62-0.83-2.87c-0.13-1.21-0.49-2.92-2.01-4.34      c-0.48-0.46-1.21-0.55-1.79-0.21c-1.9,1.09-3.28,1.57-4.75,1.57c-0.88,0-1.84-0.181-3.02-0.591c-0.71-0.25-1.5,0.061-1.841,0.73      c-0.199,0.41-0.56,0.82-1.01,1.28c-1.58-4.49-4.13-9.16-5.84-13.301c-0.58-1.359-1.41-2.63-2.06-3.8      c-0.671-1.16-1.091-2.22-1.061-2.739c0-0.16,0.021-0.261,0.05-0.351c0.44-1.149,1.17-1.85,2.061-2.92      c0.88-1.04,1.8-2.59,1.779-4.77c0-0.33-0.02-0.66-0.06-1.011c-0.3-2.81-1.729-6.42-2.72-8.63c-0.65-1.359-1.71-2.16-2.44-2.87      c-0.79-0.71-1.04-1.21-0.99-1.279c0-0.07,0-0.19,0.2-0.49c0.12-0.26,0.73-0.53,1.91-0.811c1.08-0.279,2.73-0.67,3.75-2.33      c0.51-0.859,0.73-1.8,0.73-2.68c-0.011-1.35-0.48-2.55-1.12-3.51c-0.98-1.44-2.351-2.1-3.45-2.64      c-1.14-0.54-2.021-0.98-2.49-1.561c-1.49-1.75-1.939-3.06-2.97-4.45c-1.05-1.439-2.82-2.42-5.72-2.75      c-5.11-0.55-9.92-5.279-16.78-5.399c-0.21,0-0.43,0.02-0.64,0.029c-0.54-0.329-1.03-0.59-1.311-0.75      c-0.39-0.229-0.87-0.26-1.29-0.09s-0.75,0.521-0.88,0.96c-0.43,1.42-0.94,2.271-1.38,2.69c-0.45,0.42-0.771,0.52-1.271,0.54      c-1.239,0.08-3.64-1.391-5.93-3.28c-2.34-1.86-4.58-3.979-6.8-4.93c-4.36-1.72-11.05-3.03-13.49-5.72      c-0.75-0.721-1.14-2.261-2.03-3.961c-0.159-0.279-0.31-0.55-0.47-0.819c1.59-0.71,3.25-1.47,4.811-2.96      c1.329-1.32,2.369-3.17,3.329-4.09c1.32-1.32,2.881-2.57,3.471-5.051c0.1-0.42,0.14-0.81,0.14-1.189c0-1.03-0.34-1.83-0.56-2.37      c-0.24-0.56-0.34-0.85-0.33-1.09c0-0.061,0-0.101,0-0.12c0.06-0.49,0.45-1.12,1.1-1.93c0.62-0.811,1.46-1.78,1.83-3.21      c0.18-0.73,0.22-1.44,0.22-2.11c0-1.1-0.12-2.13-0.12-2.96c0-0.13,0.011-0.25,0.011-0.34c0.149-2.24,0.689-2.96,1.62-3.601      c0.97-0.64,2.729-1.01,5.05-1.33c0.68-0.1,1.21-0.659,1.28-1.34c0.05-0.56,0.079-1.05,0.079-1.52      c0.021-1.21-0.27-2.33-0.92-3.19c-0.64-0.85-1.399-1.38-2.33-2.12c-0.89-0.689-1.8-1.199-2.369-1.71      c-0.591-0.529-0.761-0.819-0.771-1.33c0-0.069,0-0.109,0-0.12c0.22-1.819,0.84-2.42,1.98-3c1.159-0.539,2.939-0.699,4.76-0.689      c1.149,0,2.32,0.05,3.39,0.05c0.38,0,0.74-0.01,1.08-0.02c0.62-0.03,1.16-0.44,1.36-1.03c0.37-1.33,2.7-4.05,4.06-4.93      c1.311-0.91,3.12-1.2,5.26-1.49c2.12-0.3,4.57-0.63,6.851-2.16c2.32-1.52,3.39-3.41,3.63-5.24c0.26-1.81,0.03-3.399,0.32-5.34      c0.33-2.04,0.659-2.25,1.13-2.54c0.55-0.33,1.99-0.5,4.029-1c2.48-0.66,4.801-2.24,7.061-3.59c1.99-1.22,3.92-2.19,5.35-2.36      c0.271,0.44,0.74,0.74,1.28,0.74c0.04,0,0.09-0.01,0.13-0.01c0.28-0.03,0.53-0.13,0.74-0.28c0.68,0.43,1.35,1.24,2.12,2.78      c0.77,1.64,1.37,3.46,2.41,5.06c0.979,1.59,2.79,2.99,5.229,2.94c0.98,0,2.04-0.19,3.22-0.561      c3.101-1.01,6.511-3.609,8.61-5.609c3.82-3.7,6.63-8.13,9.79-12.25c1.37-1.78,2.521-3.33,3.79-4.38      c1.27-1.04,2.6-1.67,4.72-1.78c0.49-0.021,1.011-0.03,1.561-0.03c3.609,0,8.33,0.431,11.859,0.78      c1.551,0.14,3.641,0.729,5.351,1.64c1.74,0.91,3.02,2.16,3.37,3.3c0.149,0.45,0.21,0.971,0.21,1.551      c0.01,1.14-0.261,2.5-0.271,3.989c-0.05,1.721,0.561,3.9,2.63,5.261c0.931,0.64,1.931,0.989,2.91,0.979      c1.811-0.02,3.101-1.05,4.13-2.02c1.03-1,1.931-2.101,2.771-2.79c1.97-1.681,4.8-3.4,7.05-4.05c0.54-0.16,1.2-0.25,1.95-0.25      c3.29-0.04,7.95,1.819,9.939,3.739c1.511,1.42,3.94,3.181,6.62,4.641c2.69,1.449,5.561,2.63,8.2,2.649      c0.24,0,0.47-0.01,0.68-0.029c0.561-0.04,1.051-0.4,1.271-0.921c0.35-0.92,1.069-1.96,1.37-3.399      c0.21,0.03,0.399,0.06,0.56,0.08c0.15,0.02,0.28,0.04,0.37,0.06c0.04,0,0.07,0.01,0.09,0.01c1.11,0.25,1.891,0.95,3.021,2.551      c1.109,1.55,2.229,3.77,4.3,5.71c1.09,1.02,1.54,1.819,2.109,3.05c0.57,1.2,1.181,2.87,2.461,4.72      c0.729,1.141,1.859,2.021,2.67,2.34c0.8,0.351,0.64,0.261,0.779,0.37c1.551,1.271,2.25,2.811,3.83,5.29      c1.08,1.67,2.3,2.83,3.351,3.7c1.06,0.89,1.92,1.51,2.71,2.33c0.89,0.88,1.76,2.81,2.25,5.06c0.51,2.24,0.72,4.73,0.81,6.69      c0.04,0.9,0.05,1.87,0.05,2.88c0,1.11-0.01,2.28-0.01,3.49c0,3.09,0.08,6.37,0.84,9.58c0.32,1.35,0.79,2.71,1.431,4      c-0.24,0.16-0.471,0.3-0.69,0.43c-0.81,0.46-1.41,0.7-2.3,0.71c-0.2,0-0.44-0.02-0.7-0.06c-1.88-0.2-3.99-1.96-6.91-2.65      c-2.09-0.44-3.7-0.52-4.87-0.87c-1.18-0.37-2.04-0.84-3.229-2.46c-0.74-0.979-0.92-2.6-1.221-4.39      c-0.159-0.891-0.369-1.84-0.89-2.75c-0.5-0.91-1.41-1.74-2.59-2.15c-0.6-0.22-1.2-0.33-1.8-0.33      c-2.13,0.021-3.65,1.33-4.75,2.67c-1.12,1.36-1.971,2.91-2.681,4.021C715.151,527.519,715.331,528.419,716.001,528.879z",
                        "Illintsi": "M703.972,413.509c0.329,1.26-0.11,3.22,0.819,6.09c0.25,0.72,0.78,1.32,1.471,1.67      c1.6,0.81,3.229,0.99,4.63,0.99c2.01-0.02,3.729-0.33,5.029-0.31c0.69,0,1.23,0.07,1.641,0.21c0.55,0.19,0.779,0.39,1.109,0.83      c0.49,0.67,0.92,2.08,1.21,3.81c0.32,1.729,0.521,3.71,1.141,5.689c0.399,1.21,0.93,2.061,1.24,2.681      c0.06,0.12,0.109,0.22,0.149,0.319c-0.31,0.301-0.689,0.66-1.06,1.011c-0.83,0.84-1.58,1.47-2.311,2.67      c-1.39,2.54-3.89,5.68-5.3,9.27c-1.24,3.41-1.21,6.38-2.03,8.521c-0.779,2.25-0.83,4.449-0.84,6.41c0,0.699,0.01,1.38,0.01,2.02      c-0.29,0.21-0.6,0.48-0.92,0.91c-0.33,0.439-0.66,1.17-0.649,1.99c0.02,1.5,0.899,2.359,1.38,2.729      c0.91,0.67,1.55,0.82,2.26,1.04c0.24,0.07,0.47,0.13,0.71,0.18c-0.14,0.521-0.43,1.11-0.78,1.86      c-1.68-0.11-4.109-1.03-6.369-2.27c-2.45-1.341-4.761-3.021-6-4.19c-2.82-2.6-7.73-4.51-11.99-4.56      c-0.971,0-1.91,0.109-2.8,0.369c-2.87,0.86-5.87,2.73-8.141,4.631c-1.13,0.97-2.05,2.1-2.91,2.92      c-0.87,0.84-1.56,1.21-2.05,1.189c-0.29,0-0.649-0.08-1.21-0.46c-1.149-0.84-1.28-1.47-1.33-2.78      c-0.01-1.079,0.26-2.46,0.271-3.989c0-0.78-0.08-1.62-0.36-2.471c-0.77-2.319-2.72-3.899-4.81-5.02      c-2.12-1.12-4.471-1.79-6.471-1.99c-3.55-0.35-8.319-0.79-12.149-0.79c-0.59,0-1.15,0.01-1.69,0.04      c-2.72,0.101-4.859,1.08-6.51,2.47c-1.66,1.391-2.9,3.11-4.25,4.86c-3.25,4.26-6.01,8.55-9.49,11.91      c-1.79,1.75-5.2,4.24-7.43,4.91c-0.96,0.3-1.73,0.42-2.32,0.42c-1.42-0.05-1.939-0.49-2.729-1.59      c-0.74-1.11-1.351-2.851-2.2-4.681c-1.05-2.37-2.59-3.899-4.311-4.58c-0.05-1.949,0.04-3.81-0.55-6.25      c-0.609-2.51-0.76-4.909-1.02-7.689c-0.21-2.08-1.11-4.33-2.351-6.22c-1.199-1.74-2.63-3.33-4.739-3.57      c-0.11-0.021-0.221-0.021-0.341-0.03c-1.02-0.01-2.05,0.48-2.77,1.28c-0.021,0.02-0.03,0.04-0.04,0.05      c-0.05-0.149-0.08-0.29-0.12-0.43c-0.16-0.67-0.18-1.851-0.2-3.08c-0.029-1.24-0.05-2.53-0.54-3.78      c-1.08-2.82-3.64-4.08-5.949-4c-1.86,0-3.681,0.58-5.311,1.271c-2.18,0.92-3.57,1.92-4.63,3.06c-1.06,1.13-1.79,2.25-2.96,3.6      c-1.11,1.341-3.21,2.311-5.23,3.28c-0.319-0.77-0.83-1.399-1.319-1.88c-0.82-0.8-1.67-1.38-2.271-1.99      c-1.39-1.38-2.35-2.46-3.529-3.399c-1.181-0.94-2.561-1.641-4.461-2.15c-3.229-0.89-5.069-2.38-6.27-4.39      c-1.19-2.01-1.68-4.681-1.68-7.84c0-0.08,0-0.16,0-0.25c0.01-0.8-0.61-1.47-1.41-1.52c-0.73-0.04-1.45-0.04-2.13-0.05      c0.17-0.45,0.399-0.96,0.64-1.47c0.55-1.23,1.24-2.36,1.3-3.82c0-0.11-0.01-0.22-0.02-0.33c-0.13-1.23-0.59-2.31-1.431-3      c-0.84-0.69-1.84-0.87-2.699-0.87c-1.63,0.04-3.29,0.55-4.431,0.74c-0.67-2.16-2.35-3.75-3.62-4.96      c-0.609-0.57-1.02-0.91-1.439-1.18c-0.38-0.27-0.97-0.45-1.38-0.43c-0.29,0-0.36,0.02-0.36,0.01c-0.01,0,0,0.01-0.109-0.02      c-0.431-0.12-0.841-0.16-1.181-0.16c-0.6,0.01-1.05,0.08-1.33,0.07c-0.25,0-0.35-0.03-0.43-0.07c-0.21-0.07-0.75-0.58-1.28-1.24      c-0.55-0.64-1.109-1.39-1.93-2c-1.5-1.08-2.5-1.86-3.13-2.73c-0.63-0.88-1.061-1.94-1.271-3.95c-0.1-0.94-0.189-2.18-0.189-3.39      c-0.01-1.42,0.16-2.83,0.439-3.46c0.03-0.09,0.061-0.17,0.07-0.26c1.28-0.32,2.47-0.87,3.42-1.29c3.01-1.38,5.16-2,8.44-2.54      c1.989-0.32,3.529-1.1,4.489-2.34c0.971-1.24,1.24-2.72,1.24-4.13c-0.04-3.31-1.35-6.93-1.32-9.5c0-0.01,0-0.02,0-0.03      c0.931-0.08,1.66-0.25,2.36-0.64c0.99-0.58,1.5-1.23,2.51-2.16c0.811-0.76,1.271-1.21,1.54-1.35c0.25-0.14,0.431-0.22,1.28-0.24      c0.21,0,0.47,0.01,0.771,0.03c0.77,0.04,1.449-0.51,1.569-1.28c0.601-3.44,0.9-4.16,3.37-5.82c1.75-1.12,2.98-1.59,4.16-2.73      c1.18-1.18,1.75-2.77,2.18-5.36c0.21-1.27,0.33-2.22,0.33-3.04c0-0.75-0.09-1.5-0.6-2.19c-0.86-1.05-1.92-1.05-2.7-1.14      c-0.84-0.06-1.75-0.1-2.93-0.35c-1.63-0.37-2.57-1.35-3.67-2.85c-0.881-1.2-1.74-2.7-3.051-4.02c0.41-0.91,0.62-1.86,0.71-2.78      c0.5-0.1,1.011-0.16,1.48-0.15c0.95,0,1.67,0.22,2.14,0.68c0.431,0.4,0.44,0.68,0.79,1.6c0.28,0.94,1.41,2.13,3.061,2.44      c0.779,0.19,1.54,0.28,2.29,0.28c3.31-0.02,6.06-1.65,8.54-3.24c2.47-1.61,4.76-3.22,6.83-3.71c2.529-0.63,4.72-0.63,7.05-1      c2.319-0.35,4.779-1.19,7.2-3.45c1.8-1.66,2.779-3.12,2.8-4.81c-0.03-1.75-1.03-2.86-1.82-3.9c-0.47-0.59-0.93-1.18-1.34-1.82      c0.13-0.01,0.26-0.01,0.39-0.01c1.17,0,2.5,0.13,3.851,0.14c0.989,0,2.01-0.09,3.01-0.42c0.72,0.89,1.689,1.53,2.8,1.99      c0.49,1.9,1.771,3.24,2.79,4.34c1.271,1.29,2.11,2.35,2.08,2.92c0,0.03,0,0.09,0,0.12c0.02,0.64-0.4,1.23-1.26,2.22      c-0.79,0.93-1.98,2.26-1.99,4.3c0,0.48,0.07,0.96,0.2,1.45c0.55,2.16,2,3.67,3.51,4.68c1.53,1.03,3.18,1.66,4.48,2.18      c0.779,0.3,1.609,0.45,2.369,0.68c0.761,0.2,1.341,0.55,1.36,0.62c0.26,0.29,0.39,0.78,0.521,1.57c0.02,0.1,0.039,0.2,0.06,0.31      c-3.96,0.2-7.89,0.14-12.021,1c-0.77,0.16-1.289,0.9-1.18,1.68c0.43,2.81,2.38,5.13,4.48,7.22c2.109,2.06,4.479,3.86,5.96,5.11      c0.63,0.54,1.13,1.13,1.739,1.71c0.591,0.56,1.48,1.22,2.681,1.21c0.64,0,1.27-0.17,1.88-0.46c1.34-0.68,2.21-1.83,3.12-2.95      c0.439-0.58,0.89-1.16,1.28-1.64c0.26,0.43,0.5,1.01,0.75,1.71c0.5,1.31,1.02,3.04,2.63,4.29c1.83,1.41,3.68,1.43,4.529,1.59      c0.45,0.08,0.591,0.16,0.69,0.25s0.31,0.34,0.51,1.13c0.101,0.43,0.15,0.83,0.15,1.21c0.02,2.01-1.42,3.82-3.71,5.37      c-2.261,1.52-5.17,2.62-7.29,3.25c-0.61,0.19-1.03,0.72-1.07,1.35c-0.01,0.16-0.01,0.29-0.01,0.39      c0.05,5.33,3.67,9.41,6.03,12.84c0.619,0.87,1.069,1.71,1.619,2.47c0.5,0.7,1.301,1.64,2.681,1.66      c1.189-0.03,2.06-0.64,3.04-1.5c1.2-1.14,1.97-2.92,3.05-4.53c0.52-0.78,1.06-1.49,1.55-1.92c0.5-0.45,0.86-0.58,1.09-0.58      c0.08,0,0.15,0.01,0.25,0.04c0.011,0.02,0.021,0.06,0.05,0.13c0.04,0.14,0.07,0.38,0.07,0.65c0,0.03,0,0.06,0,0.09      c0,0.83-0.38,2.01-0.49,2.13c-0.29,0.45-0.31,1.01-0.069,1.48c0.25,0.47,0.72,0.78,1.239,0.81c1.16,0.07,2.811,0.26,4.521,0.26      c1.3,0,2.66-0.1,3.93-0.51c1.261-0.4,2.511-1.19,3.23-2.54c0.5-0.96,0.53-1.9,0.53-2.69c0-0.46-0.011-0.9-0.011-1.29      c-0.01-0.57,0.04-1.02,0.15-1.3c0.12-0.29,0.21-0.44,0.57-0.67c0.529-0.32,1.05-0.41,1.79-0.42c0.649,0,1.439,0.1,2.34,0.1      c1.3,0.02,2.97-0.28,4.38-1.58c2.35-2.15,3.6-5.26,3.8-8.29c0.84,0.01,1.65,0.03,2.44,0.11c-0.431,1.54-0.761,3.41-0.761,5.28      c0.011,2.31,0.49,4.82,2.57,6.37c0.54,0.39,1.27,0.38,1.8-0.04c1.9-1.51,3.15-1.96,3.65-1.93c0.439,0.02,0.72,0.14,1.37,1.09      c0.59,0.91,1.22,2.43,1.989,4.21c1.9,4.2,5.2,6.89,6.83,10.03c0.42,0.78,0.58,1.92,0.58,3.27c0,1.23-0.12,2.59-0.12,3.98      c0.011,1.63,0.15,3.36,1.181,4.9c0.859,1.25,2.189,1.83,3.5,2.15c1.33,0.32,2.76,0.39,4.149,0.4c1.5,0,2.96-0.09,4.09-0.11      c0.221,0.66,0.421,1.1,0.391,1.44c0.02,0.77,0.609,1.4,1.38,1.46c1.28,0.11,2.44,0.18,3.63,0.18c1.03,0,2.08-0.05,3.23-0.18      c0.739-0.09,1.3-0.69,1.34-1.42c0.01-0.23,0.01-0.45,0.01-0.66c0-0.36-0.01-0.7-0.02-1.03c0.02,0.04,0.06,0.07,0.079,0.1      C703.691,412.789,703.951,413.319,703.972,413.509z",
                        "Kalynivka": "M479.691,209.188c-0.4,0.31-0.61,0.81-0.57,1.31c0.351,3.15,2.311,6.22,4.17,8.85      c-0.45,0.06-0.92,0.1-1.43,0.1c-0.771,0-1.6-0.05-2.49-0.05c-0.53,0-1.08,0.02-1.649,0.08c-2.73,0.31-5.29,1.28-7.53,2      c-2.82,0.95-5.97,2.63-8.26,2.59c-1.17-0.03-2.011-0.3-2.92-1.29c-0.271-0.31-0.641-0.48-1.051-0.5      c-0.399-0.02-0.79,0.12-1.09,0.4c-1.35,1.27-3.229,2.34-5.1,3.38c-0.61-0.52-1.101-1.11-1.771-1.76      c-0.89-0.88-2.189-1.77-4.1-2.09c-0.89-0.16-1.79-0.2-2.67-0.2c-1.53,0-3.04,0.13-4.28,0.13c-5.12,0-10.25,0-15.38,0      c-1.84,0-4.06-0.2-6.32-0.2c-2.37,0.01-4.82,0.21-7.01,1.25c-1.26,0.61-3.22,2.04-5.07,3.65c-0.92,0.81-1.77,1.64-2.45,2.46      c-0.65,0.85-1.24,1.53-1.31,2.78c0,0.16,0.02,0.32,0.05,0.48c0.1,0.43,0.38,0.8,0.77,1c4.58,2.3,7.71,8.95,10.43,14.06      c0.84,1.51,1.72,4.17,2.97,6.62c0.86,1.65,1.95,3.33,3.51,4.44c-0.39,0.47-0.72,1-1.03,1.55c-0.56,1.04-1,2.16-1.26,3.27      c-0.16-0.01-0.33-0.03-0.49-0.05c-2.5-0.43-5.59-3.04-7.27-5.07l-0.01-0.02c-0.02-0.03-0.05-0.05-0.07-0.07      c-0.06-0.06-0.13-0.12-0.2-0.17c-0.05-0.05-0.13-0.1-0.28-0.16c-0.18-0.07-0.38-0.11-0.58-0.11c-0.4,0-0.78,0.16-1.06,0.44      c-0.28,0.28-0.44,0.66-0.44,1.06c0,0.26,0.07,0.52,0.2,0.74c-0.08,0.1-0.15,0.19-0.24,0.28c-0.13,0.16-0.25,0.31-0.33,0.4      c-0.03,0.04-0.06,0.07-0.07,0.08c-0.17,0.08-0.8,0.22-1.55,0.2c-1.31,0-2.87-0.23-3.98-0.24c0-0.01-0.05-0.01-0.1-0.01      c-0.09,0-0.17,0-0.24,0c-3.67-0.01-5.58-0.01-8.37-1.77c-2.72-1.84-3.12-2.5-3.74-5.64c-0.54-3.55-2.81-5.66-5.38-6.74      c-2.57-1.14-5.52-1.67-8.44-2.75c-3.11-1.13-5.24-1.66-6.65-2.45c-1.4-0.8-2.35-1.76-3.56-4.44c-0.4-0.87-0.31-1.1-0.69-1.96      c-0.2-0.42-0.6-0.83-0.99-1.08c-0.4-0.26-0.82-0.46-1.41-0.72c-0.46-0.17-0.64-0.17-1.02-0.23c-1.02-0.14-2.65-0.26-3.69-0.26      c-0.12,0-0.21,0-0.3,0c-0.24,0-0.43,0-0.89,0.15c-2.26,0.85-3.06,3.02-3.3,4.82c-0.26,1.86-0.16,3.77-0.3,5.09      c-0.05,0.39-0.06,0.79-0.06,1.2c0,1.3,0.13,2.73,0.13,4.01c0.04,1.64-0.3,2.9-0.68,3.18c-0.46,0.43-0.89,0.57-1.61,0.59      c-1.13,0.02-2.83-0.61-4.54-1.38c-1.73-0.76-3.42-1.64-5.17-1.89c-0.41-0.06-0.83,0.06-1.15,0.33      c-0.32,0.26-0.52,0.65-0.54,1.07c-0.13,2.23-0.31,4.49-0.4,6.78c-0.73-0.18-1.25-0.61-1.85-1.36c-1.15-1.48-1.96-4.16-2.97-6.61      c-0.52-1.22-1.11-2.41-1.98-3.4c-0.85-0.98-2.14-1.76-3.67-1.8c-0.07,0-0.16,0-0.21,0c-1.34-0.07-2.45,0.59-3.13,1.4      c-0.53-1.98-1.04-4.46-2.12-6.33c-2-3.19-4.94-4.97-5.9-7.49c-0.31-0.75-1.16-1.12-1.92-0.83c-1.56,0.6-3.15,1.8-4.89,2.83      c-1.7,1.04-3.46,1.83-4.69,1.81c-0.8-0.03-1.37-0.22-2.07-0.96c-0.32-0.37-0.39-0.61-0.4-0.98c-0.08-0.97,1.16-2.84,2.25-4.15      c2.37-3.07,3.48-6.19,5.11-9.43c0.17-0.34,0.2-0.73,0.1-1.09c-0.1-0.34-0.52-1.82-0.83-2.56c-0.15-0.33-0.41-0.6-0.74-0.75      c-0.75-0.35-1.29-1.11-1.7-2.3c-0.4-1.17-0.59-2.63-0.78-3.91c-0.07-0.46-0.35-0.86-0.76-1.08c-1.67-0.93-3.16-1.02-4.03-1.22      c-0.89-0.25-1.09-0.24-1.75-1.27c-0.96-1.58-1.18-4.6-1.56-7.3c1.18-0.12,2.81-0.13,4.39-0.33c1.14-0.17,2.32-0.46,3.37-1.2      c1.06-0.73,1.85-1.99,2.06-3.52c0.03-0.26,0.05-0.5,0.05-0.75c-0.01-0.43-0.07-0.85-0.16-1.25c-0.62-2.83-2.89-5-3.77-6.49      c-0.93-1.48-0.83-1.44-0.85-1.72c0-0.19,0.04-0.58,0.04-1.16c0-0.3-0.01-0.64-0.04-1.05c-0.25-4.22-2.97-7.83-7.49-8.88      c-0.74-0.18-1.46-0.22-2.12-0.22c-0.81,0-1.56,0.06-2.21,0.06c-1.22-0.01-1.97-0.15-2.69-0.82c-0.55-0.59-0.5-0.61-0.54-1.15      c-0.01-0.49,0.16-1.39,0.17-2.6c0-0.03-0.01-0.05-0.01-0.08c0.33,0.02,0.66,0.03,1,0.03c0.47-0.01,0.97-0.02,1.48-0.04      c0.61-0.04,1.13-0.43,1.34-1c0.47-1.32,0.68-2.82,0.68-4.37c-0.02-2.98-0.73-6.13-2.67-8.2c-1.22-1.25-2.42-2.04-3.13-2.74      c-0.71-0.73-0.99-1.12-1.02-2.22c0-0.43,0.06-0.97,0.23-1.65c0.44-1.49,0.96-1.71,2.25-2.32c1.22-0.54,3.16-1.06,4.59-2.97      c1.56-2.13,3.49-5.55,4.24-8.17c0.15-0.53,0.22-1.06,0.22-1.57c-0.01-1.8-0.75-3.25-1.34-4.51c-0.61-1.26-1.06-2.32-1.04-3.07      c0-0.21,0.02-0.38,0.08-0.57c0.22-0.74,0.48-1.04,0.7-1.21c0.22-0.16,0.5-0.25,0.96-0.26c1.2-0.03,3.2,0.88,4.62,1.64      c1.71,0.89,2.4,1.59,3.12,2.55c0.71,0.96,1.4,2.31,2.7,4.1c0.91,1.23,2.42,2.82,4.13,4.24c1.72,1.4,3.51,2.65,5.41,3.01      c0.6,0.11,1.15,0.16,1.67,0.16c1.49,0.03,2.88-0.55,3.58-1.65c0.69-1.06,0.75-2.17,0.76-3.19c0-1.06-0.11-2.09-0.11-2.94      c0-0.6,0.06-1.1,0.17-1.39c0.25-0.7,0.54-0.98,1.02-1.26c0.72-0.42,2.02-0.59,3.5-0.67c1.49-0.12,3.13-0.15,4.7-0.87      c2.96-1.36,4.83-2.97,5.88-5.06c1.05-2.07,1.27-4.33,1.57-7.12c0.37-3.63,2.61-6.35,5.4-9.44c0.44-0.51,1.07-0.97,1.71-1.66      c0.45-0.47,0.89-1.14,1.12-1.95c2.14-0.19,4.24-0.55,6.14-1.47c2.01-0.97,3.72-2.68,4.65-5.18c0.07,0,0.14,0,0.2,0      c0.68,0,1.42,0.07,2.2,0.14c0.49,3.39,1.77,6.19,3.17,9.03c0.62,1.25,1.1,2.11,1.68,2.81c0.54,0.69,1.49,1.24,2.4,1.21      c1.75-0.11,2.66-0.92,4.91-1.49c0.94-0.27,1.75-0.38,2.44-0.38c1.51,0.02,2.43,0.48,3.29,1.3c1.27,1.24,2.18,3.55,2.93,6.11      c0.76,2.56,1.37,5.3,2.54,7.51c2.15,3.9,6.62,8.12,11,9.41c0.93,0.25,1.79,0.38,2.58,0.38c2.25,0.01,3.84-1.04,5.06-1.93      c1.26-0.91,2.28-1.69,3.86-2.05c0.28-0.06,0.56-0.09,0.84-0.09c1.21-0.02,2.66,0.58,4.2,1.39c1.55,0.79,3.15,1.78,4.95,2.26      c0.68,0.17,1.35,0.23,2,0.23c2.15-0.02,4.24-0.57,5.82-0.55c0.72,0,1.29,0.1,1.72,0.31c0.9,0.41,1.76,1.46,2.74,2.79      c0.979,1.29,2.09,2.84,3.979,3.74c1.261,0.57,2.511,0.59,3.65,0.6c0.41,0,0.81-0.01,1.19-0.01c1.17-0.02,2.039,0.14,2.279,0.35      c0.41,0.18,0.79,1.48,0.75,3.1c0,0.77-0.05,1.56-0.05,2.29c0,0.02-0.01,0.04-0.01,0.06c0.01,2.29,0.53,6.93,1.569,11.37      c0.521,2.22,1.16,4.37,1.98,6.14c0.69,1.46,1.43,2.74,2.61,3.55c1.08,5.5,4.359,9.44,5.21,13.91      c0.779,3.72,0.26,7.38,1.779,11.81c0.19,0.56,0.69,0.95,1.29,1c1.42,0.04,3.551,1.85,5.21,4.35c1.681,2.45,2.971,5.44,3.4,7.15      c0.19,0.76,0.95,1.24,1.72,1.1c0.771-0.13,1.311-0.85,1.23-1.62c-0.021-0.19-0.03-0.34-0.03-0.48c0-0.1,0.01-0.18,0.01-0.25      c0.301,0.07,0.82,0.27,1.37,0.6c1.19,0.68,2.63,1.79,3.811,2.76c0.59,0.48,1.12,0.94,1.55,1.29c0.47,0.38,0.66,0.59,1.12,0.85      c1.21,0.62,2.92,1.32,4.34,2.08c0.7,0.38,1.32,0.77,1.72,1.11c0.05,0.05,0.09,0.08,0.13,0.13      C479.731,209.159,479.711,209.168,479.691,209.188z",
                        "Khmilnyk": "M259.401,190.019c0.01,1.97-1.2,4.86-3.04,7.36c-1.83,2.53-4.3,4.68-6.34,5.47      c-1.53,0.63-5.57,1.33-7.66,1.31c-0.23,0-0.44,0-0.6-0.02c-2.43-0.13-4.37-1.59-7.4-1.67c-1.28-0.01-2.69,0.36-4.14,1.21      c-1.06,0.61-1.6,1.38-1.81,1.57c-0.22,0.15,0.01,0.16-0.85,0.22c-0.01,0-0.02,0-0.03,0h-0.01c-1.37,0.09-2.88-1.47-4.73-3.13      c-2.91-2.52-4.48-3.66-8.04-5.14c-2.13-0.88-4.3-2.48-7.08-3.35c-1.83-0.51-2.38-0.28-3.37-0.86c-0.35-0.18-1.27-0.91-2.25-1.59      c-1.02-0.66-2.12-1.4-3.61-1.44c-0.75-0.02-1.63,0.29-2.22,0.93c-0.29,0.3-0.52,0.64-0.7,1.01c-0.89-0.11-1.64-0.15-2.2-0.28      c-0.84-0.21-1.09-0.32-1.51-1.02c-0.16-0.29-0.26-0.74-0.25-1.34c-0.02-1.25,0.43-2.88,0.46-4.49c0-0.01,0-0.03,0-0.06      c0,0,0-0.01,0-0.02c0-0.41-0.17-0.8-0.47-1.09c-0.29-0.28-0.69-0.43-1.1-0.41c-0.07,0-0.13,0.01-0.17,0.01      c-0.76-0.01-1.37-0.33-2.25-0.95c-0.87-0.59-1.92-1.48-3.49-1.85c-0.49-0.12-0.94-0.17-1.37-0.17c-0.94,0-1.69,0.27-2.25,0.48      c-0.57,0.21-0.98,0.38-1.56,0.46c-0.68,0.09-1.36,0.13-2.07,0.13c-1.35,0-2.76-0.13-4.24-0.13c-1.81,0-3.78,0.21-5.71,1.24      c-0.78,0.42-1.33,0.98-1.86,1.41c-0.25,0.22-0.49,0.4-0.66,0.51c-0.08,0.05-0.14,0.08-0.18,0.09v0.01c0,0-0.02,0-0.03,0      c-0.24,0.03-1.14-0.29-2-0.8c-0.88-0.5-1.76-1.11-2.47-1.53c-3.03-1.76-6.09-2.06-9.12-2.06c-1.73,0-3.47,0.09-5.28,0.1      c-0.46-0.29-1-0.45-1.58-0.45c-0.06,0-0.11,0-0.15,0c-1.94,0.02-5.65-0.72-8.45-2.08c-1.4-0.66-2.59-1.47-3.29-2.24      c-0.71-0.78-0.92-1.34-0.93-1.94c0.01-0.39,0.11-0.91,0.52-1.66c0.74-1.3,1.38-1.83,2.01-2.17c0.64-0.33,1.43-0.48,2.53-0.48      c1.9-0.03,4.46,0.56,7.38,0.58c0.7,0,1.41-0.04,2.15-0.14c1.07-0.15,1.97-0.86,2.37-1.87c0.23-0.65,0.78-1.02,2.31-2.21      c0.71-0.58,1.6-1.4,2.26-2.61c0.68-1.2,1.04-2.7,1.03-4.34c0-0.1,0-0.16,0-0.19c-0.05-2.12-0.17-4.96-0.75-7.36      c-0.97-3.76-3.28-6.15-4.89-8.21c-1.66-2.12-2.65-3.67-2.71-6.01c0-0.1,0-0.14,0-0.15c0.01-1.06,0.2-1.49,0.4-1.82      c0.28-0.49,1.04-1.05,2.45-1.85c1.36-0.8,3.26-1.85,4.85-3.86c1.72-2.18,2.87-4.3,3.5-6.56c0.47-1.67,0.67-3.34,0.76-5.15      c0.41-0.24,0.79-0.53,1.14-0.88c0.98-0.93,1.49-2.35,1.45-3.52c-0.1-2.58-1.39-4.17-2.57-5.64c-1.25-1.44-2.55-2.55-3.67-3.27      c-4.82-3.16-6.36-5.64-8.06-11.48c-0.25-0.91-0.61-1.8-0.89-2.66c-0.14-0.42-0.27-0.81-0.34-1.12      c-0.07-0.29-0.08-0.47-0.09-0.48c0.01-0.24,0.03-0.42,0.05-0.52c0.45-0.2,2.01-0.56,4.01-1.28c1.52-0.63,4.91-0.96,8.11-1.96      c1.61-0.52,3.28-1.25,4.71-2.64c1.43-1.36,2.38-3.51,2.34-5.81c0-0.76-0.08-1.54-0.24-2.34c-0.2-1-0.91-1.83-1.86-2.2      c-1.05-0.4-1.94-0.89-2.37-1.24c-0.03-0.02-0.05-0.05-0.08-0.07c0.09-0.12,0.23-0.28,0.43-0.46c0.38-0.4,1.18-0.72,2.64-1.08      c1.4-0.38,3.43-0.79,5.32-2.39c1.01-0.89,1.5-1.83,1.76-2.24c0.02-0.02,0.03-0.04,0.04-0.06c0.06,0,0.11-0.01,0.18-0.01      c0.83-0.02,2.33,0.3,4.03,0.33c0.35,0,0.7-0.02,1.09-0.07c0.83-0.12,2.84-0.34,4.78-0.69c0.99-0.17,1.96-0.37,2.88-0.65      c0.93-0.35,1.76-0.46,2.93-1.71c0.7-0.91,0.77-1.51,0.9-2c0.15-0.72,0.19-1.29,0.26-1.69c0.02-0.13,0.04-0.24,0.06-0.31      c0.52-0.66,1.93-1.57,2.57-1.69c0.48-0.14,1.25-0.22,2.15-0.22c1.82-0.01,4.08,0.31,6.24,0.32c0.04,0,0.08,0,0.14,0      c4.09-0.04,7.02-1.85,9.21-3.19c2.27-1.39,3.81-2.26,5.7-2.25c0.4,0,0.82,0.03,1.3,0.12c2.59,0.46,5.27,2.01,8.52,3.47      c3.38,1.51,6.01,1.8,9.28,2.17c3.29,0.33,6.63,1.66,11.16,1.7c0.33,0,0.65-0.01,0.98-0.02c3.24-0.17,5.76-0.67,8.46-0.67h0.02      h0.04h0.02c2.42,0.02,4.37-0.35,6.04-1.1c1.67-0.76,2.88-1.66,4.56-2.7c1.77-1.12,3-1.9,3.96-2.33c0.97-0.42,1.66-0.6,2.97-0.62      c0.43,0,0.92,0.03,1.49,0.09c0.84,0.08,1.64,0.12,2.43,0.12c3.88-0.02,7.19-0.78,10.22-0.79h0.09c0.27,0,0.87,0.07,1.6,0.14      c0.74,0.07,1.61,0.14,2.42,0.14c0.89-0.05,1.7,0.05,3.08-0.66c1.74-1.13,2.07-2.46,2.42-3.29c0.15-0.44,0.27-0.81,0.37-1.07      c0.04-0.13,0.08-0.24,0.11-0.29c0.01-0.03,0.02-0.04,0.02-0.05c1.63-2.57,3.41-3.4,4.38-3.36c0.55,0.01,1.05,0.16,1.71,0.73      c0.65,0.57,1.41,1.63,2.02,3.34c0.52,1.48,2.09,2.3,3.6,1.89c2.7-0.73,6.15-1.3,9.43-1.3c3.33-0.01,6.44,0.61,8.51,1.9      c2.43,1.36,4.31,4.49,8.79,6.55c0.56,0.24,1.55,0.68,2.66,1.07c0.85,0.29,1.75,0.58,2.76,0.71c0.69,1.28,1.19,3.03,1.49,4.96      c0.46,2.77,0.61,5.75,1.03,8.09c0.48,2.64,0.87,5.28,1.86,7.73c0.98,2.44,2.7,4.69,5.58,6.08c0.45,0.22,0.98,0.2,1.41-0.04      c0.43-0.25,0.71-0.7,0.75-1.19c0-0.02,0.01-0.07,0.18-0.24c0.59-0.63,2.81-1.31,3.91-1.44c0.53-0.08,0.94-0.11,1.28-0.11      c0.74,0.01,1.02,0.11,1.49,0.4c0.46,0.3,1.07,0.91,1.96,1.83c2.39,2.37,5.43,3.69,7.29,5.34c-0.95,1.03-1.43,2.24-1.91,3.09      c-0.17,0.31-0.32,0.58-0.48,0.8c-0.23-0.16-0.51-0.25-0.81-0.25c-1.56,0-3.38-0.35-5.3-0.36c-0.5,0-1,0.03-1.52,0.1      c-0.59,0.08-1.08,0.51-1.24,1.08c-0.67,2.34-1.8,3.48-3.41,4.3c-1.62,0.81-3.83,1.13-6.27,1.26c-0.83,0.05-1.46,0.76-1.41,1.58      c0,0.08,0,0.15,0,0.19c-0.02,0.48-0.11,0.63-0.47,1.06c-0.36,0.41-1.03,0.91-1.73,1.68c-2.78,3.09-5.64,6.38-6.15,11.13      c-0.28,2.8-0.55,4.72-1.26,6.08c-0.7,1.36-1.83,2.45-4.48,3.7c-1.02,0.53-3.08,0.51-5.18,0.73c-1.06,0.12-2.16,0.33-3.2,0.9      c-1.04,0.56-1.96,1.57-2.41,2.91c-0.28,0.81-0.32,1.61-0.33,2.37c0.01,1.07,0.11,2.1,0.11,2.94c0.01,0.81-0.13,1.37-0.25,1.52      c-0.12,0.12-0.15,0.29-1.09,0.32c-0.31,0-0.7-0.03-1.17-0.11c-0.8-0.1-2.51-1.1-4-2.37c-1.51-1.25-2.94-2.77-3.62-3.7      c-1.17-1.6-1.79-2.84-2.7-4.1c-0.91-1.26-2.15-2.42-4.17-3.45c-1.49-0.74-3.65-1.94-5.99-1.97c-0.91,0-1.9,0.22-2.75,0.85      c-0.85,0.63-1.46,1.6-1.79,2.78c-0.14,0.47-0.2,0.95-0.2,1.41c0.02,1.73,0.76,3.11,1.33,4.36c0.61,1.24,1.06,2.34,1.05,3.22      c0,0.26-0.03,0.5-0.1,0.76c-0.54,1.97-2.43,5.42-3.77,7.19c-0.74,1.01-1.84,1.37-3.36,2c-1.46,0.56-3.39,1.78-3.97,4.35      c-0.22,0.86-0.33,1.65-0.33,2.38c-0.04,1.93,0.9,3.43,1.93,4.38c1.04,0.99,2.13,1.69,3.07,2.67c1.07,1.04,1.85,3.67,1.82,6.11      c0.01,0.85-0.08,1.68-0.23,2.4c-0.09,0-0.18,0.01-0.27,0.01c-2.28-0.01-3.68-0.35-5.21-0.97c-1.53-0.63-3.2-1.61-5.68-2.81      c-1.71-0.82-3.28-1.36-4.84-1.37c-1.34-0.01-2.71,0.49-3.67,1.52c-0.98,1.02-1.57,2.41-1.94,4.16c-0.47,2.48-0.1,4.25-0.8,5.68      c-1.02,2.39-3.61,4.7-5.1,7.94c-1.33,2.97-1.49,5.91-1.49,8.75c0,1.06,0.03,2.12,0.03,3.18c0,0.01,0,0.01,0,0.02      C259.401,189.969,259.401,190.009,259.401,190.019z",
                        "Koziatyn": "M510.262,63.589c0.029,0.15,0.039,0.4,0.039,0.71c0.011,0.47-0.039,1.07-0.039,1.8      c0,0.22,0.01,0.46,0.02,0.71c0.11,1.41,1.21,2.57,2.62,2.75c0.68,0.02,2.28,0.98,3.729,2.56c1.471,1.54,2.83,3.49,3.761,4.91      c1.479,2.21,2.77,4.88,2.729,7.02c0,0.43-0.04,0.85-0.14,1.27c-0.931,4.11-3.73,7.35-7.181,11.01      c-2.02,2.17-3.029,4.44-4.06,6.03c-1.06,1.63-1.84,2.54-3.51,3.2c-1.03,0.39-1.771,1.32-1.91,2.41      c-0.03,0.2-0.04,0.42-0.04,0.64c0.12,2.57,1.34,4.1,2.4,5.68c1.1,1.5,2.319,2.86,2.819,3.52c1.19,1.53,2.311,2.55,3.05,3.43      c0.74,0.89,1.181,1.54,1.511,2.77c0.26,1.01,1.02,1.81,2.02,2.12c0.95,0.33,1.29,0.7,1.75,1.65c0.41,0.94,0.641,2.46,0.63,4.14      c0,2.25-0.35,4.71-0.55,6.68c-0.05,0.45-0.07,0.91-0.07,1.38c0,1.26,0.171,2.57,0.561,3.84c-0.64-0.07-1.271,0.27-1.54,0.89      c-1.68,3.89-2.76,8.5-2.76,13.09c0,3.46,0.62,6.91,2.12,9.98c1.479,2.93,5.25,9.38,5.18,13.24c0,0.89-0.18,1.57-0.5,2.07      c-0.44,0.78-1.73,1.28-3.561,1.74c-1.75,0.49-3.96,0.95-5.569,2.82c-1.15,1.38-1.86,2.59-1.88,4c0,1.07,0.489,1.98,1.05,2.68      c0.57,0.71,1.25,1.34,2.01,2.06c2.771,2.65,4.07,4.44,4.05,6.51c0,1.02-0.3,2.26-1.069,3.85c-1.381,0-3.021,0.08-4.601,0.57      c-1.58,0.49-3.229,1.58-3.899,3.53c-0.16,0.45-0.181,0.87-0.19,1.27c0.021,1.22,0.3,2.44,0.3,3.38      c-2.81-0.06-6.399-2.25-10.51-2.36c-0.18,0-0.35,0-0.53,0c-0.45,0-0.88,0-1.29,0c-2.109,0-3.83-0.1-5.47-0.9      c-0.9-0.44-2.33-1.42-3.89-2.31c-1.551-0.86-3.23-1.69-5.11-1.74c-0.29-0.59-0.72-1.05-1.17-1.45      c-1.96-1.64-5.11-2.76-6.61-3.57c-0.239-0.17-0.76-0.62-1.439-1.19c-0.681-0.58-1.521-1.27-2.4-1.93      c-1.82-1.31-3.57-2.66-5.64-2.76c-0.311-0.01-0.66,0.05-1,0.18c-0.681-1.54-1.57-3.18-2.62-4.73c-1.7-2.44-3.74-4.73-6.41-5.45      c-0.97-3.34-0.62-6.58-1.41-10.62c-1.22-5.65-4.67-9.66-5.31-14.47c-0.08-0.53-0.431-0.98-0.931-1.18      c-0.31-0.07-1.14-0.95-1.8-2.46c-2.09-4.47-3.29-13.41-3.27-16.26l0.01-0.02c-0.01-0.58,0.04-1.42,0.04-2.33      c-0.04-1.76-0.05-4.03-2-5.54c-1.34-0.91-2.76-0.89-4.02-0.91c-0.421,0-0.82,0.01-1.19,0.01c-1.05,0.01-1.93-0.09-2.37-0.31      c-1.01-0.46-1.89-1.52-2.86-2.83c-0.979-1.28-2.029-2.81-3.85-3.7c-1-0.47-2.03-0.6-3.01-0.6c-2.141,0.01-4.23,0.57-5.82,0.55      c-0.47,0-0.9-0.04-1.25-0.13c-1.17-0.3-2.68-1.16-4.31-2.02c-1.65-0.85-3.48-1.72-5.59-1.73c-0.49,0-0.99,0.05-1.5,0.16      c-2.28,0.51-3.77,1.7-4.95,2.54c-1.22,0.87-1.99,1.36-3.31,1.37c-0.48,0-1.06-0.08-1.78-0.27c-3.12-0.8-7.54-4.81-9.15-7.94      c-1.21-2.2-1.9-6.12-3.19-9.6c-0.67-1.74-1.5-3.41-2.82-4.73c-1.31-1.32-3.18-2.18-5.4-2.17c-1.01,0-2.08,0.16-3.24,0.48      c-2.31,0.68-3.78,1.39-4.06,1.4c-0.05-0.03-0.18-0.15-0.4-0.47c-0.26-0.38-0.61-1.01-1.04-1.88c-1.1-2.23-2.02-4.25-2.56-6.42      c0.85-0.15,1.6-0.54,2.15-1.04c1.11-1.01,1.59-2.22,2.12-3.19c0.52-1,1.01-1.69,1.62-2.02c0.38-0.21,0.65-0.58,0.74-1      c0.09-0.43,0-0.87-0.27-1.22c-2.5-3.18-6.43-4.44-8.5-6.67c-0.89-0.91-1.58-1.65-2.46-2.24c-0.87-0.59-1.97-0.92-3.14-0.9      c-0.54,0-1.1,0.05-1.72,0.15c-0.97,0.14-2.36,0.45-3.67,1.04c-0.65,0.29-1.29,0.65-1.85,1.17c-0.07,0.07-0.15,0.15-0.22,0.22      c-1.39-0.98-2.22-2.22-2.87-3.78c-0.81-1.96-1.21-4.43-1.69-7.12c-0.37-2.03-0.53-5.07-1.02-8.05      c-0.28-1.65-0.66-3.31-1.29-4.81c0.08-0.04,0.16-0.07,0.24-0.11c0.85-0.43,1.67-1.18,2.11-2.08c0.45-0.89,0.51-1.73,0.52-2.32      c-0.02-0.89-0.12-1.42-0.11-1.71c0-0.17,0.02-0.25,0.03-0.3c0.07-0.2,0.15-0.37,0.56-0.79c0.4-0.41,1.09-0.95,1.86-1.83      c0.93-1.08,1.47-2.19,1.79-3c0.33-0.83,0.49-1.28,0.78-1.76c0.73-1.14,1.27-1.46,2.43-1.82c1.14-0.32,2.9-0.38,5.02-0.39      c2.51-0.03,5.05-0.32,7.18-0.31c0.98,0,1.86,0.05,2.58,0.19c0.71,0.11,1.56,0.61,2.83,1.42c1.23,0.76,3.02,1.85,5.48,1.86      c0.77,0,1.57-0.11,2.37-0.34c2.06-0.61,3.33-1.74,4.3-2.38c1-0.7,1.48-0.88,1.93-0.88c0.12,0,0.24,0.01,0.39,0.04      c0.51,0.09,1.11,0.47,1.82,1.37c0.71,0.88,1.38,2.13,2,3.33c0.54,1.04,1.58,3.42,2.76,5.7c0.6,1.15,1.25,2.29,1.97,3.32      c0.74,1.03,1.47,1.98,2.74,2.76c1.25,0.73,2.56,0.94,3.78,0.94c3.71-0.12,7.04-1.66,9.27-3.88c2.57-2.6,3.1-5.74,3.02-7.82      c0-0.59-0.02-1.12-0.02-1.61c0-0.75,0.03-1.42,0.17-2.13c0.21-0.79,0.26-0.67,0.37-0.78c0.14-0.1,0.73-0.28,1.71-0.27      c0.58,0,1.28,0.05,2.03,0.12c1.34,0.14,2.38,0.77,3.87,1.9c1.47,1.07,3.229,2.67,5.96,3.45c0.64,0.17,1.27,0.25,1.87,0.25      c2.51-0.05,4.31-1.09,5.84-1.8c1.521-0.77,2.74-1.23,3.31-1.19c0.101,0,0.171,0.01,0.25,0.02c0.631,0.09,1.4,0.57,2.521,1.43      c0.55,0.42,1.18,0.91,2,1.35c0.8,0.45,1.88,0.86,3.13,0.86c2.11-0.01,3.98-1.14,5.61-2.83c1.12-1.17,2.359-2.92,3.5-4.98      c1.1-2.09,2.109-4.29,2.16-6.82c-0.011-0.58-0.07-1.17-0.24-1.78c-0.28-0.81-0.65-1.4-1.01-1.84      c0.279-0.05,0.569-0.11,0.88-0.18c3.819-1.02,6.449-1.47,10.359-1.49c0.07,0,0.09,0,0.101,0c1.34,0,2.6,0.07,3.95,0.07      c2.239,0.02,4.829-0.26,7.56-1.64c4.47-2.21,7.16-6.32,8.25-10.78c0.54-2.37,0.3-4.47,0.51-5.52c0.01-0.11,0.03-0.19,0.05-0.27      c0.021,0,0.04,0,0.07,0c0.13,0,0.29,0.01,0.5,0.04c0.3-0.01,1.34,0.48,2.41,1.36c1.1,0.86,2.21,1.95,3.39,2.86      c2.34,1.75,3.21,4.03,5.69,7.35c4.29,5.57,8.109,11.28,8.83,17.54c0.41,3.36,2.35,5.53,3.609,7c0.65,0.74,1.16,1.34,1.431,1.79      c0.27,0.45,0.31,0.65,0.31,0.89c0.01,0.28-0.1,0.96-0.99,2.25c-0.47,0.69-1.449,1.72-2.42,2.96c-0.93,1.25-2.05,2.85-2.09,5.18      c-0.01,1.18,0.37,2.45,1.08,3.5c1.08,1.55,2.37,1.89,2.79,2.14c0.12,0.06,0.2,0.1,0.26,0.13      C510.251,63.509,510.262,63.549,510.262,63.589z",
                        "Kryzhopil": "M533.531,742.238c0.56,0.73,0.88,1.54,0.88,1.96c0,0.011,0,0.04,0,0.101      c-0.01,0.33-0.03,0.57-0.07,0.729c0,0.03-0.01,0.051-0.01,0.07c-0.02,0.01-0.04,0.01-0.069,0.01      c-0.471,0.061-1.62-0.06-2.94,0.48c-1.92,0.84-2.96,2.6-3.35,4.5c-0.221-0.03-0.44-0.04-0.65-0.04      c-1.48-0.04-2.68,0.75-3.32,1.51c-0.68,0.75-1.12,1.42-1.739,1.94c-1.521,1.27-2.4,1.14-5.16,1.39      c-0.94,0.08-1.9,0.12-2.851,0.12c-3.63,0-7.26-0.63-10.39-2.08c-1.2-0.55-1.771-0.73-2.68-1.26      c-0.61-0.351-0.891-0.66-1.471-1.12c-0.56-0.48-1.47-0.94-2.609-1.07c-0.33-0.05-0.66-0.07-0.971-0.07      c-1.699,0.03-2.79,0.49-3.409,0.45c-0.44-0.01-0.79-0.06-1.57-0.649c-1.65-1.271-2.83-2.95-4.37-4.62      c-1.52-1.65-3.55-3.24-6.62-3.771c-0.979-0.18-1.93-0.25-2.85-0.25c-7.11,0.101-11.96,4.261-18.09,4.24      c-3.421,0.05-5.82,1.11-8.45,1.34c-1.82,0.181-2.971,0.08-4.33,0.4c-1.391,0.33-2.59,1.22-3.92,2.77      c-2.181,2.42-3.101,4.141-3.44,7.471c-0.05,0.409-0.1,0.76-0.149,1.06c-0.69-0.44-1.74-0.94-3.04-0.94      c-0.57,0-1.17,0.091-1.79,0.301c-0.641,0.199-1.24,0.54-1.67,1.1c-0.44,0.54-0.591,1.22-0.58,1.76c0.01,0.95,0.3,1.67,0.51,2.36      c0.22,0.67,0.38,1.29,0.37,1.74c0,0.149-0.01,0.279-0.03,0.399c-0.39,1.641-0.76,2-1.2,2.261c-0.46,0.29-1.529,0.46-3.189,0.649      c-1.82,0.25-2.98,0.34-4.141,1.04c-0.569,0.36-1.04,0.97-1.239,1.601c-0.21,0.619-0.25,1.229-0.25,1.89      c0,0.45,0.02,0.93,0.06,1.47c0.01,0.23,0.01,0.44,0.01,0.62c-0.01,1.01-0.13,1.31-0.43,1.94c-0.31,0.619-0.92,1.51-1.68,3      c-0.841,1.71-1.311,2.56-1.69,2.819c-0.34,0.29-1.07,0.54-3.11,0.61c-3.99,0.17-7.25,1.1-10.71,1.34c-0.12,0-0.26,0.01-0.4,0.01      c-1.54,0.021-3.86-0.59-6.07-0.6c-0.75,0-1.51,0.07-2.26,0.32c-1.27,0.38-2.17,1.369-2.47,2.189c-0.33,0.82-0.41,1.29-0.69,1.71      c-1.5,2.36-2.74,3.96-4.69,4.41c-0.38,0.09-0.8,0.12-1.25,0.13c-2.06,0.03-4.65-1.04-7.45-1.08c-0.69,0-1.41,0.08-2.12,0.29      c-0.5,0.15-0.96,0.36-1.37,0.63c-0.06-0.069-0.11-0.14-0.16-0.189c-0.73-0.73-1.41-1.05-1.8-1.42      c-0.39-0.37-0.54-0.521-0.59-1.21c-0.01-0.07-0.01-0.101-0.01-0.15c0.02-0.49,0.06-0.479,0.1-0.58c0-0.06,0.44-0.52,0.46-1.39      c-0.03-0.851-0.34-1.38-0.83-2.24c-0.75-1.28-1.93-2.51-3.57-2.86c0-0.05,0-0.1,0-0.149c-0.01-1.36-0.23-2.53-0.27-3.67      c-0.03-0.78-0.64-1.4-1.42-1.44c-2.95-0.13-5.99-1.52-9.22-2.62c-3.27-1.06-6.35-0.8-8.68-1.609c-0.87-0.28-1.35-0.58-1.52-0.75      c-0.08-0.08-0.1-0.12-0.1-0.12c-0.01-0.011-0.01-0.021-0.01-0.03c0-0.19,0.46-1.06,1.2-1.98c0.76-1.039,1.74-2.18,2.1-3.779      c0.11-0.55,0.15-1.09,0.15-1.641c-0.02-2.369-0.74-4.75-0.79-6.409c-0.02-0.301-0.02-0.591-0.02-0.891      c0-1.359,0.11-2.819,0.11-4.34c0-0.7-0.02-1.41-0.1-2.13c-0.1-0.89-0.14-1.7-0.14-2.47c0-2.391,0.41-4.5,0.97-7.37      c0.02-0.01,0.04-0.01,0.06-0.021c0.51-0.149,0.9-0.56,1.03-1.08c0.15-0.63,0.24-1.239,0.24-1.83c0-0.729-0.14-1.409-0.37-2.029      c0.96-1.09,2.18-2.09,3.61-2.65c0.84-0.34,1.6-0.32,2.72-0.53c1.12-0.17,2.52-1,3.3-2.56c1.36-2.56,1-5.1,1.16-6.98      c0.21-1.939,0.37-2.939,2.55-4.119c0.55-0.28,0.88-0.851,0.83-1.471c-0.22-1.91-1.2-3.31-1.74-4.43      c1.46-1.24,4.04-2.55,5.38-5.01c1.6-3.25,1.92-8.011,2.41-11.15c0.46-3.13,0.4-5.479,1.32-7.939c0.27-0.74,0.48-1.091,0.74-1.69      c0.26-0.59,0.47-1.33,0.6-2.4c0.03-0.33,0.05-0.619,0.05-0.89c-0.01-0.77-0.1-1.29-0.09-1.63c0.01-0.32,0.03-0.55,0.25-1.061      c0.48-1.069,1.24-1.56,2.51-2.069c1.25-0.49,2.85-0.8,4.42-1.62c2.53-1.44,4.2-4.021,5.63-4.54c0.27-0.12,0.64-0.2,1.11-0.2      c1.73-0.03,4.57,1.18,6.77,2.96c2.26,1.75,3.78,4.08,3.74,5.51c0.01,0.65,0.45,1.221,1.08,1.41c0.04,0.011,0.08,0.021,0.11,0.03      c1.01,0.5,1.88,0.41,2.7,0.44c0.16,0,0.34,0,0.51,0c0.75-0.021,1.35,0.09,1.35,0.119c1.2,0.53,2.41,2.83,3.78,4.7      c0.7,0.891,1.81,2.03,3.09,3.04c1.3,1,2.69,1.92,4.32,2.12c0.19,0.021,0.37,0.03,0.56,0.03c2,0,3.42-1.17,4.4-2.24      c0.989-1.1,1.79-2.24,2.51-2.82c2.39-2.02,4.939-3.12,7.43-5.989c1.021-1.16,1.76-1.561,2.811-1.92      c1.04-0.351,2.439-0.57,4.27-1.141c3.11-0.979,4.95-2.59,7.23-3.77c1.31-0.69,2.21-0.67,3.35-0.87      c0.54-0.09,1.35-0.32,1.92-1.061c0.55-0.739,0.66-1.55,0.67-2.46c0-0.42-0.029-0.88-0.08-1.41      c-0.35-2.979-1.529-5.72-1.689-8.06c0.99-0.2,1.85-0.71,2.38-1.45c0.71-0.99,0.85-2.09,0.86-3.06      c-0.011-0.94-0.15-1.83-0.29-2.57c-0.261-1.35-0.391-2.72-0.49-4.17c2.55,0.26,5.45,1.23,8.67,1.29      c2.78,0.02,5.55,0.33,8.55,0.33c0.03,0,0.061,0,0.09,0c3.3-0.03,6.03,1.56,9.471,1.63c1.46,0.01,3.01-0.38,4.52-1.35      c0.32,0.62,0.66,1.399,0.99,2.17c0.67,1.46,1.17,2.939,2.55,3.97c0.63,0.43,1.37,0.67,2.07,0.67c1.59-0.05,2.55-0.93,3.409-1.54      c0.86-0.66,1.601-1.18,2.271-1.3c0.53-0.11,0.96-0.5,1.12-1c0.52,0.46,0.51,0.74,0.609,1.229c0.101,0.771-0.18,2.29,0.511,4.2      c0.7,1.91,2.01,3.07,3.04,4.09c1.069,1.03,1.87,1.891,2.27,3.15c0.561,1.75,1.03,3.31,1.75,4.93c0.49,1.07,1.19,1.91,1.73,2.681      c0.5,0.689,0.83,1.3,0.92,1.71c-0.05,0.13-0.2,0.449-0.38,0.819c-0.21,0.471-0.49,1.08-0.5,1.91      c-0.011,0.521,0.149,1.141,0.51,1.65c1.01,1.399,2.52,1.479,3.57,1.5c0.939-0.01,1.819-0.12,2.25-0.12      c2.579,0,5.29-0.12,7.819-0.12c1.2,0,2.36,0.03,3.45,0.1c1.07,0.101,1.12,0.2,1.48,0.46c0.359,0.28,0.979,1,2.17,1.721      c2.02,1.09,3.939,1.02,4.77,1.77c2,1.561,2.83,3.11,2.84,4.69c0,0.55-0.1,1.12-0.33,1.75c-0.529,1.47-1.819,3.479-2.85,4.97      c-0.41,0.6-0.66,1.061-0.82,1.36c-0.02,0.029-0.04,0.069-0.05,0.1c-0.24,0.04-0.71,0.12-1.36,0.22      c-0.329,0.051-0.739,0.08-1.199,0.08c-1.601,0.011-3.73-0.33-5.79-0.34c-1.79,0.01-3.74,0.23-5.2,1.72      c-1.15,1.28-1.48,2.99-1.521,4.671c0.011,1.05,0.15,2.079,0.69,3.029c0.65,1.09,1.61,1.42,2.08,1.681      c0.54,0.279,0.63,0.35,0.74,0.579c0.01,0.03,0.06,0.211,0.06,0.471c0,0.62-0.22,1.56-0.37,2.35c-0.63,3.811-3.05,6.61-3.1,11.87      c0,0,0,0,0,0.05c0,0.01,0,0.03,0.01,0.05c0,2.15,0,4.28,0.35,6.49c0.49,2.811,1.82,4.72,2.04,6.61      c0.101,0.71,0.69,1.25,1.41,1.29c0.311,0.01,0.62,0.02,0.92,0.02c2.19-0.01,4.4-0.319,6.34-0.319c1.591,0,2.94,0.21,3.95,0.79      C532.211,740.829,532.981,741.499,533.531,742.238z",
                        "Lityn": "M248.681,309.799l0.04-0.14c0.05-0.23,0.09-0.5,0.09-0.77c-0.02-1.28-0.61-2.3-1.31-3.27      c-2.16-2.84-6.03-5.42-7.51-6.28c-3.52-1.97-7.96-2.56-11.61-2.94c-2.21-0.22-4.48-0.26-6.75-0.26c-1.44,0-2.87,0.02-4.29,0.02      c-3.91,0-7.71-0.13-11.06-0.99c-2-0.49-4.16-1.61-6.79-1.64c-1.13,0-2.35,0.25-3.53,0.87c-2.57,1.38-4.97,4.06-6.81,5.71      c-3.19,2.97-8.13,5.31-11.19,9.45c-0.44,0.59-0.84,1.22-1.19,1.89c-0.87-0.54-1.81-0.87-2.67-1.07      c-1.64-0.38-3.23-0.42-4.69-0.43c0.16-2.35,0.11-4.21,0.73-5.77c0.27-0.75,0.59-1.45,0.92-2.39c0.32-0.93,0.58-2.09,0.58-3.41      c-0.01-0.13-0.01-0.23-0.01-0.29c0-0.29-0.01-0.48-0.01-0.62c0-0.36,0.01-0.58,0.01-0.87c0-0.28,0.02-0.78-0.25-1.5      c-0.2-0.53-0.55-0.98-0.78-1.21c-0.67-0.65-0.77-0.64-1.6-1.45c-1.53-1.47-2.83-4.03-2.77-5.81c0-0.21,0.01-0.39,0.03-0.55      c-0.01-0.04,0.09-0.32,0.55-1.1c0.43-0.74,1.14-2.06,1.14-3.8c0-0.33-0.03-0.64-0.07-0.93c-0.22-1.52-0.95-2.5-1.32-3.04      c-0.2-0.28-0.33-0.47-0.4-0.58c-0.02-0.04-0.04-0.07-0.04-0.08c-0.15-0.57-0.21-1.16-0.21-1.8c-0.11-3.19,2.05-7.41,2.16-12.54      c0-0.8-0.06-1.62-0.22-2.46c-0.44-2.54-2.1-4.3-3.39-5.24c-1.31-0.99-2.28-1.58-2.96-2.4c-0.79-0.91-1.36-2.22-1.88-3.91      c-0.54-1.67-1.02-3.67-2.02-5.72c-0.69-1.35-1.51-2.09-2.05-2.73c-0.21-0.23-0.38-0.44-0.49-0.59c0.42-0.25,0.94-0.59,1.46-1.06      c1.63-1.42,2.64-3.33,2.82-4.99c0.21-1.64,0.06-2.73,0.21-4.19c0.19-1.88,0.9-3.45,2.03-5.26c1.12-1.8,2.65-3.74,4.03-6.15      c0.76-1.45,2.28-3.84,2.36-6.99c0.03-1.51-0.57-3.45-2.08-4.74c-1-0.82-1.82-0.97-2.55-1.13c-0.74-0.13-1.42-0.16-2.07-0.17      c-0.98,0.01-1.84,0.08-2.48,0.18c-1.15,0.17-2.02,0.39-2.58,0.54c-0.27,0.08-0.47,0.12-0.56,0.14c-0.02,0-0.04-0.01-0.07-0.02      c-0.12-0.05-0.33-0.15-0.63-0.31c-0.2-0.09-0.74-0.57-1.41-1.33c-0.7-0.73-1.51-1.79-3.18-2.51c-0.83-0.35-1.61-0.41-2.22-0.41      c-1.02,0.01-1.68,0.14-1.98,0.12c-0.01,0-0.02,0-0.04,0c-0.13-0.18-0.41-0.61-0.75-1.2c-0.5-0.76-1.2-2.02-2.93-2.81      c-0.77-0.33-1.46-0.39-2.02-0.39c-0.79,0.03-1.46,0.12-1.97,0.21c0.29-0.51,0.78-1.19,1.33-1.8c0.85-0.96,1.8-1.84,2.41-2.41      c0.96-0.91,2.1-1.81,3.16-3.11c1.07-1.27,1.99-3.18,1.96-5.35c0-0.3-0.01-0.6-0.04-0.9c1.32-0.03,2.57-0.08,3.75-0.08      c2.86,0,5.23,0.28,7.61,1.65c0.53,0.31,1.47,0.96,2.49,1.55c1.05,0.57,2.14,1.15,3.49,1.19c0.14,0,0.27-0.01,0.4-0.03      c1.18-0.19,1.78-0.8,2.4-1.28c0.58-0.5,1.13-0.97,1.33-1.06c1.34-0.71,2.71-0.89,4.31-0.89c1.3,0,2.71,0.13,4.24,0.13      c0.8,0,1.63-0.04,2.48-0.16c0.97-0.14,1.7-0.44,2.21-0.63c0.52-0.19,0.8-0.28,1.19-0.28c0.19,0,0.4,0.02,0.69,0.09      c0.74,0.16,1.48,0.69,2.44,1.38c0.68,0.48,1.53,1.04,2.6,1.32c-0.13,0.93-0.33,2.07-0.34,3.24c0,0.88,0.12,1.84,0.6,2.75      c0.8,1.58,2.31,2.33,3.55,2.55c1.27,0.25,2.42,0.25,3.48,0.5c0.39,0.09,0.8,0.02,1.14-0.19c0.34-0.22,0.58-0.56,0.66-0.95      c0.14-0.63,0.32-0.9,0.38-0.94c0.05-0.03,0-0.02,0.07-0.02c0.2-0.04,1.09,0.32,1.92,0.92c0.87,0.59,1.67,1.28,2.48,1.74      c1.84,0.98,2.98,0.75,3.96,1.1c2.14,0.64,4.23,2.15,6.79,3.24c3.39,1.44,4.31,2.15,7.25,4.65c1.56,1.26,3.35,3.73,6.6,3.86      c0.02,0,0.03,0,0.05,0h0.09c0.05,0,0.1,0,0.14,0c1.22,0.01,2.29-0.5,2.81-1.09c0.55-0.57,0.64-0.78,1.2-1.11      c1.08-0.63,1.87-0.8,2.63-0.8c1.74-0.08,3.81,1.33,7.15,1.66c0.27,0.03,0.56,0.03,0.85,0.03c2.64-0.02,6.56-0.67,8.76-1.52      c2.86-1.15,5.56-3.63,7.66-6.5c2.05-2.84,3.54-6.02,3.62-9.02c0-0.02,0-0.05,0-0.07c0-0.03,0-0.06,0-0.09      c0-1.13-0.03-2.22-0.03-3.26c0-2.74,0.17-5.17,1.23-7.52c1.05-2.48,3.63-4.76,5.1-7.94c1.08-2.55,0.6-4.66,1-6.29      c0.29-1.42,0.74-2.28,1.16-2.7c0.43-0.42,0.8-0.58,1.51-0.6c0.82,0,2.05,0.34,3.53,1.06c2.37,1.16,4.03,2.14,5.85,2.89      c0.74,0.31,1.51,0.56,2.34,0.76c0.01,0.16,0.02,0.33,0.02,0.49c0,0.89-0.16,1.64-0.17,2.6c-0.05,1.04,0.4,2.39,1.49,3.34      c1.48,1.41,3.31,1.64,4.74,1.63c0.81,0,1.55-0.06,2.21-0.06c0.54,0,1.01,0.04,1.4,0.14c3.34,0.86,4.93,3.01,5.22,6.18      c0.02,0.32,0.03,0.59,0.03,0.83c0,0.44-0.04,0.73-0.04,1.16c-0.02,0.99,0.39,1.95,1.33,3.35c1.2,1.72,2.94,3.84,3.36,5.38      c0.07,0.26,0.11,0.51,0.09,0.73c0,0.1-0.01,0.21-0.02,0.32c-0.15,0.86-0.42,1.19-0.83,1.51c-0.63,0.48-1.96,0.73-3.5,0.8      c-1.53,0.11-3.18,0.06-4.72,0.58c-0.7,0.25-1.11,0.97-0.97,1.7c0.54,2.56,0.44,6.63,2.13,9.68c0.92,1.75,2.51,2.51,3.72,2.71      c0.97,0.2,1.74,0.28,2.57,0.61c0.16,1.09,0.37,2.37,0.79,3.63c0.46,1.37,1.25,2.83,2.69,3.74c0.12,0.35,0.26,0.82,0.37,1.19      c-1.56,3.22-2.6,5.93-4.53,8.4c-1.02,1.38-2.81,3.35-2.88,5.99c-0.01,1.01,0.37,2.13,1.18,3c1.18,1.34,2.79,1.96,4.29,1.94      c2.31-0.03,4.38-1.15,6.24-2.24c1.19-0.73,2.33-1.48,3.22-2c1.7,2.77,4.22,4.42,5.37,6.46c1.04,1.64,1.51,5.45,2.64,8.1      c0.09,0.2,0.22,0.36,0.38,0.49c-1.04,1.79-3.08,2.64-5.13,4.92c-1.94,2.34-2.41,5.14-3.67,6.77c-0.92,1.39-3.16,2.02-5.01,3.95      c-1.57,1.82-2.78,4.81-2.82,7.75c0,1.16,0.21,2.34,0.82,3.39c0.46,0.81,1.19,1.51,2.12,1.95c0.15,0.82,0.22,1.51,0.22,2.09      c-0.03,1.65-0.44,2.39-1.38,3.35c-0.96,0.94-2.58,1.9-4.64,3.22c-4.64,2.97-7.62,5.9-11.22,9.83c-2.04,2.27-5.2,3.63-8.27,5.79      c-1.07,0.78-2.05,2.02-3.1,3.15c-0.51,0.55-1.01,1.06-1.43,1.4c-0.21,0.17-0.4,0.3-0.53,0.38c-0.14,0.08-0.19,0.08-0.19,0.09      c-0.06,0.01-0.12,0.01-0.18,0.01c-0.53,0.08-1.63-0.72-2.81-2.05c-1.21-1.25-2.37-2.86-4.35-3.53c-0.65-0.2-1.28-0.28-1.89-0.28      c-0.34,0.01-0.67,0.03-0.99,0.08c-2.63,0.34-4.74,1.71-6.32,1.85c-0.49,0.07-0.92,0.37-1.15,0.82c-0.22,0.44-0.21,0.97,0.04,1.4      c0.7,1.25,1.63,2.6,2.37,3.85c0.74,1.22,1.21,2.42,1.17,2.86c-0.04,0.28,0.03,0.15-0.16,0.31c-0.21,0.15-0.92,0.38-2.2,0.38      c-0.04,0-0.07,0-0.09,0c-4.51,0.01-9.04-1-14.01-1.27c0.16-0.06,0.33-0.13,0.52-0.19c0.46-0.15,0.82-0.51,0.97-0.96      C248.631,309.958,248.661,309.869,248.681,309.799z",
                        "Lypovets": "M551.501,346.779c1.88,0.41,3.32,0.36,3.86,0.47c0.01,0.07,0.01,0.17,0.01,0.28      c0.01,0.49-0.09,1.34-0.29,2.54c-0.42,2.45-0.83,3.23-1.34,3.74c-0.52,0.55-1.69,1.1-3.64,2.31c-2.7,1.61-3.971,3.71-4.54,6.62      c-0.9,0.04-1.721,0.23-2.4,0.66c-0.78,0.48-1.28,1.03-2.03,1.73c-1.1,1.04-1.619,1.58-1.93,1.73c-0.28,0.16-0.76,0.3-2.3,0.33      c-0.7,0.01-1.3,0.52-1.44,1.21c-0.109,0.58-0.16,1.16-0.16,1.75c0.04,3.37,1.351,7,1.32,9.5c-0.01,1.06-0.21,1.78-0.6,2.28      c-0.391,0.49-1.08,0.97-2.61,1.23c-3.439,0.56-6.01,1.3-9.21,2.77c-1.26,0.6-3.12,1.31-3.979,1.28      c-0.16,0-0.261-0.02-0.311-0.03h-0.02c-0.63-0.55-1.57-0.48-2.12,0.14c-0.13,0.16-0.23,0.33-0.29,0.52      c-1.37,0.11-2.7,0.52-3.96,0.93c-1.431,0.48-2.78,0.96-3.5,1.05c-1.91,0.26-3.9,0.36-5.891,0.36c-0.54,0-1.08-0.01-1.619-0.02      c0.02-0.19,0.029-0.38,0.029-0.57c-0.029-2.53-1.56-4.38-3.02-5.86c-1.49-1.48-3.101-2.75-3.74-3.68      c-0.74-1.02-1-2.02-1.01-3.12c-0.03-2.57,1.76-5.71,3.35-8.29c2.07-3.45,4.58-6.59,4.94-11.31c0.04-0.49,0.06-0.92,0.06-1.32      c-0.01-1.02-0.109-1.86-0.49-2.64c-0.6-1.25-1.909-1.72-2.83-1.84c-0.979-0.16-1.979-0.19-3.199-0.44      c-2.63-0.5-7.601-2.52-9.75-4.09c-1.23-0.88-1.79-1.71-2.7-2.68c-0.89-0.98-2.28-1.92-4.351-2.17      c-0.369-0.05-0.729-0.07-1.09-0.07c-1.29,0.01-2.479,0.22-3.41,0.22c-0.399,0-0.75-0.04-1.029-0.11c-0.9-0.18-1.57-1-2.7-2.05      c-0.72-4.77-0.69-9.22-4.65-13.46c-0.59-0.63-1.159-1.02-1.409-1.21c0.039-0.26,0.18-0.79,0.47-1.59      c0.29-0.84,0.97-1.8,1.67-2.91c0.689-1.1,1.439-2.44,1.439-4.14c0-0.36-0.029-0.72-0.1-1.07c-0.1-0.55-0.49-1-1.03-1.16      c-4.26-1.33-7.479-1.88-11.979-2.11c-0.851-0.04-1.69-0.05-2.521-0.05c-1.189,0-2.35,0.02-3.489,0.02      c-2.931,0-5.66-0.17-8.19-1.21c-2.93-1.19-5.73-1.38-8.32-1.75c-2.6-0.37-4.97-0.87-7.399-2.47c-2.811-1.82-5.62-5.08-5.55-8.04      c0-0.67,0.119-1.35,0.409-2.06c0.311-0.74-0.029-1.59-0.76-1.93c-2.54-1.16-3.98-1.97-4.83-2.88c-0.85-0.9-1.38-2.1-1.95-4.56      c-0.94-3.94-3.42-6.07-4.82-8.65c-0.88-1.57-0.91-2.55-1.58-4.71c-0.32-1.06-0.72-1.81-1.24-2.35c-0.5-0.52-0.84-0.74-1.47-1.46      c-1.74-1.99-2.4-3.91-2.52-6.5c0.8,0.07,1.77,0.15,2.71,0.16c1.09-0.03,2.18-0.06,3.25-0.73c0.56-0.4,0.74-0.73,0.99-1.02      c1.92,1.82,4.42,3.64,7.28,4.09c0.39,0.07,0.78,0.1,1.18,0.11c0.4,0,0.81-0.03,1.21-0.1c0.65-0.11,1.15-0.64,1.23-1.3      c0.12-1.01,0.55-2.36,1.14-3.43c0.57-1.09,1.37-1.84,1.73-1.94c0.63-0.23,1.029-0.85,0.979-1.52      c-0.04-0.66-0.53-1.22-1.189-1.36c-1.521-0.28-2.83-1.79-3.96-3.99c-1.13-2.17-1.96-4.74-3-6.67      c-2.54-4.59-5.35-11.19-10.55-14.61c0.53-0.7,1.58-1.83,2.71-2.76c1.57-1.35,3.41-2.62,4.08-2.93c1.49-0.72,3.52-0.95,5.71-0.95      c2.08,0,4.28,0.2,6.32,0.2c5.13,0,10.25,0,15.38,0c1.43,0,2.92-0.13,4.28-0.13c0.78,0,1.51,0.04,2.13,0.15      c1.36,0.27,1.86,0.66,2.56,1.31c0.69,0.64,1.48,1.67,2.88,2.62c0.471,0.33,1.091,0.35,1.58,0.07c1.721-0.98,3.71-2.01,5.48-3.39      c1.25,0.93,2.7,1.31,4.07,1.3c3.479-0.05,6.77-1.99,9.18-2.73c2.32-0.76,4.71-1.63,6.95-1.88c0.41-0.04,0.85-0.06,1.31-0.06      c0.771,0,1.61,0.05,2.49,0.05c0.979,0,2.03-0.06,3.12-0.37c0.069-0.02,0.14-0.05,0.21-0.08c0.17,0.25,0.33,0.49,0.49,0.72      c2.159,3.09,4.93,4.74,5.85,6.89c0.56,1.07,0.45,2.49,1.48,4.28c1.569,2.39,3.8,3.4,4.56,4.96c0.8,1.32,0.42,2.94,1.4,5.3      c0.42,0.9,0.8,1.56,1.279,2.1c0.46,0.53,1.19,0.99,2,0.98c1.11-0.04,1.681-0.59,2.16-0.95c0.48-0.4,0.9-0.77,1.32-1.01      c1.819-1.07,3.67-1.32,5.85-1.4c2.16-0.08,4.58,0.07,7.26-0.41c1.86-0.37,2.971-0.85,3.671-0.81c0.39,0.01,0.739,0.07,1.34,0.38      c0.83,0.34,1.77,2.14,3.62,3.44c3.13,2.01,7.27,2.77,10.67,3c0.199,0.01,0.399,0.01,0.609,0.01c0.92,0,2.03-0.07,3.12-0.07      c1.061-0.01,2.11,0.08,2.76,0.3c0.69,0.24,0.771,0.4,0.841,0.61c0.01,0.06,0.02,0.14,0.02,0.22c0.01,0.06,0.01,0.13,0,0.21      c-0.12,0.72-1.07,2.11-2.44,3.23c-1.47,1.28-3.31,2.37-4.14,2.69c-3.3,1.31-6.28,4.35-6.28,8.66c0,0.64,0.061,1.3,0.2,1.97      c0.36,1.8,1.38,3.04,2.28,3.96c0.92,0.93,1.72,1.64,2.17,2.45c0.39,0.7,0.44,1.03,0.43,1.12c0.011,0.1-0.04,0.23-0.34,0.83      c-0.28,0.56-0.63,1.46-0.64,2.62c-0.01,0.05-0.01,0.09-0.01,0.12c-0.011,1.34,0.46,2.5,1.159,3.31      c1.051,1.21,2.301,1.73,3.19,2.34c0.91,0.63,1.44,1.12,1.729,2.22c0.131,0.54,0.561,0.97,1.11,1.1c2.33,0.52,3.61,1.1,5.39,1.12      c1.381,0,2.75-0.43,4.57-1.34c1.98-1.01,3.84-2.39,5.561-3.59c0.159,0.17,0.35,0.31,0.58,0.4c2.939,1.06,4.859,2.09,7.189,2.13      c1.94,0.01,3.76-0.88,5.771-2.63c1.42-1.21,2.409-2.44,3.229-3.72c0.66,0.41,1.33,0.79,2.05,1.08c0.57,1.96,1.61,3.39,2.58,4.62      c1.12,1.42,2.15,2.63,2.851,4.35c0.869,2.14,2.26,3.64,3.39,4.97c1.16,1.34,2.03,2.49,2.37,3.9c0.26,1.06,0.31,1.76,0.5,2.64      c0.18,0.88,0.55,1.85,1.31,2.93c0.61,0.88,1.271,1.52,1.681,2.02c0.439,0.52,0.51,0.77,0.5,0.87c0,0.04,0,0.06,0,0.06      c-0.021,0.29-0.32,0.75-0.931,1.53c-0.58,0.76-1.37,1.9-1.43,3.5c-0.01,0.15-0.01,0.31-0.01,0.44c0,0.49,0.05,0.96,0.13,1.42      c-0.48,0.12-1.101,0.18-1.8,0.18c-1.141,0-2.471-0.14-3.851-0.14c-1,0-2.04,0.07-3.069,0.39c-0.391,0.12-0.721,0.39-0.9,0.76      c-0.18,0.36-0.21,0.79-0.07,1.17c0.69,1.96,1.82,3.34,2.641,4.37c0.85,1.05,1.21,1.71,1.18,2.04c0.02,0.31-0.24,1.14-1.84,2.61      c-2.021,1.83-3.641,2.36-5.641,2.69s-4.38,0.33-7.3,1.04c-2.899,0.74-5.34,2.58-7.74,4.11c-2.399,1.56-4.67,2.77-6.909,2.76      c-0.521-0.01-1.04-0.06-1.58-0.19c-1.061-0.36-0.75-0.28-0.99-0.64c-0.17-0.39-0.39-1.62-1.5-2.67      c-1.23-1.16-2.81-1.51-4.21-1.51c-1.21,0.01-2.36,0.25-3.36,0.55c-0.63,0.19-1.06,0.77-1.06,1.43c0.01,1.21-0.29,2.6-0.891,3.42      c-0.46,0.66-0.319,1.56,0.311,2.05c1.28,0.97,2.229,2.58,3.42,4.26C547.211,344.398,548.821,346.199,551.501,346.779z",
                        "Mohyliv-Podilskyi": "M219.481,732.479c-0.37-0.14-1.19-0.77-2.03-1.43c-0.92-0.65-1.86-1.47-3.39-1.521      c-0.12,0-0.19,0-0.23,0.011c-0.59,0.05-1.1,0.449-1.29,1.02c-0.53,1.62-1.42,3.82-2.35,5.18c-3.7-1.83-7.69-3.09-10.67-3.42      c-1.05-0.1-2.08-0.13-3.08-0.13c-2.43,0-4.7,0.181-6.8,0.181c-0.96,0-1.88-0.04-2.77-0.131c-3.21-0.34-7.44-1.689-10.99-2.83      c-2.73-0.859-4.87-2.77-6.94-5.39c-2.07-2.6-3.93-5.81-6.16-8.78c-3.09-4.1-5.78-8.779-7.38-13.6c-0.95-2.82-1.61-5.9-2.94-8.94      c-1.3-3.029-3.51-6.069-7.23-7.979c-5.45-2.84-11.15-5.54-16.51-8.33c-1.62-0.83-3.93-2.31-6.37-3.64      c-2.48-1.301-5.06-2.561-7.93-2.771c-0.11-0.01-0.25-0.01-0.42-0.01c-1.75,0-3.15,0.63-4.2,1.21c-1.05,0.6-1.85,1.19-2.43,1.5      c-2.57,1.42-4.67,2.25-7.47,2.66c-1.68,0.229-3.32,0.359-4.9,0.359c-3.47,0-6.66-0.609-9.8-2.17c-4.19-2.04-9.3-3.84-11.98-6.12      c-0.74-0.63-1.05-1.149-1.29-1.84c-0.24-0.699-0.34-1.62-0.34-2.77c0-1.16,0.1-2.53,0.1-4.04c0-1-0.05-2.08-0.23-3.2      c-0.31-1.9-0.87-3.51-2.01-4.82c-1.12-1.33-2.92-2-4.4-1.96c-2.84,0.08-4.94,1.42-7.03,2.71c-2.05,1.32-3.99,2.78-5.33,3.561      c-1.12,0.649-2.32,0.95-3.52,0.96c-2.18-0.01-4.39-1.03-6.03-3.22c-1.76-2.311-3.55-7.131-5.18-10.721      c-1.86-3.88-1.77-10.029-1.99-15.5c-0.29-5.02,0.51-10.899-1.78-16.89c1.46-0.66,3.13-1.16,4.8-1.75      c0.28,0.89,0.41,1.88,0.65,2.87c0.19,0.72,0.44,1.52,1.11,2.22c0.66,0.69,1.66,1.05,2.69,1.05c0.02,0,0.05,0,0.07,0      c0.76,0,1.57-0.14,2.52-0.399c3.41-0.931,5.57-1.141,9.28-1.53c3.58-0.39,8.09-2.03,12.1-4.47c3.97-2.45,7.49-5.65,8.61-9.63      c0.4-1.46,0.34-2.44,0.43-2.78c0.08-0.29,0.06-0.45,1.11-1.41c0.6-0.54,1.76-1.05,3.01-1.69c1.22-0.649,2.66-1.55,3.4-3.27      c0.57-1.38,0.71-2.86,0.72-4.37c-0.01-2.67-0.47-5.49-0.46-7.72c0-0.7,0.05-1.34,0.15-1.87c0.16-0.94,0.16-2.03,0.22-3.1      c0.03-1.04,0.2-2.07,0.3-2.21c0.25-0.551,0.83-0.94,1.9-1.301c1.04-0.35,2.36-0.56,3.63-1.01c1.8-0.67,3.45-1.13,4.93-1.13      c1.24,0.01,2.38,0.29,3.65,1.11c1.12,0.72,2.07,2.1,3.21,3.63c1.14,1.489,2.56,3.18,4.92,3.92c0.8,0.26,1.58,0.33,2.28,0.33      c1.28-0.011,2.32-0.23,3.15-0.221c0.8,0.021,1.37,0.12,2.16,0.66c0.97,0.7,1.26,1.48,1.64,2.811      c0.36,1.279,0.69,3.029,2.03,4.68c1.85,2.24,4.68,3.74,6.92,4.57c0.41,0.149,0.85,0.12,1.22-0.09      c0.38-0.2,0.65-0.551,0.75-0.971c0.59-2.569,1.33-6.979,2.42-8.46c0.88-1.17,1.19-1.16,1.9-1.22c0.85-0.03,2.29,0.51,4.18,0.55      c0.04,0.01,0.08,0.01,0.11,0.01c2.28,0.021,3.83-1.159,4.85-2.08c1.07-0.96,1.75-1.569,2.66-1.71c0.04-0.01,0.09-0.02,0.13-0.02      c0.45-0.04,1.62,0.47,2.92,1.18c1.33,0.67,2.87,1.5,4.7,1.61c1.23,0.06,3.69,0.36,5.93,0.37c1.58-0.03,3.03-0.08,4.33-0.82      c1.86-1.12,2.58-2.97,2.89-4.54c0.32-1.59,0.38-3.1,0.69-4.08c0.48-1.88,3.23-4.2,5.4-4.939c0.14-0.051,0.28-0.09,0.41-0.13      c0.27,0.29,0.66,0.479,1.09,0.479c0.4,0,0.75-0.16,1.02-0.41c0.12,0.07,0.24,0.16,0.38,0.26c0.52,0.4,1.17,1.11,2,2.011      c2.49,2.66,5.05,5.029,5.83,7.72c0.56,1.66,0.02,4.28,0.67,6.96c0.43,1.6,1.28,2.96,2.07,4.07c-0.14,0.529-0.21,1.08-0.21,1.609      c0.06,3.49,2.24,7.2,3.93,10.351c0.74,1.359,1,2.56,1.01,3.75c0.06,3.26-2.34,6.81-3.79,11.31c-1.76,5.95-0.52,10.82-3.28,15.38      c-0.69,1.311-2.5,2.91-2.59,5.54c0,0.73,0.19,1.521,0.59,2.25c0.81,1.23,1.69,1.311,2.34,1.7c0.32,0.16,0.6,0.311,0.75,0.43      c0.07,0.061,0.11,0.101,0.13,0.12c0.04,0.12,0.05,0.21,0.05,0.3c0.07,0.32-0.44,1.03-0.98,2.4c-0.54,1.6-1.45,3.36-1.49,5.33      c0,0.84,0.23,1.79,0.85,2.56c0.62,0.78,1.52,1.301,2.61,1.641c0.59,0.18,1.19,0.25,1.78,0.25c1.23-0.01,2.46-0.29,3.53-0.71      c0.07,0.95,0.2,1.95,0.47,2.93c0.43,1.57,1.26,3.22,2.98,4.11c1.01,0.479,2.04,0.54,3.12,0.609c0.28,2.44,1.48,4.04,1.48,5.41      c0.01,0.24,0.08,0.45,0.18,0.65c-0.15,1.75-0.31,3.59-0.31,5.46c0,1.979,0.17,3.99,0.77,5.939c1.07,3.41,2.7,5.851,3.59,8.54      c-0.82,0.181-1.68,0.311-2.48,0.49c-0.64,0.16-1.27,0.33-1.9,0.76c-0.64,0.4-1.21,1.32-1.17,2.221c0.02,1.09,0.48,2,1.23,3.149      c0.64,0.96,1.22,1.55,1.59,2.021c0.38,0.479,0.59,0.79,0.81,1.54c0.39,1.13,0.04,2.91,0.8,5.04c0.59,1.58,1.68,2.76,2.99,3.43      c1.31,0.68,2.77,0.91,4.26,0.91c3.5-0.021,7.47-1.271,10.56-2.25c-0.74,1.319-1.34,2.819-1.37,4.569c0,0.19,0.01,0.4,0.03,0.631      c0.18,1.899,1.37,3.119,2.22,3.909c0.43,0.4,0.81,0.721,1,0.94c0.06,0.07,0.1,0.12,0.13,0.16c0.02,0.21,0.09,0.399,0.19,0.57      c-0.06,0.43-0.08,0.85-0.09,1.26c0.01,1.399,0.23,2.81,0.23,3.649c0,0.091-0.01,0.16-0.01,0.221c-0.06,1.27-0.59,2.18-1.35,3.43      c-0.72,1.22-1.64,2.8-1.67,4.97c0,0.03,0,0.05,0,0.07c0.02,1.59,0.64,3.22,1.19,4.9c0.56,1.63,1.05,3.289,1.03,4.079      c0,0.261-0.04,0.391-0.04,0.391C219.531,732.398,219.501,732.438,219.481,732.479z",
                        "Murovani Kurylivtsi": "M162.831,514.729c-1.58,2.33-1.85,5.87-1.89,9.771c0.01,5.979,0.96,12.479,1.6,14.79      c0.55,2,1.16,3.8,2.94,5.649c1.03,1.05,2.26,1.641,3.25,2.26c1.02,0.601,1.69,1.181,1.88,1.681c0.28,0.62,0.44,1.779,0.43,3.13      c0.01,2.26-0.36,4.97-0.54,7.3c-0.37,0.09-0.74,0.2-1.13,0.34c-2.92,1.11-6.17,3.54-7.25,6.891c-0.44,1.54-0.48,3.08-0.75,4.33      c-0.28,1.27-0.64,2.05-1.51,2.59c-0.2,0.17-1.41,0.399-2.77,0.37c-1.99,0.01-4.35-0.28-5.78-0.36      c-0.92-0.03-2.17-0.59-3.47-1.28c-1.31-0.649-2.62-1.46-4.3-1.51c-0.21,0-0.42,0.02-0.64,0.06c-2.01,0.341-3.19,1.61-4.13,2.42      c-0.96,0.82-1.57,1.28-2.78,1.33c-0.03-0.01-0.07-0.01-0.1-0.01c-1.26,0.03-2.57-0.51-4.28-0.55c-1.48-0.05-3.22,0.75-4.37,2.52      c-1.39,2.101-1.99,5.301-2.48,7.73c-1.53-0.76-3.13-1.83-4.04-2.97c-0.8-0.99-1.07-2.141-1.46-3.59c-0.38-1.4-1-3.2-2.8-4.461      c-1.31-0.939-2.72-1.22-3.89-1.199c-1.25,0-2.27,0.22-3.15,0.21c-0.49,0-0.93-0.05-1.39-0.19c-1.37-0.43-2.34-1.46-3.42-2.87      c-1.06-1.39-2.12-3.109-3.95-4.33c-1.73-1.14-3.56-1.609-5.3-1.6c-2.09,0.01-4.05,0.61-5.96,1.31      c-0.86,0.32-2.19,0.551-3.54,0.98c-1.32,0.43-2.86,1.18-3.67,2.85c-0.48,1.09-0.51,2.2-0.59,3.36c-0.05,1.11-0.08,2.24-0.17,2.7      c-0.15,0.779-0.2,1.59-0.2,2.42c0.01,2.58,0.46,5.39,0.46,7.72c0,1.311-0.15,2.43-0.48,3.2c-0.28,0.68-0.95,1.22-2.04,1.78      c-1.06,0.58-2.41,1.08-3.59,2.09c-1.23,1.05-1.9,2.069-2.08,3.109c-0.16,0.99-0.07,1.471-0.37,2.551      c-0.7,2.699-3.63,5.649-7.29,7.859c-3.62,2.23-7.91,3.75-10.84,4.04c-3.67,0.391-6.13,0.63-9.76,1.62      c-0.78,0.22-1.36,0.3-1.73,0.3c-0.54-0.02-0.55-0.1-0.61-0.14c-0.11-0.06-0.37-0.72-0.55-1.79c-0.21-1.05-0.45-2.44-1.2-3.84      c-0.37-0.67-1.18-0.97-1.89-0.68c-1.86,0.77-4.14,1.34-6.34,2.34c-2.1-4.17-4.63-8.09-7.26-11.811      c-4.16-5.83-9.43-10.109-13.7-14.51c-1.56-1.61-2.55-3.14-3.2-5.17c-0.18-0.59-0.26-1.14-0.26-1.73      c-0.01-1.43,0.52-3.159,1.26-5.189c0.72-2.021,1.63-4.32,1.8-7.05c0.11-1.48,0.34-2.011,0.74-2.721      c0.4-0.699,1.22-1.64,2.3-3.12c1.84-2.569,4.12-6.159,5.13-9.949c0.27-1.051,0.42-2.051,0.42-3.011      c0.01-1.96-0.67-3.67-1.44-4.939c-0.77-1.3-1.57-2.32-2.31-3.57c-0.89-1.53-1.07-2.28-1.09-3.319      c-0.01-0.79,0.17-1.86,0.57-3.381c0.38-1.47,0.6-3.13,0.95-4.619c0.29-1.48,0.85-2.7,1.02-2.801      c0.35-0.399,0.84-0.58,2.24-0.979c0.67-0.21,1.54-0.48,2.47-1.07c0.92-0.59,1.83-1.57,2.38-2.76c0.88-1.98,0.95-3.92,1.05-5.75      c0.06-1.8,0.06-3.53,0.21-4.42c0.37-2.41,0.48-4.811,0.48-7.17c0-4.721-0.45-9.32-0.45-13.61c0-3.18,0.35-7,0.35-10.939      c-0.01-3.351-0.25-6.841-1.34-10.15c0.97-0.34,1.77-0.7,2.5-0.771c0.63-0.09,1.32-0.119,2.04-0.119c1.41,0,2.95,0.119,4.44,0.14      c0.56,0.01,1.13,0.02,1.7,0.02c1.71-0.02,3.43-0.06,5.01-0.79c1.62-0.689,2.81-2.52,2.74-4.729c-0.01-0.61-0.07-1.25-0.19-1.94      c-0.22-1.09-0.74-1.83-1.07-2.43c-0.36-0.6-0.51-1-0.5-1.26c0-0.16,0.03-0.33,0.2-0.63c0-0.021,0.13-0.17,0.38-0.351      c0.76-0.56,2.53-1.09,3.22-1.06c0.11,0,0.15,0.01,0.16,0.01c1.34,0.311,2.37,2.18,3.49,4.54c0.58,1.14,1.19,2.34,2.13,3.36      c0.92,1.029,2.31,1.85,3.98,1.87c0.64,0.01,1.21-0.37,1.44-0.96c0.59-1.601,2.35-2.75,3.89-2.73c0.28,0,0.54,0.03,0.79,0.1      c1.84,0.5,2.45,1.131,3.08,2.091c0.61,0.96,1.05,2.42,1.91,4.079c1.49,2.771,4.08,4.19,6.42,5.49c2.38,1.29,4.56,2.5,5.76,4.271      c1.44,2.05,1.96,4.91,2.52,7.97c0.57,3.04,1.19,6.31,3.4,8.97c1.14,1.36,2.11,2.271,3.36,2.78c1.25,0.49,2.44,0.54,4.09,0.66      c3.27,0.29,4.05,0.899,6.89,3.24c2.58,2.17,5.27,4.729,7.06,7.409c0.04,0.011,0.39,1.011,0.81,1.921      c0.22,0.47,0.49,0.96,0.92,1.43c0.41,0.46,1.12,0.93,2,0.92c0.85,0,1.56-0.39,2.17-0.92c0.62-0.61,0.67-1.061,0.81-1.54      c0.28-1.17,0.32-2.72,0.34-4c0.95,0.32,1.76,0.66,3.07,0.71c0.82,0,1.69-0.2,2.68-0.6c0.85-0.351,1.39-0.881,1.61-1.07      c0.1-0.08,0.12-0.09,0.12-0.09l0.01,0.01c0.08,0,0.28,0.01,0.62,0.11c0.35,0.069,0.93,0.46,1.62,1.01      c0.7,0.54,1.5,1.229,2.62,1.64c1.23,0.45,2.68,0.74,4.16,0.74c1.8,0,3.77-0.44,5.15-2c1.35-1.55,1.59-3.32,1.64-4.7      c0.06-1.42,0.04-2.55,0.44-3.49c0.51-1.189,1.46-1.699,2.5-1.72c0.72,0,1.45,0.28,2.03,0.88c1.15,1.04,1.35,4.23,2.06,6.74      c0.92,2.88,2.44,6.09,5.66,7.82c2.98,1.52,4.85,1.569,6.61,3.43c0.96,0.97,1.34,1.54,2.17,2.15c0.84,0.579,1.72,0.84,3.29,1.26      c1.23,0.3,2.22,0.38,2.5,0.54c0.04,0.02,0.06,0.029,0.08,0.04c0,0.01-0.01,0.02-0.01,0.029c0,0.021,0,0.051-0.01,0.08      C163.391,514.049,163.071,514.379,162.831,514.729z",
                        "Nemyriv": "M468.591,341.519c0.07,0.04,0.141,0.11,0.21,0.16c0.15,0.57,0.601,0.97,1.16,1.08      c0.851,0.86,1.851,1.84,3.551,2.33c0.619,0.16,1.22,0.2,1.789,0.21c1.301-0.01,2.49-0.22,3.41-0.22c0.25,0,0.48,0.02,0.681,0.04      c1.52,0.25,1.89,0.59,2.59,1.27c0.67,0.69,1.5,1.89,3.12,3.05c2.79,1.96,7.689,3.93,10.91,4.6c1.939,0.36,3.39,0.38,3.779,0.56      c0.2,0.1,0.09,0.03,0.16,0.11c0.05,0.1,0.17,0.51,0.17,1.3c0,0.31-0.02,0.68-0.05,1.09c-0.26,3.67-2.28,6.31-4.521,9.99      c-1.55,2.6-3.739,6.02-3.779,9.84c0,1.63,0.46,3.34,1.569,4.87c1.11,1.5,2.75,2.72,4.061,4.05c1.33,1.33,2.16,2.6,2.14,3.74      c0,0.41-0.09,0.85-0.319,1.38c-0.21,0.46-0.181,0.98,0.09,1.4c0.25,0.43,0.71,0.69,1.2,0.72c1.189,0.05,2.399,0.09,3.619,0.09      c2.101,0,4.21-0.11,6.29-0.39c1.301-0.18,2.65-0.72,4.051-1.17c1.369-0.47,2.76-0.84,3.67-0.83c0.239,0,0.43,0.02,0.58,0.06      c-0.141,0.91-0.19,1.86-0.2,2.82c0,1.36,0.1,2.68,0.21,3.7c0.229,2.3,0.81,4.03,1.819,5.41c1.021,1.37,2.301,2.3,3.811,3.39      c0.28,0.19,0.82,0.82,1.39,1.51c0.601,0.69,1.221,1.47,2.23,1.99c0.64,0.32,1.27,0.39,1.77,0.38c0.59,0,1.04-0.07,1.33-0.07      c0.16,0,0.271,0.02,0.34,0.04c0.36,0.11,0.7,0.15,0.95,0.14c0.08,0,0.15,0,0.2,0c0.15,0.1,0.47,0.36,0.95,0.8      c1.479,1.32,2.95,3.12,2.93,4.37c0.04,0.72,0.59,1.32,1.311,1.41c0.22,0.03,0.43,0.04,0.64,0.04c1.96-0.04,3.99-0.83,5.2-0.79      c0.489,0,0.699,0.1,0.79,0.17c0.08,0.07,0.26,0.25,0.359,1.01v0.01c0.05,0.15-0.41,1.35-1.01,2.54      c-0.57,1.25-1.26,2.59-1.29,4.17c0,0,0,0.12,0.021,0.24c0.1,0.71,0.68,1.25,1.39,1.29c0.87,0.05,1.71,0.05,2.51,0.06      c0.11,3,0.68,5.79,2.08,8.17c1.57,2.71,4.26,4.75,8.07,5.771c1.62,0.45,2.49,0.91,3.38,1.609c0.89,0.69,1.83,1.721,3.26,3.16      c0.87,0.851,1.75,1.46,2.3,2.01c0.561,0.58,0.721,0.881,0.73,1.37c0,0.11-0.01,0.25-0.04,0.42c-0.11,0.58,0.13,1.16,0.61,1.5      c0.479,0.33,1.109,0.36,1.619,0.07c1.971-1.189,5.641-2.26,8.011-4.939c1.29-1.511,2.04-2.65,2.859-3.5      c0.811-0.851,1.71-1.54,3.62-2.36c1.42-0.61,2.94-1.04,4.141-1.03c1.529,0.07,2.39,0.4,3.18,2.141      c0.2,0.449,0.3,1.529,0.31,2.699c0.03,1.19,0.011,2.471,0.28,3.7c0.33,1.39,0.91,2.96,1.43,4.061      c0.271,0.56,0.851,0.899,1.471,0.85c0.609-0.04,1.14-0.46,1.319-1.05c0.351-1.12,0.75-1.8,1.05-2.11      c0.32-0.32,0.421-0.31,0.58-0.33c0.021,0,0.04-0.01,0.061-0.01c0.41,0,1.609,0.81,2.52,2.27c0.99,1.471,1.74,3.45,1.87,4.851      c0.26,2.7,0.4,5.27,1.09,8.109c0.45,1.83,0.41,3.33,0.45,5.19c-2.34,0.28-4.479,1.53-6.56,2.76c-2.3,1.4-4.55,2.83-6.261,3.25      c-1.789,0.49-3.189,0.53-4.659,1.25c-1.561,0.771-2.44,2.46-2.73,4.79c-0.31,2.351-0.1,4.12-0.3,5.3      c-0.23,1.16-0.5,1.9-2.36,3.21c-1.56,1.061-3.45,1.381-5.569,1.671c-2.101,0.3-4.431,0.55-6.54,1.989      c-1.69,1.21-3.7,3.301-4.79,5.45c0,0-0.011,0-0.021,0c-0.97,0-2.149-0.05-3.39-0.05c-1.96,0-4.09,0.11-6,0.96      c-1.92,0.81-3.53,2.72-3.72,5.41c-0.021,0.149-0.021,0.31-0.021,0.439c-0.02,1.63,0.92,2.86,1.811,3.61      c0.909,0.76,1.859,1.29,2.47,1.79c0.97,0.75,1.56,1.229,1.78,1.55c0.21,0.311,0.319,0.51,0.329,1.4c0,0.029,0,0.05,0,0.08      c-1.859,0.3-3.55,0.67-5.02,1.58c-1.82,1.109-2.92,3.21-3,5.96c-0.01,0.159-0.021,0.34-0.021,0.51      c0.011,1.07,0.12,2.09,0.12,2.96c0,0.54-0.04,1.01-0.13,1.38c-0.13,0.58-0.63,1.271-1.29,2.1c-0.63,0.83-1.46,1.811-1.689,3.301      c-0.03,0.189-0.04,0.399-0.04,0.59c0,0.99,0.35,1.729,0.56,2.24c0.22,0.529,0.33,0.85,0.33,1.22c0,0.14-0.02,0.3-0.06,0.5      c-0.351,1.46-1.13,2.1-2.66,3.609c-1.37,1.391-2.44,3.261-3.3,4.061c-1.24,1.21-2.75,1.84-4.58,2.66      c-0.04-0.03-0.07-0.07-0.101-0.101c-1.029-0.949-2.479-1.489-4.13-1.47c-0.439,0-0.89,0.03-1.38,0.09      c-3.49,0.53-5.41,2.21-7.729,2.13c-0.511,0-1.061-0.069-1.69-0.229c-1.49-0.32-3.05-1.74-5.6-2.24      c-0.44-0.08-0.86-0.1-1.261-0.1c-1.729,0.01-3.18,0.449-4.21,0.449c-0.02-0.01-0.06-0.01-0.1,0c-1.95-0.01-3.29-0.67-4.83-1.699      c-1.53-1.021-3.15-2.431-5.37-3.521c-0.38-0.18-0.71-0.21-0.979-0.21c-0.45,0.01-0.82,0.08-1.061,0.13      c-0.189-0.31-0.439-0.95-1.17-1.62c-0.31-0.239-0.729-0.85-1.35-1.54c-0.61-0.67-1.681-1.46-3.09-1.449      c-0.131,0.01-0.29,0.01-0.49,0.029c-1.32,0.181-2.141,0.94-2.94,1.561c-0.76,0.63-1.5,1.21-1.81,1.3      c-1.07,0.5-2.73,0.05-4.94,0.73c-2.069,0.72-3.16,2.189-3.93,3.1c-0.851,0.979-1.101,1.24-1.89,1.27      c-0.33,0-0.801-0.069-1.44-0.29c-1.95-0.659-3.5-1.359-4.47-2.239c-0.96-0.891-1.511-1.88-1.62-3.79      c-0.16-3.261-0.87-7.45-3.67-10.33c-0.84-0.87-1.851-1.19-2.471-1.34c-0.659-0.17-0.939-0.23-1.39-0.561      c-0.1-0.04-0.61-0.68-1.03-1.359c-0.449-0.71-0.89-1.471-1.3-2.051c-2.39-3.399-3.58-5.189-7.07-7.76      c-4.329-3.18-8.76-7.16-8.67-11.72c0-0.15,0-0.28,0.011-0.391c0.06-1.109,0.149-2.069,0.149-3.05c0.05-1.84-0.51-3.83-2.31-5.68      c-2.101-2.26-4.62-4.44-6.7-6.49c-0.3-0.3-0.71-0.45-1.13-0.43c-0.42,0.02-0.811,0.22-1.08,0.55c-0.8,0.99-1.43,2.311-2.16,3.48      c-0.689,1.18-1.54,2.01-1.78,2.02c-0.04,0.01-0.189,0.04-0.409,0.04c-1.641,0.06-5.74-1.69-6.99-2.5      c-0.93-0.56-2.26-1.71-3.7-2.75c-1.47-1.01-3.09-2.03-5.07-2.06c-1.65-0.03-3.29,0.92-4.44,2.64c-0.33-0.03-0.68-0.06-1.07-0.08      c-0.26-1.16-0.37-2.34-0.37-3.55c0-1.28,0.12-2.58,0.33-3.9c0.06-0.439-0.07-0.88-0.36-1.22c-0.29-0.33-0.72-0.521-1.16-0.51      c-0.29-0.261-0.99-1.87-1.27-3.62c-0.34-1.74-0.5-3.68-0.52-4.9c0.04-0.01,0.06-0.02,0.08-0.02c0.59-0.13,1.05-0.62,1.14-1.221      c0.07-0.42,0.1-0.84,0.1-1.25c-0.01-2.42-1.05-4.46-1.93-6.34c-0.91-1.88-1.66-3.6-1.65-5.189c0.01-0.811,0.18-1.62,0.65-2.55      c0.43-0.87,1.35-1.671,2.43-2.521c1.06-0.87,2.31-1.76,3.03-3.32c1.15-2.88,0.48-5.89,1.31-7.5c0.07-0.239,1.21-1.689,2.25-3.05      c1.03-1.479,2.16-2.81,2.26-4.67c0.01-0.27-0.03-0.57-0.14-0.88c-0.42-1.12-1.24-1.72-2.06-2.27      c-1.24-0.801-2.74-1.44-3.99-2.13c-1.26-0.65-2.15-1.42-2.26-1.79c-0.18-0.41-0.23-0.71-0.23-0.96      c0.01-0.47,0.19-0.89,0.71-1.48c0.77-0.87,2.22-1.79,3.58-2.92c1.2-1.01,2.48-2.38,2.72-4.32c1.3-0.71,2.24-2.03,2.26-3.66      c0-0.71-0.19-1.43-0.58-2.1c-0.81-1.38-2.27-1.7-3.15-1.76c-0.92-0.05-1.63-0.11-1.63-0.16c-2.12-1.11-2.38-1.92-2.36-2.2      c-0.02-0.28,0.24-0.88,0.99-1.57c0.73-0.69,1.81-1.39,2.93-1.99c0.41-0.22,0.69-0.62,0.77-1.08c0.07-0.42,0.11-0.85,0.11-1.27      c-0.01-0.31-0.03-0.62-0.08-0.91c-0.13-1-0.43-1.89-0.81-2.72c0.24-0.09,0.46-0.2,0.68-0.33c0.77-0.4,1.28-1.49,1.21-2.15      c-0.03-0.89-0.22-1.32-0.2-1.78c0-0.35,0.05-0.7,0.38-1.27c0.44-0.66,0.51-0.6,0.85-0.64c0.4-0.03,1.28,0.31,2.2,0.88      c0.94,0.55,1.91,1.26,2.91,1.77c2.33,1.18,4.29,1.86,6.431,1.86c1.399,0,2.81-0.28,4.399-0.79c0.59-0.21,4.24-1.52,6.07-1.6      c-0.28,0.47-0.29,1.05-0.021,1.52c0.271,0.47,0.771,0.76,1.311,0.76c0.109,0,0.24,0,0.39,0c5.07-0.01,10.78-1.33,14.49-5.16      c3.59-3.79,7.96-6.64,10.939-11.58c0.41-0.71,1.53-1.93,2.631-3.12c1.109-1.23,2.21-2.38,2.77-3.75      c0.51-1.37,0.59-2.94,0.61-4.55c-0.011-2.11-0.2-4.3-0.2-5.67c0-0.04,0-0.07,0-0.11c0-1.82,0.38-3.93,0.39-6.07      c0-0.45-0.02-0.9-0.06-1.35c-0.34-2.62-1.42-4.04-1.351-5.61c0-0.13,0-0.27,0.021-0.41c0.04-0.57,0.27-1.85,0.63-2.95      c0.17-0.55,0.38-1.06,0.58-1.42c0.1-0.18,0.189-0.31,0.26-0.39c0.04-0.04,0.061-0.07,0.07-0.08c0.17-0.09,0.3-0.15,0.39-0.19      C467.551,340.619,467.981,341.059,468.591,341.519z",
                        "Orativ": "M719.321,387.579c-1.18-0.47-2.64-1.19-4.66-1.23c-0.09,0.01-0.189,0-0.41,0.03      c-0.8,0.1-1.52,0.51-2.01,1.14c-0.49,0.64-0.7,1.44-0.59,2.23c0.01,0.13,0.02,0.24,0.02,0.36c0.021,0.8-0.47,1.64-1.77,3.09      c-1.19,1.4-3.101,3.1-3.851,6.09c-0.149,0.64-0.159,1.14-0.17,1.66c0.011,1.22,0.141,2.5,0.17,3.68      c-0.489-0.55-1.13-1.05-1.949-1.39c-0.931-0.38-1.99-0.27-2.82,0.3c-0.83,0.56-1.33,1.5-1.32,2.51      c0.011,0.96,0.271,1.8,0.59,2.5c-0.47,0.97-0.56,1.99-0.55,2.81c0,0.3,0.011,0.58,0.011,0.85c-0.53,0.04-1.04,0.05-1.561,0.05      c-0.72,0-1.45-0.03-2.229-0.08c-0.21-0.79-0.511-1.33-0.54-1.73c-0.11-0.7-0.7-1.22-1.4-1.26c-0.26-0.01-0.52-0.02-0.8-0.02      c-1.34,0-2.95,0.12-4.521,0.12c-1.27,0-2.51-0.08-3.449-0.31c-0.95-0.23-1.5-0.59-1.721-0.93c-0.47-0.67-0.67-1.78-0.66-3.21      c0-1.2,0.12-2.58,0.12-3.98c-0.01-1.54-0.14-3.17-0.93-4.68c-2.09-3.82-5.28-6.45-6.73-9.83c-0.77-1.73-1.39-3.31-2.22-4.62      c-0.77-1.27-2.08-2.49-3.89-2.47c-1.42,0.03-2.78,0.63-4.391,1.75c-0.399-0.74-0.64-1.84-0.63-3.15      c-0.01-2.14,0.601-4.61,1.13-5.95c0.171-0.42,0.141-0.88-0.069-1.27s-0.59-0.67-1.021-0.75c-1.6-0.33-3.18-0.41-4.75-0.41      c-0.5,0-1.01,0-1.51,0.02c-0.41,0.01-0.79,0.19-1.06,0.49c-0.28,0.3-0.42,0.69-0.391,1.1c0.01,0.19,0.021,0.39,0.021,0.59      c0.01,2.49-1.05,5.26-2.84,6.85c-0.801,0.69-1.391,0.79-2.37,0.81c-0.66,0-1.44-0.09-2.34-0.1c-1,0-2.2,0.15-3.351,0.85      c-0.92,0.54-1.54,1.39-1.83,2.22c-0.3,0.84-0.33,1.62-0.33,2.32c0,0.47,0.021,0.91,0.021,1.29c0,0.66-0.08,1.1-0.19,1.29      c-0.26,0.48-0.7,0.82-1.5,1.08c-0.8,0.26-1.88,0.37-3.01,0.37c-0.79,0-1.6-0.05-2.38-0.11c0.09-0.44,0.149-0.9,0.16-1.4      c0.02-0.08,0.02-0.17,0.02-0.26c0-0.65-0.08-1.32-0.38-1.99c-0.29-0.67-0.92-1.37-1.78-1.63c-0.39-0.13-0.8-0.2-1.21-0.2      c-1.279,0.01-2.31,0.63-3.109,1.35c-1.2,1.1-2.08,2.54-2.86,3.83c-0.74,1.27-1.48,2.44-1.72,2.62      c-0.38,0.34-0.681,0.55-0.87,0.65c-0.04,0.03-0.08,0.04-0.11,0.06c-0.27-0.26-0.97-1.44-1.899-2.84      c-2.381-3.33-5.131-6.78-5.46-10.32c2.149-0.71,4.739-1.77,7.01-3.29c2.64-1.77,5.02-4.33,5.04-7.86c0-0.63-0.08-1.27-0.24-1.92      c-0.27-1.13-0.71-2.02-1.42-2.66c-1.1-0.95-2.271-0.96-3.061-1.1c-0.85-0.13-1.5-0.26-2.34-0.89      c-0.689-0.49-1.149-1.55-1.64-2.94c-0.51-1.33-1.08-3.06-2.85-4.13c-0.551-0.32-1.25-0.26-1.74,0.16      c-0.96,0.85-1.771,2.02-2.61,3.09c-0.81,1.06-1.7,1.97-2.04,2.08c-0.34,0.16-0.52,0.18-0.6,0.18c-0.09,0-0.181,0.01-0.63-0.4      c-0.42-0.39-1-1.08-1.851-1.8c-1.58-1.35-3.87-3.08-5.8-4.98c-1.42-1.35-2.58-2.81-3.18-4.1c3.85-0.58,7.8-0.45,12.149-0.8      c0.61-0.05,1.13-0.48,1.311-1.07c0.18-0.58-0.03-1.23-0.51-1.61c-0.011,0-0.021-0.01-0.07-0.14c-0.26-0.46-0.061-2.2-1.36-3.84      c-0.859-0.96-1.89-1.27-2.8-1.56c-0.92-0.27-1.8-0.46-2.11-0.59c-1.319-0.53-2.77-1.11-3.92-1.88c-1.16-0.8-1.96-1.69-2.29-2.95      c-0.069-0.28-0.1-0.5-0.1-0.7c0-0.78,0.43-1.38,1.27-2.35c0.761-0.91,1.96-2.16,1.98-4.17c0-0.11,0-0.21,0-0.28      c-0.24-2.29-1.771-3.56-2.9-4.82c-1.21-1.25-2.08-2.38-2.159-3.53c-0.051-0.61-0.471-1.13-1.051-1.31      c-1.12-0.34-1.81-0.8-2.229-1.32c-0.42-0.53-0.67-1.2-0.67-2.29c0-0.11,0-0.2,0-0.25c0.04-0.74,0.31-1.19,0.83-1.88      c0.479-0.67,1.3-1.51,1.51-2.94c0.03-0.18,0.03-0.33,0.03-0.46c-0.011-1.26-0.66-2.14-1.19-2.79c-0.57-0.67-1.13-1.22-1.52-1.8      c-0.58-0.86-0.721-1.27-0.851-1.86c-0.13-0.59-0.21-1.46-0.51-2.72c-0.55-2.21-1.84-3.77-3.01-5.14      c-1.19-1.38-2.271-2.61-2.891-4.15c-0.91-2.23-2.229-3.74-3.27-5.07c-1.05-1.35-1.84-2.48-2.2-4.2      c-0.11-0.52-0.49-0.94-0.99-1.11c-0.84-0.29-1.59-0.67-2.34-1.15c0.19-0.38,0.38-0.76,0.58-1.15c0.71-1.47,1.17-2.41,1.6-2.87      c0.431-0.44,0.87-0.73,2.32-0.99c0.91-0.15,2.101-0.23,3.32-0.22c1.39,0,2.81,0.09,3.92,0.23c1.439,0.21,1.81,0.49,2.36,0.98      c0.55,0.5,1.22,1.46,2.52,2.46c2.32,1.79,4.69,2.76,7.12,2.75c2.189,0,4.32-0.77,6.42-2.1c3.62-2.29,8.28-6.11,11.19-9.32      c1.55-1.67,2.319-3.31,2.289-5.04c-0.01-1.22-0.289-2.36-0.59-3.79c-0.09-0.41-0.13-0.79-0.13-1.16      c0.03-2.02,1.13-3.78,3.84-4.99c0.83-0.36,1.61-0.5,2.42-0.5c2.15-0.03,4.57,1.13,7.15,2.46c2.59,1.3,5.35,2.77,8.51,2.79      c1.07,0,2.181-0.19,3.271-0.61c1.56-0.63,3.3-2.09,5.09-3.68c1.75-1.59,3.36-3.23,4.16-4.21c1.47-1.84,2.1-4.1,2.8-6.1      c0.68-2.03,1.42-3.75,2.46-4.61c0.67-0.57,1.36-0.79,2.21-0.79c0.25-0.01,0.51,0.02,0.78,0.06c1.7,0.29,3.71,1.5,4.97,2.86      c0.98,1,2,2.62,3.17,4.2c0.42,0.55,0.87,1.1,1.351,1.62c-1.58,2.35-2.681,5.13-2.711,8.21c0,1.74,0.391,3.56,1.25,5.28      c0.69,1.29,1.511,1.75,1.87,2.06c0.051,0.04,0.101,0.08,0.141,0.11c0,0.01,0,0.02,0.01,0.03c0.02,0.15,0.04,0.4,0.04,0.69      c0,0.73-0.12,1.72-0.13,2.86c0,0.01,0,0.1,0.01,0.25c0.05,1.45,0.41,3.06,0.96,5.08c0.86,3.09,2.19,6.83,3.84,9.99      c0.83,1.58,1.721,3.02,2.811,4.23c1.08,1.15,2.46,2.36,4.68,2.42c0.29,0,0.57-0.03,0.82-0.07c1.279-0.22,2.279-1.24,2.47-2.52      c0.04,0,0.09-0.01,0.15-0.01c0.399-0.02,0.8,0.26,0.8,0.29c0.46,0.68,1.18,1.14,2,1.27c0.81,0.13,1.64-0.08,2.29-0.58      c1.22-0.93,1.8-1.05,2.109-1.05c0.341-0.02,1.19,0.21,2.79,1.46c1.03,0.79,1.86,1.56,2.4,2.26c0.53,0.69,0.78,1.26,0.88,1.93      c-0.01,0.07-0.06,0.23-0.15,0.53c-0.13,0.43-0.329,1.13-0.329,2.01c0,0.33,0.029,0.68,0.09,1.04      c0.229,1.33,0.81,2.26,1.069,2.77c-0.449,0.52-0.96,1.46-0.93,2.44c0,0.92,0.31,1.63,0.63,2.18c0.84,1.38,2.01,1.87,2.9,2.15      c-0.12,0.81-0.221,1.67-0.23,2.64c-0.06,1.98,0.69,4.5,2.62,6.39c0.96,0.98,2.69,2.81,4.63,4.45      c0.98,0.83,2.021,1.61,3.141,2.25c1.109,0.61,2.29,1.16,3.83,1.2c0.029,0,0.06,0,0.079,0c0.011,0,0.021,0,0.03,0      c0,0,0.01,0,0.021,0c0.02,0,0.029,0,0.05,0c0.02,0,0.03,0,0.03,0c1.6-0.05,2.569-0.75,3.1-1.05c0.28-0.18,0.47-0.29,0.56-0.33      c0.011-0.01,0.011-0.01,0.021-0.01c0.24-0.03,0.42-0.04,0.6-0.04c0.34-0.01,0.721,0.05,1.42,0.05c1,0.03,2.391-0.28,3.641-0.99      c1.54-0.84,2.68-1.82,3.569-2.44c0.9-0.65,1.4-0.77,1.41-0.74c0,0.01,0.28-0.1,1.34,1c-0.109,0.44-0.159,0.9-0.159,1.36      c0,0.08,0,0.21,0.01,0.37c0.04,0.68,0.14,1.31,0.229,2.02c0.061,0.41,0.101,0.83,0.13,1.17c-0.84,0.28-1.75,0.82-2.3,1.53      c-1.52,1.59-1.779,3.79-1.72,4.95c0,0.32,0,0.62,0,0.91c0,0.17,0,0.34,0,0.5c-0.03,0.73-0.06,1.48-0.06,2.24      c0,1.31,0.09,2.71,0.6,4.16c0.51,1.45,1.47,2.83,2.78,3.99c0.84,0.75,1.67,1.31,2.29,1.74c-0.32,0.2-0.841,0.49-1.53,0.95      c-0.521,0.36-1.16,0.9-1.66,1.72c-0.51,0.82-0.78,1.87-0.77,2.87c0,0.6,0.079,1.21,0.229,1.84c0.71,2.66,2.49,3.88,3.47,4.85      c0.521,0.47,0.9,0.87,1.051,1.08c0.02,0.02,0.029,0.03,0.029,0.05c-0.2,0.16-0.83,0.47-1.689,0.89      c-0.931,0.49-2.32,1.2-3.29,2.85c-0.96,1.8-0.98,3.42-1.021,5.02c0.011,1.97,0.24,3.93,0.29,4.94      c0.061,1.19,0.811,2.21,1.88,2.63c-1.229,0.68-3.399,1.24-5.72,2.17c-1.36,0.58-2.83,1.37-4.06,2.75      c-1.23,1.37-2.03,3.31-2.15,5.47c-0.02,0.24-0.02,0.49-0.02,0.74c0.01,1.92,0.329,3.65,0.319,4.99      c-0.02,1.36-0.24,1.93-0.649,2.34c-0.2,0.15-0.181,0.15-0.2,0.14c-0.021,0-0.04,0-0.09,0.01      C721.381,388.369,720.481,388.109,719.321,387.579z",
                        "Pishchanka": "M482.901,842.009c0.02,1.689-0.11,2.36-0.17,2.41c-0.01,0.05-0.2,0.41-1.55,1.3      c-1.551,1.02-2.631,1.36-4.011,1.59c-1.37,0.22-3.109,0.22-5.42,0.33c-1.439,0.17-4.149-0.25-6.92,1.69      c-0.34,0.229-0.649,0.52-0.91,0.829c0.021-0.92,0.04-1.84,0.04-2.779c0.021-3-0.319-6.48-2.58-9.76      c-0.779-1.131-1.869-2.761-3.17-4.311c-1.319-1.55-2.76-3.1-4.87-4.04c-1.85-0.74-3.699-0.79-5.739-0.82      c-2.811,0-5.73,0.301-7.471,0.551c-1.55,0.239-2.739,0.77-3.699,1.12c-0.96,0.369-1.65,0.55-2.061,0.539      c-0.05,0-0.12,0-0.2-0.01c-0.399-0.04-0.54-0.1-0.56-0.1c-0.15-0.13-0.92-1.24-2.42-2.3c-1.851-1.28-3.93-1.62-5.75-1.62      c-2.641,0.01-5.05,0.649-6.8,1c-1.36,0.27-3.15,0.5-4.82,0.5c-1.8,0.02-3.46-0.32-4.2-0.76c0,0-0.01-0.011-0.05-0.051      c-0.23-0.199-0.75-1.08-1.34-2.18c-0.63-1.06-1.28-2.51-3.18-3.59c-1.42-0.72-2.63-0.74-3.72-0.76c-0.54,0-1.06,0.029-1.54,0.05      c-0.41-1.101-0.96-2.09-1.88-3.01c-1.59-1.471-3.39-1.82-5.26-2.141c-3.32-0.51-6.75-2.28-10.7-3.78      c-2.9-1.079-6.96-1.88-11.08-1.89c-0.04,0-0.09,0-0.13,0.01c0.01-3.29,0.03-6.43,0.04-9.56c0.37,0,0.75-0.01,1.13-0.01      c0.59,0,1.19,0.01,1.8,0.01c0.84,0,1.69-0.01,2.56-0.05c0.79-0.04,1.41-0.67,1.43-1.46c0-0.141,0-0.271,0-0.38      c0-1.24-0.14-2.301-0.14-3.021c0-0.58,0.09-0.87,0.17-1c0.08-0.11,0.2-0.28,0.86-0.49c0.38-0.12,0.8-0.17,1.26-0.17      c1.93-0.04,4.56,1.04,7.45,1.08c0.64,0,1.29-0.06,1.94-0.21c3.32-0.81,5.03-3.38,6.53-5.71c0.6-0.979,0.76-1.82,0.91-2.13      c0.19-0.31,0.04-0.271,0.69-0.55c0.31-0.101,0.75-0.16,1.29-0.16c1.64-0.021,3.93,0.58,6.07,0.6c0.2,0,0.4-0.01,0.59-0.02      c3.88-0.28,7.09-1.2,10.64-1.33c2.14-0.08,3.61-0.29,4.85-1.26c1.2-0.99,1.68-2.2,2.51-3.82c0.67-1.34,1.2-2.08,1.67-2.98      c0.47-0.88,0.78-1.97,0.76-3.31c0-0.25,0-0.51-0.02-0.78c-0.03-0.54-0.05-0.97-0.05-1.31c0-0.521,0.05-0.82,0.09-0.91      c0.01-0.04,0.01-0.04,0.01-0.05c0,0,0.17-0.12,0.67-0.24c0.48-0.12,1.24-0.229,2.24-0.35c1.59-0.221,2.939-0.28,4.3-1.021      c1.38-0.77,2.22-2.25,2.63-4.229c0.08-0.36,0.12-0.71,0.11-1.04c0-1.05-0.29-1.931-0.51-2.65c-0.221-0.64-0.36-1.18-0.381-1.39      c0.051-0.021,0.11-0.04,0.19-0.07c0.35-0.12,0.62-0.15,0.86-0.15c0.55,0,0.989,0.2,1.489,0.511c0.24,0.16,0.48,0.33,0.78,0.52      c0.3,0.17,0.65,0.431,1.38,0.46c0.49,0.021,1.08-0.25,1.391-0.59c0.85-1.04,0.85-1.88,1.13-3.66c0.439-3.1,0.64-3.37,2.72-5.859      c1.23-1.391,1.75-1.66,2.39-1.83c0.67-0.19,1.87-0.15,3.88-0.33c3.221-0.33,5.49-1.32,8.2-1.32      c7.431-0.189,12.351-4.35,18.061-4.24c0.75,0,1.52,0.061,2.33,0.2c2.319,0.44,3.59,1.44,4.949,2.87      c1.351,1.43,2.641,3.31,4.71,4.94c1.15,0.909,2.37,1.3,3.421,1.279c1.52-0.04,2.42-0.479,3.409-0.45      c0.17,0,0.36,0.011,0.561,0.04c0.74,0.12,0.83,0.21,1.17,0.45c0.33,0.25,0.87,0.82,1.82,1.37c1.149,0.67,1.89,0.91,2.93,1.39      c3.62,1.671,7.67,2.351,11.64,2.351c1.04,0,2.09-0.05,3.11-0.14c2.35-0.2,4.55-0.11,6.84-2.091c1-0.859,1.561-1.729,2-2.18      c0.47-0.45,0.51-0.52,1.12-0.55c0.16,0,0.35,0.01,0.58,0.05c0.3,2.01,1.3,3.99,3.26,5.12c1.32,0.75,2.561,0.7,3.28,0.72      c0.76,0.05,0.97,0.04,1.56,0.5c0.63,0.54,0.95,1.181,1.33,2.11c0.29,0.689,0.61,1.55,1.21,2.38c-0.68,3.3-2.38,6.24-4.25,9.27      c-0.819,1.301-1.01,2.561-1.08,3.521c-0.069,0.99-0.09,1.7-0.449,2.67c-0.32,1.06-1.841,1.98-3.45,3.15      c-0.54,0.43-1.721,1.13-2.84,1.909c-1.131,0.83-2.28,1.641-2.91,3.04c-0.25,0.591-0.32,1.19-0.32,1.73      c0.03,1.5,0.48,2.7,0.45,3.38c0,0.1-0.01,0.18-0.021,0.26c-0.12,1.5-1.55,3.3-1.62,6.04c0,0.09,0,0.15,0,0.2      c0.12,2.72,1.551,4.25,2.061,5.61c-0.48,0.18-0.94,0.42-1.32,0.72c-1.27,1.01-1.75,2.12-2.2,2.97      c-0.42,0.891-0.77,1.62-1.18,2.23c-0.229,0.319-0.35,0.42-0.86,0.77c-0.47,0.33-1.369,0.851-2.239,1.84      c-1.33,1.45-1.95,3.391-1.9,4.9c0.061,2.12,0.54,3.33,0.5,4.49c0,0.069,0,0.16,0.01,0.25c0,0.569,0,1.18,0,1.8      c0.011,2.06-0.08,4.33-0.43,5.71c-0.08,0.37-0.19,0.66-0.27,0.85c-0.03-0.01-0.061-0.02-0.08-0.029      c-0.29-0.11-0.721-0.34-1.271-0.71c-1.95-1.33-3.72-3.681-5.649-6.28c-1.95-2.561-4.101-5.43-7.5-7.25      c-1.511-0.79-3.021-1.26-4.561-1.26c-2.34-0.04-4.399,1.26-5.54,2.779c-1.76,2.28-2.439,4.971-3.03,7.49      c-0.54,2.49-0.93,4.91-1.3,5.99c-0.46,1.41-0.99,2.52-1.5,3.97s-0.899,3.2-0.89,5.34v0.021c0,0.03,0,0.06,0,0.1      C482.901,841.608,482.901,841.818,482.901,842.009z",
                        "Pohrebyshche": "M656.762,123.789c0.329-0.09,0.77-0.16,1.149-0.15h0.021c1.109,0,2.05,0.52,3.55,1.78      c1.46,1.2,3.17,3.04,5.859,4.19c2.221,0.9,5.091,1.68,7.811,1.7h0.02h0.021c1.359-0.03,2.25-0.41,2.96-0.63      c0.35-0.12,0.64-0.22,0.82-0.27c0.02,0,0.04-0.01,0.05-0.01c0.05,0.01,0.12,0.04,0.189,0.07c0.79,0.29,2.351,1.34,3.601,2.53      c0.02,0.02,0.04,0.04,0.06,0.06c-0.47,0.16-0.92,0.35-1.35,0.55c-0.681,0.33-1.15,0.55-1.71,0.91      c-0.41,0.25-0.94,0.66-1.37,1.31c-0.641,1.04-0.63,1.85-0.69,2.27c-0.04,0.46-0.069,0.87-0.21,1.59      c-0.029,0.48-0.8,1.69-1.96,3.12c-1.05,1.45-2.63,3.22-2.71,6.15c0,0.18,0,0.41,0.04,0.69c0.29,2.34,1.61,3.79,2.58,4.86      c1.03,1.07,1.9,1.93,2.1,2.33c0.96,1.61,2.2,4.31,2.82,6.1c1.55,4.43,3.7,10.2,4.49,14.46c0.1,0.55,0.14,1.14,0.14,1.8      c0.01,1.04-0.109,2.24-0.109,3.62c-0.021,1.89,0.279,4.29,1.81,6.5c1.48,2.1,3.55,3.9,5.9,5.03c1.159,0.56,2.31,0.66,2.899,0.69      c0.63,0.04,0.721,0.05,0.95,0.13c0.53,0.21,0.93,0.41,1.21,0.59c-0.32,0.2-0.79,0.43-1.39,0.61      c-1.141,0.39-2.61,0.44-4.521,1.01c-1.92,0.51-4.189,2.19-5.229,4.84c-0.08,0.14,0.04-0.03-0.24,0.34      c-0.31,0.33-0.89,1.64-0.82,2.54c0,0.21,0.021,0.46,0.05,0.72c0.23,1.32,0.601,1.63,0.94,2.23c1.01,1.53,2.64,3.35,3.06,3.88      c1.221,1.52,2.11,2.46,2.591,3.2c0.479,0.75,0.779,1.35,1.05,2.93c0.149,0.93,0.22,1.72,0.22,2.48c0,1.11-0.149,2.2-0.43,3.59      c-0.17,0.87-0.181,1.61-0.2,2.48c-0.02,1.27-0.01,2.7-0.08,3.85c-0.03,0.39-0.06,0.74-0.1,1.01c-0.5,0.01-1.24,0.07-2.011,0.36      c-0.76,0.29-1.119,0.35-1.93,0.78c-0.8,0.47-1.149,0.85-1.84,1.46c-1.3,1.17-2.14,2.27-2.83,3.02s-1.16,1.18-1.979,1.58      c-1.54,0.81-4.011,1.14-6.53,3.49c-0.28,0.28-0.561,0.57-0.83,0.86c-0.28-0.32-0.561-0.66-0.84-1.04      c-1.08-1.42-2.101-3.11-3.4-4.47c-1.7-1.74-4.1-3.35-6.78-3.74c-0.38-0.06-0.76-0.1-1.14-0.1c-1.43-0.01-2.93,0.45-4.16,1.51      c-1.85,1.61-2.63,3.85-3.35,5.92c-0.69,2.08-1.34,4.03-2.29,5.18c-0.61,0.75-2.2,2.39-3.851,3.88      c-1.609,1.48-3.479,2.88-4.14,3.1c-0.75,0.29-1.46,0.41-2.2,0.41c-2.14,0.02-4.56-1.14-7.149-2.47      c-2.59-1.29-5.34-2.76-8.511-2.79c-1.18,0-2.399,0.23-3.609,0.76c-3.53,1.48-5.67,4.43-5.65,7.74c0,0.59,0.07,1.19,0.2,1.79      c0.32,1.45,0.52,2.46,0.52,3.16c-0.029,0.93-0.199,1.53-1.51,3.02c-2.63,2.93-7.24,6.71-10.569,8.81      c-1.801,1.13-3.351,1.63-4.82,1.63c-1.62,0-3.3-0.61-5.3-2.13c-0.94-0.72-1.41-1.42-2.28-2.26c-0.85-0.84-2.17-1.57-4.05-1.78      c-1.26-0.16-2.78-0.25-4.29-0.25c-1.33,0-2.65,0.07-3.811,0.26c-1.76,0.27-3.12,0.89-4.05,1.94c-0.92,1.03-1.37,2.16-2.07,3.54      c-1.42,2.85-2.279,4.6-4.529,6.55c-1.82,1.53-2.82,1.89-3.82,1.9c-0.88,0.02-2.08-0.39-3.8-1.05c0.34-0.54,0.57-1.18,0.6-1.92      c0.011-0.03,0.011-0.06,0.011-0.08v-0.01v-0.01c0-0.37-0.141-0.74-0.4-1.03c-0.43-0.45-1.1-0.6-1.67-0.36      c-3.41,1.45-6.49,4.41-9.41,5.83c-1.67,0.83-2.51,1.03-3.23,1.03c-0.81,0.03-1.89-0.34-3.88-0.84      c-0.859-2.1-2.64-3.08-3.779-3.77c-0.681-0.41-1.19-0.76-1.471-1.1c-0.27-0.34-0.42-0.63-0.439-1.34c0-0.01,0-0.01,0-0.02      c0-0.01,0-0.03,0-0.04c0.01-0.7,0.13-0.96,0.34-1.41c0.19-0.41,0.63-1.09,0.64-2.14c0-0.84-0.29-1.66-0.819-2.6      c-0.801-1.38-1.86-2.26-2.63-3.06c-0.78-0.82-1.28-1.47-1.49-2.46c-0.101-0.49-0.141-0.95-0.141-1.38      c0-2.81,1.881-4.83,4.41-5.88c1.3-0.53,3.21-1.69,4.971-3.2c1.59-1.43,3.18-3.07,3.439-5.26c0.021-0.15,0.03-0.3,0.04-0.45      c0-0.32-0.04-0.62-0.1-0.91c-0.38-1.57-1.69-2.44-2.851-2.78c-1.2-0.38-2.47-0.44-3.67-0.44c-1.21,0-2.37,0.08-3.12,0.07      c-0.16,0-0.319,0-0.439-0.01c-3.05-0.17-6.86-0.97-9.21-2.51c-0.971-0.53-1.851-2.4-3.84-3.58c-0.94-0.5-1.881-0.74-2.75-0.73      c-1.65,0.03-2.74,0.61-4.2,0.85c-2.25,0.42-4.49,0.3-6.83,0.38c-2.34,0.07-4.83,0.37-7.271,1.81c-0.75,0.44-1.3,0.94-1.689,1.25      c-0.061,0.06-0.12,0.1-0.17,0.14c-0.16-0.22-0.391-0.61-0.65-1.18c-0.62-1.14-0.24-3.03-1.5-5.49      c-1.53-2.61-3.89-3.69-4.62-5.08c-0.55-0.78-0.5-2.09-1.33-3.98c-1.6-3.27-4.52-4.88-6.09-7.31c-2.02-2.91-5.12-6.86-5.88-9.82      c0.11-0.02,0.24-0.03,0.38-0.04c0.89-0.02,2.311,0.55,3.71,1.36c1.42,0.81,2.8,1.77,4.04,2.39c2.34,1.14,4.64,1.21,6.8,1.21      c0.431,0,0.86-0.01,1.29-0.01c0.16,0,0.33,0.01,0.49,0.01c3.06-0.06,6.7,2.27,10.82,2.36c0.41,0,0.83-0.03,1.25-0.09      c0.55-0.08,1.01-0.46,1.2-0.99c0.229-0.65,0.279-1.28,0.279-1.87c-0.01-1.4-0.31-2.75-0.3-3.43c0-0.17,0.021-0.25,0.021-0.27      c0.3-0.84,0.89-1.3,1.979-1.67c1.07-0.34,2.5-0.44,3.78-0.43c0.27,0,0.54,0,0.79,0.01c0.56,0.01,1.09-0.3,1.35-0.79      c1.21-2.24,1.84-4.19,1.84-6.07c-0.02-3.49-2.16-5.99-4.979-8.68c-0.771-0.73-1.391-1.32-1.73-1.76      c-0.35-0.45-0.399-0.64-0.399-0.81c-0.021-0.23,0.18-0.9,1.18-2.07c0.71-0.9,2.22-1.38,4.05-1.85c1.76-0.5,3.94-0.97,5.311-3.02      c0.72-1.13,0.97-2.41,0.97-3.69c-0.061-5.35-4.17-11.77-5.48-14.56c-1.26-2.56-1.819-5.56-1.819-8.66      c0-3.98,0.93-8.1,2.37-11.55c0.699,1.2,1.659,2.28,2.909,3.14c1.7,1.17,3.601,1.68,5.29,1.66c3.221-0.06,5.53-1.35,7.38-1.77      c0.351-0.09,0.62-0.12,0.87-0.12c0.58,0,1.2,0.17,2.181,0.55c0.979,0.36,2.279,0.93,3.97,1.22c3.8,0.63,7.4,0.52,10.36,1.01      c2.85,0.44,5.25,1.51,8.59,2.56c1.6,0.51,3,0.73,4.279,0.73c2.61-0.05,4.021-0.73,5.99-0.96c0.271-0.03,0.561-0.05,0.88-0.05      c2.341-0.07,5.75,1.24,9.761,1.31c0.939,0,1.93-0.09,2.93-0.33c0.88,0.39,1.82,0.57,2.66,0.56c2.63-0.07,4.41-1.19,5.529-1.53      c1.41-0.51,2.211-0.65,2.601-0.64c0.34,0.01,0.49,0.03,0.979,0.25c0.471,0.22,1.21,0.69,2.24,1.37c0.01,0,0.141,0.12,0.601,0.6      c0.38,0.43,1.569,1.45,3.18,1.43c1.35-0.02,2.3-0.53,3.25-1.13c1.55-1.01,2.32-2.57,2.64-3.82c0.33-1.28,0.351-2.42,0.36-3.3      c0-0.11,0-0.11,0-0.11c-0.03-3.34-0.73-6.22-0.93-8.81c0.75-0.11,1.529-0.16,2.319-0.16c1.69,0,3.45,0.24,5.11,0.64      c0.25,0.03,0.89,0.44,1.82,1.28c0.939,0.78,2.149,2.01,4.279,2.54c0.511,0.12,1.021,0.17,1.5,0.17      c2.061-0.02,3.48-0.87,4.48-1.38c1.02-0.57,1.67-0.85,2.05-0.87c0.55-0.05,1.03-0.07,1.49-0.07c0.68,0,1.31,0.04,2.069,0.04      c0.931,0.01,2.15-0.09,3.37-0.61c1.23-0.5,2.351-1.31,3.54-2.44c3.521-3.39,4.19-7.14,5.431-10.12      c0.479-1.14,0.729-1.22,0.84-1.29c0.12-0.08,0.62-0.21,1.72-0.2c0.62,0,1.39,0.03,2.28,0.03c0.54,0,1.13-0.02,1.77-0.05      c1.01-0.06,1.91-0.62,2.42-1.5C656.871,125.379,656.972,124.559,656.762,123.789z",
                        "Sharhorod": "M342.241,505.289c0.23,0.51,0.46,3.21,3,5.199c2.77,2.091,7.47,2.641,10.52,2.98      c1.47,0.13,4.56,0.37,7.52,0.37c0.5-0.01,0.98-0.021,1.45-0.03c-0.01,2.09-0.06,4.1-0.32,5.96c-0.06,0.46-0.07,0.88-0.07,1.21      c0,0.17,0.01,0.3,0.01,0.41c-0.02,0.64-0.01,0.66-0.25,1.03c0,0.01-0.01,0.02-0.13,0.069c-0.21,0.101-0.71,0.19-1.37,0.42      c-0.65,0.211-1.54,0.761-2,1.73c-0.33,0.65-0.51,1.35-0.5,2.02c-0.01,1.36,0.69,2.44,1.45,3.211c1.15,1.17,2.6,1.979,3.66,2.779      c0.88,0.63,1.32,1.17,1.45,1.49c-0.76-0.09-1.81-0.39-2.9-0.74c-1.34-0.399-2.73-0.88-4.2-0.89c-0.66,0-1.36,0.11-2.03,0.46      c-1.04,0.47-1.65,1.71-1.59,2.63c0.04,1.33,0.58,2.37,1,3.4c0.09,0.199,0.18,0.399,0.25,0.59c-0.27-0.13-0.57-0.29-0.88-0.47      c-1.05-0.57-2.37-1.341-4.13-1.351c-0.38,0-0.79,0.04-1.19,0.13c-0.41,0.08-0.76,0.33-0.98,0.69c-0.93,1.52-1.34,3.14-1.34,4.72      c0.13,6.49,6.17,11.9,9.52,15.17c0.46,0.44,0.84,0.73,1.1,0.92c0.11,0.07,0.19,0.12,0.25,0.16c0.04,0.16,0.12,0.5,0.22,1.03      c0.04,0.21,0.06,0.43,0.06,0.649c0.03,1.141-0.63,2.521-0.98,4.41c-0.1,0.58-0.14,1.19-0.14,1.811      c0.02,2.33,0.58,4.97,1.57,7.34c-1.51-0.141-2.9-0.2-3.96-0.58c-2.74-0.86-5.08-2.46-8.65-2.48c-0.41,0-0.83,0.021-1.25,0.07      c-3.76,0.42-6.54,2.38-9.24,3.86c-2.69,1.479-5.37,3.319-7.81,4.989c-2.83,2.03-4.75,5.461-6.34,6.24      c-1.12,0.641-2.05,0.641-3.34,0.99c-0.63,0.17-1.38,0.51-1.98,1.16c-0.6,0.64-1,1.49-1.26,2.54c-0.21,0.8-0.28,1.609-0.28,2.39      c0.01,2.42,0.64,4.61,0.63,6.48c-2.14,0.3-3.6,1.609-4.63,2.68c-1.23,1.27-2.12,2.19-3.2,2.39c0-0.01-0.01-0.01-0.01-0.01      c-0.02,0.03-0.5-0.16-1.14-0.63c-0.66-0.4-1.45-1.09-2.81-1.13c-0.58-0.01-1.21,0.189-1.72,0.55c-1.1,0.79-1.2,1.98-1.2,2.71      c0,0.771,0.11,1.45,0.1,1.83c0,0.11,0,0.18-0.01,0.22h0.01c-0.27,0.73-1.42,1.761-2.95,2.7c-1.52,0.98-3.29,1.91-4.71,3.04      c-1.63,1.34-2.45,1.97-3.22,2.25c-0.76,0.3-1.81,0.42-4.06,0.41c-0.18,0-0.34,0.04-0.5,0.09c-0.89-2.35-2.49-4.08-4.68-5.71      c-1.97-1.49-4.03-2.58-5.55-3.99c-1.06-0.939-2.17-2.39-3.72-3.51c-1.65-1.19-3.38-1.54-4.86-1.53      c-1.7,0.011-3.13,0.351-4.22,0.34c-0.9-0.02-1.49-0.149-2.21-0.699c-1.3-0.94-2.15-3.11-4.28-4.78      c-3.02-2.22-6.56-2.24-9.44-2.53c-6.18-0.59-12.23-0.67-18.31-1.02c-1.71-2.521-3.86-4.351-5.57-6.17      c-1.89-1.99-3.23-3.82-3.52-6.471c-0.13-1.18-0.34-3.71-0.91-6.14c-0.29-1.229-0.66-2.44-1.22-3.51      c-0.55-1.05-1.31-2.05-2.56-2.54c-0.44-0.17-0.9-0.26-1.35-0.26c-1.99,0.06-3.23,1.359-4.23,2.46      c-0.98,1.12-1.85,2.34-2.24,2.64c-0.9,0.76-2.13,1.92-3.38,2.99c-1.21,1.06-2.54,2.01-3.11,2.189      c-0.48,0.19-1.33,0.301-2.33,0.29c-2.23,0.011-5.1-0.47-7.38-0.479c-0.18,0-0.36,0-0.54,0.01c-2.34,0.1-4.13,0.59-5.44,1.6      c-0.45-0.72-0.82-1.46-1-2.159c-0.49-1.65,0.08-4.33-0.69-7.061c-1.18-3.81-4.19-6.36-6.49-8.88c-0.82-0.88-1.51-1.68-2.37-2.35      c-0.47-0.37-1.03-0.681-1.64-0.891c0.17-2.149,0.54-4.92,0.54-7.39c0-1.55-0.12-3.01-0.67-4.311      c-0.69-1.56-1.98-2.39-3.08-3.069c-1.13-0.66-2.16-1.24-2.64-1.76c-1.35-1.45-1.64-2.391-2.22-4.4      c-0.52-1.771-1.51-8.37-1.49-13.97c-0.01-2.44,0.18-4.721,0.61-6.301c0.2-0.779,0.47-1.38,0.71-1.72      c0.26-0.34,0.4-0.39,0.53-0.42c0.36-0.07,0.66-0.26,0.88-0.52c1.65-0.141,3.03-1.04,3.95-2.21      c2.94-3.83,3.05-10.421,3.11-13.561c0-0.01,0-0.02,0-0.11c0-0.47-0.01-0.85-0.01-1.17c0.07-1.239-0.03-1.08,0.59-1.819      c0.01,0,0.01-0.021,0.18-0.08c0.24-0.09,0.78-0.13,1.49-0.4c0.72-0.24,1.59-0.939,1.98-1.939c0.45-1.051,0.49-2.03,0.49-2.761      c0-0.18,0-0.359,0-0.54c0.02-0.909,0.01-1.26,0.61-2.05c0.01-0.04,0.65-0.52,1.24-0.83c0.21-0.13,0.42-0.239,0.62-0.35      c1.31,0.76,2.33,1.2,3.1,1.65c0.93,0.539,1.64,1.079,2.76,2.569c1.16,1.58,2.45,3.23,4.54,4.09      c0.68,0.271,1.32,0.311,1.82,0.311c0.44,0,0.79-0.03,1.02-0.03c0.08,0,0.13,0.01,0.17,0.01c0.04,0.08,0.1,0.25,0.15,0.54      c0.11,0.57,0.53,1.021,1.09,1.181c0.52,0.14,1.04,0.22,1.54,0.22c0.02,0,0.04,0,0.06,0c1.06,0,2.05-0.44,2.7-1.07      c1.01-0.97,1.4-2.149,1.76-3.17c0.32-1.03,0.61-1.97,0.86-2.32c1.49-2.43,5.99-6.02,9.02-8.09c1.15-0.8,2.23-1.39,3.21-2.26      c0.98-0.84,1.76-2.22,1.72-3.84c0-0.88-0.17-1.82-0.5-2.91c-0.6-1.84-1.32-2.63-1.57-4c-0.28-1.37-0.48-2.75-0.86-4.19      c2.63-0.56,4.97-1.21,7.04-1.199c1.77,0.02,3.32,0.399,5.02,1.699c3.59,2.681,8.29,7.891,13.93,9.021      c0.56,0.11,1.12,0.18,1.7,0.21c0.49,0.01,0.97,0.01,1.47,0.01c5.49,0,11.22-0.68,16.57-0.68c2.17,0,3.53-0.18,4.71-0.87      c1.16-0.68,1.77-1.46,3.13-2.55c1.11-0.91,2.34-1.53,3.56-2.61c1.23-1.08,2.28-2.689,2.76-5.09c0.1-0.53,0.14-1.05,0.14-1.57      c0-1.83-0.52-3.529-0.84-4.84c-0.28-1.02-0.82-1.85-1.27-2.6c-0.23-0.37-0.44-0.71-0.59-0.97c-0.07-0.131-0.12-0.23-0.15-0.301      c-0.01-0.029-0.02-0.05-0.03-0.06c-0.05-0.26-0.06-0.48-0.07-0.69c0.02-0.899,0.34-1.569,1.01-2.359      c0.3-0.351,0.66-0.69,1.07-1.051c0.27,0.771,0.6,1.57,0.99,2.351c0.83,1.61,1.88,3.18,3.59,4.02c0.81,0.36,1.6,0.42,2.31,0.42      c0.37,0,0.73-0.02,1.07-0.04c0.57,1.65,0.96,3.65,2.29,5.591c1.64,2.189,3.59,2.84,4.48,4.069c2.03,2.551,2.31,5.19,2.32,8.561      c0,1.109-0.04,2.279-0.04,3.51c0,0.74,0.02,1.5,0.06,2.27c0.17,3.851,1.68,6.65,3.44,9.061c1.76,2.43,3.75,4.56,5.35,7.41      c1.51,2.7,4.06,5.95,8.36,5.979c0.23,0,0.47-0.01,0.71-0.029c1.77-0.171,3.31-1.141,4.51-2.4c1.05-1.16,1.87-2.59,2.03-4.19      c0.69-0.229,1.22-0.479,1.65-0.63c0.11,1.25,0.32,2.721,0.79,4.11c0.62,1.92,2.2,4.05,4.93,4.13l0.14-0.01c0.02,0,0.04,0,0.06,0      c1.41-0.07,2.3-0.811,3.01-1.28c0.72-0.55,1.27-0.78,1.3-0.75c0,0,0,0,0.01,0c0.02,0,0.14,0,0.59,0.58      c0.24,0.36,0.3,0.61,0.31,0.97c0.08,0.891-0.78,2.261-0.95,4.16c-0.02,0.12-0.02,0.23-0.03,0.351      c-0.01,0.729,0.2,1.56,0.69,2.289c1.43,1.961,3.75,2.23,5.77,2.261c1.86,0,3.66-0.33,4.82-0.63c0.63-0.17,1.09-0.721,1.12-1.37      c0.03-0.681,0.04-1.271,0.04-1.771c0-0.34,0-0.63,0-0.91c-0.02-1.029,0.1-1.39,0.16-1.449c0.04-0.091,0.46-0.45,1.8-0.86      c0.92-0.3,1.53-0.4,1.8-0.39C342.191,505.289,342.221,505.289,342.241,505.289z",
                        "Teplyk": "M783.621,576.639c0.42,0.92,0.73,1.83,1.3,2.8c1.44,2.38,3.65,5.34,6.28,7.95      c2.66,2.56,5.62,4.9,9.28,5.54c0.77,0.13,1.479,0.15,2.12,0.15c0.96,0,1.79-0.061,2.46-0.061c1.09,0,1.6,0.15,1.92,0.36      c0.359,0.21,1.46,1.39,2.35,2.689c0.91,1.29,1.75,2.74,2.24,3.66c0.05,0.16,0.21,0.94,0.31,1.82c0.2,1.54,0.381,3.54,0.83,5.41      c0.25,0.939,0.53,1.87,1.17,2.85c0.061,0.1,0.131,0.2,0.21,0.3c-0.5,1.45-0.689,2.931-0.689,4.37c0,0.15,0,0.29,0,0.44      c-1.21,0.189-2.521,0.479-3.811,0.96c-1.31,0.5-2.64,1.189-3.77,2.38c-1.13,1.149-1.92,2.899-1.91,4.76      c-1.6,0.63-2.87,1.3-4.21,1.47c-0.22,0.03-0.45,0.04-0.68,0.04c-1.4,0.03-3.08-0.609-5.11-0.649c-0.01,0-0.02,0-0.03,0      c-2.83-0.04-4.699,1.66-5.859,3.319c-1.21,1.69-2.13,3.471-3.48,4.69c-5.05,4.7-12.42,7.5-17.92,12.58      c-2.399,2.24-4.27,5.24-6.189,7.57c-1.931,2.369-3.74,3.83-5.66,3.8c-1.351,0-3.141-0.65-5.54-2.76      c-0.771-0.58-1.47-2.48-3.141-3.9c-1.72-1.35-3.949-1.93-6.069-2.54c-2.12-0.57-4.16-1.16-5.24-1.93      c-3.18-2.16-6.52-5.761-8.28-9.11c-1.26-2.36-2.45-3.9-4.239-4.71c-1.771-0.77-3.591-0.74-6.141-0.75      c-2.57,0-5.18-0.07-7.81-0.07c-1.69,0-3.4,0.03-5.101,0.12c-0.399,0.021-0.779,0.21-1.04,0.51c-0.27,0.301-0.399,0.7-0.37,1.101      c0,0.08,0.011,0.16,0.011,0.24c-0.03,0.619-0.15,0.81-0.45,1.109c-0.44,0.45-1.61,0.87-3.01,1.181      c-1.4,0.34-2.99,0.609-4.431,1.29c-3.21,1.43-4.81,4.05-5.1,7.439c-0.03,0.24-0.04,0.47-0.04,0.69      c0.01,0.93,0.16,1.63,0.15,2.01c-0.07,0.46,0.06,0.399-0.54,0.91c-0.061,0.01-0.24,0.04-0.5,0.04c-0.311,0-0.721-0.03-1.2-0.03      c-0.67,0.01-1.69,0.02-2.561,0.92c-0.72,0.81-0.779,1.67-0.8,2.48c0.01,1.5,0.45,3.17,1.03,4.71c0.25,0.609,0.5,1.189,0.77,1.72      c-1.359,0.479-2.68,1.11-3.97,1.92c-0.34,0.21-0.59,0.55-0.67,0.94c-0.08,0.35-0.12,0.699-0.12,1.039      c0.021,1.811,0.95,3.091,1.601,4.12c0.51,0.761,0.869,1.38,1.029,1.91c-1.39-0.06-2.22-0.319-3.189-0.74      c-1.08-0.47-2.33-1.229-4.271-2.04c-2.09-0.859-4.34-1.27-6.59-1.27c-2.34,0-4.67,0.43-6.85,1.25      c-3.19,1.21-5.71,3.23-8.07,4.83c-2.38,1.61-4.5,2.76-6.85,2.75c-0.051,0-0.101-0.01-0.15-0.01c-0.15-2.21-0.85-5.11-2.09-7.74      c-0.7-1.47-1.57-2.84-2.69-3.91c-1.04-1.01-2.39-1.77-3.93-1.86c-0.98-2.39-2.31-4.54-2.62-6.329      c-0.46-2.25,0.09-5.011-0.68-8.11c-0.73-2.75-1.54-4.48-1.62-7v-0.09c0,0,0,0,0-0.021c-0.03-1.01,0.49-2.939,0.51-4.7      c-0.01-0.529-0.05-1.069-0.25-1.64c-0.479-1.34-1.39-2.26-2.189-3.17c-0.82-0.9-1.57-1.77-1.95-2.62      c-0.71-1.55-1.471-3.439-1.83-5.02c-0.26-1.11-0.73-3.48-0.73-5.33c-0.029-1.17,0.28-2.08,0.38-2.11      c0.221-0.21,0.301-0.229,0.921-0.34c0.529-0.08,1.75-0.26,2.539-1.36c0.341-0.51,0.341-0.79,0.391-1.069      c0.03-0.271,0.04-0.53,0.04-0.79c0-0.36-0.021-0.761-0.04-1.12c0.09-0.03,0.18-0.061,0.24-0.07c0.02-0.01,0.04-0.02,0.06-0.02      c0.56-0.08,1.04-0.471,1.22-1.021c0.2-0.62-0.02-1.29-0.54-1.68c-2.479-1.88-3.439-2.9-3.779-5.931      c-0.021-0.21-0.021-0.38-0.021-0.56c0.04-1.22,0.3-1.5,0.891-2.29c0.579-0.729,1.59-1.9,1.819-3.8      c0.021-0.22,0.04-0.43,0.04-0.64c-0.02-1.82-0.97-3.091-1.64-4.061c-0.73-0.97-1.13-1.689-1.08-1.99c0-0.14,0.02-0.3,0.229-0.63      c0,0,0,0,0.04-0.04c0.29-0.35,1.53-1.33,2.71-2.069c0.601-0.37,1.2-0.71,1.681-0.94c0.239-0.11,0.45-0.2,0.6-0.24      c0.01-0.01,0.01-0.01,0.021-0.01c0.189,0.14,0.58,0.47,1.02,0.83c0.61,0.46,1.46,1.09,2.71,1.11c0.09,0,0.19-0.011,0.3-0.011      c1.24-0.14,2.011-0.83,2.53-1.279c0.44-0.391,0.771-0.66,1.01-0.79c0.391,0.04,1.351,0.18,2.19,0.189      c0.31,0,0.62-0.01,1.02-0.109c1.04-0.29,1.67-0.99,1.99-1.351c0.36-0.38,0.37-0.37,0.44-0.38c0.34-0.08,0.64-0.12,0.93-0.12      c1.84-0.05,3.61,1.5,5.68,3.54c2.04,1.94,4.41,4.34,8.021,4.37c0.529,0,1.069-0.05,1.63-0.17c0.67-0.13,1.16-0.7,1.2-1.38      c0.1-2.05,0.47-3.181,0.76-3.58c0.3-0.37,0.33-0.39,0.979-0.43c1.33-0.061,4.131,1.13,7.511,1.159c0.22,0,0.449-0.01,0.689-0.02      c3.19-0.19,5.45-1.09,8.08-1.34c3-0.33,5.93,0.26,9.37-2.01c3.13-2.11,3.88-4.57,5.75-6.891c1.3-1.71,3.01-1.97,5.521-3.7      c1.909-1.359,2.85-3.109,3.569-4.609c0.72-1.521,1.271-2.79,2.3-3.811c0.96-1.02,2.891-1.399,5.08-1.38      c0.38,0,0.771,0.01,1.16,0.021c0.45,0.02,0.891-0.16,1.19-0.511c0.3-0.34,0.43-0.79,0.35-1.239      c-0.01-0.051-0.01-0.091-0.01-0.141c0-0.109,0.02-0.13,0.02-0.13c0-0.01,0.011-0.02,0.091-0.06      c0.109-0.061,0.359-0.12,0.71-0.12c0,0,0.029,0,0.079,0c0.561,0.03,1.08-0.26,1.36-0.74c0.28-0.479,0.271-1.07-0.02-1.54      c-1.551-2.52-2.21-5.27-2.841-8.55c-0.47-2.39-1.47-5.47-1.46-7.65c0-0.43,0.04-0.81,0.11-1.13c-0.09-0.13,0.99-1.24,2.38-2.21      c0.681-0.53,1.391-1.08,2-1.76c0.601-0.67,1.17-1.561,1.181-2.72c-0.011-1.12-0.551-2.08-1.44-2.94      c0.56-0.91,1.14-1.84,1.76-2.58c0.9-1.08,1.71-1.59,2.44-1.58c0.22,0,0.47,0.04,0.779,0.15c0.561,0.22,0.771,0.439,1.011,0.82      c0.359,0.579,0.54,1.699,0.739,3.039c0.23,1.33,0.5,2.921,1.53,4.36c1.44,2.05,3.13,3.12,4.83,3.59      c1.69,0.48,3.271,0.53,5.09,0.92c1.92,0.351,4.07,2.19,7.11,2.69c0.39,0.06,0.76,0.09,1.12,0.09c1.55,0,2.8-0.53,3.81-1.12      c0.271-0.16,0.53-0.319,0.78-0.479c0.62,0.8,1.34,1.56,2.17,2.239c1.17,1.021,2.6,1.721,3.82,1.83      c1.149,0.13,1.489,0.051,2.569,0.271c0.98,0.2,1.641,0.5,2.69,0.95c1.02,0.439,2.44,0.979,4.25,1.13      c0.61,0.05,1.17,0.06,1.71,0.06c0.96,0,1.81-0.04,2.56-0.04c0.881,0,1.601,0.061,2.23,0.221c1.33,0.329,2.37,0.81,3.74,1.35      c0.14,0.06,0.29,0.11,0.439,0.17c-0.319,0.63-0.55,1.4-0.52,2.18c0,1.011,0.27,1.931,0.68,2.87c0.43,0.97,0.811,1.7,1.01,2.2      c0.21,0.52,0.25,0.74,0.261,1.02c0,0.271-0.061,0.69-0.391,1.49c-0.38,0.891-1.399,3.391-2.35,6.38      c-0.94,3.011-1.84,6.42-1.86,9.57c0.021,1.46,0.17,2.94,1,4.42c0.79,1.5,2.681,2.69,4.51,2.73c1.4,0.08,2.66-0.82,3.061-2.141      c0.13-0.16,0.52-0.58,0.939-0.85c0.16-0.11,0.311-0.2,0.46-0.271C783.031,575.369,783.352,575.988,783.621,576.639z",
                        "Tomashpil": "M373.021,681.969c0,0.71,0.1,1.17,0.09,1.63c0,0.16-0.01,0.33-0.03,0.54c-0.12,0.88-0.22,1.19-0.38,1.57      s-0.46,0.92-0.8,1.84c-1.13,3.09-1.03,5.74-1.47,8.52c-0.46,3.261-0.92,7.95-2.12,10.25c-0.63,1.49-3.57,2.9-5.56,4.98      c-0.35,0.39-0.47,0.93-0.32,1.43c0.52,1.561,1.33,2.8,1.71,3.75c-2.39,1.601-3.11,4.04-3.17,6.021      c-0.12,2.3,0.05,4.26-0.79,5.739c-0.59,0.95-0.68,0.881-1.28,1.061c-0.6,0.14-1.78,0.12-3.22,0.68c-1.76,0.7-3.2,1.8-4.34,2.98      c-2.46-1.99-5.98-2.551-8.5-2.92c0.23-0.46,0.54-0.94,0.91-1.48c0.71-1.07,1.66-2.439,1.66-4.35c0-0.101,0-0.2,0-0.311      c-0.12-2.149-1.3-3.72-2.53-4.81c-1.24-1.101-2.59-1.891-3.5-2.67c-0.6-0.49-0.93-0.83-1.04-0.971      c0.03-0.21,0.14-0.739,0.14-1.479c0-0.021,0-0.05,0-0.08c0.06-0.13,0.14-0.31,0.22-0.49c0.15-0.37,0.33-0.689,0.39-1.33v-0.149      v-0.011c0-0.02,0-0.05-0.01-0.1c-0.09-1.04-0.58-1.479-0.79-1.83c-0.12-0.16-0.2-0.29-0.24-0.359      c0.14-1.58,1.9-3.051,3.87-3.591c0.62-0.17,1.06-0.72,1.1-1.359c0.05-0.96,0.11-2,0.11-3.07c0-1.77-0.15-3.62-0.93-5.32      c-0.77-1.699-2.32-3.159-4.56-3.75c-0.57-0.159-1.15-0.21-1.75-0.21c-4.27,0.04-10.59,2.681-13.31,3.66      c-2.15,0.891-3.32,1.9-3.8,1.771c-0.12,0-0.24-0.021-0.43-0.091c0,0-0.03-0.01-0.13-0.09c-0.84-0.56-2.68-2.92-3.11-3.569      c-0.43-0.61-0.78-1.04-0.98-1.301c0.13-0.25,0.37-0.68,0.69-1.26c0.59-1.1,1.5-2.27,2.36-2.91c0.59-0.439,0.77-1.25,0.43-1.899      c-0.96-1.8-2.2-3.63-2.61-5.07c-0.11-0.38-0.13-0.63-0.13-0.92c0-0.25,0.03-0.53,0.03-0.92c0.01-0.49-0.09-1.24-0.51-1.88      c-0.41-0.65-1-1.16-1.82-1.71c-1.34-0.891-2.46-1.141-3-1.391c-0.52-0.26-0.71-0.29-1.34-1.439c-0.96-1.7-0.8-3.93-2.87-6.36      c-0.27-0.3-0.66-0.479-1.06-0.5c-0.04,0-0.08,0.01-0.12,0.01c-0.19-0.22-0.4-0.43-0.6-0.63c-1.44-1.35-3.31-2.41-4.77-3.46      c-0.73-0.51-1.34-1.02-1.7-1.439c-0.37-0.431-0.44-0.7-0.44-0.82c0.01-0.11,0.02-0.29,0.36-0.7c0.34-0.399,1-0.95,2.04-1.56      c0.91-0.54,2.83-1.19,4.56-2.11c0.88-0.47,1.73-1.01,2.44-1.78c0.71-0.75,1.25-1.819,1.25-3.029c0-0.681-0.17-1.37-0.46-2.05      c-0.91-1.931-2.73-2.721-4.36-3.521c-1.65-0.76-3.31-1.47-3.9-2.07c-1.47-1.449-1.49-1.8-1.54-2.72      c-0.02-0.81,0.26-2.14,0.34-4.11c0.01-0.199,0.01-0.39,0.01-0.56c0.01-4.22-1.87-6.89-3.82-9.95c-1.01-1.68-2.25-2.5-3.3-2.71      c-1-0.24-1.32-0.17-2.34-0.84c-0.22-0.15-0.36-0.27-0.43-0.33c-0.02-0.22,0.01-0.8-0.09-1.59c2.18-0.01,3.58-0.09,4.95-0.61      c1.41-0.55,2.43-1.42,4.03-2.72c1.05-0.86,2.78-1.79,4.43-2.84c1.64-1.061,3.3-2.2,4.11-4.09c0.21-0.53,0.23-0.971,0.23-1.36      c0-0.74-0.11-1.39-0.1-1.83c0-0.1,0-0.18,0.01-0.25c0.05,0.021,0.12,0.05,0.22,0.101c0.7,0.25,1.65,1.52,3.64,1.649      c0.2,0,0.38-0.02,0.54-0.05c2.4-0.5,3.69-2.13,4.8-3.23c1.17-1.149,1.96-1.819,3.43-1.84c0.12,0,0.23,0.01,0.32,0.021      c0.79,0.069,1.5-0.48,1.63-1.261c0.09-0.569,0.12-1.13,0.12-1.67c-0.02-2.449-0.65-4.659-0.63-6.51c0-0.58,0.05-1.13,0.19-1.649      c0.19-0.761,0.4-1.091,0.54-1.24c0.18-0.19,0.44-0.3,1.29-0.47c0.8-0.16,2-0.37,3.31-1.101c2.77-1.67,4.51-5.06,6.57-6.38      c2.43-1.67,5.05-3.46,7.56-4.85c2.88-1.601,5.3-3.21,8.11-3.5c0.33-0.04,0.63-0.051,0.93-0.051c2.53-0.029,4.49,1.261,7.73,2.33      c2.35,0.7,4.82,0.65,6.68,0.99c0.23,0.32,0.47,0.63,0.72,0.92c0.3,0.33,0.7,0.49,1.11,0.49c0.27,0,0.52-0.09,0.76-0.23      c0.71,0.681,1.21,1.67,1.74,2.87c0.73,1.58,1.37,3.561,3.34,4.78c0.42,0.26,0.95,0.29,1.4,0.07c0.46-0.21,0.77-0.63,0.85-1.13      c0.06-0.431,0.3-0.83,0.8-1.45c0.3-0.391,0.7-0.84,1.06-1.431c0.45,0.15,0.98,0.431,1.65,0.82c0.98,0.57,2.28,1.33,4.03,1.37      c0.1,0,0.17,0,0.24,0c3.39-0.04,6.19-1.38,8.67-1.34l0.04,0.01c2.9,0,4.66,0.021,6.07,1.34c0.58,0.521,1.12,1.54,1.67,2.74      c0.57,1.18,1.14,2.54,2.3,3.64c1.04,0.98,2.17,1.45,3.07,1.931c0.91,0.479,1.58,0.91,2.09,1.64c1.09,1.46,1.9,4.64,3.57,7.12      c1.47,2.13,2.86,3.89,3.69,5.979c0.27,0.66,0.43,1.71,0.69,2.851c0.28,1.12,0.71,2.46,1.96,3.42c0.39,0.29,0.9,0.38,1.36,0.229      c0.46-0.149,0.83-0.51,0.97-0.979c0.62-1.74,1.05-1.72,1.32-1.75c0.46-0.08,1.85,0.75,2.89,2.16      c0.82,1.05,1.471,2.37,1.74,3.399c-2.18,1.561-4.36,4.12-6,5.601c-0.94,0.859-2.54,2.18-3.94,3.689      c-1.38,1.53-2.72,3.221-2.83,5.391c-0.01,0.59,0.32,1.13,0.85,1.39c2.16,1.05,4.1,1.24,5.85,1.23c0.88,0,1.72-0.04,2.58-0.04      c0.39,0,0.78,0.01,1.18,0.029c0.279,0.011,0.55,0.021,0.81,0.021c3.08-0.01,5.3-0.891,7.561-1.47      c0.52,0.46,1.149,0.76,1.76,0.939c0.99,0.3,2.04,0.37,3.149,0.37c2.66,0,5.71-0.47,7.87-0.47c0.4,0,0.761,0.02,1.07,0.05      c0,0.76-0.12,1.6-0.29,2.3c-0.19,0.75,0.23,1.51,0.95,1.771c1.62,0.579,2.649,0.68,3.17,0.859c0.5,0.17,0.84,0.311,1.91,1.45      c2.1,2.37,2.319,3.18,2.55,6.41c0.01,0.1,0.01,0.2,0.02,0.3c-0.239,0.28-0.38,0.65-0.35,1.05c0.021,0.391,0.2,0.73,0.46,0.98      c0.1,1.74,0.23,3.45,0.57,5.2c0.13,0.659,0.24,1.39,0.24,2.01c0,0.649-0.141,1.109-0.28,1.28c-0.13,0.14-0.23,0.3-1.05,0.329      c-0.101,0-0.2,0-0.301-0.01c-0.81-0.05-1.51,0.55-1.59,1.36c-0.029,0.31-0.04,0.609-0.04,0.92c0.04,3.41,1.49,6.45,1.721,9      c0.05,0.45,0.069,0.81,0.069,1.1c0,0.271-0.02,0.46-0.04,0.57c-0.479,0.09-2.3,0.12-4.31,1.17c-2.641,1.41-4.24,2.8-6.72,3.561      c-1.601,0.5-2.921,0.689-4.32,1.159c-1.4,0.45-2.83,1.271-4.12,2.801c-2,2.329-4.29,3.34-7.09,5.649c-1.18,1-1.99,2.22-2.8,3.08      c-0.83,0.89-1.44,1.28-2.19,1.28c-0.07,0-0.16,0-0.25-0.01c-0.51-0.021-1.72-0.641-2.77-1.49c-1.07-0.84-2.08-1.891-2.58-2.53      c-1.14-1.38-2.22-4.12-4.76-5.52c-1.02-0.5-1.91-0.431-2.74-0.46c-0.16,0-0.34,0-0.51,0c-0.41,0-0.77,0-1.02-0.04      c-0.52-2.591-2.47-4.851-4.74-6.69c-2.63-2.07-5.77-3.58-8.64-3.61c-0.79,0-1.57,0.12-2.31,0.44c-2.66,1.26-4.27,3.91-5.84,4.64      c-1.02,0.561-2.52,0.88-4.09,1.471c-1.54,0.58-3.29,1.6-4.18,3.659C373.151,680.528,373.011,681.318,373.021,681.969z",
                        "Trostianets": "M556.451,760.349c-0.81,0.43-1.6,0.74-1.76,0.73c-0.04,0-0.101,0-0.13,0c-0.4,0.01-0.98-0.19-1.74-0.521      c-0.75-0.31-1.68-0.75-2.9-0.76c-2.01-0.01-3.68,1.08-4.699,2.5c-0.4,0.56-0.73,1.17-0.98,1.82      c-0.04-0.061-0.08-0.131-0.12-0.19c-0.79-1.14-1.689-2.46-3.39-3.021c-0.141-0.039-0.29-0.05-0.44-0.05      c-0.06-0.149-0.12-0.3-0.189-0.46c-0.4-0.97-0.95-2.22-2.16-3.25c-1.18-1.04-2.561-1.2-3.41-1.21c-0.9-0.02-1.3-0.01-1.89-0.33      c-1.15-0.62-1.851-2.149-1.851-3.79c-0.01-1.71,0.79-3.14,1.69-3.46c0.649-0.3,1.31-0.149,2.5-0.319      c0.59-0.08,1.45-0.5,1.88-1.271c0.43-0.729,0.53-1.52,0.55-2.5v-0.02c0-0.011,0-0.03,0-0.061c0-0.01,0-0.03-0.01-0.05      c-0.04-1.44-0.71-2.66-1.47-3.7c-0.811-1.06-1.75-1.93-2.71-2.47c-1.71-0.96-3.601-1.17-5.421-1.18      c-2.09,0.01-4.159,0.279-5.97,0.31c-0.569-2.13-1.56-3.74-1.78-5.38c-0.31-1.93-0.31-3.91-0.31-6.09l-0.01-0.03v-0.02      c0-0.04,0-0.08,0-0.11c0-4.061,2.13-6.51,3.05-11.21c0.11-0.62,0.41-1.7,0.42-2.88c-0.01-0.51-0.06-1.061-0.3-1.65      c-0.521-1.22-1.55-1.8-2.15-2.08c-0.63-0.3-0.83-0.46-0.83-0.5c-0.14-0.21-0.3-0.83-0.29-1.529      c-0.04-1.11,0.44-2.421,0.681-2.601c0.439-0.49,1.489-0.8,3.04-0.79c1.729,0,3.83,0.33,5.79,0.34c0.56,0,1.12-0.029,1.68-0.12      c0.7-0.109,1.15-0.17,1.56-0.26c0.311-0.069,0.641-0.149,1-0.37c0.591-0.38,0.811-0.87,0.96-1.14c0.16-0.3,0.33-0.62,0.71-1.17      c1.061-1.561,2.44-3.65,3.181-5.64c0.34-0.921,0.52-1.851,0.52-2.78c0-2.75-1.55-5.19-4.01-7.061      c-2.08-1.479-4.3-1.39-5.04-1.97c-0.85-0.51-1.15-0.9-1.83-1.47c-0.68-0.601-1.78-1.07-3.189-1.13      c-1.181-0.08-2.4-0.101-3.641-0.101c-2.62,0-5.319,0.11-7.819,0.11c-0.78,0.01-1.57,0.12-2.25,0.12      c-0.391,0-0.721-0.04-0.9-0.101c-0.12-0.04-0.16-0.069-0.18-0.08c0.01-0.1,0.109-0.409,0.3-0.779      c0.189-0.471,0.54-0.91,0.59-1.891c0-0.06,0-0.14-0.01-0.239c-0.181-1.37-0.87-2.37-1.471-3.24      c-0.619-0.851-1.199-1.61-1.439-2.16c-0.62-1.41-1.07-2.84-1.63-4.61c-0.65-2.06-1.96-3.35-3.03-4.399      c-1.1-1.061-1.939-1.88-2.32-2.96c-0.43-1.16-0.239-2.04-0.35-3.471c-0.07-1.47-1.05-3.189-3.21-4.35      c-0.7-0.41-1.61-0.18-2.03,0.521c-0.05,0.09-0.149,0.18-0.45,0.51c-0.149,0.16-0.319,0.399-0.47,0.689      c-1.109,0.41-1.95,1.091-2.63,1.601c-0.85,0.68-1.47,0.97-1.6,0.93c-0.08-0.01-0.15,0-0.391-0.16      c-0.17-0.02-0.92-1.26-1.479-2.67c-0.63-1.42-1.2-2.99-2.28-4.17c-0.55-0.59-1.47-0.63-2.08-0.1      c-1.53,1.319-2.64,1.62-3.899,1.64c-1.771,0.05-3.971-0.91-6.79-1.38c1.13-2.34,1.909-4.9,1.92-7.94c0-0.12,0-0.22,0-0.33      c0-0.42-0.011-0.79-0.011-1.119c0-1.03,0.07-1.58,0.261-1.971c0.189-0.399,0.6-0.899,1.75-1.64c2.979-1.99,7.12-1.62,11.54-2.19      c0.279-0.04,0.529-0.05,0.77-0.06c1.061,0,1.95,0.32,3.05,0.74c1.08,0.41,2.38,0.939,4.021,0.939c0.12,0,0.229,0,0.34,0      c1.65-0.06,2.8-0.819,3.49-1.38c0.72-0.56,1.04-0.85,1.819-1.01c0.74-0.15,1.53-0.21,2.351-0.21      c3.529-0.021,7.7,1.21,11.79,1.22c0.31,0,0.63,0,0.95-0.02c0.81-0.04,1.439-0.721,1.42-1.53c0-0.17,0-0.34,0-0.49      c-0.021-1.439,0.189-2.29,0.35-2.47c0.12-0.15,0.15-0.29,1.18-0.32c0.34,0,0.78,0.03,1.301,0.101      c3.029,0.399,5.689,1.069,9.029,1.08c0.34,0,0.69-0.011,1.04-0.021c0.72-0.03,1.311-0.56,1.431-1.27      c0.06-0.41,0.09-0.811,0.09-1.21c-0.021-2.19-0.88-3.971-1.67-5.521c0.59-0.08,1.189-0.12,1.79-0.12c2.1,0,4.29,0.44,6.21,1.08      c4.05,1.35,8.02,2.07,12.31,2.07c0.59,0,1.19-0.021,1.79-0.04c0.55-0.021,1.03-0.34,1.28-0.83c0.359-0.71,0.54-1.45,0.54-2.15      c-0.03-1.76-0.98-2.939-1.62-3.87c-0.7-0.949-1.09-1.64-1.061-2.069c0-0.08,0.011-0.15,0.03-0.21      c0.061-0.28,0.13-0.38,0.82-0.801c0.609-0.369,1.74-0.85,2.42-2.189c0.28-0.59,0.399-1.22,0.399-1.79      c-0.079-2.13-1.279-3.6-1.31-4.23c-0.12-0.649-0.18-1.319-0.18-1.989c-0.03-4.38,2.51-9.49,3.83-14.351      c0.96-3.729,3.529-8.39,4.25-12.979c1.33,0.54,3.02,1.38,4.89,1.529c0.3,0.011,0.57,0.011,0.82,0.011      c0.71,0,1.29-0.04,1.92-0.28c0.46-0.17,0.939-0.55,1.2-1c0.68-1.37,0.369-2.13,0.63-3.44c0.02-0.369,0.67-1.88,1.319-3.25      c0.33-0.699,0.66-1.409,0.91-2.079c0.26-0.681,0.48-1.24,0.5-2c0-0.141-0.01-0.271-0.03-0.421c0,0-0.01-0.01-0.01-0.02      c4.36,0.96,8.53,4.3,13.96,5.11c2.61,0.39,3.09,0.84,3.73,1.6c0.649,0.81,1.31,2.48,3.06,4.57c1.08,1.25,2.41,1.8,3.47,2.319      c1.08,0.521,1.86,0.971,2.271,1.61c0.37,0.54,0.62,1.23,0.61,1.84c0,0.4-0.091,0.771-0.311,1.15      c-0.229,0.43-0.79,0.68-1.92,0.96c-1.02,0.29-2.58,0.51-3.65,2.05c-0.449,0.65-0.72,1.4-0.71,2.15      c0.051,1.729,1.15,2.699,1.94,3.46c0.84,0.77,1.56,1.46,1.76,1.939c0.92,1.99,2.28,5.62,2.471,7.67      c0.02,0.261,0.039,0.5,0.039,0.721c-0.029,1.43-0.399,1.97-1.1,2.869c-0.689,0.86-1.83,1.921-2.53,3.73      c-0.189,0.479-0.26,0.979-0.26,1.44c0.021,1.59,0.74,2.92,1.44,4.199c0.72,1.28,1.5,2.511,1.91,3.49      c1.909,4.58,4.6,9.5,6.01,13.82c0.109,0.34,0.33,0.63,0.63,0.81c0.35,0.21,0.61,0.3,0.95,0.44c0.33,0.13,0.64,0.24,0.85,0.31      c0.53,0.17,1.11,0.04,1.51-0.359c0.471-0.471,1.08-0.99,1.641-1.7c0.989,0.27,1.949,0.41,2.89,0.41c1.79,0,3.43-0.511,5.12-1.36      c0.27,0.5,0.35,0.99,0.46,1.72c0.14,1.07,0.22,2.67,1.36,4.25c1,1.41,2.59,2.03,4.02,2.03c0.03,0,0.061,0,0.09-0.01      c1.391-0.011,2.721-0.431,3.91-1.021c0.37,1.87,0.98,3.42,1.42,5.12c0.61,2.22,0.101,4.88,0.63,7.9      c0.601,2.979,2.41,5.529,3.12,7.8c0.23,0.71,0.94,1.14,1.68,1.01c0.16-0.02,0.301-0.04,0.44-0.04c0.74,0.01,1.43,0.32,2.19,1.03      c1.939,1.76,3.39,6.03,3.779,8.84c-0.27-0.11-0.55-0.22-0.83-0.36c-1.13-0.51-2.56-1.949-4.08-3.409      c-1.539-1.44-3.21-2.99-5.52-3.391c-0.28-0.05-0.56-0.069-0.83-0.069c-1.439-0.04-2.72,0.81-3.31,1.84      c-0.931,1.51-1.091,3.26-1.37,4.88c-0.23,1.62-0.58,3.08-1.05,3.63c-0.271,0.34-0.49,0.47-1,0.72      c-0.49,0.23-1.271,0.53-2.021,1.25c-1.6,1.53-1.9,3.101-2.53,4.811c-0.739,2.04-1.52,3.79-1.68,6.34      c-0.01,0.08-0.01,0.18-0.01,0.3c0.01,1.22,0.33,3.13,0.33,4.39c0,0.091-0.011,0.181-0.011,0.261c-0.979-0.061-2.14-0.2-3.3-0.2      c-0.62,0-1.26,0.04-1.91,0.21c-3.42,0.99-5.47,4.14-7.409,5.27c-1.73,1.141-3.96,2.03-5.771,3.92      c-1.149,1.171-1.67,2.421-1.649,3.511c0.02,0.91,0.199,1.449,0.229,1.91c-3.729,0.149-6.41,2.77-6.41,5.829      c-0.03,2.641,2.101,5.11,5.73,5.91c1.62,0.38,3.31,0.49,5.01,0.49c3.35,0,6.75-0.45,9.68-0.45c0.48,2.48,1.561,5.37,4.46,6.57      c0.601,0.22,1.19,0.28,1.74,0.28c1.57-0.021,3-0.46,3.92-0.44c0.33,0,0.561,0.05,0.71,0.11v0.01c0.11,0.07,0.42,0.37,0.72,0.69      c0.311,0.26,0.45,0.539,0.98,0.84c0.01,0,0.01,0,0.02,0.01c0.07,0.05,0.101,0.07,0.131,0.08c0.08,0.04,0.17,0.08,0.26,0.1      c0.01,0.01,0.01,0.01,0.01,0.01c0.021,0.011,0.04,0.011,0.061,0.021c0.17,0.05,0.46,0.14,0.8,0.229      c0.39,0.091,0.7,0.19,1.149,0.23c0.04,0.03,0.08,0.05,0.11,0.07c-0.05,0.22-0.17,0.63-0.4,1.199      c-1.319,3.2-3.97,5.16-7.239,6.301c-1.67,0.6-3.811,0.489-6.07,0.62c-1.57,0.09-3.33,0.39-4.86,1.39      c-1.239-0.34-2.64-0.311-4.41-0.33c-0.409,0-0.85,0-1.31,0c-1.08,0-2.2,0.1-3.2,0.1c-1.109,0.011-2.02-0.149-2.47-0.449      c-0.33-0.181-0.75-0.78-1.26-1.62c-0.521-0.811-1.2-1.92-2.57-2.54c-0.58-0.26-1.27-0.12-1.71,0.34      c-1.7,1.83-2.18,3.53-2.6,4.189c-0.221,0.341-0.301,0.431-0.601,0.601c-0.31,0.149-0.939,0.33-2.06,0.38      c-1.09,0.05-2.19,0.08-3.3,0.08c-2.2,0-4.44-0.08-6.69-0.08c-0.25,0-0.5,0-0.75,0c-1.47,0.01-2.87-0.01-4.271,0.63      c-1.42,0.63-2.479,2.021-3.01,3.92c-0.2,0.65-0.279,1.311-0.279,1.94c0.079,3.17,1.71,5.92,1.619,7.59      c0,0.27-0.029,0.5-0.09,0.71c-0.14,0.64-0.899,1.4-2.1,2.15c-1.18,0.76-2.62,1.439-3.811,2.399c-2.319,1.86-3.5,2.04-6.6,2.71      C558.211,759.429,557.301,759.929,556.451,760.349z",
                        "Tulchyn": "M565.881,569.799c1.181,0.01,2.44-0.46,3.37-1.4c0.59-0.58,1.08-1.31,1.49-2.189      c0.07,0.05,0.14,0.09,0.22,0.13c0.07,0.05,0.15,0.1,0.23,0.149c0.33,0.23,0.63,0.471,0.81,0.66c0.04,0.04,0.07,0.07,0.101,0.101      c-0.011,0.029-0.021,0.06-0.03,0.1c-0.17,0.63-0.75,1.89-1.32,3.12c-0.569,1.26-1.14,2.4-1.33,3.55      c-0.109,0.71-0.14,1.3-0.17,1.72c-0.02,0.17-0.029,0.301-0.04,0.41c-0.13,0.01-0.319,0.03-0.569,0.021      c-0.2,0-0.431,0-0.681-0.011c-1.39,0.011-3.649-1.529-6.14-1.949c-0.42-0.061-0.85,0.06-1.18,0.34      c-0.32,0.28-0.511,0.68-0.521,1.109c-0.04,4-3.03,9.4-4.34,14.181c-1.14,4.43-3.9,9.689-3.93,15.12      c0,0.85,0.069,1.699,0.239,2.56c0.431,1.72,1.33,2.95,1.25,3.66c0,0.18-0.029,0.32-0.109,0.5c-0.061,0.18-0.42,0.45-1.22,0.89      c-0.711,0.4-1.94,1.2-2.25,2.78c-0.061,0.26-0.091,0.55-0.091,0.82c0.03,1.739,0.98,2.89,1.62,3.81      c0.69,0.95,1.08,1.641,1.061,2.13c0,0.011,0,0.011,0,0.011c-0.21,0.01-0.41,0.01-0.61,0.01c-3.96,0-7.56-0.66-11.37-1.91      c-2.17-0.72-4.64-1.24-7.149-1.24c-1.471,0-2.96,0.18-4.4,0.62c-0.41,0.12-0.75,0.42-0.93,0.81      c-0.181,0.391-0.181,0.841-0.011,1.23c0.96,2.08,2.03,3.83,2.2,5.47c-2.71-0.05-5.109-0.62-8.16-1.04      c-0.62-0.08-1.18-0.13-1.71-0.13c-1.42-0.04-2.899,0.431-3.689,1.67c-0.59,0.95-0.76,1.971-0.82,3.16      c-3.34-0.11-7.28-1.2-11.18-1.22c-0.98,0-1.96,0.08-2.931,0.27c-1.529,0.28-2.489,1.12-3.09,1.59      c-0.649,0.48-0.87,0.671-1.75,0.74c-0.069,0-0.149,0-0.229,0c-0.98,0-1.84-0.31-2.95-0.74c-1.09-0.409-2.43-0.93-4.12-0.939      c-0.38,0-0.78,0.03-1.189,0.09c-3.86,0.59-8.551-0.02-12.75,2.64c-1.36,0.87-2.301,1.761-2.82,2.87      c-0.53,1.11-0.55,2.181-0.55,3.261c0,0.369,0,0.729,0,1.119c0,0.11,0,0.21,0,0.32c-0.021,2.97-0.851,5.28-2.15,7.69      c-2.64-0.03-5.25-0.29-8.06-0.32c-2.71,0-5.66-1.06-8.87-1.3c-0.11-3.351-0.88-5.69-3.33-8.24c-1.19-1.3-2.19-1.97-3.23-2.28      c-0.66-0.189-1.18-0.27-1.83-0.439c0.07-0.521,0.11-1.07,0.11-1.62c0-0.49-0.03-0.99-0.12-1.48c-0.09-0.54-0.46-0.97-0.96-1.159      c-0.939-0.33-1.93-0.4-2.99-0.4c-2.52,0-5.55,0.47-7.87,0.46c-0.949,0.01-1.77-0.08-2.29-0.24      c-0.539-0.17-0.659-0.33-0.699-0.42c-0.311-0.62-1-0.95-1.67-0.8c-3.011,0.689-5.04,1.63-7.811,1.62c-0.22,0-0.43,0-0.66-0.021      c-0.46-0.02-0.91-0.029-1.33-0.029c-0.95,0-1.8,0.04-2.58,0.04c-1.23-0.011-2.27-0.08-3.45-0.48c0.33-0.729,0.96-1.63,1.78-2.49      c1.23-1.33,2.73-2.58,3.77-3.52c2-1.87,4.689-4.891,6.34-5.78c0.51-0.29,0.8-0.83,0.76-1.41c-0.149-2-1.149-4.08-2.5-5.85      c-1.37-1.71-3.02-3.25-5.26-3.33c-1.05-0.021-1.99,0.439-2.73,1.21c-0.21-0.89-0.35-1.99-0.79-3.1      c-1.05-2.591-2.62-4.54-4-6.561c-1.29-1.81-2.05-4.899-3.59-7.16c-0.93-1.31-2.14-2.029-3.15-2.55      c-1.03-0.53-1.85-0.93-2.41-1.46c-0.55-0.5-1.08-1.53-1.63-2.74c-0.57-1.189-1.17-2.56-2.36-3.67      c-2.46-2.24-5.34-2.109-8.02-2.13c-0.07-0.01-0.11-0.01-0.12-0.01c-3.39,0.05-6.19,1.38-8.67,1.34c-0.07,0-0.13,0-0.18,0      c-0.86-0.02-1.62-0.4-2.6-0.97c-0.95-0.53-2.12-1.3-3.77-1.32c-0.15,0-0.27,0.01-0.38,0.021c-0.59,0.039-1.1,0.43-1.3,0.989      c-0.16,0.48-0.55,0.98-1.1,1.65c-0.11,0.14-0.22,0.28-0.34,0.439c-0.31-0.56-0.62-1.26-0.95-2.05c-0.74-1.66-1.7-3.76-3.99-4.95      c-0.4-0.199-0.82-0.359-1.24-0.489c-1.32-2.261-2.26-5.58-2.22-8c-0.01-0.49,0.03-0.931,0.09-1.301c0.19-1.319,1-2.84,1.03-4.92      c0-0.399-0.04-0.8-0.11-1.199c-0.12-0.62-0.2-1.021-0.32-1.41c-0.12-0.58-0.72-1.3-1.07-1.48c-0.32-0.229-0.52-0.34-1.06-0.84      c-3.42-3.15-8.71-8.59-8.58-13c0-0.86,0.16-1.689,0.56-2.54c0.78,0.01,1.58,0.4,2.62,0.98c1.04,0.56,2.32,1.33,4.05,1.35      c0.14,0,0.25-0.01,0.32-0.01c0.76-0.03,1.38-0.61,1.45-1.37c0.01-0.14,0.01-0.26,0.01-0.36c-0.02-1.38-0.57-2.5-0.99-3.55      c-0.45-0.979-0.77-1.91-0.76-2.189c0.12-0.061,0.32-0.11,0.62-0.11c0.74-0.01,1.99,0.34,3.31,0.76      c1.33,0.41,2.74,0.88,4.22,0.89c0.35,0,0.71-0.029,1.06-0.1c0.45-0.09,0.82-0.37,1.03-0.77c0.33-0.62,0.51-1.28,0.51-1.94      c-0.01-1.34-0.73-2.36-1.48-3.09c-1.15-1.11-2.57-1.9-3.62-2.72c-1.1-0.82-1.54-1.48-1.5-1.881c0-0.159,0.04-0.369,0.2-0.68      c0.09-0.149,0.07-0.17,0.7-0.37c0.54-0.17,1.67-0.29,2.54-1.42c0.74-0.979,0.84-2.109,0.81-2.8c0-0.16,0-0.3,0-0.41      c0-0.29,0.01-0.53,0.05-0.79c0.29-2.18,0.34-4.399,0.34-6.62c0.83-0.14,1.59-0.35,2.25-0.689c2.49-1.5,3.24-4.221,4.14-6.5      c0.86-2.36,1.79-4.181,3.03-4.62c0.34-0.15,0.53-0.17,0.67-0.17c0.19,0,0.39,0.06,0.88,0.33c0.49,0.25,1.2,0.67,2.18,0.92      c1.01,0.25,2.07,0.38,3.16,0.38c1.17,0,2.38-0.15,3.59-0.46c2.45-0.66,4.08-1.22,6.02-1.22c0.77,0,1.61,0.09,2.6,0.31      c2.96,0.63,5.06,1.58,8.45,1.59c0.28,0,0.58-0.01,0.9-0.02c0.43-0.021,0.83-0.23,1.1-0.57s0.38-0.78,0.3-1.2      c-0.25-1.399-0.86-2.35-1.22-2.95c-0.37-0.63-0.48-0.819-0.5-1.47c0-0.29,0.04-0.67,0.16-1.189c0.51-2.36,2.63-4.79,3.53-7.971      c0.02-0.06,0.02-0.13,0.03-0.199c0.81-1.15,1.34-1.301,1.96-1.33c0.78-0.03,2.04,0.569,3.33,1.51c1.3,0.92,2.59,2.07,3.88,2.859      c1.76,1.021,5.57,2.87,8.55,2.94c0.42-0.01,0.85-0.04,1.29-0.18c1.739-0.601,2.609-2.021,3.449-3.3      c0.37-0.61,0.721-1.23,1.03-1.771c1.82,1.72,3.74,3.45,5.3,5.12c1.34,1.51,1.46,2.21,1.5,3.64c0.01,0.761-0.08,1.7-0.14,2.87      c-0.021,0.18-0.021,0.38-0.021,0.57c0.08,6.54,5.57,10.859,9.881,14.12c3.22,2.42,3.92,3.58,6.42,7.09      c0.27,0.38,0.72,1.16,1.21,1.93c0.51,0.78,0.979,1.53,1.75,2.141c0.939,0.729,1.899,0.939,2.449,1.079      c0.58,0.16,0.721,0.19,1.08,0.53c1.92,1.891,2.71,5.45,2.82,8.37c0.08,2.521,1.07,4.53,2.61,5.88      c1.529,1.36,3.43,2.13,5.5,2.851c0.87,0.29,1.66,0.449,2.41,0.449c2.119,0.021,3.42-1.38,4.189-2.35      c0.85-1.02,1.46-1.78,2.61-2.18c1.01-0.45,2.779,0.029,5.05-0.771c1.1-0.45,1.87-1.2,2.61-1.77      c0.689-0.61,1.359-0.94,1.399-0.91c0.04,0,0.07,0,0.141,0c0.359,0.01,0.479,0.08,0.899,0.5c0.4,0.399,0.83,1.1,1.61,1.78      c0.01,0,0.029,0.02,0.1,0.13c0.24,0.279,0.47,1.16,1.53,1.92c0.479,0.28,0.87,0.319,1.18,0.319c0.58-0.02,1.021-0.13,1.22-0.17      c1.711,0.86,3.141,2.08,4.801,3.21c1.72,1.171,3.8,2.221,6.51,2.21c0.04,0,0.08,0,0.13,0c1.65-0.05,3.04-0.47,4.18-0.449      c0.261,0,0.511,0.01,0.74,0.05c1.49,0.21,2.98,1.52,5.38,2.2c0.851,0.22,1.67,0.319,2.431,0.319      c3.64-0.08,5.699-1.93,8.119-2.149c0.37-0.05,0.69-0.07,0.99-0.07c1.021,0.021,1.5,0.21,1.99,0.6      c0.01,0.221,0.05,0.44,0.16,0.65c0.21,0.43,0.6,0.7,1.03,0.79c0.229,0.37,0.479,0.78,0.75,1.271      c0.659,1.1,0.989,2.96,2.479,4.569c3.75,3.78,10.68,4.771,14.521,6.42c1.34,0.521,3.689,2.57,6.069,4.5      C560.521,567.759,562.991,569.719,565.881,569.799z",
                        "Tyvriv": "M322.991,500.349c-0.71,0.53-1.26,0.78-1.37,0.74c-0.01,0-0.03,0-0.04,0      c-1.08-0.061-1.59-0.66-2.16-2.12c-0.51-1.42-0.66-3.34-0.74-4.72c-0.04-0.67-0.52-1.23-1.17-1.37      c-0.35-0.08-0.7-0.12-1.04-0.12c-2.06,0.08-3.2,1.05-4.08,1.1c-0.4,0.07-0.75,0.28-0.99,0.61c-0.24,0.34-0.33,0.74-0.26,1.14      c0.02,0.11,0.03,0.221,0.03,0.351c0.02,0.739-0.46,1.819-1.26,2.67c-0.79,0.859-1.84,1.42-2.56,1.46      c-0.15,0.02-0.3,0.02-0.46,0.02c-2.54,0.03-4.36-1.989-5.75-4.45c-1.81-3.21-3.94-5.479-5.54-7.689      c-1.6-2.24-2.7-4.311-2.87-7.46c-0.03-0.71-0.05-1.42-0.05-2.12c0-1.17,0.04-2.35,0.04-3.51c0.01-3.48-0.31-7.12-2.98-10.44      c-1.71-2-3.52-2.609-4.37-3.93c-0.73-0.98-1.09-2.3-1.56-3.79c0.33-0.08,0.64-0.25,0.86-0.54c4.52-5.95,6.97-14.23,7.06-21.54      c0.04-5.34,1.65-9.57,1.67-15.19c0-0.03,0-0.08,0-0.15v-0.04c0.01-2.35,1.17-3.78,2.8-5.67c1.57-1.82,3.59-4.04,3.86-7.58      c0.05-0.55,0.06-1.09,0.06-1.62c0-2.62-0.39-5.08-0.39-7.42c-0.01-2.07,0.66-3.69,1-5.83c0.19-1.28,0.32-2.91,0.32-4.6      c-0.01-2.43-0.22-4.93-1.09-6.85c-0.62-1.23-1.6-1.98-2.36-2.8c-0.79-0.8-1.18-1.53-1.13-1.71c0-0.06,0.01-0.11,0.06-0.21      c0.09-0.07,0.66-0.27,1.37-0.35c0.78-0.12,1.63-0.13,2.57-0.5c1.61-0.67,3.21-1.84,4.51-3.28c1.29-1.45,2.32-3.17,2.42-5.14      c0-0.11,0.01-0.21,0.01-0.34c0.02-0.91-0.18-1.7-0.49-2.41c0.02-0.05,0.05-0.1,0.07-0.15c0.41-1.3,1.33-2.24,2.49-3.18      c1.16-0.94,2.56-1.88,3.91-3.18c1.86-1.91,2.42-4.09,3.02-6.04c0.46-1.54,0.92-2.53,1.25-3.01c0.1-0.14,0.17-0.23,0.23-0.29      c0.11,0.07,0.28,0.2,0.49,0.43c1.1,1.08,2.56,3.65,4.45,5.55c0.45,0.44,1.12,0.56,1.69,0.29c2.65-1.23,5.12-3.42,7.13-5.2      c0.77-0.7,1.51-1.73,2.31-2.65c0.39-0.46,0.78-0.87,1.08-1.13c0.15-0.12,0.29-0.21,0.36-0.26c0.03-0.01,0.04-0.02,0.05-0.02      c0.04-0.01,0.07-0.01,0.1-0.01c0.42-0.01,1.08,0.31,1.86,1.23c1.17,1.35,2.33,3.75,3.29,6.09c0.96,2.36,1.73,4.62,2.43,6.03      c1.04,2.23,2.49,3.38,3.94,3.81c1.4,0.44,2.49,0.5,4.15,1.37c1.42,0.73,1.99,1.2,2.25,1.61c0.27,0.39,0.46,1.07,0.61,2.54      c0.25,2.26-0.21,4.19,1.44,6.96c1.5,2.49,3.93,4.95,5.51,6.85c0.37,0.44,0.96,0.63,1.52,0.48c0.56-0.14,0.99-0.59,1.1-1.16      c0.28-1.29,0.86-1.89,1.82-2.4c0.96-0.49,2.33-0.7,3.68-0.7c2.07-0.02,3.81-0.13,5.47-0.74c1.66-0.61,3.09-1.73,4.45-3.42      c1.52-1.9,2.97-4.4,4.61-6.36c1.67-1.99,3.36-3.24,5.24-3.22c0.54,0,1.14,0.09,1.81,0.33c2.76,0.96,4.13,3.75,4.71,7.16      c0.17,1,0.04,1.55,0.16,2.59c0.12,1.07,0.71,2.17,1.88,3.38c0.85,0.88,1.83,1.48,2.64,2.1c0.82,0.6,1.39,1.19,1.57,1.66      c0.33,0.8,0.43,1.81,0.43,3.01c0,0.74-0.04,1.55-0.04,2.4c0,1.39,0.09,2.92,0.67,4.47c0.15,0.37,0.32,0.74,0.49,1.08      c0.5,1.05,1.07,1.97,1.58,2.83c0.08,0.24,0.2,0.45,0.37,0.62c0.63,1.07,1.11,2.03,1.23,2.98c0.02,0.18,0.03,0.37,0.02,0.55      c0,0.03,0,0.07,0,0.1c-1.03,0.59-2.02,1.27-2.86,2.05c-1.02,0.96-1.91,2.16-1.94,3.76c0.03,2.02,1.53,3.61,3.99,4.86      c1.16,0.55,2.09,0.4,2.73,0.49c0.69,0.09,0.73,0.14,0.83,0.29c0.13,0.24,0.17,0.41,0.17,0.58c0.03,0.43-0.45,1.04-1.08,1.18      c-0.74,0.17-1.23,0.86-1.15,1.61c0,0.09,0.01,0.18,0.01,0.26c-0.01,0.61-0.23,1.09-0.74,1.71c-0.77,0.92-2.19,1.85-3.53,2.93      c-1.29,1.06-2.75,2.48-2.78,4.69c0,0.71,0.16,1.43,0.48,2.15c1.03,2.14,3.16,2.99,4.98,3.96c0.92,0.46,1.79,0.9,2.39,1.29      c0.31,0.2,0.54,0.38,0.68,0.52c0.09,0.091,0.14,0.15,0.16,0.19c-0.07,0.33-0.77,1.68-1.67,2.79c-1,1.37-2.05,2.52-2.59,3.63      c-1.21,2.97-0.54,6.05-1.32,7.51c-0.23,0.58-1.05,1.33-2.15,2.19c-1.07,0.86-2.39,1.87-3.23,3.49      c-0.68,1.319-0.98,2.66-0.98,3.92c0.02,2.5,1.05,4.59,1.94,6.479c0.9,1.87,1.64,3.54,1.64,5.011      c-0.05,0.02-0.07,0.029-0.09,0.02c-0.65,0.13-1.14,0.67-1.2,1.34c-0.02,0.26-0.03,0.57-0.03,0.91c0,1.62,0.21,4.24,0.75,6.6      c0.28,1.181,0.62,2.29,1.14,3.23c0.29,0.52,0.7,1.09,1.28,1.479c-0.12,1.021-0.19,2.061-0.19,3.101      c0,1.81,0.22,3.649,0.78,5.479c0.21,0.67,0.85,1.11,1.55,1.051c0.09-0.011,0.19-0.011,0.3-0.011c0.2,0,0.42,0.011,0.67,0.03      c-0.88,1.78-2.23,3.79-2.86,6.25c-0.16,0.69-0.24,1.31-0.24,1.88c-0.02,1.351,0.53,2.37,0.93,3.021      c0.02,0.04,0.05,0.08,0.07,0.12c-2.01-0.211-3.69-0.851-6.39-1.461c-1.18-0.25-2.25-0.369-3.24-0.369      c-2.55,0.01-4.5,0.72-6.78,1.31c-0.96,0.26-1.91,0.37-2.83,0.37c-0.85,0-1.67-0.1-2.42-0.29c-0.54-0.13-0.95-0.36-1.5-0.66      c-0.54-0.29-1.3-0.68-2.3-0.68c-0.59,0-1.2,0.13-1.83,0.399c-2.81,1.24-3.76,4.021-4.67,6.33c-0.86,2.4-1.75,4.44-2.82,4.94      c-0.38,0.3-2.81,0.62-5.22,0.58c-2.81,0-5.84-0.24-7.25-0.36c-2.79-0.22-7.47-1.08-8.92-2.34c-1.24-1.01-1.45-1.87-1.77-2.94      c-0.16-0.529-0.28-1.13-0.78-1.81c-0.49-0.71-1.52-1.14-2.41-1.1c-0.79,0-1.63,0.189-2.71,0.529c-1.49,0.48-2.59,0.96-3.34,1.99      c-0.73,1.07-0.7,2.14-0.71,3.18c0,0.28,0,0.58,0,0.91c0,0.15,0,0.311,0,0.48c-0.88,0.16-1.96,0.29-2.98,0.29      c-1.71,0.029-3.05-0.46-3.28-0.95c-0.14-0.21-0.17-0.34-0.18-0.6c0-0.03-0.01-0.07-0.01-0.11c0-0.82,0.91-2.351,0.98-4.4      c0.01-0.87-0.24-1.85-0.86-2.71c-0.76-1.09-1.85-1.85-3.04-1.83C324.571,499.119,323.721,499.879,322.991,500.349z",
                        "Yampil": "M335.491,713.389c-0.02,0.15-0.02,0.29-0.01,0.39c0,0.07,0,0.13,0,0.19c0.01,0.59-0.12,0.79-0.15,1.58      c-0.02,0.53,0.23,1.24,0.61,1.7c0.37,0.479,0.83,0.89,1.52,1.47c1.19,0.99,2.49,1.76,3.42,2.61      c0.94,0.859,1.45,1.609,1.53,2.729c0,0.04,0,0.1,0,0.15c0.01,0.819-0.42,1.6-1.15,2.68c-0.7,1.06-1.67,2.38-1.8,4.27      c-0.06,0.771,0.49,1.45,1.25,1.57c1.79,0.3,4.46,0.59,6.57,1.36c1.05,0.38,1.92,0.87,2.46,1.41c0.53,0.56,0.79,1.08,0.81,1.949      c0,0.04-0.01,0.08-0.01,0.12c-0.54,0.16-0.95,0.601-1.05,1.16c-0.66,3.38-1.23,5.93-1.24,9.021c0,0.88,0.05,1.8,0.16,2.79      c0.06,0.58,0.08,1.18,0.08,1.81c0,1.36-0.11,2.82-0.11,4.34c0,0.34,0.01,0.681,0.02,1.04c0.12,2.2,0.81,4.53,0.79,6.26      c0,0.391-0.03,0.73-0.09,1.051c-0.08,0.529-0.76,1.54-1.56,2.56c-0.74,1.07-1.72,2.11-1.79,3.82c-0.02,0.83,0.4,1.739,1.07,2.33      c0.66,0.6,1.51,1.02,2.61,1.39c3.16,1,6.18,0.73,8.66,1.6c2.65,0.881,5.5,2.21,8.7,2.65c0.08,0.84,0.17,1.58,0.17,2.24      c0,0.439-0.04,0.87-0.14,1.29c-0.11,0.5,0.04,1.02,0.39,1.38c0.36,0.359,0.87,0.52,1.37,0.42c0.16-0.03,0.3-0.04,0.42-0.04      c0.69,0,1.26,0.39,1.95,1.5c0.17,0.27,0.27,0.479,0.34,0.62c-0.06,0.1-0.13,0.24-0.2,0.41c-0.18,0.43-0.29,0.979-0.29,1.64      c0,0.08,0.01,0.19,0.01,0.33c0.04,2.03,1.47,3.29,2.33,3.85c0.44,0.311,0.77,0.54,0.89,0.681c0.12,0.149,0.07,0.05,0.09,0.14      c0,0.021-0.01,0.08-0.03,0.18c-0.1,0.53,0.1,1.04,0.47,1.38c0,0.051,0,0.101,0,0.15c0,0.65,0.06,1.28,0.1,1.9      c-0.31,0.01-0.63,0.01-0.95,0.01c-0.6,0-1.2,0-1.8,0c-0.89,0-1.79,0-2.71,0.05c-0.79,0.05-1.41,0.7-1.42,1.5      c0,3.66-0.03,7.311-0.04,11.19c-2.88,0.33-5.68,1.199-7.9,3.3c-2.21,2.32-3.27,4.79-4.33,5.56c-0.06,0.07-0.47,0.32-1.09,0.63      c-0.62,0.33-1.45,0.7-2.34,1.601c-0.97,0.97-1.59,2.17-1.87,3.229c-0.42,1.601-0.33,2.75-0.45,3.46      c-0.12,0.73-0.18,1.03-0.78,1.75c-0.93,1.07-1.94,1.74-3.25,2.74c-1.28,0.98-2.85,2.44-3.82,4.69      c-0.74,1.64-1.13,3.22-1.12,4.75c0.03,2.569,0.92,4.359,1.63,6.46c0.84,2.27,2.49,6.71,2.44,8.93c0,0.49-0.08,0.8-0.11,0.86      c-0.05,0.26-1.16,1.529-2.65,2.34c-1.47,0.87-3.28,1.42-4.32,1.399c-0.39,0-0.65-0.06-0.77-0.109      c-0.93-0.271-2.9-2.43-4.39-5.18c-1.55-2.73-2.86-5.83-3.82-7.91c-3.01-6.42-3.25-13.681-3.24-21.641c0-0.609,0-1.22,0.01-1.819      c0-0.021,0-0.03,0-0.04c0.01-4.04-1.11-6.33-2.08-9.21c-0.08-0.19-0.21-1.07-0.39-2.11c-0.22-1.03-0.44-2.39-1.65-3.79      c-0.9-1.04-2.35-1.97-3.88-1.94c-1.01,0.011-1.62,0.28-1.91,0.36c-0.14,0.05-0.22,0.07-0.25,0.07      c-0.17-0.021-0.34-0.03-0.51-0.03c-0.49-0.729-1.29-1.229-2.21-1.32c-0.02,0-0.1-0.01-0.31-0.01      c-2.32,0.04-4.03,1.101-5.43,2.17c-1.39,1.101-2.51,2.34-3.32,3.37c-1.74,2.14-2.36,4.51-2.54,6.4      c-0.19,1.93-0.15,3.43-0.46,4.85c-0.29,1.87-2.95,5.11-5.29,6.811c-0.5,0.38-0.89,0.63-1.14,0.76c-0.26-0.28-0.7-0.8-1.22-1.51      c-2.51-3.24-4.52-6.671-4.44-9.2c0.03-1.431,0.42-2.74,1.97-4.46c1.89-2.061,4.44-3.71,7.19-5.61c2.74-1.91,5.71-4.11,7.96-7.52      c1.24-1.86,1.85-3.98,1.85-6.051c0-1.46-0.29-2.88-0.8-4.229c0.28-0.43,0.53-0.851,0.76-1.29c0.48-0.9,0.83-1.99,0.83-3.14      c-0.06-2.221-0.99-3.62-1.98-5.421c-0.69-1.149-0.86-2.109-1.91-3.609c-0.54-0.73-1.45-1.46-2.44-1.82      c-0.99-0.38-1.99-0.5-3.1-0.51c-0.16-0.01-0.35-0.01-0.55-0.01c-4.64,0.01-9.33,0.779-13.42,0.76      c-3.25-0.01-5.71,0.47-7.78,1.68c-2.03,1.2-3.36,2.61-5.48,4.38c-2.3,1.94-5.05,4.591-7.96,6.7c-2.89,2.15-5.88,3.57-8.08,3.521      c-0.85,0-1.61-0.16-2.41-0.551c-0.43-0.239-0.28-0.159-0.35-0.25c-0.07-0.1-0.24-0.609-0.44-1.55      c-0.45-1.859-0.52-3.84-1.34-6.3c-0.35-0.99-0.76-1.61-0.98-2.05c-0.11-0.21-0.18-0.37-0.21-0.45      c-0.01-0.03-0.01-0.05-0.02-0.06c0-0.04,0-0.061,0-0.07c-0.01-0.43,0.18-1.37,0.46-2.51c0.26-1.15,0.6-2.53,0.6-4.13      c0-0.19,0-0.33,0-0.431l-0.01-0.09c-0.19-2.92-0.65-6.83-3.54-9.89c-1.85-1.88-3.9-3.141-6.28-3.16      c-2.55,0.02-4.43,1.5-5.68,2.97c-1.92,2.28-3.19,5.11-4.45,7.601c-1.18,2.47-2.55,4.56-3.04,4.79      c-1.63,1.149-2.68,1.449-3.5,1.449c-0.81,0-1.81-0.31-3.35-1.39c-1.46-1-2.14-1.6-2.16-1.68c0,0-0.01,0-0.03-0.13      c-0.02-0.131-0.04-0.391-0.04-0.771c0-0.44,0.03-1.04,0.06-1.77c0.29-5.71,0.3-11.301,0.34-16.921      c-0.01-2.109,0.73-5.149,0.76-8.489c0-1.681-0.22-3.511-1-5.311c-0.82-1.819-2.16-3.1-3.68-4.29c-0.77-0.58-1.61-1.12-2.48-1.64      c0.88-1.33,1.54-2.88,2.05-4.271c0.33,0.2,0.72,0.48,1.1,0.801c1.01,0.699,1.91,1.71,3.64,1.81c1.15,0.05,2.24-0.87,2.66-1.91      c0.25-0.569,0.32-1.13,0.32-1.66c-0.02-1.649-0.64-3.35-1.19-5.029c-0.54-1.561-1.01-3.12-1.03-3.84c0-0.04,0-0.08,0-0.11      c0.02-1.36,0.52-2.26,1.25-3.5c0.71-1.2,1.67-2.7,1.77-4.84c0-0.12,0-0.24,0-0.351c0-1.229-0.23-2.59-0.22-3.649      c-0.01-0.66,0.11-1.15,0.19-1.26c0.03-0.04,0.03-0.04,0.03-0.04s0.07-0.04,0.28-0.04c0.3-0.011,0.87,0.09,1.68,0.409      c0.31,0.12,0.52,0.221,0.64,0.29c0.01,0.011,0.03,0.021,0.04,0.03c0,0.03,0,0.061,0,0.101c0,0.239-0.04,0.729-0.04,1.369      c0,0.391,0.02,0.841,0.08,1.36c0.1,0.73-0.02,1.53,0.28,2.6c0.16,0.53,0.57,1.16,1.19,1.521c0.61,0.37,1.27,0.49,1.99,0.51      c0.06,0,0.07,0,0.09,0c1.32,0,2.41-0.66,3.19-1.41c1.17-1.149,1.96-2.609,2.74-3.83c0.74-1.239,1.53-2.119,1.92-2.229      c0.7-0.3,1.27-0.4,1.75-0.4c1,0,1.78,0.431,2.69,1.37c1.33,1.41,2.54,3.88,3.84,6.22c1.33,2.301,2.73,4.671,5.37,5.53      c0.29,0.09,0.39,0.16,0.75,0.33c0.35,0.18,0.95,0.36,1.57,0.36c0.29,0.01,0.58-0.061,0.84-0.21c0.36-0.221,0.61-0.561,0.7-0.971      c0.19-1.069,1.02-2.46,1.06-4.369c0.01-0.721-0.16-1.521-0.55-2.261c-0.68-1.33-1.71-1.989-2.35-2.5      c-0.67-0.54-0.99-0.83-1.22-1.55c-0.15-0.52-0.23-1.04-0.23-1.5c0.03-1.3,0.48-2.22,1.6-2.88c0.65-0.36,1.14-0.47,1.65-0.47      c1.37-0.07,3.12,1.13,5.6,1.71c0.45,0.09,0.92-0.03,1.27-0.33s0.55-0.75,0.53-1.21c-0.1-2.07-0.62-3.891-0.97-5.53      c-0.22-0.93-0.66-1.81-1.04-2.71c-0.35-0.75-0.61-1.56-0.63-1.75v-0.02c0.06-0.601,0.18-0.94,0.24-1.091      c0.39,0,1.56,0.44,3.02,0.471c0.52,0,1.08-0.07,1.66-0.261c1.38-0.489,2.15-1.43,2.76-2.029c0.63-0.65,0.98-0.811,1.03-0.771      c0.07,0,0.35,0.021,0.96,0.521c0.82,0.64,1.34,1.949,1.93,3.649c0.6,1.65,1.34,3.681,3.27,5.16c1.17,0.89,2.75,2.22,4.49,3.351      c1.74,1.119,3.64,2.119,5.75,2.149c2.43,0.061,4.7-1.72,5.75-4.96c0.34-0.96,0.52-1.87,0.52-2.729c0.02-2-1.02-3.62-2.32-4.65      c-1.96-1.57-4.51-2.37-6.66-3.3c-2.19-0.9-3.73-1.931-4.07-3c-0.07-0.21-0.11-0.431-0.11-0.67c-0.09-1.32,1.36-3.4,1.78-5.87      c0.06-0.431,0.08-0.82,0.08-1.181c0.02-1.189-0.35-2.149-0.72-2.84c-0.37-0.699-0.69-1.199-1-2.09      c-0.32-0.92-0.43-1.62-0.43-2.08c0.02-0.66,0.15-0.74,0.27-0.85c0.13-0.12,0.54-0.28,1.21-0.271      c0.97-0.01,2.33,0.301,3.63,0.761c1.83,0.649,3.11,1.13,5.43,1.18c0.12,0,0.22,0,0.31,0c1.76,0.01,3.11-0.44,4.21-0.9      c1.11-0.46,1.98-0.89,3.17-1.149c0.4-0.08,0.71-0.101,1.04-0.101c0.35,0,0.73,0.03,1.21,0.03c0.94,0.021,2.19-0.24,3.52-1.13      c0.62-0.4,1.14-0.82,1.61-1.24c0.15,0.08,0.32,0.13,0.49,0.15c0.19,0.02,0.36,0,0.53-0.04c0.31,0.979,0.59,2.13,1.29,3.58      c0.74,1.55,1.84,2.45,2.83,2.83c0.97,0.409,1.59,0.51,2.53,1.13c0.63,0.42,0.87,0.7,0.92,0.8c0.05,0.09,0.05,0.03,0.06,0.29      c0,0.17-0.03,0.49-0.03,0.92c0,0.47,0.05,1.09,0.25,1.77c0.51,1.69,1.48,3.24,2.27,4.591c-0.91,0.909-1.64,1.979-2.2,3      c-0.6,1.199-1.05,1.55-1.15,2.79c0.01,0.79,0.4,1.31,0.64,1.64c0.27,0.35,0.56,0.7,0.96,1.28c0.33,0.47,1.04,1.43,1.86,2.38      c0.87,0.95,1.59,1.85,2.78,2.37c0.5,0.199,1.01,0.29,1.5,0.29c2.33-0.13,3.38-1.511,4.84-1.95c2.69-1.03,9.14-3.53,12.27-3.48      c0.41,0,0.74,0.04,0.95,0.101c1.49,0.43,2.13,1.109,2.64,2.13c0.48,1.02,0.66,2.47,0.65,4.05c0,0.62-0.02,1.26-0.05,1.9      c-2.42,0.96-4.76,2.93-5.02,6.029c0,0-0.01,0.061-0.01,0.16c0.03,1.08,0.55,1.65,0.8,2.03c0.08,0.11,0.14,0.2,0.19,0.27      c-0.05,0.131-0.12,0.29-0.19,0.44c-0.06,0.14-0.12,0.27-0.18,0.4c-0.03,0.069-0.06,0.13-0.09,0.22      C335.561,713.139,335.521,713.179,335.491,713.389z",
                        "Zhmerynka": "M253.371,339.849c0.38,0,0.76-0.04,1.15-0.13c0.63-0.14,1.09-0.67,1.16-1.32      c0.21-1.44,0.85-1.72,1.67-1.79c0.48,0.02,0.96,0.18,1.35,0.54c-2.76,0.91-4.59,3.35-4.53,6.21c0,0.67,0.09,1.36,0.27,2.06      c0.44,1.7,1.5,4.39,3.01,6.83c1.54,2.36,3.42,4.74,6.38,4.86c0.19,0,0.36-0.01,0.51-0.03c0.61-0.06,1.12-0.5,1.29-1.08      c0.56-2,0.47-3.67,0.61-4.96c0.16-1.3,0.38-2.16,1.49-3.35c1.26-1.3,2.15-1.62,2.98-1.63c0.94-0.02,2.19,0.55,3.72,1.69      c1.33,0.95,2.56,2.63,4.32,3.99c0.94,0.72,1.74,1.13,2.46,1.4c0.72,0.28,1.3,0.43,2.12,0.79c4.42,1.81,7.95,6.18,13.89,7.56      c1.83,0.4,3.85,0.63,5.22,1.2c1.37,0.65,1.89,1.05,1.97,2.67c0,0.05-0.01,0.14-0.01,0.26c-0.02,0.84-0.64,2.1-1.65,3.22      c-0.99,1.11-2.33,2.07-3.42,2.51c-0.16,0.1-1.19,0.21-2.24,0.36c-1,0.19-2.43,0.4-3.26,1.94c-0.23,0.48-0.36,1.02-0.36,1.53      c0.06,1.77,1.13,2.86,1.97,3.78c0.88,0.88,1.71,1.73,1.8,2.01c0.53,1.07,0.83,3.38,0.81,5.57c0,1.54-0.12,3.05-0.28,4.15      c-0.24,1.64-1.02,3.57-1.04,6.28c0.01,2.65,0.4,5.11,0.39,7.42c0,0.47-0.01,0.93-0.05,1.39c-0.19,2.43-1.5,3.95-3.15,5.85      c-1.59,1.84-3.53,4.11-3.52,7.63c0,0,0,0.03,0,0.12c0,0.02,0,0.04,0,0.07c0.02,4.96-1.58,9.209-1.67,15.15      c-0.06,6.36-2.2,13.78-5.9,19.021c-0.24-0.021-0.47-0.03-0.69-0.03c-0.37-0.15-0.81-0.16-1.2,0.02      c-0.01,0.011-0.02,0.021-0.04,0.03c-0.49,0.03-0.95,0.06-1.34,0.06c-0.52,0-0.89-0.069-1.05-0.149      c-0.62-0.25-1.52-1.3-2.17-2.641c-0.67-1.319-1.16-2.869-1.38-3.899c-0.11-0.5-0.47-0.91-0.96-1.09      c-0.48-0.181-1.03-0.09-1.43,0.229c-1.09,0.86-2.26,1.721-3.23,2.84c-0.97,1.101-1.75,2.57-1.74,4.33      c0,0.4,0.03,0.83,0.12,1.271c0.23,1,0.72,1.56,1.15,2.33c0.45,0.7,0.86,1.45,0.92,1.76c0.35,1.37,0.76,2.86,0.76,4.1      c0,0.351-0.03,0.67-0.09,0.971c-0.42,1.909-1,2.699-1.82,3.449c-0.82,0.75-2.04,1.4-3.45,2.521c-1.51,1.25-2.22,2.01-2.73,2.28      c-0.48,0.279-1.15,0.47-3.23,0.47c-5.58,0.01-11.32,0.689-16.56,0.68c-0.47,0.01-0.94,0-1.41-0.01c-0.41,0-0.84-0.05-1.26-0.13      c-4.12-0.851-8.83-5.48-12.6-8.47c-2.21-1.73-4.59-2.341-6.85-2.33c-3.19,0.02-6.19,1.05-9.21,1.58      c-0.43,0.069-0.81,0.34-1.03,0.72c-0.23,0.38-0.27,0.84-0.12,1.25c0.6,1.71,0.84,3.42,1.24,5.43c0.45,2.12,1.33,3.15,1.64,4.29      c0.27,0.891,0.37,1.55,0.37,2.03c-0.04,0.85-0.19,1.07-0.74,1.63c-0.57,0.52-1.62,1.13-2.89,2.01      c-3.19,2.221-7.76,5.69-9.86,8.95c-0.79,1.31-1.03,2.78-1.49,3.83c-0.21,0.52-0.44,0.9-0.64,1.07s-0.31,0.239-0.68,0.26      c-0.2-0.51-0.5-0.95-0.93-1.311c-0.72-0.569-1.52-0.64-2.05-0.63c-0.41,0-0.74,0.03-1.02,0.03c-0.32,0-0.53-0.04-0.7-0.11      c-1.14-0.439-2.14-1.55-3.25-3.08c-1.27-1.739-2.47-2.72-3.68-3.399c-1.16-0.66-2.22-1.08-3.64-1.96      c-0.2-0.15-0.42-0.25-0.67-0.29c-0.08-0.021-0.16-0.03-0.24-0.03c-0.03,0-0.05-0.01-0.08-0.01c-0.17,0.01-0.32,0.01-0.46,0.02      c-0.66,0-1-0.119-1.1-0.159c0-0.021,0-0.051,0-0.08c-0.03-0.4,0.39-1.551,0.92-2.69c0.51-1.189,1.14-2.31,1.18-3.72      c0-0.03,0.01-0.07,0-0.141c-0.02-0.569-0.37-1.09-0.9-1.319c-0.54-0.23-1.16-0.13-1.59,0.26c-1.19,1.06-2.02,1.73-2.86,1.88      c-0.01-0.38-0.01-0.75-0.01-1.13c0-0.76,0.01-1.54,0.01-2.33c0-0.81-0.01-1.63-0.05-2.46c-0.04-0.71-0.57-1.29-1.27-1.4v-0.01      c-0.5-0.13-1.99-2.76-2.92-5.49c-1.04-2.76-1.85-5.59-2.47-7.01c-1.12-2.51-1.49-4.39-1.49-6.17      c-0.02-2.85,1.06-5.71,2.12-10.149c0.11-0.49-0.03-1-0.37-1.37c-0.34-0.36-0.85-0.53-1.34-0.45c-0.35,0.06-0.63,0.08-0.83,0.08      c-0.63-0.03-0.62-0.11-0.72-0.19c-0.17-0.13-0.41-1.01-0.59-2.21c-0.23-1.17-0.52-2.7-1.72-3.99      c-1.11-1.17-2.38-1.439-3.07-1.739c-0.72-0.33-0.99-0.42-1.48-1.431c-0.96-2.22-1.5-4.62-1.5-7.06c0-2.29,0.48-4.62,1.55-6.89      c1.96-0.11,3.84-0.33,5.64-0.36c0.4-0.01,0.78-0.17,1.06-0.46c0.28-0.29,0.42-0.68,0.41-1.08c-0.03-1.69-0.89-2.95-1.68-3.79      c-0.79-0.86-1.51-1.5-1.89-2.15c-0.79-1.24-0.74-3.13-1.06-5.53c-0.24-1.6-0.43-2.98-0.42-4.2c0.02-2.15,0.46-3.77,2.39-5.89      c0.46-0.5,0.53-1.25,0.16-1.83c-2.32-3.71-4.7-5.62-7.48-6.42c-2.76-0.79-5.6-0.65-9.37-0.93c-2.27-0.2-2.8-0.66-3.12-1.21      c-0.38-0.6-0.52-2.1-0.49-4.32c0-0.11,0-0.23,0-0.35c-0.01-1,0.28-3.06,0.29-4.93c-0.01-1.02-0.07-2.01-0.46-2.97      c-0.61-1.27-1.53-1.63-2.06-2.07c-0.6-0.45-0.71-0.64-0.71-0.79v-0.01c0-0.05,0.09-0.36,0.36-0.74      c0.85-1.31,3.37-3.11,4.28-3.41c1.32-0.51,2.29-0.42,3.67-0.83c0.68-0.21,1.43-0.67,1.97-1.38c0.55-0.7,0.94-1.57,1.28-2.72      c0.18-0.65,0.22-1.26,0.22-1.84c0-0.92-0.1-1.78-0.1-2.45c0-0.48,0.06-0.84,0.14-1.04c0.12-0.63,1.69-1.63,3.15-2.54      c1.74-1.17,2.48-1.34,3.26-1.36c0.8-0.01,1.99,0.33,4,0.61c0.4,0.06,0.78,0.08,1.16,0.08c1.99,0.02,3.68-0.82,4.79-2.07      c1.68-1.88,2.35-4.39,2.9-6.81c0.52-2.41,0.88-4.79,1.42-6.14c0.09-0.24,0.12-0.48,0.09-0.72c0.75-0.28,1.5-0.61,2.25-1.05      c1.9-1.06,3.74-3.14,4.21-5.88c0.22-1.16,0.28-2.3,0.28-3.4c0-2.18-0.23-4.26-0.23-5.83c0.01-1.67-0.34-3.24-1.15-4.56      c-0.01-0.02-0.03-0.04-0.05-0.07c0.32-0.87,0.79-1.67,1.37-2.43c2.51-3.26,7.07-5.67,10.76-8.91c1.96-1.8,4.38-4.35,6.2-5.28      c0.75-0.39,1.41-0.53,2.13-0.53c1.66-0.03,3.65,0.9,6.04,1.54c3.8,0.98,7.84,1.09,11.81,1.09c1.44,0,2.88-0.02,4.29-0.02      c2.24,0,4.41,0.04,6.45,0.25c3.54,0.34,7.67,0.98,10.43,2.56c0.76,0.43,2.75,1.75,4.44,3.23c0.84,0.74,1.62,1.53,2.14,2.23      c0.34,0.44,0.54,0.84,0.64,1.12c-0.54,0.25-1.05,0.56-1.5,0.98c-0.72,0.65-1.23,1.69-1.21,2.78c0,0.26,0.02,0.53,0.07,0.79      c-0.28,0.09-0.57,0.19-0.86,0.3c-0.9,0.39-1.89,0.66-2.65,1.86c-0.33,0.59-0.48,1.25-0.47,1.85c0.02,1.32,0.55,2.33,0.93,3.21      c0.42,0.87,0.7,1.62,0.69,2.03c0,0,0,0.02,0,0.05c0.04,1.07-0.82,2.36-2.01,3.82c-1.12,1.45-2.62,3.03-2.67,5.4      c0,0.31,0.03,0.64,0.1,0.98c0.12,0.55,0.56,0.99,1.11,1.13c3.19,0.79,6.9,1.7,9.72,2.9c0.71,0.29,1.54,0.98,2.52,1.71      C250.471,339.029,251.711,339.839,253.371,339.849z"
                    }
                }
            }
        }
    );
})(jQuery);
