'''OpenGL extension QCOM.texture_foveated_subsampled_layout

This module customises the behaviour of the 
OpenGL.raw.GLES2.QCOM.texture_foveated_subsampled_layout to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension builds on QCOM_texture_foveated by introducing a new foveation
	method bit that aims to reduce memory bandwidth by avoiding the upscaling that
	occurred as part of the original extension.
	
	With the original FOVEATION_SCALED_BIN_METHOD_BIT_QCOM foveation method,
	the render target in system memory is entirely populated. The lower
	resolution framebuffer data is upscaled to fill the entire render target.
	The subsampled layout method introduced in this extension leaves the
	framebuffer data at the calculated lower density and instead samples
	directly from the the lower resolution texels.
	
	The primary usecase this is targeting is traditional VR pipeline. The
	application eye buffers would be rendered as textures with a subsampled layout
	and then sampled by the warp process. Sampling from a texture with a
	subsampled layout requires a new sampler layout qualifier.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/QCOM/texture_foveated_subsampled_layout.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GLES2 import _types, _glgets
from OpenGL.raw.GLES2.QCOM.texture_foveated_subsampled_layout import *
from OpenGL.raw.GLES2.QCOM.texture_foveated_subsampled_layout import _EXTENSION_NAME

def glInitTextureFoveatedSubsampledLayoutQCOM():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION