'''OpenGL extension NV.gpu_multicast

This module customises the behaviour of the 
OpenGL.raw.GL.NV.gpu_multicast to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension enables novel multi-GPU rendering techniques by providing application control
	over a group of linked GPUs with identical hardware configuration.
	
	Multi-GPU rendering techniques fall into two categories: implicit and explicit.  Existing
	explicit approaches like WGL_NV_gpu_affinity have two main drawbacks: CPU overhead and
	application complexity.  An application must manage one context per GPU and multi-pump the API
	stream.  Implicit multi-GPU rendering techniques avoid these issues by broadcasting rendering
	from one context to multiple GPUs.  Common implicit approaches include alternate-frame
	rendering (AFR), split-frame rendering (SFR) and multi-GPU anti-aliasing.  They each have
	drawbacks.  AFR scales nicely but interacts poorly with inter-frame dependencies.  SFR can
	improve latency but has challenges with offscreen rendering and scaling of vertex processing.
	With multi-GPU anti-aliasing, each GPU renders the same content with alternate sample
	positions and the driver blends the result to improve quality.  This also has issues with
	offscreen rendering and can conflict with other anti-aliasing techniques.
	
	These issues with implicit multi-GPU rendering all have the same root cause: the driver lacks
	adequate knowledge to accelerate every application.  To resolve this, NV_gpu_multicast
	provides fine-grained, explicit application control over multiple GPUs with a single context.
	
	Key points:
	
	- One context controls multiple GPUs.  Every GPU in the linked group can access every object.
	
	- Rendering is broadcast.  Each draw is repeated across all GPUs in the linked group.
	
	- Each GPU gets its own instance of all framebuffers, allowing individualized output for each
	  GPU.  Input data can be customized for each GPU using buffers created with the storage flag,
	  PER_GPU_STORAGE_BIT_NV and a new API, MulticastBufferSubDataNV. 
	
	- New interfaces provide mechanisms to transfer textures and buffers from one GPU to another.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/gpu_multicast.txt
'''
from OpenGL import platform, constant, arrays
from OpenGL import extensions, wrapper
import ctypes
from OpenGL.raw.GL import _types, _glgets
from OpenGL.raw.GL.NV.gpu_multicast import *
from OpenGL.raw.GL.NV.gpu_multicast import _EXTENSION_NAME

def glInitGpuMulticastNV():
    '''Return boolean indicating whether this extension is available'''
    from OpenGL import extensions
    return extensions.hasGLExtension( _EXTENSION_NAME )


### END AUTOGENERATED SECTION