from typing import Any
from typing_extensions import TypeAlias
from weakref import ReferenceType

__all__ = ["local"]
_localdict: TypeAlias = dict[Any, Any]

class _localimpl:
    key: str
    dicts: dict[int, tuple[ReferenceType[Any], _localdict]]
    def __init__(self) -> None: ...
    def get_dict(self) -> _localdict: ...
    def create_dict(self) -> _localdict: ...

class local:
    def __getattribute__(self, name: str) -> Any: ...
    def __setattr__(self, name: str, value: Any) -> None: ...
    def __delattr__(self, name: str) -> None: ...
