"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PPLQueryParser = void 0;

var _ppl_syntax_parser = require("../antlr/ppl_syntax_parser");

var _stats_ast_builder = require("../ast/builder/stats_ast_builder");

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; } /*
                                                                                                                                                                                                                   * Copyright OpenSearch Contributors
                                                                                                                                                                                                                   * SPDX-License-Identifier: Apache-2.0
                                                                                                                                                                                                                   */

class PPLQueryParser {
  constructor() {
    _defineProperty(this, "parser", null);

    _defineProperty(this, "visitor", null);

    _defineProperty(this, "rawQuery", '');
  }

  parse(pplQuery) {
    this.rawQuery = pplQuery;
    this.parser = new _ppl_syntax_parser.PPLSyntaxParser().parse(this.rawQuery);
    return this;
  }

  getStats() {
    this.visitor = new _stats_ast_builder.StatsAstBuilder();
    return this.visitor.visitRoot(this.parser.root()).getTokens();
  }

}

exports.PPLQueryParser = PPLQueryParser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInBwbF9xdWVyeV9wYXJzZXIudHMiXSwibmFtZXMiOlsiUFBMUXVlcnlQYXJzZXIiLCJwYXJzZSIsInBwbFF1ZXJ5IiwicmF3UXVlcnkiLCJwYXJzZXIiLCJQUExTeW50YXhQYXJzZXIiLCJnZXRTdGF0cyIsInZpc2l0b3IiLCJTdGF0c0FzdEJ1aWxkZXIiLCJ2aXNpdFJvb3QiLCJyb290IiwiZ2V0VG9rZW5zIl0sIm1hcHBpbmdzIjoiOzs7Ozs7O0FBS0E7O0FBRUE7O2tOQVBBO0FBQ0E7QUFDQTtBQUNBOztBQU1PLE1BQU1BLGNBQU4sQ0FBcUI7QUFBQTtBQUFBLG9DQUNXLElBRFg7O0FBQUEscUNBRVgsSUFGVzs7QUFBQSxzQ0FHUCxFQUhPO0FBQUE7O0FBSzFCQyxFQUFBQSxLQUFLLENBQUNDLFFBQUQsRUFBbUI7QUFDdEIsU0FBS0MsUUFBTCxHQUFnQkQsUUFBaEI7QUFDQSxTQUFLRSxNQUFMLEdBQWMsSUFBSUMsa0NBQUosR0FBc0JKLEtBQXRCLENBQTRCLEtBQUtFLFFBQWpDLENBQWQ7QUFDQSxXQUFPLElBQVA7QUFDRDs7QUFFREcsRUFBQUEsUUFBUSxHQUFHO0FBQ1QsU0FBS0MsT0FBTCxHQUFlLElBQUlDLGtDQUFKLEVBQWY7QUFDQSxXQUFPLEtBQUtELE9BQUwsQ0FBYUUsU0FBYixDQUF1QixLQUFLTCxNQUFMLENBQWFNLElBQWIsRUFBdkIsRUFBNENDLFNBQTVDLEVBQVA7QUFDRDs7QUFkeUIiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbmltcG9ydCB7IFBQTFN5bnRheFBhcnNlciB9IGZyb20gJy4uL2FudGxyL3BwbF9zeW50YXhfcGFyc2VyJztcbmltcG9ydCB7IE9wZW5TZWFyY2hQUExQYXJzZXIgfSBmcm9tICcuLi9hbnRsci9vdXRwdXQvT3BlblNlYXJjaFBQTFBhcnNlcic7XG5pbXBvcnQgeyBTdGF0c0FzdEJ1aWxkZXIgfSBmcm9tICcuLi9hc3QvYnVpbGRlci9zdGF0c19hc3RfYnVpbGRlcic7XG5cbmV4cG9ydCBjbGFzcyBQUExRdWVyeVBhcnNlciB7XG4gIHBhcnNlcjogT3BlblNlYXJjaFBQTFBhcnNlciB8IG51bGwgPSBudWxsO1xuICB2aXNpdG9yOiBhbnkgPSBudWxsO1xuICByYXdRdWVyeTogc3RyaW5nID0gJyc7XG5cbiAgcGFyc2UocHBsUXVlcnk6IHN0cmluZykge1xuICAgIHRoaXMucmF3UXVlcnkgPSBwcGxRdWVyeTtcbiAgICB0aGlzLnBhcnNlciA9IG5ldyBQUExTeW50YXhQYXJzZXIoKS5wYXJzZSh0aGlzLnJhd1F1ZXJ5KTtcbiAgICByZXR1cm4gdGhpcztcbiAgfVxuXG4gIGdldFN0YXRzKCkge1xuICAgIHRoaXMudmlzaXRvciA9IG5ldyBTdGF0c0FzdEJ1aWxkZXIoKTtcbiAgICByZXR1cm4gdGhpcy52aXNpdG9yLnZpc2l0Um9vdCh0aGlzLnBhcnNlciEucm9vdCgpKS5nZXRUb2tlbnMoKTtcbiAgfVxufVxuIl19