"use strict";

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

/**
 * The transform configuration in Jest allows you to 
 * specify custom transformation logic for specific file types during testing. 
 */
module.exports = {
  /**
   * This function is responsible for transforming the file.
   * @returns the string module.exports = {};, which is an empty CommonJS module.
   */
  process() {
    return {
      code: `module.exports = {};`
    };
  },

  /**
   * The cache key helps Jest determine if a file needs to be retransformed or if it can use the cached transformation result. 
   * @returns a unique string that serves as a cache key for the transformation. 
   */
  getCacheKey() {
    return 'svgTransform';
  }

};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbInRyYW5zZm9ybU1vY2sudHMiXSwibmFtZXMiOlsibW9kdWxlIiwiZXhwb3J0cyIsInByb2Nlc3MiLCJjb2RlIiwiZ2V0Q2FjaGVLZXkiXSwibWFwcGluZ3MiOiI7O0FBQUE7QUFDQTtBQUNBO0FBQ0E7O0FBRUE7QUFDQTtBQUNBO0FBQ0E7QUFDQUEsTUFBTSxDQUFDQyxPQUFQLEdBQWlCO0FBQ2Y7QUFDRjtBQUNBO0FBQ0E7QUFDRUMsRUFBQUEsT0FBTyxHQUFHO0FBQ1IsV0FBTztBQUNMQyxNQUFBQSxJQUFJLEVBQUc7QUFERixLQUFQO0FBR0QsR0FUYzs7QUFVZjtBQUNGO0FBQ0E7QUFDQTtBQUNFQyxFQUFBQSxXQUFXLEdBQUc7QUFDWixXQUFPLGNBQVA7QUFDRDs7QUFoQmMsQ0FBakIiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuICogQ29weXJpZ2h0IE9wZW5TZWFyY2ggQ29udHJpYnV0b3JzXG4gKiBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuICovXG5cbi8qKlxuICogVGhlIHRyYW5zZm9ybSBjb25maWd1cmF0aW9uIGluIEplc3QgYWxsb3dzIHlvdSB0byBcbiAqIHNwZWNpZnkgY3VzdG9tIHRyYW5zZm9ybWF0aW9uIGxvZ2ljIGZvciBzcGVjaWZpYyBmaWxlIHR5cGVzIGR1cmluZyB0ZXN0aW5nLiBcbiAqL1xubW9kdWxlLmV4cG9ydHMgPSB7XG4gIC8qKlxuICAgKiBUaGlzIGZ1bmN0aW9uIGlzIHJlc3BvbnNpYmxlIGZvciB0cmFuc2Zvcm1pbmcgdGhlIGZpbGUuXG4gICAqIEByZXR1cm5zIHRoZSBzdHJpbmcgbW9kdWxlLmV4cG9ydHMgPSB7fTssIHdoaWNoIGlzIGFuIGVtcHR5IENvbW1vbkpTIG1vZHVsZS5cbiAgICovXG4gIHByb2Nlc3MoKSB7XG4gICAgcmV0dXJuIHtcbiAgICAgIGNvZGU6IGBtb2R1bGUuZXhwb3J0cyA9IHt9O2AsXG4gICAgfTtcbiAgfSxcbiAgLyoqXG4gICAqIFRoZSBjYWNoZSBrZXkgaGVscHMgSmVzdCBkZXRlcm1pbmUgaWYgYSBmaWxlIG5lZWRzIHRvIGJlIHJldHJhbnNmb3JtZWQgb3IgaWYgaXQgY2FuIHVzZSB0aGUgY2FjaGVkIHRyYW5zZm9ybWF0aW9uIHJlc3VsdC4gXG4gICAqIEByZXR1cm5zIGEgdW5pcXVlIHN0cmluZyB0aGF0IHNlcnZlcyBhcyBhIGNhY2hlIGtleSBmb3IgdGhlIHRyYW5zZm9ybWF0aW9uLiBcbiAgICovXG4gIGdldENhY2hlS2V5KCkge1xuICAgIHJldHVybiAnc3ZnVHJhbnNmb3JtJztcbiAgfSxcbn07Il19