"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerDatasourcesRoute = registerDatasourcesRoute;

var _configSchema = require("@osd/config-schema");

var _shared = require("../../../common/constants/shared");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function registerDatasourcesRoute(router) {
  router.post({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.JOBS_BASE}`,
    validate: {
      body: _configSchema.schema.object({
        query: _configSchema.schema.string(),
        lang: _configSchema.schema.string(),
        datasource: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    const params = {
      body: { ...request.body
      }
    };

    try {
      const res = await context.observability_plugin.observabilityClient.asScoped(request).callAsCurrentUser('observability.runDirectQuery', params);
      return response.ok({
        body: res
      });
    } catch (error) {
      console.error('Error in running direct query:', error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
  router.get({
    path: `${_shared.OBSERVABILITY_BASE}${_shared.JOBS_BASE}/{queryId}`,
    validate: {
      params: _configSchema.schema.object({
        queryId: _configSchema.schema.string()
      })
    }
  }, async (context, request, response) => {
    try {
      const res = await context.observability_plugin.observabilityClient.asScoped(request).callAsCurrentUser('observability.getJobStatus', {
        queryId: request.params.queryId
      });
      return response.ok({
        body: res
      });
    } catch (error) {
      console.error('Error in fetching job status:', error);
      return response.custom({
        statusCode: error.statusCode || 500,
        body: error.message
      });
    }
  });
}
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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