"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = _default;

var _configSchema = require("@osd/config-schema");

/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */
function _default(services, router) {
  const {
    alertService
  } = services;
  router.get({
    path: '/api/alerting/alerts',
    validate: {
      query: _configSchema.schema.object({
        from: _configSchema.schema.maybe(_configSchema.schema.number()),
        size: _configSchema.schema.number(),
        search: _configSchema.schema.maybe(_configSchema.schema.string()),
        sortField: _configSchema.schema.string(),
        sortDirection: _configSchema.schema.string(),
        severityLevel: _configSchema.schema.maybe(_configSchema.schema.string()),
        alertState: _configSchema.schema.maybe(_configSchema.schema.string()),
        monitorIds: _configSchema.schema.maybe(_configSchema.schema.string()),
        monitorType: _configSchema.schema.maybe(_configSchema.schema.string())
      })
    }
  }, alertService.getAlerts);
  router.get({
    path: '/api/alerting/workflows/alerts',
    validate: {
      query: _configSchema.schema.object({
        workflowIds: _configSchema.schema.string(),
        getAssociatedAlerts: _configSchema.schema.boolean(),
        sortString: _configSchema.schema.string(),
        sortOrder: _configSchema.schema.string(),
        startIndex: _configSchema.schema.number(),
        size: _configSchema.schema.number(),
        severityLevel: _configSchema.schema.maybe(_configSchema.schema.string()),
        alertState: _configSchema.schema.maybe(_configSchema.schema.string()),
        searchString: _configSchema.schema.maybe(_configSchema.schema.string()),
        alertIds: _configSchema.schema.string()
      })
    }
  }, alertService.getWorkflowAlerts);
}

module.exports = exports.default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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