function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Any modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import React from 'react';
import PropTypes from 'prop-types';
import _ from 'lodash';
import { KuiTableRow, KuiTableRowCell, KuiTableRowCheckBoxCell } from '../';
import { LEFT_ALIGNMENT, RIGHT_ALIGNMENT } from '../../../services';
export class KuiListingTableRow extends React.PureComponent {
  constructor() {
    super(...arguments);

    _defineProperty(this, "onSelectionChanged", () => {
      this.props.onSelectionChanged(this.props.row.id);
    });
  }

  renderCells() {
    return this.props.row.cells.map((cell, index) => {
      let {
        content,
        ...props
      } = cell;

      if ( /*#__PURE__*/React.isValidElement(cell) || !_.isObject(cell)) {
        props = [];
        content = cell;
      }

      return /*#__PURE__*/React.createElement(KuiTableRowCell, _extends({
        key: index
      }, props), content);
    });
  }

  render() {
    const {
      enableSelection,
      isSelected
    } = this.props;
    return /*#__PURE__*/React.createElement(KuiTableRow, null, enableSelection && /*#__PURE__*/React.createElement(KuiTableRowCheckBoxCell, {
      isChecked: isSelected,
      onChange: this.onSelectionChanged
    }), this.renderCells());
  }

}
KuiListingTableRow.propTypes = {
  row: PropTypes.shape({
    id: PropTypes.string,
    cells: PropTypes.arrayOf(PropTypes.oneOfType([PropTypes.node, PropTypes.shape({
      content: PropTypes.node,
      align: PropTypes.oneOf([LEFT_ALIGNMENT, RIGHT_ALIGNMENT])
    })]))
  }).isRequired,
  enableSelection: PropTypes.bool,
  onSelectionChanged: PropTypes.func.isRequired,
  isSelected: PropTypes.bool
};
KuiListingTableRow.defaultProps = {
  enableSelection: true
};
