/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visual.graph.layout.hierarchicalsupport;

import java.util.List;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.DirectedGraph;
import org.netbeans.modules.visual.graph.layout.hierarchicalsupport.LayeredGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BarycenterXCoordinateAssigner {
    public LayeredGraph assignCoordinates(LayeredGraph layeredGraph) {
        List<List<DirectedGraph.Vertex>> list = layeredGraph.getLayers();
        int n = list.size();
        int n2 = 1;
        for (int i = 0; i < n2; ++i) {
            int[] nArray;
            List<DirectedGraph.Vertex> list2;
            float[] fArray;
            int n3;
            for (n3 = 0; n3 < n - 1; ++n3) {
                fArray = layeredGraph.computeLowerBarycenters(n3);
                list2 = layeredGraph.getLayer(n3 + 1);
                nArray = this.computeUpPriorities(list2);
                this.moveVertices(list2, fArray, nArray);
            }
            for (n3 = n - 2; n3 >= 0; --n3) {
                fArray = layeredGraph.computeUpperBarycenters(n3);
                list2 = layeredGraph.getLayer(n3);
                nArray = this.computeDownPriorities(list2);
                this.moveVertices(list2, fArray, nArray);
            }
        }
        return layeredGraph;
    }

    private void moveVertices(List<DirectedGraph.Vertex> list, float[] fArray, int[] nArray) {
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                DirectedGraph.Vertex vertex;
                float f;
                DirectedGraph.Vertex vertex2 = list.get(j);
                int n2 = nArray[j];
                float f2 = fArray[j];
                float f3 = vertex2.getX();
                if (!(f3 < f2)) continue;
                int n3 = -1;
                for (int k = j + 1; k < n; ++k) {
                    DirectedGraph.Vertex vertex3 = list.get(k);
                    if (nArray[k] < n2) continue;
                    n3 = k;
                    break;
                }
                float f4 = f2;
                float f5 = n;
                if (n3 != -1) {
                    f5 = n3;
                    DirectedGraph.Vertex vertex4 = list.get(n3);
                    float f6 = vertex4.getX();
                    float f7 = (f6 - f3) / (float)(n3 - j);
                    if (!(f7 > 1.0f)) continue;
                    f4 = f3 + (f7 - 1.0f);
                    if (f4 > f2) {
                        f4 = f2;
                    }
                }
                if (f4 <= f3) continue;
                vertex2.setX((int)f4);
                float f8 = f4;
                int n4 = j + 1;
                while ((float)n4 < f5 && (f = (float)(vertex = list.get(n4)).getX()) <= f8 + 1.0f) {
                    vertex.setX((int)(f8 += 1.0f));
                    ++n4;
                }
            }
        }
    }

    private int[] computeUpPriorities(List<DirectedGraph.Vertex> list) {
        DirectedGraph.Vertex vertex;
        int n;
        int n2 = list.size();
        int[] nArray = new int[n2];
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            int n4;
            vertex = list.get(n);
            if (vertex instanceof DirectedGraph.DummyVertex) continue;
            nArray[n] = n4 = vertex.getUpperNeighbors().size();
            if (n4 <= n3) continue;
            n3 = n4;
        }
        ++n3;
        for (n = 0; n < n2; ++n) {
            vertex = list.get(n);
            if (!(vertex instanceof DirectedGraph.DummyVertex)) continue;
            nArray[n] = n3;
        }
        return nArray;
    }

    private int[] computeDownPriorities(List<DirectedGraph.Vertex> list) {
        DirectedGraph.Vertex vertex;
        int n;
        int n2 = list.size();
        int[] nArray = new int[n2];
        int n3 = -1;
        for (n = 0; n < n2; ++n) {
            int n4;
            vertex = list.get(n);
            if (vertex instanceof DirectedGraph.DummyVertex) continue;
            nArray[n] = n4 = vertex.getLowerNeighbors().size();
            if (n4 <= n3) continue;
            n3 = n4;
        }
        ++n3;
        for (n = 0; n < n2; ++n) {
            vertex = list.get(n);
            if (!(vertex instanceof DirectedGraph.DummyVertex)) continue;
            nArray[n] = n3;
        }
        return nArray;
    }
}

