/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.authentication.authenticators.util.LoAUtil;
import org.keycloak.common.Profile;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientSessionContext;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.TokenIntrospectionTokenMapper;
import org.keycloak.protocol.oidc.utils.AcrUtils;
import org.keycloak.provider.EnvironmentDependentProviderFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.IDToken;
import org.keycloak.services.managers.AuthenticationManager;

public class AcrProtocolMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
TokenIntrospectionTokenMapper,
EnvironmentDependentProviderFactory {
    private static final Logger logger = Logger.getLogger(AcrProtocolMapper.class);
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String PROVIDER_ID = "oidc-acr-mapper";

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Authentication Context Class Reference (ACR)";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Maps the achieved LoA (Level of Authentication) to the 'acr' claim of the token";
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession, KeycloakSession keycloakSession, ClientSessionContext clientSessionCtx) {
        AuthenticatedClientSessionModel clientSession = clientSessionCtx.getClientSession();
        String acr = this.getAcr(clientSession);
        token.setAcr(acr);
    }

    public static ProtocolMapperModel create(String name, boolean accessToken, boolean idToken, boolean introspectionEndpoint) {
        ProtocolMapperModel mapper = new ProtocolMapperModel();
        mapper.setName(name);
        mapper.setProtocolMapper(PROVIDER_ID);
        mapper.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        if (accessToken) {
            config.put("access.token.claim", "true");
        }
        if (idToken) {
            config.put("id.token.claim", "true");
        }
        if (introspectionEndpoint) {
            config.put("introspection.token.claim", "true");
        }
        mapper.setConfig(config);
        return mapper;
    }

    protected String getAcr(AuthenticatedClientSessionModel clientSession) {
        Map<String, Integer> acrLoaMap;
        String acr;
        int loa = LoAUtil.getCurrentLevelOfAuthentication(clientSession);
        logger.tracef("Loa level when authenticated to client %s: %d", (Object)clientSession.getClient().getClientId(), (Object)loa);
        if (loa < 0) {
            int n = loa = AuthenticationManager.isSSOAuthentication(clientSession) ? 0 : 1;
        }
        if ((acr = AcrUtils.mapLoaToAcr(loa, acrLoaMap = AcrUtils.getAcrLoaMap(clientSession.getClient()), AcrUtils.getRequiredAcrValues(clientSession.getNote("claims")))) == null && (acr = AcrUtils.mapLoaToAcr(loa, acrLoaMap, AcrUtils.getAcrValues(clientSession.getNote("claims"), clientSession.getNote("acr_values"), clientSession.getClient()))) == null && (acr = AcrUtils.mapLoaToAcr(loa, acrLoaMap, acrLoaMap.keySet())) == null) {
            acr = String.valueOf(loa);
        }
        logger.tracef("Level sent in the token to client %s: %s. Original loa from the authentication: %d", (Object)clientSession.getClient().getClientId(), (Object)acr, (Object)loa);
        return acr;
    }

    public boolean isSupported() {
        return Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.STEP_UP_AUTHENTICATION);
    }

    static {
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(configProperties, AcrProtocolMapper.class);
    }
}

